#define ID_BYTE_OFFSET	0x08

#define ID_MASK		0x7f
#define ID_OFF_MAJOR	0x00
#define ID_OFF_MINOR	0x08
#define ID_OFF_REVLEV1	0x10
#define ID_OFF_REVLEV2	0x18
#define ID_OFF_OFFSET1	0x20
#define ID_OFF_OFFSET2	0x28
#define ID_OFF_OFFSET3	0x30
#define ID_OFF_OFFSET4	0x38
#define ID_OFF_SIZE1	0x40
#define ID_OFF_SIZE2	0x48
#define ID_OFF_SIZE3	0x50
#define ID_OFF_SIZE4	0x58
#define ID_OFF_CKSUM	0x60
#define ID_OFF_STRING	0x68

#define ID_MAX_STRING_SIZE 129

#define ID_4BYTES_TO_LONG(a1, a2, a3, a4) \
	((a1 << 24) | (a2 << 16) | (a3 << 8) | a4)
#define ID_2BYTES_TO_SHORT(a1, a2) ((a1 << 8) | a2)

#define ID_MEMORY_BOARD		'M'
#define ID_SYSTEM_BOARD		'S'
#define ID_GRAPHIC_BOARD	'G'

/* For the system board.  */
#define ID_S_SERIAL_SIZE	16
#define ID_S_ENET_SIZE		6
#define ID_S_MFGDATE_SIZE	6
#define ID_S_BANNER_SIZE	64
#define ID_S_COPYRIGHT_SIZE	64
#define ID_S_LOGOBITMAP_SIZE	512

#define ID_S_OFF_HOSTID1	0x000
#define ID_S_OFF_HOSTID2	0x008
#define ID_S_OFF_HOSTID3	0x010
#define ID_S_OFF_HOSTID4	0x018
#define ID_S_OFF_SERIAL		0x080
#define ID_S_OFF_ENETADDR	0x180
#define ID_S_OFF_MFGDATE	0x1c0
#define ID_S_OFF_OEM_FLAG	0x1f0
#define ID_S_OFF_BANNER		0x1f8
#define ID_S_OFF_COPYRIGHT	0x3f8
#define ID_S_OFF_LOGOBITMAP	0x5f8

#define ID_G_OFF_TYPE		0x00
#define ID_G_OFF_NBR_PLANE	0x08
#define ID_G_OFF_ACCESS_SIZE	0x10
#define ID_G_OFF_RES_COUNT	0x18

#define ID_G_OFF_FB_SIZES	0x20
#define ID_G_SIZE_FB_SIZES	0x90
#define ID_G_OFF_X_RES1		0x00
#define ID_G_OFF_X_RES2		0x08
#define ID_G_OFF_Y_RES1		0x10
#define ID_G_OFF_Y_RES2		0x18
#define ID_G_OFF_XOFFSET1	0x20
#define ID_G_OFF_XOFFSET2	0x28
#define ID_G_OFF_FB_SIZE1	0x30
#define ID_G_OFF_FB_SIZE2	0x38
#define ID_G_OFF_FB_SIZE3	0x40
#define ID_G_OFF_FB_SIZE4	0x48
#define ID_G_OFF_ITBL_OFF1	0x50
#define ID_G_OFF_ITBL_OFF2	0x58
#define ID_G_OFF_ITBL_OFF3	0x60
#define ID_G_OFF_ITBL_OFF4	0x68
#define ID_G_OFF_FONT_OFF1	0x70
#define ID_G_OFF_FONT_OFF2	0x78
#define ID_G_OFF_FONT_OFF3	0x80
#define ID_G_OFF_FONT_OFF4	0x88

#define ID_G_OFF_WHITE_OFF1	0x00
#define ID_G_OFF_WHITE_OFF2	0x08
#define ID_G_OFF_WHITE_OFF3	0x10
#define ID_G_OFF_WHITE_OFF4	0x18
#define ID_G_OFF_BLACK_OFF1	0x20
#define ID_G_OFF_BLACK_OFF2	0x28
#define ID_G_OFF_BLACK_OFF3	0x30
#define ID_G_OFF_BLACK_OFF4	0x38
#define ID_G_OFF_FB_OFF1	0x40
#define ID_G_OFF_FB_OFF2	0x48
#define ID_G_OFF_FB_OFF3	0x50
#define ID_G_OFF_FB_OFF4	0x58
#define ID_G_OFF_KB_OFF1	0x60
#define ID_G_OFF_KB_OFF2	0x68
#define ID_G_OFF_KB_OFF3	0x70
#define ID_G_OFF_KB_OFF4	0x78
