/*	$OpenBSD: lib_tracemse.c,v 1.1 1999/01/18 19:10:24 millert Exp $	*/

/****************************************************************************
 * Copyright (c) 1998 Free Software Foundation, Inc.                        *
 *                                                                          *
 * Permission is hereby granted, free of charge, to any person obtaining a  *
 * copy of this software and associated documentation files (the            *
 * "Software"), to deal in the Software without restriction, including      *
 * without limitation the rights to use, copy, modify, merge, publish,      *
 * distribute, distribute with modifications, sublicense, and/or sell       *
 * copies of the Software, and to permit persons to whom the Software is    *
 * furnished to do so, subject to the following conditions:                 *
 *                                                                          *
 * The above copyright notice and this permission notice shall be included  *
 * in all copies or substantial portions of the Software.                   *
 *                                                                          *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS  *
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF               *
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.   *
 * IN NO EVENT SHALL THE ABOVE COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,   *
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR    *
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR    *
 * THE USE OR OTHER DEALINGS IN THE SOFTWARE.                               *
 *                                                                          *
 * Except as contained in this notice, the name(s) of the above copyright   *
 * holders shall not be used in advertising or otherwise to promote the     *
 * sale, use or other dealings in this Software without prior written       *
 * authorization.                                                           *
 ****************************************************************************/

/****************************************************************************
 *  Author: Zeyd M. Ben-Halim <zmbenhal@netcom.com> 1992,1995               *
 *     and: Eric S. Raymond <esr@snark.thyrsus.com>                         *
 ****************************************************************************/



/*
 *	lib_tracemse.c - Tracing/Debugging routines (mouse events)
 */

#include <curses.priv.h>

MODULE_ID("$From: lib_tracemse.c,v 1.6 1998/11/16 14:28:17 Alexander.V.Lukyanov Exp $")

#ifdef TRACE

char *_tracemouse(MEVENT const *ep)
{
	static char buf[80];

	(void) sprintf(buf, "id %2d  at (%2d, %2d, %2d) state %4lx = {",
		       ep->id, ep->x, ep->y, ep->z, ep->bstate);

#define SHOW(m, s) if ((ep->bstate & m)==m) {strcat(buf,s); strcat(buf, ", ");}
	SHOW(BUTTON1_RELEASED,		"release-1")
	SHOW(BUTTON1_PRESSED,		"press-1")
	SHOW(BUTTON1_CLICKED,		"click-1")
	SHOW(BUTTON1_DOUBLE_CLICKED,	"doubleclick-1")
	SHOW(BUTTON1_TRIPLE_CLICKED,	"tripleclick-1")
	SHOW(BUTTON1_RESERVED_EVENT,	"reserved-1")
	SHOW(BUTTON2_RELEASED,		"release-2")
	SHOW(BUTTON2_PRESSED,		"press-2")
	SHOW(BUTTON2_CLICKED,		"click-2")
	SHOW(BUTTON2_DOUBLE_CLICKED,	"doubleclick-2")
	SHOW(BUTTON2_TRIPLE_CLICKED,	"tripleclick-2")
	SHOW(BUTTON2_RESERVED_EVENT,	"reserved-2")
	SHOW(BUTTON3_RELEASED,		"release-3")
	SHOW(BUTTON3_PRESSED,		"press-3")
	SHOW(BUTTON3_CLICKED,		"click-3")
	SHOW(BUTTON3_DOUBLE_CLICKED,	"doubleclick-3")
	SHOW(BUTTON3_TRIPLE_CLICKED,	"tripleclick-3")
	SHOW(BUTTON3_RESERVED_EVENT,	"reserved-3")
	SHOW(BUTTON4_RELEASED,		"release-4")
	SHOW(BUTTON4_PRESSED,		"press-4")
	SHOW(BUTTON4_CLICKED,		"click-4")
	SHOW(BUTTON4_DOUBLE_CLICKED,	"doubleclick-4")
	SHOW(BUTTON4_TRIPLE_CLICKED,	"tripleclick-4")
	SHOW(BUTTON4_RESERVED_EVENT,	"reserved-4")
	SHOW(BUTTON_CTRL,		"ctrl")
	SHOW(BUTTON_SHIFT,		"shift")
	SHOW(BUTTON_ALT,		"alt")
	SHOW(ALL_MOUSE_EVENTS,		"all-events")
	SHOW(REPORT_MOUSE_POSITION,	"position")
#undef SHOW

	if (buf[strlen(buf)-1] == ' ')
		buf[strlen(buf)-2] = '\0';
	(void) strcat(buf, "}");
	return(buf);
}

#else /* !TRACE */
/* don't make empty module */
void _nc_lib_tracemouse(void);
void _nc_lib_tracemouse(void) {}
#endif
