require '_h2ph_pre.ph';

unless(defined(&_VM_PARAM_)) {
    eval 'sub _VM_PARAM_ () {1;}' unless defined(&_VM_PARAM_);
    require 'machine/vmparam.ph';
    unless(defined(&TRUE)) {
	eval 'sub TRUE () {1;}' unless defined(&TRUE);
    }
    unless(defined(&FALSE)) {
	eval 'sub FALSE () {0;}' unless defined(&FALSE);
    }
    eval 'sub DEFAULT_PAGE_SIZE () {4096;}' unless defined(&DEFAULT_PAGE_SIZE);
    if(defined(&_KERNEL)) {
	if(!defined( &PAGE_SIZE) || defined( &_LKM)) {
	    undef(&PAGE_SIZE) if defined(&PAGE_SIZE);
	    undef(&PAGE_MASK) if defined(&PAGE_MASK);
	    undef(&PAGE_SHIFT) if defined(&PAGE_SHIFT);
	    if(defined( &UVM)) {
		eval 'sub PAGE_SIZE () { ($uvmexp->{pagesize});}' unless defined(&PAGE_SIZE);
		eval 'sub PAGE_MASK () { ($uvmexp->{pagemask});}' unless defined(&PAGE_MASK);
		eval 'sub PAGE_SHIFT () { ($uvmexp->{pageshift});}' unless defined(&PAGE_SHIFT);
	    } else {
		eval 'sub PAGE_SIZE () { ($cnt->{v_page_size});}' unless defined(&PAGE_SIZE);
		eval 'sub PAGE_MASK () { &page_mask;}' unless defined(&PAGE_MASK);
		eval 'sub PAGE_SHIFT () { &page_shift;}' unless defined(&PAGE_SHIFT);
	    }
	}
    }
    if(defined( &_KERNEL)  && !defined( &UVM)) {
    }
    eval 'sub VM_METER () {1;}' unless defined(&VM_METER);
    eval 'sub VM_LOADAVG () {2;}' unless defined(&VM_LOADAVG);
    eval 'sub VM_PSSTRINGS () {3;}' unless defined(&VM_PSSTRINGS);
    if(!defined( &UVM)) {
	eval 'sub VM_MAXID () {4;}' unless defined(&VM_MAXID);
	eval 'sub CTL_VM_NAMES () {{ { 0, 0}, { "vmmeter",  &CTLTYPE_STRUCT }, { "loadavg",  &CTLTYPE_STRUCT }, { "psstrings",  &CTLTYPE_STRUCT }, };}' unless defined(&CTL_VM_NAMES);
    } else {
	eval 'sub VM_UVMEXP () {4;}' unless defined(&VM_UVMEXP);
	eval 'sub VM_SWAPENCRYPT () {5;}' unless defined(&VM_SWAPENCRYPT);
	eval 'sub VM_MAXID () {6;}' unless defined(&VM_MAXID);
	eval 'sub CTL_VM_NAMES () {{ { 0, 0}, { "vmmeter",  &CTLTYPE_STRUCT }, { "loadavg",  &CTLTYPE_STRUCT }, { "psstrings",  &CTLTYPE_STRUCT }, { "uvmexp",  &CTLTYPE_STRUCT }, { "swapencrypt",  &CTLTYPE_NODE }, };}' unless defined(&CTL_VM_NAMES);
    }
    eval 'sub SWAPSKIPBYTES () {8192;}' unless defined(&SWAPSKIPBYTES);
    eval 'sub KERN_SUCCESS () {0;}' unless defined(&KERN_SUCCESS);
    eval 'sub KERN_INVALID_ADDRESS () {1;}' unless defined(&KERN_INVALID_ADDRESS);
    eval 'sub KERN_PROTECTION_FAILURE () {2;}' unless defined(&KERN_PROTECTION_FAILURE);
    eval 'sub KERN_NO_SPACE () {3;}' unless defined(&KERN_NO_SPACE);
    eval 'sub KERN_INVALID_ARGUMENT () {4;}' unless defined(&KERN_INVALID_ARGUMENT);
    eval 'sub KERN_FAILURE () {5;}' unless defined(&KERN_FAILURE);
    eval 'sub KERN_RESOURCE_SHORTAGE () {6;}' unless defined(&KERN_RESOURCE_SHORTAGE);
    eval 'sub KERN_NOT_RECEIVER () {7;}' unless defined(&KERN_NOT_RECEIVER);
    eval 'sub KERN_NO_ACCESS () {8;}' unless defined(&KERN_NO_ACCESS);
    eval 'sub KERN_PAGES_LOCKED () {9;}' unless defined(&KERN_PAGES_LOCKED);
    unless(defined(&ASSEMBLER)) {
	if(defined(&_KERNEL)) {
	    eval 'sub atop {
	        local($x) = @_;
    		eval q(((($x)) >>  &PAGE_SHIFT));
	    }' unless defined(&atop);
	    eval 'sub ptoa {
	        local($x) = @_;
    		eval q(((($x) <<  &PAGE_SHIFT)));
	    }' unless defined(&ptoa);
	    eval 'sub round_page {
	        local($x) = @_;
    		eval q(((((($x)) +  &PAGE_MASK) & ~ &PAGE_MASK)));
	    }' unless defined(&round_page);
	    eval 'sub trunc_page {
	        local($x) = @_;
    		eval q((((($x)) & ~ &PAGE_MASK)));
	    }' unless defined(&trunc_page);
	    eval 'sub num_pages {
	        local($x) = @_;
    		eval q(((((($x)) +  &PAGE_MASK) >>  &PAGE_SHIFT)));
	    }' unless defined(&num_pages);
	} else {
	    eval 'sub round_page {
	        local($x) = @_;
    		eval q((((($x) + ( &vm_page_size - 1)) /  &vm_page_size) *  &vm_page_size));
	    }' unless defined(&round_page);
	    eval 'sub trunc_page {
	        local($x) = @_;
    		eval q((((($x)) /  &vm_page_size) *  &vm_page_size));
	    }' unless defined(&trunc_page);
	}
    }
}
1;
