require '_h2ph_pre.ph';

unless(defined(&_SPARC_PARAM_H_)) {
    eval 'sub _SPARC_PARAM_H_ () {1;}' unless defined(&_SPARC_PARAM_H_);
    eval 'sub _MACHINE () { &sparc;}' unless defined(&_MACHINE);
    eval 'sub MACHINE () {"sparc";}' unless defined(&MACHINE);
    eval 'sub _MACHINE_ARCH () { &sparc;}' unless defined(&_MACHINE_ARCH);
    eval 'sub MACHINE_ARCH () {"sparc";}' unless defined(&MACHINE_ARCH);
    eval 'sub MID_MACHINE () { &MID_SPARC;}' unless defined(&MID_MACHINE);
    if(defined(&_KERNEL)) {
	unless(defined(&_LOCORE)) {
	    require 'machine/cpu.ph';
	}
    }
    eval 'sub ALIGNBYTES () {7;}' unless defined(&ALIGNBYTES);
    eval 'sub ALIGN {
        local($p) = @_;
	    eval q(((($p) +  &ALIGNBYTES) & ~ &ALIGNBYTES));
    }' unless defined(&ALIGN);
    eval 'sub ALIGNED_POINTER {
        local($p,$t) = @_;
	    eval q((((($p)) & ($sizeof{$t}-1)) == 0));
    }' unless defined(&ALIGNED_POINTER);
    eval 'sub SUN4_PGSHIFT () {13;}' unless defined(&SUN4_PGSHIFT);
    eval 'sub SUN4CM_PGSHIFT () {12;}' unless defined(&SUN4CM_PGSHIFT);
    if(defined( &_KERNEL)  && !defined( &_LOCORE)) {
    }
    eval 'sub KERNBASE () {0xf8000000;}' unless defined(&KERNBASE);
    eval 'sub KERNTEXTOFF () {0xf8004000;}' unless defined(&KERNTEXTOFF);
    eval 'sub DEV_BSIZE () {512;}' unless defined(&DEV_BSIZE);
    eval 'sub DEV_BSHIFT () {9;}' unless defined(&DEV_BSHIFT);
    eval 'sub BLKDEV_IOSIZE () {2048;}' unless defined(&BLKDEV_IOSIZE);
    eval 'sub MAXPHYS () {(64* 1024);}' unless defined(&MAXPHYS);
    eval 'sub CLSIZE () {1;}' unless defined(&CLSIZE);
    eval 'sub CLSIZELOG2 () {0;}' unless defined(&CLSIZELOG2);
    eval 'sub SSIZE () {1;}' unless defined(&SSIZE);
    eval 'sub USPACE () {8192;}' unless defined(&USPACE);
    eval 'sub MSIZE () {128;}' unless defined(&MSIZE);
    eval 'sub MCLBYTES () {2048;}' unless defined(&MCLBYTES);
    eval 'sub MCLSHIFT () {11;}' unless defined(&MCLSHIFT);
    eval 'sub MCLOFSET () {( &MCLBYTES - 1);}' unless defined(&MCLOFSET);
    unless(defined(&NMBCLUSTERS)) {
	if(defined(&GATEWAY)) {
	    eval 'sub NMBCLUSTERS () {1024;}' unless defined(&NMBCLUSTERS);
	} else {
	    eval 'sub NMBCLUSTERS () {512;}' unless defined(&NMBCLUSTERS);
	}
    }
    eval 'sub MSGBUFSIZE () {4096;}' unless defined(&MSGBUFSIZE);
    unless(defined(&NKMEMCLUSTERS)) {
	eval 'sub NKMEMCLUSTERS () {(6* 1024* 1024/  &CLBYTES);}' unless defined(&NKMEMCLUSTERS);
    }
    eval 'sub ctod {
        local($x) = @_;
	    eval q((($x) << ( &PGSHIFT -  &DEV_BSHIFT)));
    }' unless defined(&ctod);
    eval 'sub dtoc {
        local($x) = @_;
	    eval q((($x) >> ( &PGSHIFT -  &DEV_BSHIFT)));
    }' unless defined(&dtoc);
    eval 'sub ctob {
        local($x) = @_;
	    eval q((($x) <<  &PGSHIFT));
    }' unless defined(&ctob);
    eval 'sub btoc {
        local($x) = @_;
	    eval q(((($x) +  &PGOFSET) >>  &PGSHIFT));
    }' unless defined(&btoc);
    eval 'sub btodb {
        local($x) = @_;
	    eval q((($x) >>  &DEV_BSHIFT));
    }' unless defined(&btodb);
    eval 'sub dbtob {
        local($x) = @_;
	    eval q((($x) <<  &DEV_BSHIFT));
    }' unless defined(&dbtob);
    eval 'sub bdbtofsb {
        local($bn) = @_;
	    eval q((($bn) / ( &BLKDEV_IOSIZE /  &DEV_BSIZE)));
    }' unless defined(&bdbtofsb);
    eval 'sub sparc_btop {
        local($x) = @_;
	    eval q((($x) >>  &PGSHIFT));
    }' unless defined(&sparc_btop);
    eval 'sub sparc_ptob {
        local($x) = @_;
	    eval q((($x) <<  &PGSHIFT));
    }' unless defined(&sparc_ptob);
    if(defined(&_KERNEL)) {
	unless(defined(&_LOCORE)) {
	    eval 'sub DELAY {
	        local($n) = @_;
    		eval q( &delay($n));
	    }' unless defined(&DELAY);
	    if(0) {
	    }
	}
    }
    eval 'sub CPU_SUN4 () {0;}' unless defined(&CPU_SUN4);
    eval 'sub CPU_SUN4C () {1;}' unless defined(&CPU_SUN4C);
    eval 'sub CPU_SUN4M () {2;}' unless defined(&CPU_SUN4M);
    if(defined( &SUN4M)  && defined( &SUN4C)  && defined( &SUN4)) {
	eval 'sub CPU_ISSUN4M () {( &cputyp ==  &CPU_SUN4M);}' unless defined(&CPU_ISSUN4M);
	eval 'sub CPU_ISSUN4C () {( &cputyp ==  &CPU_SUN4C);}' unless defined(&CPU_ISSUN4C);
	eval 'sub CPU_ISSUN4 () {( &cputyp ==  &CPU_SUN4);}' unless defined(&CPU_ISSUN4);
	eval 'sub CPU_ISSUN4OR4C () {( &cputyp ==  &CPU_SUN4 ||  &cputyp ==  &CPU_SUN4C);}' unless defined(&CPU_ISSUN4OR4C);
	eval 'sub CPU_ISSUN4COR4M () {( &cputyp ==  &CPU_SUN4C ||  &cputyp ==  &CPU_SUN4M);}' unless defined(&CPU_ISSUN4COR4M);
	eval 'sub NBPG () { &nbpg;}' unless defined(&NBPG);
	eval 'sub PGOFSET () { &pgofset;}' unless defined(&PGOFSET);
	eval 'sub PGSHIFT () { &pgshift;}' unless defined(&PGSHIFT);
    }
 elsif(defined( &SUN4M)  && defined( &SUN4C)  && !defined( &SUN4)) {
	eval 'sub CPU_ISSUN4M () {( &cputyp ==  &CPU_SUN4M);}' unless defined(&CPU_ISSUN4M);
	eval 'sub CPU_ISSUN4C () {( &cputyp ==  &CPU_SUN4C);}' unless defined(&CPU_ISSUN4C);
	eval 'sub CPU_ISSUN4 () {(0);}' unless defined(&CPU_ISSUN4);
	eval 'sub CPU_ISSUN4OR4C () {( &cputyp ==  &CPU_SUN4C);}' unless defined(&CPU_ISSUN4OR4C);
	eval 'sub CPU_ISSUN4COR4M () {( &cputyp ==  &CPU_SUN4C ||  &cputyp ==  &CPU_SUN4M);}' unless defined(&CPU_ISSUN4COR4M);
	eval 'sub NBPG () {4096;}' unless defined(&NBPG);
	eval 'sub PGOFSET () {( &NBPG-1);}' unless defined(&PGOFSET);
	eval 'sub PGSHIFT () { &SUN4CM_PGSHIFT;}' unless defined(&PGSHIFT);
	eval 'sub PAGE_SIZE () {4096;}' unless defined(&PAGE_SIZE);
	eval 'sub PAGE_MASK () {( &PAGE_SIZE - 1);}' unless defined(&PAGE_MASK);
	eval 'sub PAGE_SHIFT () { &SUN4CM_PGSHIFT;}' unless defined(&PAGE_SHIFT);
    }
 elsif(defined( &SUN4M)  && !defined( &SUN4C)  && defined( &SUN4)) {
	eval 'sub CPU_ISSUN4M () {( &cputyp ==  &CPU_SUN4M);}' unless defined(&CPU_ISSUN4M);
	eval 'sub CPU_ISSUN4C () {(0);}' unless defined(&CPU_ISSUN4C);
	eval 'sub CPU_ISSUN4 () {( &cputyp ==  &CPU_SUN4);}' unless defined(&CPU_ISSUN4);
	eval 'sub CPU_ISSUN4OR4C () {( &cputyp ==  &CPU_SUN4);}' unless defined(&CPU_ISSUN4OR4C);
	eval 'sub CPU_ISSUN4COR4M () {( &cputyp ==  &CPU_SUN4M);}' unless defined(&CPU_ISSUN4COR4M);
	eval 'sub NBPG () { &nbpg;}' unless defined(&NBPG);
	eval 'sub PGOFSET () { &pgofset;}' unless defined(&PGOFSET);
	eval 'sub PGSHIFT () { &pgshift;}' unless defined(&PGSHIFT);
    }
 elsif(defined( &SUN4M)  && !defined( &SUN4C)  && !defined( &SUN4)) {
	eval 'sub CPU_ISSUN4M () {(1);}' unless defined(&CPU_ISSUN4M);
	eval 'sub CPU_ISSUN4C () {(0);}' unless defined(&CPU_ISSUN4C);
	eval 'sub CPU_ISSUN4 () {(0);}' unless defined(&CPU_ISSUN4);
	eval 'sub CPU_ISSUN4OR4C () {(0);}' unless defined(&CPU_ISSUN4OR4C);
	eval 'sub CPU_ISSUN4COR4M () {(1);}' unless defined(&CPU_ISSUN4COR4M);
	eval 'sub NBPG () {4096;}' unless defined(&NBPG);
	eval 'sub PGOFSET () {( &NBPG-1);}' unless defined(&PGOFSET);
	eval 'sub PGSHIFT () { &SUN4CM_PGSHIFT;}' unless defined(&PGSHIFT);
	eval 'sub PAGE_SIZE () {4096;}' unless defined(&PAGE_SIZE);
	eval 'sub PAGE_MASK () {( &PAGE_SIZE - 1);}' unless defined(&PAGE_MASK);
	eval 'sub PAGE_SHIFT () { &SUN4CM_PGSHIFT;}' unless defined(&PAGE_SHIFT);
    }
 elsif(!defined( &SUN4M)  && defined( &SUN4C)  && defined( &SUN4)) {
	eval 'sub CPU_ISSUN4M () {(0);}' unless defined(&CPU_ISSUN4M);
	eval 'sub CPU_ISSUN4C () {( &cputyp ==  &CPU_SUN4C);}' unless defined(&CPU_ISSUN4C);
	eval 'sub CPU_ISSUN4 () {( &cputyp ==  &CPU_SUN4);}' unless defined(&CPU_ISSUN4);
	eval 'sub CPU_ISSUN4OR4C () {(1);}' unless defined(&CPU_ISSUN4OR4C);
	eval 'sub CPU_ISSUN4COR4M () {( &cputyp ==  &CPU_SUN4C);}' unless defined(&CPU_ISSUN4COR4M);
	eval 'sub NBPG () { &nbpg;}' unless defined(&NBPG);
	eval 'sub PGOFSET () { &pgofset;}' unless defined(&PGOFSET);
	eval 'sub PGSHIFT () { &pgshift;}' unless defined(&PGSHIFT);
    }
 elsif(!defined( &SUN4M)  && defined( &SUN4C)  && !defined( &SUN4)) {
	eval 'sub CPU_ISSUN4M () {(0);}' unless defined(&CPU_ISSUN4M);
	eval 'sub CPU_ISSUN4C () {(1);}' unless defined(&CPU_ISSUN4C);
	eval 'sub CPU_ISSUN4 () {(0);}' unless defined(&CPU_ISSUN4);
	eval 'sub CPU_ISSUN4OR4C () {(1);}' unless defined(&CPU_ISSUN4OR4C);
	eval 'sub CPU_ISSUN4COR4M () {(1);}' unless defined(&CPU_ISSUN4COR4M);
	eval 'sub NBPG () {4096;}' unless defined(&NBPG);
	eval 'sub PGOFSET () {( &NBPG-1);}' unless defined(&PGOFSET);
	eval 'sub PGSHIFT () { &SUN4CM_PGSHIFT;}' unless defined(&PGSHIFT);
	eval 'sub PAGE_SIZE () {4096;}' unless defined(&PAGE_SIZE);
	eval 'sub PAGE_MASK () {( &PAGE_SIZE - 1);}' unless defined(&PAGE_MASK);
	eval 'sub PAGE_SHIFT () { &SUN4CM_PGSHIFT;}' unless defined(&PAGE_SHIFT);
    }
 elsif(!defined( &SUN4M)  && !defined( &SUN4C)  && defined( &SUN4)) {
	eval 'sub CPU_ISSUN4M () {(0);}' unless defined(&CPU_ISSUN4M);
	eval 'sub CPU_ISSUN4C () {(0);}' unless defined(&CPU_ISSUN4C);
	eval 'sub CPU_ISSUN4 () {(1);}' unless defined(&CPU_ISSUN4);
	eval 'sub CPU_ISSUN4OR4C () {(1);}' unless defined(&CPU_ISSUN4OR4C);
	eval 'sub CPU_ISSUN4COR4M () {(0);}' unless defined(&CPU_ISSUN4COR4M);
	eval 'sub NBPG () {8192;}' unless defined(&NBPG);
	eval 'sub PGOFSET () {( &NBPG-1);}' unless defined(&PGOFSET);
	eval 'sub PGSHIFT () { &SUN4_PGSHIFT;}' unless defined(&PGSHIFT);
	eval 'sub PAGE_SIZE () {8192;}' unless defined(&PAGE_SIZE);
	eval 'sub PAGE_MASK () {( &PAGE_SIZE - 1);}' unless defined(&PAGE_MASK);
	eval 'sub PAGE_SHIFT () { &SUN4_PGSHIFT;}' unless defined(&PAGE_SHIFT);
    }
 elsif(!defined( &SUN4M)  && !defined( &SUN4C)  && !defined( &SUN4)) {
	eval 'sub CPU_ISSUN4M () {( &cputyp ==  &CPU_SUN4M);}' unless defined(&CPU_ISSUN4M);
	eval 'sub CPU_ISSUN4C () {( &cputyp ==  &CPU_SUN4C);}' unless defined(&CPU_ISSUN4C);
	eval 'sub CPU_ISSUN4 () {( &cputyp ==  &CPU_SUN4);}' unless defined(&CPU_ISSUN4);
	eval 'sub CPU_ISSUN4OR4C () {( &cputyp ==  &CPU_SUN4 ||  &cputyp ==  &CPU_SUN4C);}' unless defined(&CPU_ISSUN4OR4C);
	eval 'sub CPU_ISSUN4COR4M () {( &cputyp ==  &CPU_SUN4C ||  &cputyp ==  &CPU_SUN4M);}' unless defined(&CPU_ISSUN4COR4M);
	eval 'sub NBPG () { &nbpg;}' unless defined(&NBPG);
	eval 'sub PGOFSET () { &pgofset;}' unless defined(&PGOFSET);
	eval 'sub PGSHIFT () { &pgshift;}' unless defined(&PGSHIFT);
    }
}
1;
