require '_h2ph_pre.ph';

require 'sys/queue.ph';
require 'netinet/ip6.ph';
require 'netinet6/ip6_var.ph';
require 'netinet/icmp6.ph';
require 'netinet/ip_ipsp.ph';
unless(defined(&inp_faddr)) {
    sub inp_faddr () {	 ($inp_faddru->{iau_a4u}->{inaddr});}
}
unless(defined(&inp_faddr6)) {
    sub inp_faddr6 () {	 ($inp_faddru->{iau_addr6});}
}
unless(defined(&inp_laddr)) {
    sub inp_laddr () {	 ($inp_laddru->{iau_a4u}->{inaddr});}
}
unless(defined(&inp_laddr6)) {
    sub inp_laddr6 () {	 ($inp_laddru->{iau_addr6});}
}
unless(defined(&inp_route)) {
    sub inp_route () {	 ($inp_ru->{ru_route});}
}
unless(defined(&inp_route6)) {
    sub inp_route6 () {	 ($inp_ru->{ru_route6});}
}
unless(defined(&inp_ip)) {
    sub inp_ip () {	 ($inp_hu->{hu_ip});}
}
unless(defined(&inp_ipv6)) {
    sub inp_ipv6 () {	 ($inp_hu->{hu_ipv6});}
}
unless(defined(&inp_moptions)) {
    sub inp_moptions () {	 ($inp_mou->{mou_mo});}
}
unless(defined(&inp_moptions6)) {
    sub inp_moptions6 () {	 ($inp_mou->{mou_mo6});}
}
unless(defined(&SL_AUTH)) {
    sub SL_AUTH () {	0;}
}
unless(defined(&SL_ESP_TRANS)) {
    sub SL_ESP_TRANS () {	1;}
}
unless(defined(&SL_ESP_NETWORK)) {
    sub SL_ESP_NETWORK () {	2;}
}
unless(defined(&SR_FAILED)) {
    sub SR_FAILED () {	1;}
}
unless(defined(&SR_SUCCESS)) {
    sub SR_SUCCESS () {	2;}
}
unless(defined(&SR_WAIT)) {
    sub SR_WAIT () {	3;}
}
unless(defined(&INP_RECVOPTS)) {
    sub INP_RECVOPTS () {	0x001;}
}
unless(defined(&INP_RECVRETOPTS)) {
    sub INP_RECVRETOPTS () {	0x002;}
}
unless(defined(&INP_RECVDSTADDR)) {
    sub INP_RECVDSTADDR () {	0x004;}
}
unless(defined(&INP_RXDSTOPTS)) {
    sub INP_RXDSTOPTS () {	 &INP_RECVOPTS;}
}
unless(defined(&INP_RXHOPOPTS)) {
    sub INP_RXHOPOPTS () {	 &INP_RECVRETOPTS;}
}
unless(defined(&INP_RXINFO)) {
    sub INP_RXINFO () {	 &INP_RECVDSTADDR;}
}
unless(defined(&INP_RXSRCRT)) {
    sub INP_RXSRCRT () {	0x010;}
}
unless(defined(&INP_HOPLIMIT)) {
    sub INP_HOPLIMIT () {	0x020;}
}
unless(defined(&INP_CONTROLOPTS)) {
    sub INP_CONTROLOPTS () {	( &INP_RECVOPTS| &INP_RECVRETOPTS| &INP_RECVDSTADDR|  &INP_RXSRCRT| &INP_HOPLIMIT);}
}
unless(defined(&INP_HDRINCL)) {
    sub INP_HDRINCL () {	0x008;}
}
unless(defined(&INP_HIGHPORT)) {
    sub INP_HIGHPORT () {	0x010;}
}
unless(defined(&INP_LOWPORT)) {
    sub INP_LOWPORT () {	0x020;}
}
unless(defined(&INP_IPV6)) {
    sub INP_IPV6 () {	0x100;}
}
if(1) {
    eval 'sub IN6P_RECVOPTS () { &INP_RECVOPTS;}' unless defined(&IN6P_RECVOPTS);
    eval 'sub IN6P_RECVRETOPTS () { &INP_RECVRETOPTS;}' unless defined(&IN6P_RECVRETOPTS);
    eval 'sub IN6P_RECVDSTADDR () { &INP_RECVDSTADDR;}' unless defined(&IN6P_RECVDSTADDR);
    eval 'sub IN6P_HIGHPORT () { &INP_HIGHPORT;}' unless defined(&IN6P_HIGHPORT);
    eval 'sub IN6P_LOWPORT () { &INP_LOWPORT;}' unless defined(&IN6P_LOWPORT);
    eval 'sub IN6P_PKTINFO () {0x010000;}' unless defined(&IN6P_PKTINFO);
    eval 'sub IN6P_HOPLIMIT () {0x020000;}' unless defined(&IN6P_HOPLIMIT);
    eval 'sub IN6P_HOPOPTS () {0x040000;}' unless defined(&IN6P_HOPOPTS);
    eval 'sub IN6P_DSTOPTS () {0x080000;}' unless defined(&IN6P_DSTOPTS);
    eval 'sub IN6P_RTHDR () {0x100000;}' unless defined(&IN6P_RTHDR);
    eval 'sub IN6P_RTHDRDSTOPTS () {0x200000;}' unless defined(&IN6P_RTHDRDSTOPTS);
    eval 'sub IN6P_ANONPORT () {0x4000000;}' unless defined(&IN6P_ANONPORT);
    eval 'sub IN6P_FAITH () {0x8000000;}' unless defined(&IN6P_FAITH);
    eval 'sub IN6P_CONTROLOPTS () {( &IN6P_PKTINFO| &IN6P_HOPLIMIT| &IN6P_HOPOPTS|  &IN6P_DSTOPTS| &IN6P_RTHDR| &IN6P_RTHDRDSTOPTS);}' unless defined(&IN6P_CONTROLOPTS);
}
unless(defined(&INPLOOKUP_WILDCARD)) {
    sub INPLOOKUP_WILDCARD () {	1;}
}
unless(defined(&INPLOOKUP_SETLOCAL)) {
    sub INPLOOKUP_SETLOCAL () {	2;}
}
unless(defined(&INPLOOKUP_IPV6)) {
    sub INPLOOKUP_IPV6 () {	4;}
}
unless(defined(&sotoinpcb)) {
    sub sotoinpcb {
	local($so) = @_;
	eval q((($so)-> &so_pcb));
    }
}
unless(defined(&DP_MAPBITS)) {
    sub DP_MAPBITS () {	($sizeof{ &u_int32_t} *  &NBBY);}
}
unless(defined(&DP_MAPSIZE)) {
    sub DP_MAPSIZE () {	( &howmany( &IPPORT_RESERVED/2,  &DP_MAPBITS));}
}
unless(defined(&DP_SET)) {
    sub DP_SET {
	local($m, $p) = @_;
	eval q((($m)[(($p) -  &IPPORT_RESERVED/2) /  &DP_MAPBITS] |= (1<< (($p) %  &DP_MAPBITS))));
    }
}
unless(defined(&DP_CLR)) {
    sub DP_CLR {
	local($m, $p) = @_;
	eval q((($m)[(($p) -  &IPPORT_RESERVED/2) /  &DP_MAPBITS] &= ~(1<< (($p) %  &DP_MAPBITS))));
    }
}
unless(defined(&DP_ISSET)) {
    sub DP_ISSET {
	local($m, $p) = @_;
	eval q((($m)[(($p) -  &IPPORT_RESERVED/2) /  &DP_MAPBITS] & (1<< (($p) %  &DP_MAPBITS))));
    }
}
unless(defined(&DEFBADDYNAMICPORTS_TCP)) {
    sub DEFBADDYNAMICPORTS_TCP () {	{ 587, 749, 750, 751, 760, 761, 871, 0};}
}
unless(defined(&DEFBADDYNAMICPORTS_UDP)) {
    sub DEFBADDYNAMICPORTS_UDP () {	{ 750, 751, 0};}
}
if(defined(&_KERNEL)) {
    eval 'sub sotopf {
        local($so) = @_;
	    eval q(( ($so->{so_proto}->{pr_domain}->{dom_family})));
    }' unless defined(&sotopf);
    if(defined(&INET6)) {
    }
}
1;
