require '_h2ph_pre.ph';

unless(defined(&_ISP_OPENBSD_H)) {
    eval 'sub _ISP_OPENBSD_H () {1;}' unless defined(&_ISP_OPENBSD_H);
    require 'sys/types.ph';
    require 'sys/param.ph';
    require 'sys/systm.ph';
    require 'sys/kernel.ph';
    require 'sys/errno.ph';
    require 'sys/ioctl.ph';
    require 'sys/device.ph';
    require 'sys/malloc.ph';
    require 'sys/buf.ph';
    require 'sys/proc.ph';
    require 'sys/user.ph';
    require 'sys/queue.ph';
    require 'scsi/scsi_all.ph';
    require 'scsi/scsi_all.ph';
    require 'scsi/scsiconf.ph';
    require 'scsi/scsi_message.ph';
    require 'scsi/scsi_debug.ph';
    require 'vm/vm.ph';
    require 'vm/vm_param.ph';
    require 'vm/pmap.ph';
    eval 'sub ISP_PLATFORM_VERSION_MAJOR () {1;}' unless defined(&ISP_PLATFORM_VERSION_MAJOR);
    eval 'sub ISP_PLATFORM_VERSION_MINOR () {0;}' unless defined(&ISP_PLATFORM_VERSION_MINOR);
    eval 'sub discovered () { ($un->{_discovered});}' unless defined(&discovered);
    eval 'sub INLINE () { &inline;}' unless defined(&INLINE);
    eval 'sub ISP2100_FABRIC () {1;}' unless defined(&ISP2100_FABRIC);
    eval 'sub ISP2100_SCRLEN () {0x400;}' unless defined(&ISP2100_SCRLEN);
    eval 'sub MEMZERO () { &bzero;}' unless defined(&MEMZERO);
    eval 'sub MEMCPY {
        local($dst, $src, $amt) = @_;
	    eval q( &bcopy(($src), ($dst), ($amt)));
    }' unless defined(&MEMCPY);
    eval 'sub SNPRINTF () { &snprintf;}' unless defined(&SNPRINTF);
    eval 'sub STRNCAT () { &strncat;}' unless defined(&STRNCAT);
    eval 'sub USEC_DELAY {
        local($x) = @_;
	    eval q( &delay($x));
    }' unless defined(&USEC_DELAY);
    eval 'sub NANOTIME_T () {\'struct timeval\';}' unless defined(&NANOTIME_T);
    eval 'sub GET_NANOTIME () { &microtime;}' unless defined(&GET_NANOTIME);
    eval 'sub GET_NANOSEC {
        local($x) = @_;
	    eval q(((($x)-> &tv_sec * 1000000+ ($x)-> &tv_usec) * 1000));
    }' unless defined(&GET_NANOSEC);
    eval 'sub NANOTIME_SUB () { &isp_microtime_sub;}' unless defined(&NANOTIME_SUB);
    eval 'sub MAXISPREQUEST {
        local($isp) = @_;
	    eval q(256);
    }' unless defined(&MAXISPREQUEST);
    if(defined(&__alpha__)) {
	eval 'sub MEMORYBARRIER {
	    local($isp, $type, $offset, $size) = @_;
    	    eval q( &alpha_mb());
	}' unless defined(&MEMORYBARRIER);
    } else {
	eval 'sub MEMORYBARRIER {
	    local($isp, $type, $offset, $size) = @_;
    	    eval q();
	}' unless defined(&MEMORYBARRIER);
    }
    eval 'sub MBOX_ACQUIRE {
        local($isp) = @_;
	    eval q();
    }' unless defined(&MBOX_ACQUIRE);
    eval 'sub MBOX_WAIT_COMPLETE () { &isp_wait_complete;}' unless defined(&MBOX_WAIT_COMPLETE);
    eval 'sub MBOX_NOTIFY_COMPLETE {
        local($isp) = @_;
	    eval q( &if ( ($isp->{isp_osinfo}->{mboxwaiting})) {  ($isp->{isp_osinfo}->{mboxwaiting}) = 0;  &wakeup( ($isp->{isp_osinfo}->{mboxwaiting})); }  ($isp->{isp_mboxbsy}) = 0);
    }' unless defined(&MBOX_NOTIFY_COMPLETE);
    eval 'sub MBOX_RELEASE {
        local($isp) = @_;
	    eval q();
    }' unless defined(&MBOX_RELEASE);
    unless(defined(&SCSI_GOOD)) {
	eval 'sub SCSI_GOOD () {0x0;}' unless defined(&SCSI_GOOD);
    }
    unless(defined(&SCSI_CHECK)) {
	eval 'sub SCSI_CHECK () {0x2;}' unless defined(&SCSI_CHECK);
    }
    unless(defined(&SCSI_BUSY)) {
	eval 'sub SCSI_BUSY () {0x8;}' unless defined(&SCSI_BUSY);
    }
    unless(defined(&SCSI_QFULL)) {
	eval 'sub SCSI_QFULL () {0x28;}' unless defined(&SCSI_QFULL);
    }
    eval 'sub XS_T () {\'struct scsi_xfer\';}' unless defined(&XS_T);
    eval 'sub XS_CHANNEL {
        local($xs) = @_;
	    eval q(((($xs)-> ($sc_link->{flags}) &  &SDEV_2NDBUS)? 1: 0));
    }' unless defined(&XS_CHANNEL);
    eval 'sub XS_ISP {
        local($xs) = @_;
	    eval q(($xs)-> ($sc_link->{adapter_softc}));
    }' unless defined(&XS_ISP);
    eval 'sub XS_LUN {
        local($xs) = @_;
	    eval q(( ($xs)-> ($sc_link->{lun})));
    }' unless defined(&XS_LUN);
    eval 'sub XS_TGT {
        local($xs) = @_;
	    eval q(( ($xs)-> ($sc_link->{target})));
    }' unless defined(&XS_TGT);
    eval 'sub XS_CDBP {
        local($xs) = @_;
	    eval q(( ($xs)-> &cmd));
    }' unless defined(&XS_CDBP);
    eval 'sub XS_CDBLEN {
        local($xs) = @_;
	    eval q(($xs)-> &cmdlen);
    }' unless defined(&XS_CDBLEN);
    eval 'sub XS_XFRLEN {
        local($xs) = @_;
	    eval q(($xs)-> &datalen);
    }' unless defined(&XS_XFRLEN);
    eval 'sub XS_TIME {
        local($xs) = @_;
	    eval q(($xs)-> &timeout);
    }' unless defined(&XS_TIME);
    eval 'sub XS_RESID {
        local($xs) = @_;
	    eval q(($xs)-> &resid);
    }' unless defined(&XS_RESID);
    eval 'sub XS_STSP {
        local($xs) = @_;
	    eval q((($xs)-> &status));
    }' unless defined(&XS_STSP);
    eval 'sub XS_SNSP {
        local($xs) = @_;
	    eval q((($xs)-> &sense));
    }' unless defined(&XS_SNSP);
    eval 'sub XS_SNSLEN {
        local($xs) = @_;
	    eval q(($sizeof{$xs}-> &sense));
    }' unless defined(&XS_SNSLEN);
    eval 'sub XS_SNSKEY {
        local($xs) = @_;
	    eval q((($xs)-> ($sense->{flags})));
    }' unless defined(&XS_SNSKEY);
    eval 'sub XS_TAG_P {
        local($xs) = @_;
	    eval q(((($xs)-> &flags &  &SCSI_POLL) != 0));
    }' unless defined(&XS_TAG_P);
    eval 'sub XS_TAG_TYPE {
        local($xs) = @_;
	    eval q( &REQFLAG_STAG);
    }' unless defined(&XS_TAG_TYPE);
    eval 'sub XS_SETERR {
        local($xs, $v) = @_;
	    eval q(($xs)-> &error = $v);
    }' unless defined(&XS_SETERR);
    eval 'sub HBA_NOERROR () { &XS_NOERROR;}' unless defined(&HBA_NOERROR);
    eval 'sub HBA_BOTCH () { &XS_DRIVER_STUFFUP;}' unless defined(&HBA_BOTCH);
    eval 'sub HBA_CMDTIMEOUT () { &XS_TIMEOUT;}' unless defined(&HBA_CMDTIMEOUT);
    eval 'sub HBA_SELTIMEOUT () { &XS_SELTIMEOUT;}' unless defined(&HBA_SELTIMEOUT);
    eval 'sub HBA_TGTBSY () { &XS_BUSY;}' unless defined(&HBA_TGTBSY);
    eval 'sub HBA_BUSRESET () { &XS_RESET;}' unless defined(&HBA_BUSRESET);
    eval 'sub HBA_ABORTED () { &XS_DRIVER_STUFFUP;}' unless defined(&HBA_ABORTED);
    eval 'sub HBA_DATAOVR () { &XS_DRIVER_STUFFUP;}' unless defined(&HBA_DATAOVR);
    eval 'sub HBA_ARQFAIL () { &XS_DRIVER_STUFFUP;}' unless defined(&HBA_ARQFAIL);
    eval 'sub XS_ERR {
        local($xs) = @_;
	    eval q(($xs)-> &error);
    }' unless defined(&XS_ERR);
    eval 'sub XS_NOERR {
        local($xs) = @_;
	    eval q(($xs)-> &error ==  &XS_NOERROR);
    }' unless defined(&XS_NOERR);
    eval 'sub XS_INITERR {
        local($xs) = @_;
	    eval q(($xs)-> &error = 0,  &XS_CMD_S_CLEAR($xs));
    }' unless defined(&XS_INITERR);
    eval 'sub XS_SAVE_SENSE {
        local($xs, $sp) = @_;
	    eval q( &bcopy( ($sp->{req_sense_data}), ($xs)-> &sense,  &imin( &XS_SNSLEN($xs),  ($sp->{req_sense_len}))));
    }' unless defined(&XS_SAVE_SENSE);
    eval 'sub XS_SET_STATE_STAT {
        local($a, $b, $c) = @_;
	    eval q();
    }' unless defined(&XS_SET_STATE_STAT);
    eval 'sub DEFAULT_IID {
        local($x) = @_;
	    eval q(7);
    }' unless defined(&DEFAULT_IID);
    eval 'sub DEFAULT_LOOPID {
        local($x) = @_;
	    eval q(107);
    }' unless defined(&DEFAULT_LOOPID);
    eval 'sub DEFAULT_NODEWWN {
        local($isp) = @_;
	    eval q(($isp)-> ($isp_osinfo->{un}->{_wwn}));
    }' unless defined(&DEFAULT_NODEWWN);
    eval 'sub DEFAULT_PORTWWN {
        local($isp) = @_;
	    eval q(($isp)-> ($isp_osinfo->{un}->{_wwn}));
    }' unless defined(&DEFAULT_PORTWWN);
    eval 'sub ISP_NODEWWN {
        local($isp) = @_;
	    eval q( &FCPARAM($isp)-> &isp_nodewwn);
    }' unless defined(&ISP_NODEWWN);
    eval 'sub ISP_PORTWWN {
        local($isp) = @_;
	    eval q( &FCPARAM($isp)-> &isp_portwwn);
    }' unless defined(&ISP_PORTWWN);
    eval 'sub ISP_UNSWIZZLE_AND_COPY_PDBP {
        local($isp, $dest, $src) = @_;
	    eval q( &if($src != $dest)  &bcopy($src, $dest, $sizeof{ &isp_pdb_t}));
    }' unless defined(&ISP_UNSWIZZLE_AND_COPY_PDBP);
    eval 'sub ISP_SWIZZLE_ICB {
        local($a, $b) = @_;
	    eval q();
    }' unless defined(&ISP_SWIZZLE_ICB);
    if(defined(&__sparc__)) {
	eval 'sub ISP_SWIZZLE_REQUEST {
	    local($a, $b) = @_;
    	    eval q( &ISP_SBUSIFY_ISPHDR($a, ($b)-> &req_header);  &ISP_SBUSIFY_ISPREQ($a, $b));
	}' unless defined(&ISP_SWIZZLE_REQUEST);
	eval 'sub ISP_UNSWIZZLE_RESPONSE {
	    local($a, $b, $c) = @_;
    	    eval q( &ISP_SBUSIFY_ISPHDR($a, ($b)-> &req_header));
	}' unless defined(&ISP_UNSWIZZLE_RESPONSE);
    } else {
	eval 'sub ISP_SWIZZLE_REQUEST {
	    local($a, $b) = @_;
    	    eval q();
	}' unless defined(&ISP_SWIZZLE_REQUEST);
	eval 'sub ISP_UNSWIZZLE_RESPONSE {
	    local($a, $b, $c) = @_;
    	    eval q();
	}' unless defined(&ISP_UNSWIZZLE_RESPONSE);
    }
    eval 'sub ISP_SWIZZLE_SNS_REQ {
        local($a, $b) = @_;
	    eval q();
    }' unless defined(&ISP_SWIZZLE_SNS_REQ);
    eval 'sub ISP_UNSWIZZLE_SNS_RSP {
        local($a, $b, $c) = @_;
	    eval q();
    }' unless defined(&ISP_UNSWIZZLE_SNS_RSP);
    if(defined(&__sparc__)) {
	eval 'sub ISP_SWIZZLE_NVRAM_WORD {
	    local($isp, $rp) = @_;
    	    eval q({  &u_int16_t  &tmp = *$rp >> 8;  &tmp |= ((*$rp & 0xff) << 8); *$rp =  &tmp; });
	}' unless defined(&ISP_SWIZZLE_NVRAM_WORD);
    } else {
	eval 'sub ISP_SWIZZLE_NVRAM_WORD {
	    local($isp, $rp) = @_;
    	    eval q();
	}' unless defined(&ISP_SWIZZLE_NVRAM_WORD);
    }
    require 'dev/ic/ispreg.ph';
    require 'dev/ic/ispvar.ph';
    require 'dev/ic/ispmbox.ph';
    eval 'sub isp_name () { ($isp_osinfo->{_dev}->{dv_xname});}' unless defined(&isp_name);
    eval 'sub isp_unit () { ($isp_osinfo->{_dev}->{dv_unit});}' unless defined(&isp_unit);
    eval 'sub ISP_LOCK () { &isp_lock;}' unless defined(&ISP_LOCK);
    eval 'sub ISP_UNLOCK () { &isp_unlock;}' unless defined(&ISP_UNLOCK);
    eval 'sub ISP_ILOCK {
        local($x) = @_;
	    eval q( &isp_lock($x);  ($isp->{isp_osinfo}->{onintstack})++);
    }' unless defined(&ISP_ILOCK);
    eval 'sub ISP_IUNLOCK {
        local($x) = @_;
	    eval q( ($isp->{isp_osinfo}->{onintstack})--;  &isp_unlock($x));
    }' unless defined(&ISP_IUNLOCK);
    eval 'sub XS_PSTS_INWDOG () {0x10000;}' unless defined(&XS_PSTS_INWDOG);
    eval 'sub XS_PSTS_GRACE () {0x20000;}' unless defined(&XS_PSTS_GRACE);
    eval 'sub XS_PSTS_ALL () { &SCSI_PRIVATE;}' unless defined(&XS_PSTS_ALL);
    eval 'sub XS_CMD_S_WDOG {
        local($xs) = @_;
	    eval q(($xs)-> &flags |=  &XS_PSTS_INWDOG);
    }' unless defined(&XS_CMD_S_WDOG);
    eval 'sub XS_CMD_C_WDOG {
        local($xs) = @_;
	    eval q(($xs)-> &flags &= ~ &XS_PSTS_INWDOG);
    }' unless defined(&XS_CMD_C_WDOG);
    eval 'sub XS_CMD_WDOG_P {
        local($xs) = @_;
	    eval q(((($xs)-> &flags &  &XS_PSTS_INWDOG) != 0));
    }' unless defined(&XS_CMD_WDOG_P);
    eval 'sub XS_CMD_S_GRACE {
        local($xs) = @_;
	    eval q(($xs)-> &flags |=  &XS_PSTS_GRACE);
    }' unless defined(&XS_CMD_S_GRACE);
    eval 'sub XS_CMD_C_GRACE {
        local($xs) = @_;
	    eval q(($xs)-> &flags &= ~ &XS_PSTS_GRACE);
    }' unless defined(&XS_CMD_C_GRACE);
    eval 'sub XS_CMD_GRACE_P {
        local($xs) = @_;
	    eval q(((($xs)-> &flags &  &XS_PSTS_GRACE) != 0));
    }' unless defined(&XS_CMD_GRACE_P);
    eval 'sub XS_CMD_S_DONE {
        local($xs) = @_;
	    eval q(($xs)-> &flags |=  &ITSDONE);
    }' unless defined(&XS_CMD_S_DONE);
    eval 'sub XS_CMD_C_DONE {
        local($xs) = @_;
	    eval q(($xs)-> &flags &= ~ &ITSDONE);
    }' unless defined(&XS_CMD_C_DONE);
    eval 'sub XS_CMD_DONE_P {
        local($xs) = @_;
	    eval q(((($xs)-> &flags &  &ITSDONE) != 0));
    }' unless defined(&XS_CMD_DONE_P);
    eval 'sub XS_CMD_S_CLEAR {
        local($xs) = @_;
	    eval q(($xs)-> &flags &= ~ &XS_PSTS_ALL);
    }' unless defined(&XS_CMD_S_CLEAR);
    require 'dev/ic/isp_inline.ph';
}
1;
