require '_h2ph_pre.ph';

unless(defined(&_VM_PAGE_)) {
    eval 'sub _VM_PAGE_ () {1;}' unless defined(&_VM_PAGE_);
    if(defined( &UVM)) {
	require 'uvm/uvm_extern.ph';
	require 'vm/pglist.ph';
    } else {
    }
    if(!defined( &UVM) ) {
    }
    if(defined( &UVM)) {
    } else {
    }
    if(defined( &UVM)  && defined( &UVM_PAGE_TRKOWN)) {
    }
    if(defined( &UVM)) {
	eval 'sub PG_CLEAN () {0x0008;}' unless defined(&PG_CLEAN);
	eval 'sub PG_BUSY () {0x0010;}' unless defined(&PG_BUSY);
	eval 'sub PG_WANTED () {0x0020;}' unless defined(&PG_WANTED);
	eval 'sub PG_TABLED () {0x0040;}' unless defined(&PG_TABLED);
	eval 'sub PG_FAKE () {0x0200;}' unless defined(&PG_FAKE);
	eval 'sub PG_FILLED () {0x0400;}' unless defined(&PG_FILLED);
	eval 'sub PG_DIRTY () {0x0800;}' unless defined(&PG_DIRTY);
	eval 'sub PG_RELEASED () {0x1000;}' unless defined(&PG_RELEASED);
	eval 'sub PG_FAULTING () {0x2000;}' unless defined(&PG_FAULTING);
	eval 'sub PG_CLEANCHK () {0x4000;}' unless defined(&PG_CLEANCHK);
	eval 'sub PQ_FREE () {0x0001;}' unless defined(&PQ_FREE);
	eval 'sub PQ_INACTIVE () {0x0002;}' unless defined(&PQ_INACTIVE);
	eval 'sub PQ_ACTIVE () {0x0004;}' unless defined(&PQ_ACTIVE);
	eval 'sub PQ_LAUNDRY () {0x0008;}' unless defined(&PQ_LAUNDRY);
	eval 'sub PQ_ANON () {0x0010;}' unless defined(&PQ_ANON);
	eval 'sub PQ_AOBJ () {0x0020;}' unless defined(&PQ_AOBJ);
	eval 'sub PQ_SWAPBACKED () {( &PQ_ANON| &PQ_AOBJ);}' unless defined(&PQ_SWAPBACKED);
	eval 'sub PQ_ENCRYPT () {0x0040;}' unless defined(&PQ_ENCRYPT);
    } else {
	eval 'sub PG_INACTIVE () {0x0001;}' unless defined(&PG_INACTIVE);
	eval 'sub PG_ACTIVE () {0x0002;}' unless defined(&PG_ACTIVE);
	eval 'sub PG_LAUNDRY () {0x0004;}' unless defined(&PG_LAUNDRY);
	eval 'sub PG_CLEAN () {0x0008;}' unless defined(&PG_CLEAN);
	eval 'sub PG_BUSY () {0x0010;}' unless defined(&PG_BUSY);
	eval 'sub PG_WANTED () {0x0020;}' unless defined(&PG_WANTED);
	eval 'sub PG_TABLED () {0x0040;}' unless defined(&PG_TABLED);
	eval 'sub PG_COPYONWRITE () {0x0080;}' unless defined(&PG_COPYONWRITE);
	eval 'sub PG_FICTITIOUS () {0x0100;}' unless defined(&PG_FICTITIOUS);
	eval 'sub PG_FAKE () {0x0200;}' unless defined(&PG_FAKE);
	eval 'sub PG_FILLED () {0x0400;}' unless defined(&PG_FILLED);
	eval 'sub PG_DIRTY () {0x0800;}' unless defined(&PG_DIRTY);
	eval 'sub PG_FREE () {0x1000;}' unless defined(&PG_FREE);
	eval 'sub PG_FAULTING () {0x2000;}' unless defined(&PG_FAULTING);
	eval 'sub PG_PAGEROWNED () {0x4000;}' unless defined(&PG_PAGEROWNED);
	eval 'sub PG_PTPAGE () {0x8000;}' unless defined(&PG_PTPAGE);
    }
    if(defined( &MACHINE_NEW_NONCONTIG)) {
	eval 'sub VM_PSTRAT_RANDOM () {1;}' unless defined(&VM_PSTRAT_RANDOM);
	eval 'sub VM_PSTRAT_BSEARCH () {2;}' unless defined(&VM_PSTRAT_BSEARCH);
	eval 'sub VM_PSTRAT_BIGFIRST () {3;}' unless defined(&VM_PSTRAT_BIGFIRST);
	if(defined( &UVM)) {
	}
    }
    if(defined( &_KERNEL)) {
	if(defined( &MACHINE_NEW_NONCONTIG)) {
	} else {
	    if(defined( &MACHINE_NONCONTIG)) {
		eval 'sub VM_PAGE_INDEX {
		    local($pa) = @_;
    		    eval q(( &pmap_page_index(($pa)) -  &first_page));
		}' unless defined(&VM_PAGE_INDEX);
	    } else {
		eval 'sub VM_PAGE_INDEX {
		    local($pa) = @_;
    		    eval q(( &atop(($pa)) -  &first_page));
		}' unless defined(&VM_PAGE_INDEX);
	    }
	}
	if(defined( &MACHINE_NEW_NONCONTIG)) {
	}
	if(!defined( &UVM)) {
	    if(defined( &MACHINE_NONCONTIG) || defined( &MACHINE_NEW_NONCONTIG)) {
	    }
	    if(defined( &MACHINE_NEW_NONCONTIG)) {
	    }
	    if(!defined( &MACHINE_NONCONTIG)  && !defined( &MACHINE_NEW_NONCONTIG)) {
	    }
	}
	eval 'sub VM_PAGE_TO_PHYS {
	    local($entry) = @_;
    	    eval q((($entry)-> &phys_addr));
	}' unless defined(&VM_PAGE_TO_PHYS);
	if(defined( &MACHINE_NEW_NONCONTIG)) {
	    if((defined(&VM_PHYSSEG_MAX) ? &VM_PHYSSEG_MAX : 0) == 1) {
	    }
 elsif(((defined(&VM_PHYSSEG_STRAT) ? &VM_PHYSSEG_STRAT : 0) == (defined(&VM_PSTRAT_BSEARCH) ? &VM_PSTRAT_BSEARCH : 0))) {
	    } else {
	    }
	    eval 'sub IS_VM_PHYSADDR {
	        local($PA) = @_;
    		eval q(( &vm_physseg_find( &atop($PA),  &NULL) != -1));
	    }' unless defined(&IS_VM_PHYSADDR);
	}
 elsif(defined( &MACHINE_NONCONTIG)) {
	    eval 'sub IS_VM_PHYSADDR {
	        local($pa) = @_;
    		eval q(( &pmap_page_index($pa) >= 0));
	    }' unless defined(&IS_VM_PHYSADDR);
	    eval 'sub PHYS_TO_VM_PAGE {
	        local($pa) = @_;
    		eval q(( $vm_page_array[ &pmap_page_index($pa) -  &first_page]));
	    }' unless defined(&PHYS_TO_VM_PAGE);
	} else {
	    eval 'sub IS_VM_PHYSADDR {
	        local($pa) = @_;
    		eval q((($pa) >=  &first_phys_addr  && ($pa) <=  &last_phys_addr));
	    }' unless defined(&IS_VM_PHYSADDR);
	    eval 'sub PHYS_TO_VM_PAGE {
	        local($pa) = @_;
    		eval q(( $vm_page_array[ &atop($pa) -  &first_page ]));
	    }' unless defined(&PHYS_TO_VM_PAGE);
	}
	if(defined( &UVM)) {
	    eval 'sub VM_PAGE_IS_FREE {
	        local($entry) = @_;
    		eval q((($entry)-> &pqflags &  &PQ_FREE));
	    }' unless defined(&VM_PAGE_IS_FREE);
	} else {
	    eval 'sub VM_PAGE_IS_FREE {
	        local($entry) = @_;
    		eval q((($entry)-> &flags &  &PG_FREE));
	    }' unless defined(&VM_PAGE_IS_FREE);
	}
	eval 'sub PAGE_ASSERT_WAIT {
	    local($m, $interruptible) = @_;
    	    eval q({ ($m)-> &flags |=  &PG_WANTED;  &assert_wait(($m), ($interruptible)); });
	}' unless defined(&PAGE_ASSERT_WAIT);
	eval 'sub PAGE_WAKEUP {
	    local($m) = @_;
    	    eval q({ ($m)-> &flags &= ~ &PG_BUSY;  &if (($m)-> &flags &  &PG_WANTED) { ($m)-> &flags &= ~ &PG_WANTED;  &thread_wakeup(($m)); } });
	}' unless defined(&PAGE_WAKEUP);
	eval 'sub vm_page_lock_queues () {
	    eval q( &simple_lock( &vm_page_queue_lock));
	}' unless defined(&vm_page_lock_queues);
	eval 'sub vm_page_unlock_queues () {
	    eval q( &simple_unlock( &vm_page_queue_lock));
	}' unless defined(&vm_page_unlock_queues);
	eval 'sub vm_page_set_modified {
	    local($m) = @_;
    	    eval q({ ($m)-> &flags &= ~ &PG_CLEAN; });
	}' unless defined(&vm_page_set_modified);
	if(!defined( &MACHINE_NONCONTIG)  && !defined( &MACHINE_NEW_NONCONTIG)) {
	    eval 'sub VM_PAGE_INIT {
	        local($mem, $obj, $offset) = @_;
    		eval q({ ($mem)-> &flags =  &PG_BUSY |  &PG_CLEAN |  &PG_FAKE;  &vm_page_insert(($mem), ($obj), ($offset)); ($mem)-> &wire_count = 0; });
	    }' unless defined(&VM_PAGE_INIT);
	} else {
	    eval 'sub VM_PAGE_INIT {
	        local($mem, $obj, $offset) = @_;
    		eval q({ -> &flags =  &PG_BUSY |  &PG_CLEAN |  &PG_FAKE;  &if  &vm_page_insert(($mem), ($obj), ($offset));  &else ($mem)-> &object =  &NULL; ($mem)-> &wire_count = 0; });
	    }' unless defined(&VM_PAGE_INIT);
	}
	if((defined(&VM_PAGE_DEBUG) ? &VM_PAGE_DEBUG : 0)) {
	    if(defined( &MACHINE_NEW_NONCONTIG) ) {
	    }
 elsif(defined( &MACHINE_NONCONTIG)) {
		eval 'sub VM_PAGE_CHECK {
		    local($mem) = @_;
    		    eval q({  &if (( < (  $vm_page_array[0])) || (( $mem) > (  $vm_page_array[ &vm_page_count])) || (( ($mem->{flags}) & ( &PG_ACTIVE |  &PG_INACTIVE)) == ( &PG_ACTIVE |  &PG_INACTIVE)))  &panic(\\"vm_page_check: not valid!\\"); });
		}' unless defined(&VM_PAGE_CHECK);
	    } else {
		eval 'sub VM_PAGE_CHECK {
		    local($mem) = @_;
    		    eval q({  &if (( < (  $vm_page_array[0])) || (( $mem) > (  $vm_page_array[ &last_page- &first_page])) || (( ($mem->{flags}) & ( &PG_ACTIVE |  &PG_INACTIVE)) == ( &PG_ACTIVE |  &PG_INACTIVE)))  &panic(\\"vm_page_check: not valid!\\"); });
		}' unless defined(&VM_PAGE_CHECK);
	    }
	} else {
	    eval 'sub VM_PAGE_CHECK {
	        local($mem) = @_;
    		eval q();
	    }' unless defined(&VM_PAGE_CHECK);
	}
    }
}
1;
