require '_h2ph_pre.ph';

require 'machine/mips_param.ph';
unless(defined(&_MACHINE)) {
    sub _MACHINE () {	 &pmax;}
}
unless(defined(&MACHINE)) {
    sub MACHINE () {	"pmax";}
}
unless(defined(&_MACHINE_ARCH)) {
    sub _MACHINE_ARCH () {	 &mips;}
}
unless(defined(&MACHINE_ARCH)) {
    sub MACHINE_ARCH () {	"mips";}
}
unless(defined(&MID_MACHINE)) {
    sub MID_MACHINE () {	 &MID_PMAX;}
}
unless(defined(&KERNBASE)) {
    sub KERNBASE () {	0x80000000;}
}
unless(defined(&KERNTEXTOFF)) {
    sub KERNTEXTOFF () {	0x80030000;}
}
unless(defined(&BTOPKERNBASE)) {
    sub BTOPKERNBASE () {	( &KERNBASE >>  &PGSHIFT);}
}
unless(defined(&DEV_BSIZE)) {
    sub DEV_BSIZE () {	512;}
}
unless(defined(&DEV_BSHIFT)) {
    sub DEV_BSHIFT () {	9;}
}
unless(defined(&BLKDEV_IOSIZE)) {
    sub BLKDEV_IOSIZE () {	2048;}
}
unless(defined(&MAXPHYS)) {
    sub MAXPHYS () {	(64* 1024);}
}
unless(defined(&CLSIZE)) {
    sub CLSIZE () {	1;}
}
unless(defined(&CLSIZELOG2)) {
    sub CLSIZELOG2 () {	0;}
}
unless(defined(&SSIZE)) {
    sub SSIZE () {	1;}
}
unless(defined(&SINCR)) {
    sub SINCR () {	1;}
}
unless(defined(&UPAGES)) {
    sub UPAGES () {	2;}
}
unless(defined(&UADDR)) {
    sub UADDR () {	0xffffd000;}
}
unless(defined(&USPACE)) {
    sub USPACE () {	( &UPAGES* &NBPG);}
}
unless(defined(&UVPN)) {
    sub UVPN () {	( &UADDR>> &PGSHIFT);}
}
unless(defined(&KERNELSTACK)) {
    sub KERNELSTACK () {	( &UADDR+ &UPAGES* &NBPG);}
}
unless(defined(&MSIZE)) {
    sub MSIZE () {	128;}
}
unless(defined(&MCLSHIFT)) {
    eval 'sub MCLSHIFT () {11;}' unless defined(&MCLSHIFT);
}
unless(defined(&MCLBYTES)) {
    sub MCLBYTES () {	(1<<  &MCLSHIFT);}
}
unless(defined(&MCLOFSET)) {
    sub MCLOFSET () {	( &MCLBYTES - 1);}
}
unless(defined(&NMBCLUSTERS)) {
    if(defined(&GATEWAY)) {
	eval 'sub NMBCLUSTERS () {2048;}' unless defined(&NMBCLUSTERS);
    } else {
	eval 'sub NMBCLUSTERS () {1024;}' unless defined(&NMBCLUSTERS);
    }
}
unless(defined(&MSGBUFSIZE)) {
    sub MSGBUFSIZE () {	 &NBPG;}
}
if(defined(&_KERNEL)) {
    unless(defined(&_LOCORE)) {
	eval 'sub DELAY {
	    local($n) = @_;
    	    eval q({  &register \'int\'  &N =  &cpuspeed * ($n);  &while (-- &N > 0); });
	}' unless defined(&DELAY);
    }
}
1;
