require '_h2ph_pre.ph';

unless(defined(&_LOCORE)) {
    if((defined(&BYTE_ORDER) ? &BYTE_ORDER : 0) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : 0)) {
    }
    if((defined(&BYTE_ORDER) ? &BYTE_ORDER : 0) == (defined(&LITTLE_ENDIAN) ? &LITTLE_ENDIAN : 0)) {
    }
}
unless(defined(&PT_ENTRY_NULL)) {
    sub PT_ENTRY_NULL () {	( 0);}
}
unless(defined(&PG_WIRED)) {
    sub PG_WIRED () {	0x80000000;}
}
unless(defined(&PG_RO)) {
    sub PG_RO () {	0x40000000;}
}
unless(defined(&PG_SVPN)) {
    sub PG_SVPN () {	0xfffff000;}
}
unless(defined(&PG_HVPN)) {
    sub PG_HVPN () {	0xffffe000;}
}
unless(defined(&PG_ODDPG)) {
    sub PG_ODDPG () {	0x00001000;}
}
unless(defined(&PG_ASID)) {
    sub PG_ASID () {	0x000000ff;}
}
unless(defined(&PG_G)) {
    sub PG_G () {	0x00000001;}
}
unless(defined(&PG_V)) {
    sub PG_V () {	0x00000002;}
}
unless(defined(&PG_NV)) {
    sub PG_NV () {	0x00000000;}
}
unless(defined(&PG_M)) {
    sub PG_M () {	0x00000004;}
}
unless(defined(&PG_ATTR)) {
    sub PG_ATTR () {	0x0000003f;}
}
unless(defined(&PG_UNCACHED)) {
    sub PG_UNCACHED () {	0x00000010;}
}
unless(defined(&PG_CACHED)) {
    sub PG_CACHED () {	0x00000018;}
}
unless(defined(&PG_CACHEMODE)) {
    sub PG_CACHEMODE () {	0x00000038;}
}
unless(defined(&PG_ROPAGE)) {
    sub PG_ROPAGE () {	( &PG_V |  &PG_RO |  &PG_CACHED);}
}
unless(defined(&PG_RWPAGE)) {
    sub PG_RWPAGE () {	( &PG_V |  &PG_M |  &PG_CACHED);}
}
unless(defined(&PG_CWPAGE)) {
    sub PG_CWPAGE () {	( &PG_V |  &PG_CACHED);}
}
unless(defined(&PG_IOPAGE)) {
    sub PG_IOPAGE () {	( &PG_G |  &PG_V |  &PG_M |  &PG_UNCACHED);}
}
unless(defined(&PG_FRAME)) {
    sub PG_FRAME () {	0x3fffffc0;}
}
unless(defined(&PG_SHIFT)) {
    sub PG_SHIFT () {	6;}
}
unless(defined(&vad_to_pfn)) {
    sub vad_to_pfn {
	local($x) = @_;
	eval q(((($x) >>  &PG_SHIFT) &  &PG_FRAME));
    }
}
unless(defined(&pfn_to_vad)) {
    sub pfn_to_vad {
	local($x) = @_;
	eval q(((($x) &  &PG_FRAME) <<  &PG_SHIFT));
    }
}
unless(defined(&vad_to_vpn)) {
    sub vad_to_vpn {
	local($x) = @_;
	eval q((($x) &  &PG_SVPN));
    }
}
unless(defined(&vpn_to_vad)) {
    sub vpn_to_vad {
	local($x) = @_;
	eval q((($x) &  &PG_SVPN));
    }
}
unless(defined(&PTE_TO_PADDR)) {
    sub PTE_TO_PADDR {
	local($pte) = @_;
	eval q(( &pfn_to_vad($pte)));
    }
}
unless(defined(&PAGE_IS_RDONLY)) {
    sub PAGE_IS_RDONLY {
	local($pte,$va) = @_;
	eval q(( &pmap_is_page_ro( &pmap_kernel(),  &mips_trunc_page($va), ($pte))));
    }
}
unless(defined(&uvtopte)) {
    sub uvtopte {
	local($adr) = @_;
	eval q(((($adr) >>  &PGSHIFT) & ( &NPTEPG -1)));
    }
}
unless(defined(&PG_SIZE_4K)) {
    sub PG_SIZE_4K () {	0x00000000;}
}
unless(defined(&PG_SIZE_16K)) {
    sub PG_SIZE_16K () {	0x00006000;}
}
unless(defined(&PG_SIZE_64K)) {
    sub PG_SIZE_64K () {	0x0001e000;}
}
unless(defined(&PG_SIZE_256K)) {
    sub PG_SIZE_256K () {	0x0007e000;}
}
unless(defined(&PG_SIZE_1M)) {
    sub PG_SIZE_1M () {	0x001fe000;}
}
unless(defined(&PG_SIZE_4M)) {
    sub PG_SIZE_4M () {	0x007fe000;}
}
unless(defined(&PG_SIZE_16M)) {
    sub PG_SIZE_16M () {	0x01ffe000;}
}
1;
