require '_h2ph_pre.ph';

unless(defined(&_MIPS_PARAM_H_)) {
    eval 'sub _MIPS_PARAM_H_ () {1;}' unless defined(&_MIPS_PARAM_H_);
    if(defined(&_KERNEL)) {
	if(defined(&_LOCORE)) {
	    require 'machine/psl.ph';
	} else {
	    require 'machine/cpu.ph';
	}
    }
    eval 'sub MACHINE_ARCH () {"mips";}' unless defined(&MACHINE_ARCH);
    eval 'sub _MACHINE_ARCH () { &mips;}' unless defined(&_MACHINE_ARCH);
    eval 'sub ALIGNBYTES () {7;}' unless defined(&ALIGNBYTES);
    eval 'sub ALIGN {
        local($p) = @_;
	    eval q(((($p) +  &ALIGNBYTES) &~  &ALIGNBYTES));
    }' unless defined(&ALIGN);
    eval 'sub NBPG () {4096;}' unless defined(&NBPG);
    eval 'sub PGOFSET () {( &NBPG-1);}' unless defined(&PGOFSET);
    eval 'sub PGSHIFT () {12;}' unless defined(&PGSHIFT);
    eval 'sub NPTEPG () {( &NBPG/4);}' unless defined(&NPTEPG);
    eval 'sub NBSEG () {0x400000;}' unless defined(&NBSEG);
    eval 'sub SEGOFSET () {( &NBSEG-1);}' unless defined(&SEGOFSET);
    eval 'sub SEGSHIFT () {22;}' unless defined(&SEGSHIFT);
    eval 'sub KERNBASE () {0x80000000;}' unless defined(&KERNBASE);
    eval 'sub BTOPKERNBASE () {( &KERNBASE >>  &PGSHIFT);}' unless defined(&BTOPKERNBASE);
    eval 'sub DEV_BSIZE () {512;}' unless defined(&DEV_BSIZE);
    eval 'sub DEV_BSHIFT () {9;}' unless defined(&DEV_BSHIFT);
    eval 'sub BLKDEV_IOSIZE () {2048;}' unless defined(&BLKDEV_IOSIZE);
    eval 'sub MAXPHYS () {(32* 1024);}' unless defined(&MAXPHYS);
    eval 'sub CLSIZE () {1;}' unless defined(&CLSIZE);
    eval 'sub CLSIZELOG2 () {0;}' unless defined(&CLSIZELOG2);
    eval 'sub SSIZE () {1;}' unless defined(&SSIZE);
    eval 'sub SINCR () {1;}' unless defined(&SINCR);
    eval 'sub UPAGES () {2;}' unless defined(&UPAGES);
    if(defined( &_LOCORE)  && defined( &notyet)) {
	eval 'sub UADDR () {0xffffffffffffc000;}' unless defined(&UADDR);
    } else {
	eval 'sub UADDR () {0xffffc000;}' unless defined(&UADDR);
    }
    eval 'sub USPACE () {( &UPAGES* &NBPG);}' unless defined(&USPACE);
    eval 'sub UVPN () {( &UADDR>> &PGSHIFT);}' unless defined(&UVPN);
    eval 'sub KERNELSTACK () {( &UADDR+ &UPAGES* &NBPG);}' unless defined(&KERNELSTACK);
    eval 'sub MSIZE () {128;}' unless defined(&MSIZE);
    eval 'sub MCLSHIFT () {11;}' unless defined(&MCLSHIFT);
    eval 'sub MCLBYTES () {(1<<  &MCLSHIFT);}' unless defined(&MCLBYTES);
    eval 'sub MCLOFSET () {( &MCLBYTES - 1);}' unless defined(&MCLOFSET);
    unless(defined(&NMBCLUSTERS)) {
	if(defined(&GATEWAY)) {
	    eval 'sub NMBCLUSTERS () {2048;}' unless defined(&NMBCLUSTERS);
	} else {
	    eval 'sub NMBCLUSTERS () {1024;}' unless defined(&NMBCLUSTERS);
	}
    }
    unless(defined(&NKMEMCLUSTERS)) {
	eval 'sub NKMEMCLUSTERS () {(4096*1024/ &CLBYTES);}' unless defined(&NKMEMCLUSTERS);
    }
    eval 'sub ctod {
        local($x) = @_;
	    eval q((($x) << ( &PGSHIFT -  &DEV_BSHIFT)));
    }' unless defined(&ctod);
    eval 'sub dtoc {
        local($x) = @_;
	    eval q((($x) >> ( &PGSHIFT -  &DEV_BSHIFT)));
    }' unless defined(&dtoc);
    eval 'sub ctob {
        local($x) = @_;
	    eval q((($x) <<  &PGSHIFT));
    }' unless defined(&ctob);
    eval 'sub btoc {
        local($x) = @_;
	    eval q(((($x) +  &PGOFSET) >>  &PGSHIFT));
    }' unless defined(&btoc);
    eval 'sub btodb {
        local($x) = @_;
	    eval q((($x) >>  &DEV_BSHIFT));
    }' unless defined(&btodb);
    eval 'sub dbtob {
        local($x) = @_;
	    eval q((($x) <<  &DEV_BSHIFT));
    }' unless defined(&dbtob);
    eval 'sub bdbtofsb {
        local($bn) = @_;
	    eval q((($bn) / ( &BLKDEV_IOSIZE/ &DEV_BSIZE)));
    }' unless defined(&bdbtofsb);
    eval 'sub mips_round_page {
        local($x) = @_;
	    eval q((((($x)) +  &NBPG - 1) & ~( &NBPG-1)));
    }' unless defined(&mips_round_page);
    eval 'sub mips_trunc_page {
        local($x) = @_;
	    eval q((($x) & ~( &NBPG-1)));
    }' unless defined(&mips_trunc_page);
    eval 'sub mips_btop {
        local($x) = @_;
	    eval q((($x) >>  &PGSHIFT));
    }' unless defined(&mips_btop);
    eval 'sub mips_ptob {
        local($x) = @_;
	    eval q((($x) <<  &PGSHIFT));
    }' unless defined(&mips_ptob);
    eval 'sub DELAY {
        local($n) = @_;
	    eval q({  &register \'int\'  &N = ($n);  &while (-- &N > 0); });
    }' unless defined(&DELAY);
}
1;
