require '_h2ph_pre.ph';

unless(defined(&_ISPVAR_H)) {
    eval 'sub _ISPVAR_H () {1;}' unless defined(&_ISPVAR_H);
    if(defined( &__NetBSD__) || defined( &__OpenBSD__)) {
	require 'dev/ic/ispmbox.ph';
	if(defined(&ISP_TARGET_MODE)) {
	    require 'dev/ic/isp_target.ph';
	    require 'dev/ic/isp_tpublic.ph';
	}
    }
    if(defined(&__FreeBSD__)) {
	require 'dev/isp/ispmbox.ph';
	if(defined(&ISP_TARGET_MODE)) {
	    require 'dev/isp/isp_target.ph';
	    require 'dev/isp/isp_tpublic.ph';
	}
    }
    if(defined(&__linux__)) {
	require 'ispmbox.ph';
	if(defined(&ISP_TARGET_MODE)) {
	    require 'isp_target.ph';
	    require 'isp_tpublic.ph';
	}
    }
    eval 'sub ISP_CORE_VERSION_MAJOR () {1;}' unless defined(&ISP_CORE_VERSION_MAJOR);
    eval 'sub ISP_CORE_VERSION_MINOR () {16;}' unless defined(&ISP_CORE_VERSION_MINOR);
    eval 'sub MAX_TARGETS () {16;}' unless defined(&MAX_TARGETS);
    if(defined(&ISP2100_FABRIC)) {
	eval 'sub MAX_FC_TARG () {256;}' unless defined(&MAX_FC_TARG);
    } else {
	eval 'sub MAX_FC_TARG () {126;}' unless defined(&MAX_FC_TARG);
    }
    eval 'sub ISP_MAX_TARGETS {
        local($isp) = @_;
	    eval q(( &IS_FC($isp)?  &MAX_FC_TARG :  &MAX_TARGETS));
    }' unless defined(&ISP_MAX_TARGETS);
    eval 'sub ISP_MAX_LUNS {
        local($isp) = @_;
	    eval q(($isp)-> &isp_maxluns);
    }' unless defined(&ISP_MAX_LUNS);
    eval 'sub ISP_READ {
        local($isp, $reg) = @_;
	    eval q((*($isp)-> ($isp_mdvec->{dv_rd_reg}))(($isp), ($reg)));
    }' unless defined(&ISP_READ);
    eval 'sub ISP_WRITE {
        local($isp, $reg, $val) = @_;
	    eval q((*($isp)-> ($isp_mdvec->{dv_wr_reg}))(($isp), ($reg), ($val)));
    }' unless defined(&ISP_WRITE);
    eval 'sub ISP_MBOXDMASETUP {
        local($isp) = @_;
	    eval q((*($isp)-> ($isp_mdvec->{dv_mbxdma}))(($isp)));
    }' unless defined(&ISP_MBOXDMASETUP);
    eval 'sub ISP_DMASETUP {
        local($isp, $xs, $req, $iptrp, $optr) = @_;
	    eval q((*($isp)-> ($isp_mdvec->{dv_dmaset}))(($isp), ($xs), ($req), ($iptrp), ($optr)));
    }' unless defined(&ISP_DMASETUP);
    eval 'sub ISP_DMAFREE {
        local($isp, $xs, $hndl) = @_;
	    eval q( &if (($isp)-> ($isp_mdvec->{dv_dmaclr})) (*($isp)-> ($isp_mdvec->{dv_dmaclr}))(($isp), ($xs), ($hndl)));
    }' unless defined(&ISP_DMAFREE);
    eval 'sub ISP_RESET0 {
        local($isp) = @_;
	    eval q( &if (($isp)-> ($isp_mdvec->{dv_reset0})) (*($isp)-> ($isp_mdvec->{dv_reset0}))(($isp)));
    }' unless defined(&ISP_RESET0);
    eval 'sub ISP_RESET1 {
        local($isp) = @_;
	    eval q( &if (($isp)-> ($isp_mdvec->{dv_reset1})) (*($isp)-> ($isp_mdvec->{dv_reset1}))(($isp)));
    }' unless defined(&ISP_RESET1);
    eval 'sub ISP_DUMPREGS {
        local($isp) = @_;
	    eval q( &if (($isp)-> ($isp_mdvec->{dv_dregs})) (*($isp)-> ($isp_mdvec->{dv_dregs}))(($isp)));
    }' unless defined(&ISP_DUMPREGS);
    eval 'sub ISP_SETBITS {
        local($isp, $reg, $val) = @_;
	    eval q((*($isp)-> ($isp_mdvec->{dv_wr_reg}))(($isp), ($reg),  &ISP_READ(($isp), ($reg)) | ($val)));
    }' unless defined(&ISP_SETBITS);
    eval 'sub ISP_CLRBITS {
        local($isp, $reg, $val) = @_;
	    eval q((*($isp)-> ($isp_mdvec->{dv_wr_reg}))(($isp), ($reg),  &ISP_READ(($isp), ($reg)) & ~($val)));
    }' unless defined(&ISP_CLRBITS);
    eval 'sub QENTRY_LEN () {64;}' unless defined(&QENTRY_LEN);
    eval 'sub RQUEST_QUEUE_LEN () { &MAXISPREQUEST;}' unless defined(&RQUEST_QUEUE_LEN);
    if((defined(&MAXISPREQUEST) ? &MAXISPREQUEST : 0) > 64) {
	eval 'sub RESULT_QUEUE_LEN () {( &MAXISPREQUEST/2);}' unless defined(&RESULT_QUEUE_LEN);
    } else {
	eval 'sub RESULT_QUEUE_LEN () { &MAXISPREQUEST;}' unless defined(&RESULT_QUEUE_LEN);
    }
    eval 'sub ISP_QUEUE_ENTRY {
        local($q, $idx) = @_;
	    eval q((($q) + (($idx) *  &QENTRY_LEN)));
    }' unless defined(&ISP_QUEUE_ENTRY);
    eval 'sub ISP_QUEUE_SIZE {
        local($n) = @_;
	    eval q((($n) *  &QENTRY_LEN));
    }' unless defined(&ISP_QUEUE_SIZE);
    eval 'sub ISP_NXT_QENTRY {
        local($idx, $qlen) = @_;
	    eval q(((($idx) + 1) & (($qlen)-1)));
    }' unless defined(&ISP_NXT_QENTRY);
    eval 'sub ISP_QAVAIL {
        local($in, $out, $qlen) = @_;
	    eval q((($in == $out)? ($qlen - 1) : (($in > $out)? (($qlen - 1) - ($in - $out)) : ($out - $in - 1))));
    }' unless defined(&ISP_QAVAIL);
    eval 'sub ISP_ADD_REQUEST {
        local($isp, $iptr) = @_;
	    eval q( &ISP_WRITE($isp,  &INMAILBOX4, $iptr),  ($isp->{isp_reqidx}) = $iptr);
    }' unless defined(&ISP_ADD_REQUEST);
    eval 'sub DPARM_DISC () {0x8000;}' unless defined(&DPARM_DISC);
    eval 'sub DPARM_PARITY () {0x4000;}' unless defined(&DPARM_PARITY);
    eval 'sub DPARM_WIDE () {0x2000;}' unless defined(&DPARM_WIDE);
    eval 'sub DPARM_SYNC () {0x1000;}' unless defined(&DPARM_SYNC);
    eval 'sub DPARM_TQING () {0x0800;}' unless defined(&DPARM_TQING);
    eval 'sub DPARM_ARQ () {0x0400;}' unless defined(&DPARM_ARQ);
    eval 'sub DPARM_QFRZ () {0x0200;}' unless defined(&DPARM_QFRZ);
    eval 'sub DPARM_RENEG () {0x0100;}' unless defined(&DPARM_RENEG);
    eval 'sub DPARM_NARROW () {0x0080;}' unless defined(&DPARM_NARROW);
    eval 'sub DPARM_ASYNC () {0x0040;}' unless defined(&DPARM_ASYNC);
    eval 'sub DPARM_DEFAULT () {(0xff00 & ~ &DPARM_QFRZ);}' unless defined(&DPARM_DEFAULT);
    eval 'sub DPARM_SAFE_DFLT () {( &DPARM_DEFAULT & ~( &DPARM_WIDE| &DPARM_SYNC| &DPARM_TQING));}' unless defined(&DPARM_SAFE_DFLT);
    eval 'sub ISP_40M_SYNCPARMS () {0x080a;}' unless defined(&ISP_40M_SYNCPARMS);
    eval 'sub ISP_20M_SYNCPARMS () {0x080c;}' unless defined(&ISP_20M_SYNCPARMS);
    eval 'sub ISP_10M_SYNCPARMS () {0x0c19;}' unless defined(&ISP_10M_SYNCPARMS);
    eval 'sub ISP_08M_SYNCPARMS () {0x0c25;}' unless defined(&ISP_08M_SYNCPARMS);
    eval 'sub ISP_05M_SYNCPARMS () {0x0c32;}' unless defined(&ISP_05M_SYNCPARMS);
    eval 'sub ISP_04M_SYNCPARMS () {0x0c41;}' unless defined(&ISP_04M_SYNCPARMS);
    eval 'sub FL_PORT_ID () {0x7e;}' unless defined(&FL_PORT_ID);
    eval 'sub FC_PORT_ID () {0x7f;}' unless defined(&FC_PORT_ID);
    eval 'sub FC_SNS_ID () {0x80;}' unless defined(&FC_SNS_ID);
    eval 'sub FW_CONFIG_WAIT () {0;}' unless defined(&FW_CONFIG_WAIT);
    eval 'sub FW_WAIT_AL_PA () {1;}' unless defined(&FW_WAIT_AL_PA);
    eval 'sub FW_WAIT_LOGIN () {2;}' unless defined(&FW_WAIT_LOGIN);
    eval 'sub FW_READY () {3;}' unless defined(&FW_READY);
    eval 'sub FW_LOSS_OF_SYNC () {4;}' unless defined(&FW_LOSS_OF_SYNC);
    eval 'sub FW_ERROR () {5;}' unless defined(&FW_ERROR);
    eval 'sub FW_REINIT () {6;}' unless defined(&FW_REINIT);
    eval 'sub FW_NON_PART () {7;}' unless defined(&FW_NON_PART);
    eval 'sub LOOP_NIL () {0;}' unless defined(&LOOP_NIL);
    eval 'sub LOOP_LIP_RCVD () {1;}' unless defined(&LOOP_LIP_RCVD);
    eval 'sub LOOP_PDB_RCVD () {2;}' unless defined(&LOOP_PDB_RCVD);
    eval 'sub LOOP_READY () {7;}' unless defined(&LOOP_READY);
    eval 'sub TOPO_NL_PORT () {0;}' unless defined(&TOPO_NL_PORT);
    eval 'sub TOPO_FL_PORT () {1;}' unless defined(&TOPO_FL_PORT);
    eval 'sub TOPO_N_PORT () {2;}' unless defined(&TOPO_N_PORT);
    eval 'sub TOPO_F_PORT () {3;}' unless defined(&TOPO_F_PORT);
    eval 'sub TOPO_PTP_STUB () {4;}' unless defined(&TOPO_PTP_STUB);
    eval 'sub SDPARAM {
        local($isp) = @_;
	    eval q(( ($isp)-> &isp_param));
    }' unless defined(&SDPARAM);
    eval 'sub FCPARAM {
        local($isp) = @_;
	    eval q(( ($isp)-> &isp_param));
    }' unless defined(&FCPARAM);
    eval 'sub ISP_NILSTATE () {0;}' unless defined(&ISP_NILSTATE);
    eval 'sub ISP_RESETSTATE () {1;}' unless defined(&ISP_RESETSTATE);
    eval 'sub ISP_INITSTATE () {2;}' unless defined(&ISP_INITSTATE);
    eval 'sub ISP_RUNSTATE () {3;}' unless defined(&ISP_RUNSTATE);
    eval 'sub ISP_CFG_NORELOAD () {0x80;}' unless defined(&ISP_CFG_NORELOAD);
    eval 'sub ISP_CFG_NONVRAM () {0x40;}' unless defined(&ISP_CFG_NONVRAM);
    eval 'sub ISP_CFG_FULL_DUPLEX () {0x01;}' unless defined(&ISP_CFG_FULL_DUPLEX);
    eval 'sub ISP_CFG_OWNWWN () {0x02;}' unless defined(&ISP_CFG_OWNWWN);
    eval 'sub ISP_CFG_NPORT () {0x04;}' unless defined(&ISP_CFG_NPORT);
    eval 'sub ISP_FW_REV {
        local($maj, $min, $mic) = @_;
	    eval q((($maj << 24) | ($min << 16) | $mic));
    }' unless defined(&ISP_FW_REV);
    eval 'sub ISP_FW_REVX {
        local($xp) = @_;
	    eval q((($xp->[0]<<24) | ($xp->[1] << 16) | $xp->[2]));
    }' unless defined(&ISP_FW_REVX);
    eval 'sub ISP_BT_PCI () {0;}' unless defined(&ISP_BT_PCI);
    eval 'sub ISP_BT_SBUS () {1;}' unless defined(&ISP_BT_SBUS);
    eval 'sub ISP_HA_SCSI () {0xf;}' unless defined(&ISP_HA_SCSI);
    eval 'sub ISP_HA_SCSI_UNKNOWN () {0x1;}' unless defined(&ISP_HA_SCSI_UNKNOWN);
    eval 'sub ISP_HA_SCSI_1020 () {0x2;}' unless defined(&ISP_HA_SCSI_1020);
    eval 'sub ISP_HA_SCSI_1020A () {0x3;}' unless defined(&ISP_HA_SCSI_1020A);
    eval 'sub ISP_HA_SCSI_1040 () {0x4;}' unless defined(&ISP_HA_SCSI_1040);
    eval 'sub ISP_HA_SCSI_1040A () {0x5;}' unless defined(&ISP_HA_SCSI_1040A);
    eval 'sub ISP_HA_SCSI_1040B () {0x6;}' unless defined(&ISP_HA_SCSI_1040B);
    eval 'sub ISP_HA_SCSI_1040C () {0x7;}' unless defined(&ISP_HA_SCSI_1040C);
    eval 'sub ISP_HA_SCSI_1240 () {0x8;}' unless defined(&ISP_HA_SCSI_1240);
    eval 'sub ISP_HA_SCSI_1080 () {0x9;}' unless defined(&ISP_HA_SCSI_1080);
    eval 'sub ISP_HA_SCSI_1280 () {0xa;}' unless defined(&ISP_HA_SCSI_1280);
    eval 'sub ISP_HA_SCSI_12160 () {0xb;}' unless defined(&ISP_HA_SCSI_12160);
    eval 'sub ISP_HA_FC () {0xf0;}' unless defined(&ISP_HA_FC);
    eval 'sub ISP_HA_FC_2100 () {0x10;}' unless defined(&ISP_HA_FC_2100);
    eval 'sub ISP_HA_FC_2200 () {0x20;}' unless defined(&ISP_HA_FC_2200);
    eval 'sub IS_SCSI {
        local($isp) = @_;
	    eval q(( ($isp->{isp_type}) &  &ISP_HA_SCSI));
    }' unless defined(&IS_SCSI);
    eval 'sub IS_1240 {
        local($isp) = @_;
	    eval q(( ($isp->{isp_type}) ==  &ISP_HA_SCSI_1240));
    }' unless defined(&IS_1240);
    eval 'sub IS_1080 {
        local($isp) = @_;
	    eval q(( ($isp->{isp_type}) ==  &ISP_HA_SCSI_1080));
    }' unless defined(&IS_1080);
    eval 'sub IS_1280 {
        local($isp) = @_;
	    eval q(( ($isp->{isp_type}) ==  &ISP_HA_SCSI_1280));
    }' unless defined(&IS_1280);
    eval 'sub IS_12160 {
        local($isp) = @_;
	    eval q(( ($isp->{isp_type}) ==  &ISP_HA_SCSI_12160));
    }' unless defined(&IS_12160);
    eval 'sub IS_12X0 {
        local($isp) = @_;
	    eval q(( &IS_1240($isp) ||  &IS_1280($isp)));
    }' unless defined(&IS_12X0);
    eval 'sub IS_DUALBUS {
        local($isp) = @_;
	    eval q(( &IS_12X0($isp) ||  &IS_12160($isp)));
    }' unless defined(&IS_DUALBUS);
    eval 'sub IS_ULTRA2 {
        local($isp) = @_;
	    eval q(( &IS_1080($isp) ||  &IS_1280($isp) ||  &IS_12160($isp)));
    }' unless defined(&IS_ULTRA2);
    eval 'sub IS_ULTRA3 {
        local($isp) = @_;
	    eval q(( &IS_12160($isp)));
    }' unless defined(&IS_ULTRA3);
    eval 'sub IS_FC {
        local($isp) = @_;
	    eval q(( ($isp->{isp_type}) &  &ISP_HA_FC));
    }' unless defined(&IS_FC);
    eval 'sub IS_2100 {
        local($isp) = @_;
	    eval q(( ($isp->{isp_type}) ==  &ISP_HA_FC_2100));
    }' unless defined(&IS_2100);
    eval 'sub IS_2200 {
        local($isp) = @_;
	    eval q(( ($isp->{isp_type}) ==  &ISP_HA_FC_2200));
    }' unless defined(&IS_2200);
    eval("sub ISPCTL_RESET_BUS () { 0; }") unless defined(&ISPCTL_RESET_BUS);
    eval("sub ISPCTL_RESET_DEV () { 1; }") unless defined(&ISPCTL_RESET_DEV);
    eval("sub ISPCTL_ABORT_CMD () { 2; }") unless defined(&ISPCTL_ABORT_CMD);
    eval("sub ISPCTL_UPDATE_PARAMS () { 3; }") unless defined(&ISPCTL_UPDATE_PARAMS);
    eval("sub ISPCTL_FCLINK_TEST () { 4; }") unless defined(&ISPCTL_FCLINK_TEST);
    eval("sub ISPCTL_PDB_SYNC () { 5; }") unless defined(&ISPCTL_PDB_SYNC);
    eval("sub ISPCTL_TOGGLE_TMODE () { 6; }") unless defined(&ISPCTL_TOGGLE_TMODE);
    eval("sub ISPASYNC_NEW_TGT_PARAMS () { 0; }") unless defined(&ISPASYNC_NEW_TGT_PARAMS);
    eval("sub ISPASYNC_BUS_RESET () { 1; }") unless defined(&ISPASYNC_BUS_RESET);
    eval("sub ISPASYNC_LOOP_DOWN () { 2; }") unless defined(&ISPASYNC_LOOP_DOWN);
    eval("sub ISPASYNC_LOOP_UP () { 3; }") unless defined(&ISPASYNC_LOOP_UP);
    eval("sub ISPASYNC_PDB_CHANGED () { 4; }") unless defined(&ISPASYNC_PDB_CHANGED);
    eval("sub ISPASYNC_CHANGE_NOTIFY () { 5; }") unless defined(&ISPASYNC_CHANGE_NOTIFY);
    eval("sub ISPASYNC_FABRIC_DEV () { 6; }") unless defined(&ISPASYNC_FABRIC_DEV);
    eval("sub ISPASYNC_TARGET_MESSAGE () { 7; }") unless defined(&ISPASYNC_TARGET_MESSAGE);
    eval("sub ISPASYNC_TARGET_EVENT () { 8; }") unless defined(&ISPASYNC_TARGET_EVENT);
    eval("sub ISPASYNC_TARGET_ACTION () { 9; }") unless defined(&ISPASYNC_TARGET_ACTION);
}
1;
