require '_h2ph_pre.ph';

unless(defined(&EEPROM_NODE_ADDR_0)) {
    sub EEPROM_NODE_ADDR_0 () {	0x0;}
}
unless(defined(&EEPROM_NODE_ADDR_1)) {
    sub EEPROM_NODE_ADDR_1 () {	0x1;}
}
unless(defined(&EEPROM_NODE_ADDR_2)) {
    sub EEPROM_NODE_ADDR_2 () {	0x2;}
}
unless(defined(&EEPROM_PROD_ID)) {
    sub EEPROM_PROD_ID () {	0x3;}
}
unless(defined(&EEPROM_MFG_ID)) {
    sub EEPROM_MFG_ID () {	0x7;}
}
unless(defined(&EEPROM_ADDR_CFG)) {
    sub EEPROM_ADDR_CFG () {	0x8;}
}
unless(defined(&EEPROM_RESOURCE_CFG)) {
    sub EEPROM_RESOURCE_CFG () {	0x9;}
}
unless(defined(&EEPROM_OEM_ADDR0)) {
    sub EEPROM_OEM_ADDR0 () {	0xa;}
}
unless(defined(&EEPROM_PNP)) {
    sub EEPROM_PNP () {	0x13;}
}
unless(defined(&EP_COMMAND)) {
    sub EP_COMMAND () {	0x0e;}
}
unless(defined(&EP_STATUS)) {
    sub EP_STATUS () {	0x0e;}
}
unless(defined(&EP_WINDOW)) {
    sub EP_WINDOW () {	0x0f;}
}
unless(defined(&EP_W0_EEPROM_DATA)) {
    sub EP_W0_EEPROM_DATA () {	0x0c;}
}
unless(defined(&EP_W0_EEPROM_COMMAND)) {
    sub EP_W0_EEPROM_COMMAND () {	0x0a;}
}
unless(defined(&EP_W0_RESOURCE_CFG)) {
    sub EP_W0_RESOURCE_CFG () {	0x08;}
}
unless(defined(&EP_W0_ADDRESS_CFG)) {
    sub EP_W0_ADDRESS_CFG () {	0x06;}
}
unless(defined(&EP_W0_CONFIG_CTRL)) {
    sub EP_W0_CONFIG_CTRL () {	0x04;}
}
unless(defined(&EP_W0_PRODUCT_ID)) {
    sub EP_W0_PRODUCT_ID () {	0x02;}
}
unless(defined(&EP_W0_MFG_ID)) {
    sub EP_W0_MFG_ID () {	0x00;}
}
unless(defined(&EP_W1_TX_PIO_WR_2)) {
    sub EP_W1_TX_PIO_WR_2 () {	0x02;}
}
unless(defined(&EP_W1_TX_PIO_WR_1)) {
    sub EP_W1_TX_PIO_WR_1 () {	0x00;}
}
unless(defined(&EP_W1_FREE_TX)) {
    sub EP_W1_FREE_TX () {	0x0c;}
}
unless(defined(&EP_W1_TX_STATUS)) {
    sub EP_W1_TX_STATUS () {	0x0b;}
}
unless(defined(&EP_W1_TIMER)) {
    sub EP_W1_TIMER () {	0x0a;}
}
unless(defined(&EP_W1_RX_STATUS)) {
    sub EP_W1_RX_STATUS () {	0x08;}
}
unless(defined(&EP_W1_RX_PIO_RD_2)) {
    sub EP_W1_RX_PIO_RD_2 () {	0x02;}
}
unless(defined(&EP_W1_RX_PIO_RD_1)) {
    sub EP_W1_RX_PIO_RD_1 () {	0x00;}
}
unless(defined(&EP_W1_RUNNER_RDCTL)) {
    sub EP_W1_RUNNER_RDCTL () {	0x16;}
}
unless(defined(&EP_W1_RUNNER_WRCTL)) {
    sub EP_W1_RUNNER_WRCTL () {	0x1c;}
}
unless(defined(&EP_W2_RECVMASK_0)) {
    sub EP_W2_RECVMASK_0 () {	0x06;}
}
unless(defined(&EP_W2_ADDR_5)) {
    sub EP_W2_ADDR_5 () {	0x05;}
}
unless(defined(&EP_W2_ADDR_4)) {
    sub EP_W2_ADDR_4 () {	0x04;}
}
unless(defined(&EP_W2_ADDR_3)) {
    sub EP_W2_ADDR_3 () {	0x03;}
}
unless(defined(&EP_W2_ADDR_2)) {
    sub EP_W2_ADDR_2 () {	0x02;}
}
unless(defined(&EP_W2_ADDR_1)) {
    sub EP_W2_ADDR_1 () {	0x01;}
}
unless(defined(&EP_W2_ADDR_0)) {
    sub EP_W2_ADDR_0 () {	0x00;}
}
unless(defined(&EP_W3_FREE_TX)) {
    sub EP_W3_FREE_TX () {	0x0c;}
}
unless(defined(&EP_W3_FREE_RX)) {
    sub EP_W3_FREE_RX () {	0x0a;}
}
unless(defined(&EP_W3_INTERNAL_CONFIG)) {
    sub EP_W3_INTERNAL_CONFIG () {	0x00;}
}
unless(defined(&EP_W3_OTHER_INT)) {
    sub EP_W3_OTHER_INT () {	0x04;}
}
unless(defined(&EP_W3_PIO_RESERVED)) {
    sub EP_W3_PIO_RESERVED () {	0x05;}
}
unless(defined(&EP_W3_MAC_CONTROL)) {
    sub EP_W3_MAC_CONTROL () {	0x06;}
}
unless(defined(&EP_W3_RESET_OPTIONS)) {
    sub EP_W3_RESET_OPTIONS () {	0x08;}
}
unless(defined(&EP_W4_MEDIA_TYPE)) {
    sub EP_W4_MEDIA_TYPE () {	0x0a;}
}
unless(defined(&EP_W4_CTRLR_STATUS)) {
    sub EP_W4_CTRLR_STATUS () {	0x08;}
}
unless(defined(&EP_W4_NET_DIAG)) {
    sub EP_W4_NET_DIAG () {	0x06;}
}
unless(defined(&EP_W4_FIFO_DIAG)) {
    sub EP_W4_FIFO_DIAG () {	0x04;}
}
unless(defined(&EP_W4_HOST_DIAG)) {
    sub EP_W4_HOST_DIAG () {	0x02;}
}
unless(defined(&EP_W4_TX_DIAG)) {
    sub EP_W4_TX_DIAG () {	0x00;}
}
unless(defined(&EP_W4_BOOM_PHYSMGMT)) {
    sub EP_W4_BOOM_PHYSMGMT () {	0x08;}
}
unless(defined(&PHYSMGMT_CLK)) {
    sub PHYSMGMT_CLK () {	0x0001;}
}
unless(defined(&PHYSMGMT_DATA)) {
    sub PHYSMGMT_DATA () {	0x0002;}
}
unless(defined(&PHYSMGMT_DIR)) {
    sub PHYSMGMT_DIR () {	0x0004;}
}
unless(defined(&EP_W5_READ_0_MASK)) {
    sub EP_W5_READ_0_MASK () {	0x0c;}
}
unless(defined(&EP_W5_INTR_MASK)) {
    sub EP_W5_INTR_MASK () {	0x0a;}
}
unless(defined(&EP_W5_RX_FILTER)) {
    sub EP_W5_RX_FILTER () {	0x08;}
}
unless(defined(&EP_W5_RX_EARLY_THRESH)) {
    sub EP_W5_RX_EARLY_THRESH () {	0x06;}
}
unless(defined(&EP_W5_TX_AVAIL_THRESH)) {
    sub EP_W5_TX_AVAIL_THRESH () {	0x02;}
}
unless(defined(&EP_W5_TX_START_THRESH)) {
    sub EP_W5_TX_START_THRESH () {	0x00;}
}
unless(defined(&TX_TOTAL_OK)) {
    sub TX_TOTAL_OK () {	0x0c;}
}
unless(defined(&RX_TOTAL_OK)) {
    sub RX_TOTAL_OK () {	0x0a;}
}
unless(defined(&TX_DEFERRALS)) {
    sub TX_DEFERRALS () {	0x08;}
}
unless(defined(&RX_FRAMES_OK)) {
    sub RX_FRAMES_OK () {	0x07;}
}
unless(defined(&TX_FRAMES_OK)) {
    sub TX_FRAMES_OK () {	0x06;}
}
unless(defined(&RX_OVERRUNS)) {
    sub RX_OVERRUNS () {	0x05;}
}
unless(defined(&TX_COLLISIONS)) {
    sub TX_COLLISIONS () {	0x04;}
}
unless(defined(&TX_AFTER_1_COLLISION)) {
    sub TX_AFTER_1_COLLISION () {	0x03;}
}
unless(defined(&TX_AFTER_X_COLLISIONS)) {
    sub TX_AFTER_X_COLLISIONS () {	0x02;}
}
unless(defined(&TX_NO_SQE)) {
    sub TX_NO_SQE () {	0x01;}
}
unless(defined(&TX_CD_LOST)) {
    sub TX_CD_LOST () {	0x00;}
}
unless(defined(&EP_W7_MASTER_ADDDRES)) {
    sub EP_W7_MASTER_ADDDRES () {	0x00;}
}
unless(defined(&EP_W7_RX_ERROR)) {
    sub EP_W7_RX_ERROR () {	0x04;}
}
unless(defined(&EP_W7_MASTER_LEN)) {
    sub EP_W7_MASTER_LEN () {	0x06;}
}
unless(defined(&EP_W7_RX_STATUS)) {
    sub EP_W7_RX_STATUS () {	0x08;}
}
unless(defined(&EP_W7_TIMER)) {
    sub EP_W7_TIMER () {	0x0a;}
}
unless(defined(&EP_W7_TX_STATUS)) {
    sub EP_W7_TX_STATUS () {	0x0b;}
}
unless(defined(&EP_W7_MASTER_STATUS)) {
    sub EP_W7_MASTER_STATUS () {	0x0c;}
}
unless(defined(&EP_W7_MASTER_ADDDRES)) {
    sub EP_W7_MASTER_ADDDRES () {	0x00;}
}
unless(defined(&EP_W7_RX_ERROR)) {
    sub EP_W7_RX_ERROR () {	0x04;}
}
unless(defined(&EP_W7_MASTER_LEN)) {
    sub EP_W7_MASTER_LEN () {	0x06;}
}
unless(defined(&EP_W7_RX_STATUS)) {
    sub EP_W7_RX_STATUS () {	0x08;}
}
unless(defined(&EP_W7_TIMER)) {
    sub EP_W7_TIMER () {	0x0a;}
}
unless(defined(&EP_W7_TX_STATUS)) {
    sub EP_W7_TX_STATUS () {	0x0b;}
}
unless(defined(&EP_W7_MASTER_STATUS)) {
    sub EP_W7_MASTER_STATUS () {	0x0c;}
}
unless(defined(&GLOBAL_RESET)) {
    sub GLOBAL_RESET () {	 0x0000;}
}
unless(defined(&WINDOW_SELECT)) {
    sub WINDOW_SELECT () {	 (0x1<<11);}
}
unless(defined(&START_TRANSCEIVER)) {
    sub START_TRANSCEIVER () {	 (0x2<<11);}
}
unless(defined(&RX_DISABLE)) {
    sub RX_DISABLE () {	 (0x3<<11);}
}
unless(defined(&RX_ENABLE)) {
    sub RX_ENABLE () {	 (0x4<<11);}
}
unless(defined(&RX_RESET)) {
    sub RX_RESET () {	 (0x5<<11);}
}
unless(defined(&RX_DISCARD_TOP_PACK)) {
    sub RX_DISCARD_TOP_PACK () {	 (0x8<<11);}
}
unless(defined(&TX_ENABLE)) {
    sub TX_ENABLE () {	 (0x9<<11);}
}
unless(defined(&TX_DISABLE)) {
    sub TX_DISABLE () {	 (0xa<<11);}
}
unless(defined(&TX_RESET)) {
    sub TX_RESET () {	 (0xb<<11);}
}
unless(defined(&REQ_INTR)) {
    sub REQ_INTR () {	 (0xc<<11);}
}
unless(defined(&ACK_INTR)) {
    sub ACK_INTR () {	 (0x6800);}
}
unless(defined(&C_INTR_LATCH)) {
    sub C_INTR_LATCH () {	 ( &ACK_INTR|0x01);}
}
unless(defined(&C_CARD_FAILURE)) {
    sub C_CARD_FAILURE () {	 ( &ACK_INTR|0x02);}
}
unless(defined(&C_TX_COMPLETE)) {
    sub C_TX_COMPLETE () {	 ( &ACK_INTR|0x04);}
}
unless(defined(&C_TX_AVAIL)) {
    sub C_TX_AVAIL () {	 ( &ACK_INTR|0x08);}
}
unless(defined(&C_RX_COMPLETE)) {
    sub C_RX_COMPLETE () {	 ( &ACK_INTR|0x10);}
}
unless(defined(&C_RX_EARLY)) {
    sub C_RX_EARLY () {	 ( &ACK_INTR|0x20);}
}
unless(defined(&C_INT_RQD)) {
    sub C_INT_RQD () {	 ( &ACK_INTR|0x40);}
}
unless(defined(&C_UPD_STATS)) {
    sub C_UPD_STATS () {	 ( &ACK_INTR|0x80);}
}
unless(defined(&SET_INTR_MASK)) {
    sub SET_INTR_MASK () {	 (0x0e<<11);}
}
unless(defined(&STATUS_ENABLE)) {
    sub STATUS_ENABLE () {	 (0x0f<<11);}
}
unless(defined(&SET_RD_0_MASK)) {
    sub SET_RD_0_MASK () {	 (0x0f<<11);}
}
unless(defined(&SET_RX_FILTER)) {
    sub SET_RX_FILTER () {	 (0x10<<11);}
}
unless(defined(&FIL_INDIVIDUAL)) {
    sub FIL_INDIVIDUAL () {	 (0x01);}
}
unless(defined(&FIL_MULTICAST)) {
    sub FIL_MULTICAST () {	 (0x02);}
}
unless(defined(&FIL_BRDCST)) {
    sub FIL_BRDCST () {	 (0x04);}
}
unless(defined(&FIL_PROMISC)) {
    sub FIL_PROMISC () {	 (0x08);}
}
unless(defined(&SET_RX_EARLY_THRESH)) {
    sub SET_RX_EARLY_THRESH () {	 (0x11<<11);}
}
unless(defined(&SET_TX_AVAIL_THRESH)) {
    sub SET_TX_AVAIL_THRESH () {	 (0x12<<11);}
}
unless(defined(&SET_TX_START_THRESH)) {
    sub SET_TX_START_THRESH () {	 (0x13<<11);}
}
unless(defined(&START_DMA)) {
    sub START_DMA () {	 (0x14<<11);}
}
unless(defined(&START_DMA_TX)) {
    sub START_DMA_TX () {	( &START_DMA | 0x0));}
}
unless(defined(&START_DMA_RX)) {
    sub START_DMA_RX () {	( &START_DMA | 0x1);}
}
unless(defined(&STATS_ENABLE)) {
    sub STATS_ENABLE () {	 (0x15<<11);}
}
unless(defined(&STATS_DISABLE)) {
    sub STATS_DISABLE () {	 (0x16<<11);}
}
unless(defined(&STOP_TRANSCEIVER)) {
    sub STOP_TRANSCEIVER () {	 (0x17<<11);}
}
unless(defined(&POWERUP)) {
    sub POWERUP () {	 (0x1b<<11);}
}
unless(defined(&POWERDOWN)) {
    sub POWERDOWN () {	 (0x1c<<11);}
}
unless(defined(&POWERAUTO)) {
    sub POWERAUTO () {	 (0x1d<<11);}
}
unless(defined(&EP_THRESH_DISABLE)) {
    sub EP_THRESH_DISABLE () {	2047;}
}
unless(defined(&S_INTR_LATCH)) {
    sub S_INTR_LATCH () {	 (0x0001);}
}
unless(defined(&S_CARD_FAILURE)) {
    sub S_CARD_FAILURE () {	 (0x0002);}
}
unless(defined(&S_TX_COMPLETE)) {
    sub S_TX_COMPLETE () {	 (0x0004);}
}
unless(defined(&S_TX_AVAIL)) {
    sub S_TX_AVAIL () {	 (0x0008);}
}
unless(defined(&S_RX_COMPLETE)) {
    sub S_RX_COMPLETE () {	 (0x0010);}
}
unless(defined(&S_RX_EARLY)) {
    sub S_RX_EARLY () {	 (0x0020);}
}
unless(defined(&S_INT_RQD)) {
    sub S_INT_RQD () {	 (0x0040);}
}
unless(defined(&S_UPD_STATS)) {
    sub S_UPD_STATS () {	 (0x0080);}
}
unless(defined(&S_DMA_DONE)) {
    sub S_DMA_DONE () {	 (0x0100);}
}
unless(defined(&S_DOWN_COMPLETE)) {
    sub S_DOWN_COMPLETE () {	 (0x0200);}
}
unless(defined(&S_UP_COMPLETE)) {
    sub S_UP_COMPLETE () {	 (0x0400);}
}
unless(defined(&S_DMA_IN_PROGRESS)) {
    sub S_DMA_IN_PROGRESS () {	 (0x0800);}
}
unless(defined(&S_COMMAND_IN_PROGRESS)) {
    sub S_COMMAND_IN_PROGRESS () {	 (0x1000);}
}
unless(defined(&ERR_INCOMPLETE)) {
    sub ERR_INCOMPLETE () {	 (0x8000);}
}
unless(defined(&ERR_RX)) {
    sub ERR_RX () {	 (0x4000);}
}
unless(defined(&ERR_MASK)) {
    sub ERR_MASK () {	 (0x7800);}
}
unless(defined(&ERR_OVERRUN)) {
    sub ERR_OVERRUN () {	 (0x4000);}
}
unless(defined(&ERR_RUNT)) {
    sub ERR_RUNT () {	 (0x5800);}
}
unless(defined(&ERR_ALIGNMENT)) {
    sub ERR_ALIGNMENT () {	 (0x6000);}
}
unless(defined(&ERR_CRC)) {
    sub ERR_CRC () {	 (0x6800);}
}
unless(defined(&ERR_OVERSIZE)) {
    sub ERR_OVERSIZE () {	 (0x4800);}
}
unless(defined(&ERR_DRIBBLE)) {
    sub ERR_DRIBBLE () {	 (0x1000);}
}
unless(defined(&TXS_COMPLETE)) {
    sub TXS_COMPLETE () {	0x80;}
}
unless(defined(&TXS_INTR_REQ)) {
    sub TXS_INTR_REQ () {	0x40;}
}
unless(defined(&TXS_JABBER)) {
    sub TXS_JABBER () {	0x20;}
}
unless(defined(&TXS_UNDERRUN)) {
    sub TXS_UNDERRUN () {	0x10;}
}
unless(defined(&TXS_MAX_COLLISION)) {
    sub TXS_MAX_COLLISION () {	0x08;}
}
unless(defined(&TXS_STATUS_OVERFLOW)) {
    sub TXS_STATUS_OVERFLOW () {	0x04;}
}
unless(defined(&RX_BYTES_MASK)) {
    sub RX_BYTES_MASK () {	 (0x07ff);}
}
unless(defined(&CONFIG_RAMSIZE)) {
    sub CONFIG_RAMSIZE () {	 0x0007;}
}
unless(defined(&CONFIG_RAMSIZE_SHIFT)) {
    sub CONFIG_RAMSIZE_SHIFT () {	 0;}
}
unless(defined(&CONFIG_RAMWIDTH)) {
    sub CONFIG_RAMWIDTH () {	 0x0008;}
}
unless(defined(&CONFIG_RAMWIDTH_SHIFT)) {
    sub CONFIG_RAMWIDTH_SHIFT () {	 3;}
}
unless(defined(&CONFIG_RAMSPEED)) {
    sub CONFIG_RAMSPEED () {	 0x0030;}
}
unless(defined(&CONFIG_RAMSPEED_SHIFT)) {
    sub CONFIG_RAMSPEED_SHIFT () {	 4;}
}
unless(defined(&CONFIG_ROMSIZE)) {
    sub CONFIG_ROMSIZE () {	 0x00c0;}
}
unless(defined(&CONFIG_ROMSIZE_SHIFT)) {
    sub CONFIG_ROMSIZE_SHIFT () {	 6;}
}
unless(defined(&CONFIG_RAMSPLIT)) {
    sub CONFIG_RAMSPLIT () {	 0x0003;}
}
unless(defined(&CONFIG_RAMSPLIT_SHIFT)) {
    sub CONFIG_RAMSPLIT_SHIFT () {	 0;}
}
unless(defined(&CONFIG_MEDIAMASK)) {
    sub CONFIG_MEDIAMASK () {	 0x0070;}
}
unless(defined(&CONFIG_MEDIAMASK_SHIFT)) {
    sub CONFIG_MEDIAMASK_SHIFT () {	 4;}
}
unless(defined(&MAC_CONTROL_FDX)) {
    sub MAC_CONTROL_FDX () {	0x20;}
}
unless(defined(&EPMEDIA_10BASE_T)) {
    sub EPMEDIA_10BASE_T () {	 0x00;}
}
unless(defined(&EPMEDIA_AUI)) {
    sub EPMEDIA_AUI () {	 0x01;}
}
unless(defined(&EPMEDIA_RESV1)) {
    sub EPMEDIA_RESV1 () {	 0x02;}
}
unless(defined(&EPMEDIA_10BASE_2)) {
    sub EPMEDIA_10BASE_2 () {	 0x03;}
}
unless(defined(&EPMEDIA_100BASE_TX)) {
    sub EPMEDIA_100BASE_TX () {	 0x04;}
}
unless(defined(&EPMEDIA_100BASE_FX)) {
    sub EPMEDIA_100BASE_FX () {	 0x05;}
}
unless(defined(&EPMEDIA_MII)) {
    sub EPMEDIA_MII () {	 0x06;}
}
unless(defined(&EPMEDIA_100BASE_T4)) {
    sub EPMEDIA_100BASE_T4 () {	 0x07;}
}
unless(defined(&CONFIG_AUTOSELECT)) {
    sub CONFIG_AUTOSELECT () {	 0x0100;}
}
unless(defined(&CONFIG_AUTOSELECT_SHIFT)) {
    sub CONFIG_AUTOSELECT_SHIFT () {	 8;}
}
unless(defined(&EP_PCI_100BASE_T4)) {
    sub EP_PCI_100BASE_T4 () {	(1<<0);}
}
unless(defined(&EP_PCI_100BASE_TX)) {
    sub EP_PCI_100BASE_TX () {	(1<<1);}
}
unless(defined(&EP_PCI_100BASE_FX)) {
    sub EP_PCI_100BASE_FX () {	(1<<2);}
}
unless(defined(&EP_PCI_10BASE_T)) {
    sub EP_PCI_10BASE_T () {	(1<<3);}
}
unless(defined(&EP_PCI_UTP)) {
    sub EP_PCI_UTP () {	 &EP_PCI_10BASE_T;}
}
unless(defined(&EP_PCI_BNC)) {
    sub EP_PCI_BNC () {	(1<<4);}
}
unless(defined(&EP_PCI_AUI)) {
    sub EP_PCI_AUI () {	(1<<5);}
}
unless(defined(&EP_PCI_100BASE_MII)) {
    sub EP_PCI_100BASE_MII () {	(1<<6);}
}
unless(defined(&EP_PCI_INTERNAL_VCO)) {
    sub EP_PCI_INTERNAL_VCO () {	(1<<8);}
}
unless(defined(&EP_RUNNER_MII_RESET)) {
    sub EP_RUNNER_MII_RESET () {	0x4000;}
}
unless(defined(&EP_RUNNER_ENABLE_MII)) {
    sub EP_RUNNER_ENABLE_MII () {	0x8000;}
}
unless(defined(&FIFOS_RX_RECEIVING)) {
    sub FIFOS_RX_RECEIVING () {	 0x8000;}
}
unless(defined(&FIFOS_RX_UNDERRUN)) {
    sub FIFOS_RX_UNDERRUN () {	 0x2000;}
}
unless(defined(&FIFOS_RX_STATUS_OVERRUN)) {
    sub FIFOS_RX_STATUS_OVERRUN () {	 0x1000;}
}
unless(defined(&FIFOS_RX_OVERRUN)) {
    sub FIFOS_RX_OVERRUN () {	 0x0800;}
}
unless(defined(&FIFOS_TX_OVERRUN)) {
    sub FIFOS_TX_OVERRUN () {	 0x0400;}
}
unless(defined(&EP_W0_CC_AUI)) {
    sub EP_W0_CC_AUI () {	(1<<13);}
}
unless(defined(&EP_W0_CC_BNC)) {
    sub EP_W0_CC_BNC () {	(1<<12);}
}
unless(defined(&EP_W0_CC_UTP)) {
    sub EP_W0_CC_UTP () {	(1<<9);}
}
unless(defined(&EEPROM_BUSY)) {
    sub EEPROM_BUSY () {	(1<<15);}
}
unless(defined(&EEPROM_TST_MODE)) {
    sub EEPROM_TST_MODE () {	(1<<14);}
}
unless(defined(&READ_EEPROM)) {
    sub READ_EEPROM () {	(1<<7);}
}
unless(defined(&WRITE_EEPROM_RR)) {
    sub WRITE_EEPROM_RR () {	0x100;}
}
unless(defined(&READ_EEPROM_RR)) {
    sub READ_EEPROM_RR () {	0x200;}
}
unless(defined(&ERASE_EEPROM_RR)) {
    sub ERASE_EEPROM_RR () {	0x300;}
}
unless(defined(&SQE_ENABLE)) {
    sub SQE_ENABLE () {	0x08;}
}
unless(defined(&JABBER_GUARD_ENABLE)) {
    sub JABBER_GUARD_ENABLE () {	0x40;}
}
unless(defined(&LINKBEAT_ENABLE)) {
    sub LINKBEAT_ENABLE () {	0x80;}
}
unless(defined(&ENABLE_UTP)) {
    sub ENABLE_UTP () {	( &JABBER_GUARD_ENABLE| &LINKBEAT_ENABLE);}
}
unless(defined(&DISABLE_UTP)) {
    sub DISABLE_UTP () {	0x0;}
}
unless(defined(&LINKBEAT_DETECT)) {
    sub LINKBEAT_DETECT () {	0x800;}
}
unless(defined(&EPC_AUI)) {
    sub EPC_AUI () {	0x01;}
}
unless(defined(&EPC_BNC)) {
    sub EPC_BNC () {	0x02;}
}
unless(defined(&EPC_RESERVED)) {
    sub EPC_RESERVED () {	0x04;}
}
unless(defined(&EPC_UTP)) {
    sub EPC_UTP () {	0x08;}
}
unless(defined(&EPC_100TX)) {
    sub EPC_100TX () {	0x10;}
}
unless(defined(&EPC_100FX)) {
    sub EPC_100FX () {	0x20;}
}
unless(defined(&EPC_MII)) {
    sub EPC_MII () {	0x40;}
}
unless(defined(&EPC_100T4)) {
    sub EPC_100T4 () {	0x80;}
}
unless(defined(&TAG_ADAPTER)) {
    sub TAG_ADAPTER () {	0xd0;}
}
unless(defined(&ACTIVATE_ADAPTER_TO_CONFIG)) {
    sub ACTIVATE_ADAPTER_TO_CONFIG () {	0xff;}
}
unless(defined(&ENABLE_DRQ_IRQ)) {
    sub ENABLE_DRQ_IRQ () {	0x0001;}
}
unless(defined(&MFG_ID)) {
    sub MFG_ID () {	0x506d;}
}
unless(defined(&PROD_ID_3C509)) {
    sub PROD_ID_3C509 () {	0x5090;}
}
unless(defined(&GO_WINDOW)) {
    sub GO_WINDOW {
	local($x) = @_;
	eval q( &bus_space_write_2( ($sc->{sc_iot}),  ($sc->{sc_ioh}),  &EP_COMMAND,  &WINDOW_SELECT|$x));
    }
}
unless(defined(&EP_LARGEWIN_PROBE)) {
    sub EP_LARGEWIN_PROBE () {	 &EP_THRESH_DISABLE;}
}
unless(defined(&EP_LARGEWIN_MASK)) {
    sub EP_LARGEWIN_MASK () {	0xffc;}
}
1;
