.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/hacks/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.\" Patched 1999-08-03 by Thomas Lockhart <lockhart@alumni.caltech.edu>
.\" for the PostgreSQL RDBMS project (http://postgresql.org).
.TH "CLUSTER" "l" "08 May 2000" "SQL - Language Statements" ""
.SH NAME
CLUSTER \- Gives storage clustering advice to the server
.SH SYNOPSIS
.sp
.nf
CLUSTER \fIindexname\fR ON \fItable\fR
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIindexname\fB\fR
The name of an index.
.TP
\fB\fItable\fB\fR
The name of a table.
.SS "OUTPUTS"
.PP
.TP
\fBCLUSTER\fR
The clustering was done successfully.
.TP
\fBERROR: relation <\fItablerelation_number\fB> inherits "\fItable\fB"\fR
[Comment:  This is not documented anywhere. It seems not to be possible to
cluster a table that is inherited.
]
.TP
\fBERROR: Relation \fItable\fB does not exist!\fR
[Comment:  The specified relation was not shown in the error message,
which contained a random string instead of the relation name.
]
.PP
.SH "DESCRIPTION"
.PP
\fBCLUSTER\fR instructs Postgres 
to cluster the class specified
by \fItable\fR approximately
based on the index specified by
\fIindexname\fR. The index must
already have been defined on 
\fIclassname\fR.
.PP
When a class is clustered, it is physically reordered
based on the index information. The clustering is static.
In other words, as the class is updated, the changes are
not clustered. No attempt is made to keep new instances or
updated tuples clustered. If one wishes, one can
recluster manually by issuing the command again.
.SS "NOTES"
.PP
The table is actually copied to a temporary table in index
order, then renamed back to the original name. For this
reason, all grant permissions and other indexes are lost
when clustering is performed.
.PP
In cases where you are accessing single rows randomly
within a table, the actual order of the data in the heap
table is unimportant. However, if you tend to access some
data more than others, and there is an index that groups
them together, you will benefit from using \fBCLUSTER\fR.
.PP
Another place where \fBCLUSTER\fR is helpful is in
cases where you use an
index to pull out several rows from a table. If you are
requesting a range of indexed values from a table, or a
single indexed value that has multiple rows that match,
\fBCLUSTER\fR will help because once the index identifies the
heap page for the first row that matches, all other rows
that match are probably already on the same heap page,
saving disk accesses and speeding up the query.
.PP
There are two ways to cluster data. The first is with the
\fBCLUSTER\fR command, which reorders the original table with
the ordering of the index you specify. This can be slow
on large tables because the rows are fetched from the heap
in index order, and if the heap table is unordered, the
entries are on random pages, so there is one disk page
retrieved for every row moved. Postgres has a cache,
but the majority of a big table will not fit in the cache.
.PP
Another way to cluster data is to use
.sp
.nf
SELECT \fIcolumnlist\fR INTO TABLE \fInewtable\fR
     FROM \fItable\fR ORDER BY \fIcolumnlist\fR
    
.sp
.fi
which uses the Postgres sorting code in 
the ORDER BY clause to match the index, and which is much faster for
unordered data. You then drop the old table, use
\fBALTER TABLE/RENAME\fR
to rename \fItemp\fR to the old name, and
recreate any indexes. The only problem is that OIDs
will not be preserved. From then on, \fBCLUSTER\fR should be
fast because most of the heap data has already been
ordered, and the existing index is used.
.SH "USAGE"
.PP
Cluster the employees relation on the basis of its salary attribute
.sp
.nf
CLUSTER emp_ind ON emp;
  
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
There is no \fBCLUSTER\fR statement in SQL92.
