/* $Id: ggi_ext.h,v 1.3 1999/05/16 18:58:23 marcus Exp $
******************************************************************************

   Copyright (C) 1998 Andreas Beck	[becka@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#ifndef _GGI_GGI_EXT_H
#define _GGI_GGI_EXT_H

#include <ggi/ggi.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef _BUILDING_LIBGGI
typedef void *ggi_lib_id;
#endif

typedef int ggi_extid;	/* Don't rely on that ! */

ggi_extid    ggiExtensionRegister(char *name, int size,
			int (*paramchange)(ggi_visual_t,int whatchanged));
int          ggiExtensionUnregister(ggi_extid id);
int	     ggiExtensionAttach(ggi_visual_t vis,ggi_extid id);
int	     ggiExtensionDetach(ggi_visual_t vis,ggi_extid id);
ggi_lib_id   ggiExtensionLoadDL(ggi_visual_t vis, const char *filename,
				const char *args, void *argptr);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* _GGI_GGI_EXT_H */
