#!/usr/ports/misc/cbb/work/fake-amiga/usr/local/bin/wish8.0 -f
#  'CBB' -- Check Book Balancer
#
#  menu.tcl -- menu management routines.
#
#  Written by Curtis Olson.  Started August 25, 1994.
#
#  Copyright (C) 1994 - 1997  Curtis L. Olson  - curt@sledge.mn.org
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# $Id: menu.tcl,v 2.15 1997/06/12 21:53:15 curt Exp $
# (Log is kept at end of this file)


proc setup_menubar m {
    global cbb

    menubutton $m.file -text "File" -underline 0 -menu $m.file.menu \
	    -takefocus 0
    menubutton $m.edit -text "Edit" -underline 1 -menu $m.edit.menu \
	    -takefocus 0
    menubutton $m.functions -text "Functions" -menu $m.functions.menu \
	    -takefocus 0
    menubutton $m.extern -text "External" -underline 1 -menu $m.extern.menu \
	    -takefocus 0
    if { $cbb(devel) == 1 } {
	menubutton $m.devel -text "Devel" -menu $m.devel.menu \
		-takefocus 0
    }
    menubutton $m.help -text "Help" -underline 0 -menu $m.help.menu \
	    -takefocus 0
    
    if { $cbb(devel) == 0 } {
	pack $m.file $m.edit $m.functions $m.extern -side left -ipadx 2
    } else {
	pack $m.file $m.edit $m.functions $m.extern $m.devel -side left -ipadx 2
    }
    pack $m.help -side right -ipadx 1
}


proc setup_file_menu m {
    set mf $m.file.menu

    if { [winfo exists $mf] } {
	destroy $mf
    }

    menu $mf -tearoff 0

    $mf add command -label "Make New Account ..." -underline 0 \
	    -command { acctNew }
    $mf add command -label "Load Account ..." -underline 0 \
    	    -command { acctLoad }
    $mf add command -label "Save Account" -underline 0 \
            -command { 
		if { $cbb(cur_file) != "noname.cbb" } {
		    acctSave
		} else {
		    acctSaveAs
		}
	    }
    .menubar.file.menu add command -label "Save Account As ..." -underline 5 \
            -command { acctSaveAs }

    $mf add separator

    $mf add command -label "Import QIF File ..." -underline 0 \
	    -command {
		set import_type 1
		acctImport
	    }
    $mf add command -label "Export QIF File" -underline 0 \
	    -command { acctExportQIF }

    $mf add separator

    $mf add cascade -label "Preferences" -underline 0 -menu $mf.prefs

    $mf add separator

    $mf add command -label "Quit" -underline 0 -command { cbbQuit }
    $mf entryconfig 10 -accelerator <Meta-Q>
    bind all <Meta-q> { cbbQuit }
    bind all <Alt-q> { cbbQuit }
}


proc setup_edit_menu m {
    set me $m.edit.menu

    menu $me -tearoff 0

    $me add command -label "Undo" -underline 0 -command { undoAction }
    $me entryconfig 0 -accelerator <Meta-U>
    bind all <Meta-u> { undoAction }
    bind all <Alt-u> { undoAction }

    $me add separator

    $me add command -label "New Transaction" \
	    -underline 0 -command { clear_entry_area }
    $me entryconfig 2 -accelerator <Meta-N>
    bind all <Meta-n> { clear_entry_area }
    bind all <Alt-n> { clear_entry_area }

    $me add command -label "Edit Transaction" -underline 0 \
	    -command { 
	if { [listGetCurTrans] >= 1 } {
	    update_entry_area [listGetCurTrans].0
	}
    }
    $me entryconfig 3 -accelerator <Meta-E>
    bind all <Meta-e> { 
	if { [listGetCurTrans] >= 1 } {
	    update_entry_area [listGetCurTrans].0
	}
    }
    bind all <Alt-e> { 
	if { [listGetCurTrans] >= 1 } {
	    update_entry_area [listGetCurTrans].0
	}
    }

    $me add command -label "Delete Transaction" -underline 0 \
	    -command { 
	if { "[.trans.list tag nextrange sel 1.0 end ]" != "" } {
	    delete_trans [.trans.list tag nextrange sel 1.0 end ]
	}
    }

    $me add separator

    $me add command -label "Open Category Splits ... " -underline 0 \
	    -command { 
	cbbWindow.splits
	tkwait window .splits
    }
    $me entryconfig 6 -accelerator <Meta-S>
    bind all <Meta-s> { 
	cbbWindow.splits
	tkwait window .splits
    }
    bind all <Alt-s> { 
	cbbWindow.splits
	tkwait window .splits
    }
}


proc setup_functions_menu m {
    global cbb

    set mf $m.functions.menu

    menu $mf -tearoff 0

    $mf add cascade -label "Goto" -underline 0 -menu $mf.goto

    $mf add separator

    $mf add command -label "Category List ..." \
	    -underline 0 -command { cbbWindow.catwin }
    $mf entryconfig 0 -accelerator <Meta-C>
    bind all <Meta-c> { cbbWindow.catwin }
    bind all <Alt-c> { cbbWindow.catwin }

    $mf add command -label "Add Default Categories" \
	    -underline 0 -command { catImportDefaults }

    $mf add separator

    $mf add command -label "Balance ..." -underline 0 -command { balance }

    $mf add separator

    $mf add command -label "Reports ..." -underline 0 -command { 
	set report(type) "report"
	set report(cur_file) $cbb(cur_file)
	set report(tmp_file) "/tmp/cbb-tmp-[pid].cbb"

	if { $cbb(debug) } { 
	    puts "Temp file is $report(tmp_file) -- saving ..."
	}
	# tell engine to save transactions
	puts $eng "auto_save_trans $report(tmp_file)"; flush $eng
	if { $cbb(debug) } { puts "No result should be returned." }

	cbbWindow.rep
    }

    $mf add command -label "Graphs ..." -underline 0 -command { 
	set report(type) "graph"
	set report(cur_file) $cbb(cur_file)
	set report(tmp_file) "/tmp/cbb-tmp-[pid].cbb"

	if { $cbb(debug) } { 
	    puts "Temp file is $report(tmp_file) -- saving ..."
	}
	# tell engine to save transactions
	puts $eng "auto_save_trans $report(tmp_file)"; flush $eng
	if { $cbb(debug) } { puts "No result should be returned." }

	cbbWindow.rep
    }
}


proc setup_extern_menu m {
    global lib_path

    set me $m.extern.menu

    menu $me -tearoff 0

    set filehandle [open "$lib_path/extern.conf" r]
    while { [gets $filehandle line] >= 0 } {
	if { "[string range $line 0 0]" == "-" } {
            $me add separator
	} elseif { "[string range $line 0 0]" == "#" } {
	    # ignore this line
	} elseif { [string length $line] < 3  } {
	    # ignore this line
        } else {
	    set pieces [split $line "\t"]
	    set name [lindex $pieces 0]
	    set prog [lindex $pieces 1]
            $me add command -label $name -command "launch_extern \"$prog\""
	}
    }
    close $filehandle
}


proc launch_extern { prog } {
    global report cbb eng

    if { $cbb(safe_mode) == 1 } {
        cbbWindow.ok "Cannot launch external scripts when running in 'safe' \
		mode." 
	tkwait window .ok
        return
    }

    set report(tmp_file) "/tmp/cbb-tmp-[pid].cbb"
    if { $cbb(debug) } { puts "Temp file is $report(tmp_file) -- saving ..." }
    # tell engine to save transactions
    puts $eng "auto_save_trans $report(tmp_file)"; flush $eng
    if { $cbb(debug) } { puts "No result should be returned." }

    regsub -all "%a" $prog $cbb(cur_file) prog
    regsub -all "%t" $prog $report(tmp_file) prog

    if { $cbb(debug) } { puts "exec $prog &" }
    eval exec $prog &
}


proc setup_devel_menu m {
    set mf $m.devel.menu

    if { [winfo exists $mf] } {
	destroy $mf
    }

    menu $mf -tearoff 0

    $mf add command -label "Re-source \"balance.tcl\""  \
	    -command {  source "$lib_path/balance.tcl" }
    $mf add command -label "Re-source \"bindings.tcl\""  \
	    -command {  source "$lib_path/bindings.tcl" }
    $mf add command -label "Re-source \"categories.tcl\""  \
	    -command {  source "$lib_path/categories.tcl" }
    $mf add command -label "Re-source \"common.tcl\""  \
	    -command {  source "$lib_path/common.tcl" }
    $mf add command -label "Re-source \"file.tcl\""  \
	    -command {  source "$lib_path/file.tcl" }
    $mf add command -label "Re-source \"filebox.tcl\""  \
	    -command {  source "$lib_path/filebox.tcl" }
    $mf add command -label "Re-source \"help.tcl\""  \
	    -command {  source "$lib_path/help.tcl" }
    $mf add command -label "Re-source \"init.tcl\""  \
	    -command {  source "$lib_path/init.tcl" }
    $mf add command -label "Re-source \"main.tcl\""  \
	    -command {  source "$lib_path/main.tcl" }
    $mf add command -label "Re-source \"menu.tcl\""  \
	    -command {  source "$lib_path/menu.tcl" }
    $mf add command -label "Re-source \"prefs.tcl\""  \
	    -command {  source "$lib_path/prefs.tcl" }
    $mf add command -label "Re-source \"reports.tcl\""  \
	    -command {  source "$lib_path/reports.tcl" }
    $mf add command -label "Re-source \"splits.tcl\""  \
	    -command {  source "$lib_path/splits.tcl" }
    $mf add command -label "Re-source \"undo.tcl\""  \
	    -command {  source "$lib_path/undo.tcl" }
}


proc setup_help_menu m {
    global cbb argv0 libpath

    set mh $m.help.menu
    menu $mh -tearoff 0

    $mh add command -label "About [file tail $argv0] ..." \
	    -underline 0 -command { cbbWindow.aboutwin [file tail $argv0] }

    $mh add separator

    $mh add command -label "Online HTML Manual ..." -underline 0 -command {
	if { $cbb(safe_mode) == 0 } {
	    if { $cbb(web_browser) == "netscape" } {
		# ... so they want to use nutscape ...
		if [catch {exec xwininfo -name "Netscape"} data] {
		    # no existing netscape running
		    exec $cbb(web_browser) $lib_path/docs/cbb-man/cbb-man.html &
		} else {
		    # A running copy of netscape exists
		    exec $cbb(web_browser) -remote \
			    openURL($lib_path/docs/cbb-man/cbb-man.html) &
		}
	    } elseif { $cbb(web_browser) == "lynx" } {
		exec xterm -sb -e $cbb(web_browser) \
			$lib_path/docs/cbb-man/cbb-man.html &
	    } else {
		exec $cbb(web_browser) $lib_path/docs/cbb-man/cbb-man.html &
	    }
	} else {
	    cbbWindow.ok "The online manual can be read from the CBB web page \
		    at: http://www.menet.umn.edu/~curt/cbb/"
	    tkwait window .ok
	}
    }

    $mh add command -label "Online Text Manual ..." -command { 
	cbbWindow.helpwin
    }
}


proc setup_file_prefs_menu m {
    set mfp $m.file.menu.prefs

    menu $mfp -tearoff 0

    $mfp add checkbutton -label "Use Memorized Transactions" \
	    -variable cbb(use_mems) -command {
	set cbb(pref_chg) 1
    }

    $mfp add checkbutton -label "Use Startdate" \
	    -variable cbb(use_sdate) -command {
	set cbb(pref_chg) 1
    }

    $mfp add checkbutton -label "Use Account Cache" \
	    -variable cbb(cache) -command {
	set cbb(pref_chg) 1

	puts $eng "cache $cbb(cache)"; flush $eng;
	gets $eng result;
    }

    $mfp add separator

    $mfp add command -label "Set Startdate ..." -command { 
	setStartDate
    }

    $mfp add separator

    $mfp add cascade -label "Appearence" -menu $mfp.appear

    $mfp add cascade -label "Cryptography" -menu $mfp.crypt

    $mfp add separator

    $mfp add command -label "Save Preferences" -command {
	cbbrcSave
    }

}

proc setup_prefs_appear_menu m {

    set mfpa $m.file.menu.prefs.appear

    menu $mfpa -tearoff 0

    $mfpa add checkbutton -label "Use Balloon Help" \
	    -variable cbb(balloon,on) -command {
	set cbb(pref_chg) 1
    }

    $mfpa add checkbutton -label "Use Auto Highlight" \
	    -variable cbb(auto_hilite) -command {
	set cbb(pref_chg) 1
	if { $cbb(auto_hilite) } {
		setup_auto_hilite
	} else {
		bind Entry <FocusIn> {}
		bind Entry <FocusOut> {}
	}
    }

    $mfpa add checkbutton -label "Use US Date Fmt" \
	-variable cbb(date_fmt) -onvalue 1 -offvalue 2 -command {
	set cbb(pref_chg) 1
    }

    $mfpa add separator

    $mfpa add command -label "Set Dimensions" -command {
	setDimensions
    }
}

proc setup_prefs_crypt_menu m {
    set mfpc $m.file.menu.prefs.crypt

    menu $mfpc -tearoff 0

    $mfpc add checkbutton -label "Use Cryptography" \
	    -variable cbb(use_crypt) -command {
	useCrypt
    }

    $mfpc add separator

    $mfpc add command -label "Set Cryptcode ..." -command {
	setCryptCode
    }

    $mfpc add command -label "Set Cryptprogram ..." -command {
	setCryptProgram
    }

}

proc setup_functions_goto_menu m {
    set mfg $m.functions.menu.goto

    menu $mfg -tearoff 0

    $mfg add command -label "Home" -underline 0 -command { goto 0 }
    $mfg entryconfig 0 -accelerator <Meta-Home>
    $mfg add command -label "Today" -underline 0 -command { 
	puts $eng "raw_date"; flush $eng
	gets $eng tmpdate
	goto [find_index_from_date $tmpdate] 
    }
    $mfg add command -label "End" -underline 0 -command { 
	goto [expr [listGetSize] - 1]
    }
    $mfg entryconfig 2 -accelerator <Meta-End>

    $mfg add separator

    $mfg add command -label "Page Up" -underline 5 \
     	    -command {
	goto [expr [.trans.list curselection] - ($cbb(list_height) - 4)]
    }
    $mfg entryconfig 4 -accelerator <Prior>
    $mfg add command -label "Page Down" -underline 5 \
     	    -command { 
	goto [expr [.trans.list curselection] + ($cbb(list_height) - 4)]
    }
    $mfg entryconfig 5 -accelerator <Next>

    $mfg add separator

    $mfg add command -label "Up" -underline 1 \
     	    -command {
	goto [expr [.trans.list curselection] - 2]
    }
    $mfg entryconfig 7 -accelerator <Up>
    $mfg add command -label "Down" -underline 1 \
     	    -command { 
	goto [expr [.trans.list curselection] + 2]
    }
    $mfg entryconfig 8 -accelerator <Down>
}


# ----------------------------------------------------------------------------
# $Log: menu.tcl,v $
# Revision 2.15  1997/06/12 21:53:15  curt
# Applied more patches from Martin Schenk <schenkm@ping.at>.  His changes
# greatly improved and developed the preferences menu so it is now actually
# usable to set preferences.
# Current data file is now saved in ~/.cbbcur.tcl
#
# Revision 2.14  1997/05/06 01:00:28  curt
# Added patches contributed by Martin Schenk <schenkm@ping.at>
# - Default to umask of 066 so .CBB files get created rw by owner only
# - Added support for pgp encrypting data files
# - Added support for displaying only recent parts of files (avoids
#   waiting to load in lots of old txns you don't currently need.)
# - Added a feature to "cache" whole accounts in the perl engine so
#   that switching between accounts can be faster.
# - The above options can be turned on/off via the preferrences menu.
#
# Revision 2.13  1997/04/23 18:10:02  curt
# Changed "clolson" -> "curt"
#
# Revision 2.12  1997/04/14 20:18:23  curt
# If browser is lynx, spawn in an xterm.
#
# Revision 2.11  1997/04/07 21:13:33  curt
# Add a $cbb(web_browser) variable which can be set from ~/.cbbrc.tcl
# If netscape is the browser, and there is a copy running, don't start
# a new copy.
#
# Revision 2.10  1997/01/02 04:38:38  curt
# Changes over the 1996 holidays:
#   - Converted listbox to text widget.  This allows us to do nice
#     things with alternating background colors, highliting, red
#     negative numbers, etc.
#   - Negative transactions are now drawn in red.
#   - Added a Goto <Today> option.
#   - <Home> & <End> were double bound.  Now, listbox can be traversed with
#     <Meta-Home> and <Meta-End>
#
# Revision 2.9  1996/12/17 14:54:01  curt
# Updated copyright date.
#
# Revision 2.8  1996/12/16 04:18:22  curt
# Continuing the great overhaul of December 1996.
#
# Revision 2.7  1996/12/14 17:15:25  curt
# The great overhaul of December '96.
#
# Revision 2.6  1996/12/13 01:27:00  curt
# Worked on getting reports.tcl to work smoothly.
#
# Revision 2.5  1996/12/13 00:12:45  curt
# Added reports.tcl
#
# Revision 2.4  1996/12/11 18:33:40  curt
# Ran a spell checker.
#
# Revision 2.3  1996/12/11 04:18:41  curt
# Removed the categories cascade menu and made the entries directly in the
# functions menu.
#
# Revision 2.2  1996/12/08 07:40:02  curt
# Rearranged quite a bit of code.
# Put most global variables in cbb() structure.
#
# Revision 2.1  1996/12/07 20:38:17  curt
# Renamed *.tk -> *.tcl
#
# Revision 2.6  1996/10/03 21:29:19  curt
# Added a devel menu to assist in development.  Many changes to the code
# can be re-sourced in without restarting the application.
#
# Revision 2.5  1996/09/30 15:14:39  curt
# Updated CBB URL, and hardwired wish path.
#
# Revision 2.4  1996/09/27 21:43:41  curt
# Added a text version of the manual to the Help menu.
#
# Revision 2.3  1996/07/13 02:57:51  curt
# Version 0.65
# Packing Changes
# Documenation changes
# Changes to handle a value in both debit and credit fields.
#
# Revision 2.2  1996/03/03  00:16:14  curt
# Modified Files:  cbb categories.pl wrapper.pl file.tk main.tk menu.tk
#   Added an account list at the bottom of the screen.  Thanks to:
#   Cengiz Alaettinoglu <cengiz@ISI.EDU> for this great addition.
#
# Revision 2.1  1996/02/27  05:35:49  curt
# Just stumbling around a bit with cvs ... :-(
#
# Revision 2.0  1996/02/27  04:43:04  curt
# Initial 2.0 revision.  (See "Log" files for old history.)
