.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/hacks/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.\" Patched 1999-08-03 by Thomas Lockhart <lockhart@alumni.caltech.edu>
.\" for the PostgreSQL RDBMS project (http://postgresql.org).
.TH "GRANT" "l" "08 May 2000" "SQL - Language Statements" ""
.SH NAME
GRANT \- Grants access privilege to a user, a group or all users
.SH SYNOPSIS
.sp
.nf
GRANT \fIprivilege\fR [, ...] ON \fIobject\fR [, ...]
    TO { PUBLIC | GROUP \fIgroup\fR | \fIusername\fR }
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIprivilege\fB\fR
The possible privileges are:
.RS
.TP
\fBSELECT\fR
Access all of the columns of a specific
table/view.
.TP
\fBINSERT\fR
Insert data into all columns of a
specific table.
.TP
\fBUPDATE\fR
Update all columns of a specific
table.
.TP
\fBDELETE\fR
Delete rows from a specific table.
.TP
\fBRULE\fR
Define rules on the table/view
(See CREATE RULE statement).
.TP
\fBALL\fR
Grant all privileges.
.RE
.PP
.TP
\fB\fIobject\fB\fR
The name of an object to which to grant access.
The possible objects are:
.RS
.TP 0.2i
\(bu
table 
.TP 0.2i
\(bu
view 
.TP 0.2i
\(bu
sequence
.RE
.PP
.TP
\fBPUBLIC\fR
A short form representing all users.
.TP
\fBGROUP \fIgroup\fB\fR
A \fIgroup\fR to whom to grant privileges.
.TP
\fB\fIusername\fB\fR
The name of a user to whom grant privileges. PUBLIC is a short form
representing all users.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBCHANGE\fR
Message returned if successful.
.TP
\fBERROR: ChangeAcl: class "\fIobject\fB" not found\fR
Message returned if the specified object is not available or 
if it is impossible
to give privileges to the specified group or users.
.PP
.SH "DESCRIPTION"
.PP
\fBGRANT\fR allows the creator of an object to give specific permissions to
all users (PUBLIC) or to a certain user or group. 
Users other than the creator don't have any access permission 
unless the creator GRANTs permissions, after the object
is created.
.PP
Once a user has a privilege on an object, he is enabled to exercise
that privilege.
There is no need to GRANT privileges to the creator of 
an object, the creator automatically holds ALL privileges, and can 
also drop the object. 
.SS "NOTES"
.PP
Currently, to grant privileges in Postgres
to only few columns, you must
create a view having desired columns and then grant privileges
to that view.
.PP
Use \fBpsql \\z\fR
for further information about permissions 
on existing objects:
.sp
.nf
	  Database    = lusitania
   +------------------+---------------------------------------------+
   |  Relation        |        Grant/Revoke Permissions             |
   +------------------+---------------------------------------------+
   | mytable          | {"=rw","miriam=arwR","group todos=rw"}      |
   +------------------+---------------------------------------------+
   Legend:
         uname=arwR -- privileges granted to a user
   group gname=arwR -- privileges granted to a GROUP
              =arwR -- privileges granted to PUBLIC

                  r -- SELECT
                  w -- UPDATE/DELETE
                  a -- INSERT
                  R -- RULE
               arwR -- ALL
    
.sp
.fi
.PP
Refer to REVOKE statements to revoke access privileges.
.SH "USAGE"
.PP
Grant insert privilege to all users on table films:
.sp
.nf
GRANT INSERT ON films TO PUBLIC;
   
.sp
.fi
.PP
Grant all privileges to user manuel on view kinds:
.sp
.nf
GRANT ALL ON kinds TO manuel;
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
The SQL92 syntax for GRANT allows setting privileges 
for individual columns
within a table, and allows setting a privilege to grant
the same privileges to others:
.sp
.nf
GRANT \fIprivilege\fR [, ...]
    ON \fIobject\fR [ ( \fIcolumn\fR [, ...] ) ] [, ...]
    TO { PUBLIC | \fIusername\fR [, ...] } [ WITH GRANT OPTION ]
    
.sp
.fi
.PP
Fields are compatible with the those in the Postgres
implementation, with the following additions:
.TP
\fB\fIprivilege\fB\fR
SQL92 permits additional privileges to be specified:
.RS
.TP
\fBSELECT\fR
.TP
\fBREFERENCES\fR
Allowed to reference some or all of the columns of a specific
table/view in integrity constraints.
.TP
\fBUSAGE\fR
Allowed to use a domain, character set, collation
or translation.
If an object specifies anything other than a table/view,
\fIprivilege\fR
must specify only USAGE.
.RE
.PP
.TP
\fB\fIobject\fB\fR
.RS
.TP
\fB[ TABLE ] \fItable\fB\fR
SQL92 allows the additional
non-functional keyword TABLE.
.TP
\fBCHARACTER SET\fR
Allowed to use the specified character set.
.TP
\fBCOLLATION\fR
Allowed to use the specified collation sequence.
.TP
\fBTRANSLATION\fR
Allowed to use the specified character set translation.
.TP
\fBDOMAIN\fR
Allowed to use the specified domain.
.TP
\fBWITH GRANT OPTION\fR
Allowed to grant the same privilege to others.
.RE
.PP
.PP
