'\"
'\" Copyright (c) 1990 The Regents of the University of California.
'\" Copyright (c) 1994-1995 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" @(#) listbox.n 1.33 95/08/12 17:34:58
'\" 
.so STk-man.macros
.TH listbox n 3.1 STk "Tk Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
listbox \- Create and manipulate listbox widgets
.SH SYNOPSIS
(\fBlistbox\fI \fIwidget\-name \fR?\fIoptions\fR?)
.SO
:background	:foreground	:relief	:takefocus
:borderwidth	:height	:selectbackground	:width
:cursor	:highlightbackground	:selectborderwidth	:xscrollcommand
:exportselection	:highlightcolor	:selectforeground	:yscrollcommand
:font	:highlightthickness	:setgrid
.SE
.SH "WIDGET-SPECIFIC OPTIONS"
.OP :height height Height height
Specifies the desired height for the window, in lines.
If zero or less, then the desired height for the window is made just
large enough to hold all the elements in the listbox.
.OP :selectmode selectMode SelectMode select-mode
Speifies one of several styles for manipulating the selection.
The value of the option may be arbitrary, but the default bindings
expect it to be either \fBsingle\fR, \fBbrowse\fR, \fBmultiple\fR,
or \fBextended\fR;  the default value is \fBbrowse\fR.
.OP :width width Width width
Specifies the desired width for the window in characters.
If the font doesn't have a uniform width then the width of the
character ``0'' is used in translating from character units to
screen units.
If zero or less, then the desired width for the window is made just
large enough to hold all the elements in the listbox.
.BE

.SH DESCRIPTION
.PP
The \fBlistbox\fR procedure creates a new window (given by the
\fIwidget\-name\fR argument) and makes it into a listbox widget.
Additional
options, described above, may be specified on the procedure line
or in the option database
to configure aspects of the listbox such as its colors, font,
text, and relief.  The \fBlistbox\fR procedure returns its
\fIwidget\-name\fR argument.  At the time this procedure is invoked,
there must not exist a window named \fIwidget\-name\fR, but
\fIwidget\-name\fR's parent must exist.
.PP
A listbox is a widget that displays a list of strings, one per line.
When first created, a new listbox has no elements.
Elements may be added or deleted using widget procedures described
below.  In addition, one or more elements may be selected as described
below.
If a listbox is exporting its selection (see \fBexportSelection\fR
option), then it will observe the standard X11 protocols
for handling the selection.
Listbox selections are available as type \fBSTRING\fR;
the value of the selection will be the text of the selected elements, with
newlines separating the elements.
.PP
It is not necessary for all the elements to be
displayed in the listbox window at once;  procedures described below
may be used to change the view in the window.  Listboxes allow
scrolling in both directions using the standard \fBxScrollProcedure\fR
and \fByScrollProcedure\fR options.
They also support scanning, as described below.

.SH "INDICES"
.PP
Many of the widget procedures for listboxes take one or more indices
as arguments.
An index specifies a particular element of the listbox, in any of
the following ways:
.TP 12
\fInumber\fR
Specifies the element as a numerical index, where 0 corresponds
to the first element in the listbox.
.TP 12
\fBactive\fR
Indicates the element that has the location cursor.  This element
will be displayed with an underline when the listbox has the
keyboard focus, and it is specified with the \fBactivate\fR
widget procedure.
.TP 12
\fBanchor\fR
Indicates the anchor point for the selection, which is set with the
``\fIselection anchor\fR'' widget procedure.
.TP 12
\fBend\fR
Indicates the end of the listbox.
For some procedures this means just after the last element;
for other procedures it means the last element.
.TP 12
\fB@\fIx\fB,\fIy\fR
Indicates the element that covers the point in the listbox window
specified by \fIx\fR and \fIy\fR (in pixel coordinates).  If no
element covers that point, then the closest element to that
point is used.
.LP
In the widget procedure descriptions below, arguments named \fIindex\fR,
\fIfirst\fR, and \fIlast\fR always contain text indices in one of
the above forms.

.SH "WIDGET PROCEDURE"
.PP
The \fBlistbox\fR procedure creates a new STk procedure whose
name is \fIwidget\-name\fR.  This
procedure may be used to invoke various
operations on the widget.  It has the following general form:
.CS
(\fIwidget\-name option \fR?\fIarg arg ...\fR?)
.CE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the procedure.  The following
procedures are possible for listbox widgets:
.TP
(\fIwidget\-name '\fBactivate\fR \fIindex\fR)
Sets the active element to the one indicated by \fIindex\fR.
The active element is drawn with an underline when the widget
has the input focus, and its index may be retrieved with the
index \fBactive\fR.
.TP
(\fIwidget\-name '\fBbbox\fR \fIindex\fR)
Returns a list of four numbers describing the bounding box of
the text in the element given by \fIindex\fR.
The first two elements of the list give the x and y coordinates
of the upper-left corner of the screen area covered by the text
(specified in pixels relative to the widget) and the last two
elements give the width and height of the area, in pixels.
If no part of the element given by \fIindex\fR is visible on the
screen then the result is an empty list;  if the element is
partially visible, the result gives the full area of the element,
including any parts that are not visible.
.TP
(\fIwidget\-name '\fBcget\fR \fIoption\fR)
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBlistbox\fR
procedure.
.TP
(\fIwidget\-name '\fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?)
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIwidget\-name\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the procedure returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the procedure
modifies the given widget option(s) to have the given value(s);  in
this case the procedure returns an empty list.
\fIOption\fR may have any of the values accepted by the \fBlistbox\fR
procedure.
.TP
(\fIwidget\-name '\fBcurselection\fR)
Returns a list containing the numerical indices of
all of the elements in the listbox that are currently selected.
If there are no elements selected in the listbox then \fB#f\fR
is returned.
.TP
(\fIwidget\-name '\fBdelete \fIfirst\fR)
.TP
(\fIwidget\-name '\fBdelete \fIfirst \fR\fIlast\fR)
Deletes one or more elements of the listbox.  \fIFirst\fR and \fIlast\fR
are indices specifying the first and last elements in the range
to delete.  If \fIlast\fR isn't specified it defaults to
\fIfirst\fR, i.e. a single element is deleted.
.TP
(\fIwidget\-name '\fBget \fIfirst\fR)
.TP
(\fIwidget\-name '\fBget \fIfirst\fR \fIlast\fR)
If \fIlast\fR is omitted, returns the contents of the listbox
element indicated by \fIfirst\fR.
If \fIlast\fR is specified, the procedure returns a list whose elements
are all of the listbox elements between \fIfirst\fR and \fIlast\fR,
inclusive.
Both \fIfirst\fR and \fIlast\fR may have any of the standard
forms for indices.
.TP
(\fIwidget\-name '\fBindex \fIindex\fR)
Returns a decimal string giving the integer index value that
corresponds to \fIindex\fR.
.TP
(\fIwidget\-name '\fBinsert \fIindex \fR?\fIelement element ...\fR?)
Inserts zero or more new elements in the list just before the
element given by \fIindex\fR.  If \fIindex\fR is specified as
\fBend\fR then the new elements are added to the end of the
list.  Returns an empty list.
.TP
(\fIwidget\-name '\fBnearest \fIy\fR)
Given a y-coordinate within the listbox window, this procedure returns
the index of the (visible) listbox element nearest to that y-coordinate.
.TP
(\fIwidget\-name '\fBscan\fR \fIoption args\fR)
This procedure is used to implement scanning on listboxes.  It has
two forms, depending on \fIoption\fR:
.RS
.TP
(\fIwidget\-name '\fBscan 'mark \fIx y\fR)
Records \fIx\fR and \fIy\fR and the current view in the listbox
window;  used in conjunction with later \fBscan dragto\fR procedures.
Typically this procedure is associated with a mouse button press in
the widget.  It returns an empty list.
.TP
(\fIwidget\-name '\fBscan 'dragto \fIx y\fR)
This procedure computes the difference between its \fIx\fR and \fIy\fR
arguments and the \fIx\fR and \fIy\fR arguments to the last
\fBscan mark\fR procedure for the widget.
It then adjusts the view by 10 times the
difference in coordinates.  This procedure is typically associated
with mouse motion events in the widget, to produce the effect of
dragging the list at high speed through the window.  The return
value is an empty list.
.RE
.TP
(\fIwidget\-name '\fBsee \fIindex\fR)
Adjust the view in the listbox so that the element given by \fIindex\fR
is visible.
If the element is already visible then the procedure has no effect;
if the element is near one edge of the window then the listbox
scrolls to bring the element into view at the edge;  otherwise
the listbox scrolls to center the element.
.TP
(\fIwidget\-name '\fBselection \fIoption arg\fR)
This procedure is used to adjust the selection within a listbox.  It
has several forms, depending on \fIoption\fR:
.RS
.TP
(\fIwidget\-name \fB'selection 'anchor \fIindex\fR)
Sets the selection anchor to the element given by \fIindex\fR.
The selection anchor is the end of the selection that is fixed
while dragging out a selection with the mouse.
The index \fBanchor\fR may be used to refer to the anchor
element.
.TP
(\fIwidget\-name \fB'selection 'clear \fIfirst\fR)
.TP
(\fIwidget\-name \fB'selection 'clear \fIfirst \fR\fIlast\fR)
If any of the elements between \fIfirst\fR and \fIlast\fR
(inclusive) are selected, they are deselected.
The selection state is not changed for elements outside
this range.
.TP
(\fIwidget\-name \fB'selection 'includes \fIindex\fR)
Returns #t if the element indicated by \fIindex\fR is currently
selected, #f if it isn't.
.TP
(\fIwidget\-name \fB'selection 'set \fIfirst\fR)
.TP
(\fIwidget\-name \fB'selection 'set \fIfirst \fR\fIlast\fR)
Selects all of the elements in the range between
\fIfirst\fR and \fIlast\fR, inclusive, without affecting
the selection state of elements outside that range.
.RE
.TP
(\fIwidget\-name '\fBsize\fR)
Returns a decimal string indicating the total number of elements
in the listbox.
.TP
(\fIwidget\-name '\fBxview \fIargs\fR)
This procedure is used to query and change the horizontal position of the
information in the widget's window.  It can take any of the following
forms:
.RS
.TP
(\fIwidget\-name '\fBxview\fR)
Returns a list containing two elements.
Each element is a real fraction between 0 and 1;  together they describe
the horizontal span that is visible in the window.
For example, if the first element is .2 and the second element is .6,
20% of the listbox's text is off-screen to the left, the middle 40% is visible
in the window, and 40% of the text is off-screen to the right.
These are the same values passed to scrollbars via the \fB:xscrollprocedure\fR
option.
.TP
(\fIwidget\-name '\fBxview\fR \fIindex\fR)
Adjusts the view in the window so that the character position given by
\fIindex\fR is displayed at the left edge of the window.
Character positions are defined by the width of the character \fB0\fR.
.TP
(\fIwidget\-name \fB'xview 'moveto\fI fraction\fR)
Adjusts the view in the window so that \fIfraction\fR of the
total width of the listbox text is off-screen to the left.
\fIfraction\fR must be a fraction between 0 and 1.
.TP
(\fIwidget\-name \fB'xview 'scroll \fInumber what\fR)
This procedure shifts the view in the window left or right according to
\fInumber\fR and \fIwhat\fR.
\fINumber\fR must be an integer.
\fIWhat\fR must be either \fBunits\fR or \fBpages\fR or an abbreviation
of one of these.
If \fIwhat\fR is \fBunits\fR, the view adjusts left or right by
\fInumber\fR character units (the width of the \fB0\fR character)
on the display;  if it is \fBpages\fR then the view adjusts by
\fInumber\fR screenfuls.
If \fInumber\fR is negative then characters farther to the left
become visible;  if it is positive then characters farther to the right
become visible.
.RE
.TP
(\fIwidget\-name '\fByview \fI?args\fR?)
This procedure is used to query and change the vertical position of the
text in the widget's window.
It can take any of the following forms:
.RS
.TP
(\fIwidget\-name '\fByview\fR)
Returns a list containing two elements, both of which are real fractions
between 0 and 1.
The first element gives the position of the listbox element at the
top of the window, relative to the listbox as a whole (0.5 means
it is halfway through the listbox, for example).
The second element gives the position of the listbox element just after
the last one in the window, relative to the listbox as a whole.
These are the same values passed to scrollbars via the \fB:yscrollprocedure\fR
option.
.TP
(\fIwidget\-name '\fByview\fR \fIindex\fR)
Adjusts the view in the window so that the element given by
\fIindex\fR is displayed at the top of the window.
.TP
(\fIwidget\-name \fB'yview 'moveto\fI fraction\fR)
Adjusts the view in the window so that the element given by \fIfraction\fR
appears at the top of the window.
\fIFraction\fR is a fraction between 0 and 1;  0 indicates the first
element in the listbox, 0.33 indicates the element one-third the
way through the listbox, and so on.
.TP
(\fIwidget\-name \fB'yview 'scroll \fInumber what\fR)
This procedure adjusts the view in the window up or down according to
\fInumber\fR and \fIwhat\fR.
\fINumber\fR must be an integer.
\fIWhat\fR must be either \fBunits\fR or \fBpages\fR.
If \fIwhat\fR is \fBunits\fR, the view adjusts up or down by
\fInumber\fR lines;  if it is \fBpages\fR then
the view adjusts by \fInumber\fR screenfuls.
If \fInumber\fR is negative then earlier elements
become visible;  if it is positive then later elements
become visible.
.RE

.SH "DEFAULT BINDINGS"
.PP
Tk automatically creates class bindings for listboxes that give them
Motif-like behavior.  Much of the behavior of a listbox is determined
by its \fBselectMode\fR option, which selects one of four ways
of dealing with the selection.
.PP
If the selection mode is \fBsingle\fR or \fBbrowse\fR, at most one
element can be selected in the listbox at once.
In both modes, clicking button 1 on an element selects
it and deselects any other selected item.
In \fBbrowse\fR mode it is also possible to drag the selection
with button 1.
.PP
If the selection mode is \fBmultiple\fR or \fBextended\fR,
any number of elements may be selected at once, including discontiguous
ranges.  In \fBmultiple\fR mode, clicking button 1 on an element
toggles its selection state without affecting any other elements.
In \fBextended\fR mode, pressing button 1 on an element selects
it, deselects everything else, and sets the anchor to the element
under the mouse;  dragging the mouse with button 1
down extends the selection to include all the elements between
the anchor and the element under the mouse, inclusive.
.PP
Most people will probably want to use \fBbrowse\fR mode for
single selections and \fBextended\fR mode for multiple selections;
the other modes appear to be useful only in special situations.
.PP
In addition to the above behavior, the following additional behavior
is defined by the default bindings:
.IP [1]
In \fBextended\fR mode, the selected range can be adjusted by pressing
button 1 with the Shift key down:  this modifies the selection to
consist of the elements between the anchor and the element under
the mouse, inclusive.
The un-anchored end of this new selection can also be dragged with
the button down.
.IP [2]
In \fBextended\fR mode, pressing button 1 with the Control key down
starts a toggle operation: the anchor is set to the element under
the mouse, and its selection state is reversed.  The selection state
of other elements isn't changed.
If the mouse is dragged with button 1 down, then the selection state
of all elements between the anchor and the element under the mouse
is set to match that of the anchor element;  the selection state of
all other elements remains what it was before the toggle operation
began.
.IP [3]
If the mouse leaves the listbox window with button 1 down, the window
scrolls away from the mouse, making information visible that used
to be off-screen on the side of the mouse.
The scrolling continues until the mouse re-enters the window, the
button is released, or the end of the listbox is reached.
.IP [4]
Mouse button 2 may be used for scanning.
If it is pressed and dragged over the listbox, the contents of
the listbox drag at high speed in the direction the mouse moves.
.IP [5]
If the Up or Down key is pressed, the location cursor (active
element) moves up or down one element.
If the selection mode is \fBbrowse\fR or \fBextended\fR then the
new active element is also selected and all other elements are
deselected.
In \fBextended\fR mode the new active element becomes the
selection anchor.
.IP [6]
In \fBextended\fR mode, Shift-Up and Shift-Down move the location
cursor (active element) up or down one element and also extend
the selection to that element in a fashion similar to dragging
with mouse button 1.
.IP [7]
The Left and Right keys scroll the listbox view left and right
by the width of the character \fB0\fR.
Control-Left and Control-Right scroll the listbox view left and
right by the width of the window.
Control-Prior and Control-Next also scroll left and right by
the width of the window.
.IP [8]
The Prior and Next keys scroll the listbox view up and down
by one page (the height of the window).
.IP [9]
The Home and End keys scroll the listbox horizontally to
the left and right edges, respectively.
.IP [10]
Control-Home sets the location cursor to the the first element in
the listbox, selects that element, and deselects everything else
in the listbox.
.IP [11]
Control-End sets the location cursor to the the last element in
the listbox, selects that element, and deselects everything else
in the listbox.
.IP [12]
In \fBextended\fR mode, Control-Shift-Home extends the selection
to the first element in the listbox and Control-Shift-End extends
the selection to the last element.
.IP [13]
In \fBmultiple\fR mode, Control-Shift-Home moves the location cursor
to the first element in the listbox and Control-Shift-End moves
the location cursor to the last element.
.IP [14]
The space and Select keys make a selection at the location cursor
(active element) just as if mouse button 1 had been pressed over
this element.
.IP [15]
In \fBextended\fR mode, Control-Shift-space and Shift-Select
extend the selection to the active element just as if button 1
had been pressed with the Shift key down.
.IP [16]
In \fBextended\fR mode, the Escape key cancels the most recent
selection and restores all the elements in the selected range
to their previous selection state.
.IP [17]
Control-slash selects everything in the widget, except in
\fBsingle\fR and \fBbrowse\fR modes, in which case it selects
the active element and deselects everything else.
.IP [18]
Control-backslash deselects everything in the widget, except in
\fBbrowse\fR mode where it has no effect.
.IP [19]
The F16 key (labelled Copy on many Sun workstations) or Meta-w
copies the selection in the widget to the clipboard, if there is
a selection.

.PP
The behavior of listboxes can be changed by defining new bindings for
individual widgets or by redefining the class bindings.

.SH EXAMPLE
.LP
Herafter is an example of a listbox connected to a scrollbar
.DS
;; Create list box and scrollbar
(listbox   '.l :height 5 
	       :yscroll (lambda l (apply .s 'set l)))
(scrollbar '.s :command (lambda l (apply .l 'yview l)))

;; Set some elements in the listbox
(.l 'insert 0 'one 'two 'three 'four 'five 'six 'seven 'eight)

;; Pack elements
(pack .l :side "left" :expand #t  :fill "both")
(pack .s :side "right" :expand #f :fill "y")
.DE

.SH SEE ALSO
scrollbar
