require '_h2ph_pre.ph';

unless(defined(&MVMEPROM_INCHR)) {
    sub MVMEPROM_INCHR () {	0x00;}
}
unless(defined(&MVMEPROM_INSTAT)) {
    sub MVMEPROM_INSTAT () {	0x01;}
}
unless(defined(&MVMEPROM_INLN)) {
    sub MVMEPROM_INLN () {	0x02;}
}
unless(defined(&MVMEPROM_READSTR)) {
    sub MVMEPROM_READSTR () {	0x03;}
}
unless(defined(&MVMEPROM_READLN)) {
    sub MVMEPROM_READLN () {	0x04;}
}
unless(defined(&MVMEPROM_OUTCHR)) {
    sub MVMEPROM_OUTCHR () {	0x20;}
}
unless(defined(&MVMEPROM_OUTSTR)) {
    sub MVMEPROM_OUTSTR () {	0x21;}
}
unless(defined(&MVMEPROM_DSKRD)) {
    sub MVMEPROM_DSKRD () {	0x10;}
}
unless(defined(&MVMEPROM_DSKWR)) {
    sub MVMEPROM_DSKWR () {	0x11;}
}
unless(defined(&MVMEPROM_DSKCFIG)) {
    sub MVMEPROM_DSKCFIG () {	0x12;}
}
unless(defined(&MVMEPROM_DSKFMT)) {
    sub MVMEPROM_DSKFMT () {	0x14;}
}
unless(defined(&MVMEPROM_DSKCTRL)) {
    sub MVMEPROM_DSKCTRL () {	0x15;}
}
unless(defined(&MVMEPROM_NETCTRL)) {
    sub MVMEPROM_NETCTRL () {	0x1d;}
}
unless(defined(&MVMEPROM_OUTSTRCRLF)) {
    sub MVMEPROM_OUTSTRCRLF () {	0x22;}
}
unless(defined(&MVMEPROM_WRITE)) {
    sub MVMEPROM_WRITE () {	0x23;}
}
unless(defined(&MVMEPROM_WRITELN)) {
    sub MVMEPROM_WRITELN () {	0x24;}
}
unless(defined(&MVMEPROM_DELAY)) {
    sub MVMEPROM_DELAY () {	0x43;}
}
unless(defined(&MVMEPROM_RTC_RD)) {
    sub MVMEPROM_RTC_RD () {	0x53;}
}
unless(defined(&MVMEPROM_EXIT)) {
    sub MVMEPROM_EXIT () {	0x63;}
}
unless(defined(&MVMEPROM_GETBRDID)) {
    sub MVMEPROM_GETBRDID () {	0x70;}
}
unless(defined(&MVMEPROM_ENVIRON)) {
    sub MVMEPROM_ENVIRON () {	0x71;}
}
unless(defined(&NETCTRLCMD_GETETHER)) {
    sub NETCTRLCMD_GETETHER () {	1;}
}
unless(defined(&ENVIRONCMD_WRITE)) {
    sub ENVIRONCMD_WRITE () {	1;}
}
unless(defined(&ENVIRONCMD_READ)) {
    sub ENVIRONCMD_READ () {	2;}
}
unless(defined(&ENVIRONTYPE_EOL)) {
    sub ENVIRONTYPE_EOL () {	0;}
}
unless(defined(&ENVIRONTYPE_START)) {
    sub ENVIRONTYPE_START () {	1;}
}
unless(defined(&ENVIRONTYPE_DISKBOOT)) {
    sub ENVIRONTYPE_DISKBOOT () {	2;}
}
unless(defined(&ENVIRONTYPE_ROMBOOT)) {
    sub ENVIRONTYPE_ROMBOOT () {	3;}
}
unless(defined(&ENVIRONTYPE_NETBOOT)) {
    sub ENVIRONTYPE_NETBOOT () {	4;}
}
unless(defined(&ENVIRONTYPE_MEMSIZE)) {
    sub ENVIRONTYPE_MEMSIZE () {	5;}
}
unless(defined(&_LOCORE)) {
    eval 'sub BUG_FILE_MARK () {0x80;}' unless defined(&BUG_FILE_MARK);
    eval 'sub IGNORE_FILENUM () {0x02;}' unless defined(&IGNORE_FILENUM);
    eval 'sub END_OF_FILE () {0x01;}' unless defined(&END_OF_FILE);
    eval 'sub MVMEPROM_BLOCK_SIZE () {256;}' unless defined(&MVMEPROM_BLOCK_SIZE);
}
unless(defined(&MVMEPROM_CALL)) {
    sub MVMEPROM_CALL {
	local($x) = @_;
	eval q( &asm  &volatile ( &__CONCAT(\"trap #15; .short \",  &__STRING($x)) ));
    }
}
unless(defined(&MVMEPROM_NOARG)) {
    sub MVMEPROM_NOARG () {
	eval q( &asm  &volatile (\"clrl sp@-\"));
    }
}
unless(defined(&MVMEPROM_ARG1)) {
    sub MVMEPROM_ARG1 {
	local($arg) = @_;
	eval q( &asm  &volatile (\"movel %0, sp@-\"::\"d\" ($arg)));
    }
}
unless(defined(&MVMEPROM_ARG2)) {
    sub MVMEPROM_ARG2 {
	local($arg) = @_;
	eval q( &asm  &volatile (\"movel %0, sp@-\"::\"d\" ($arg)));
    }
}
unless(defined(&MVMEPROM_GETRES)) {
    sub MVMEPROM_GETRES {
	local($ret) = @_;
	eval q( &asm  &volatile (\"movel sp@+,%0\": \"=d\" ($ret):));
    }
}
unless(defined(&MVMEPROM_RETURN)) {
    sub MVMEPROM_RETURN {
	local($ret) = @_;
	eval q( &MVMEPROM_GETRES($ret);  &return ($ret););
    }
}
unless(defined(&MVMEPROM_RETURN_BYTE)) {
    sub MVMEPROM_RETURN_BYTE {
	local($ret) = @_;
	eval q( &MVMEPROM_GETRES($ret);  &return(($ret >> 24) & 0xff););
    }
}
unless(defined(&MVMEPROM_STATRET)) {
    sub MVMEPROM_STATRET {
	local($ret) = @_;
	eval q( &MVMEPROM_GETRES($ret);  &return (!($ret & 0x4)););
    }
}
unless(defined(&MVMEPROM_REG_DEVLUN)) {
    sub MVMEPROM_REG_DEVLUN () {	"d0";}
}
unless(defined(&MVMEPROM_REG_CTRLLUN)) {
    sub MVMEPROM_REG_CTRLLUN () {	"d1";}
}
unless(defined(&MVMEPROM_REG_FLAGS)) {
    sub MVMEPROM_REG_FLAGS () {	"d4";}
}
unless(defined(&MVMEPROM_REG_CTRLADDR)) {
    sub MVMEPROM_REG_CTRLADDR () {	"a0";}
}
unless(defined(&MVMEPROM_REG_ENTRY)) {
    sub MVMEPROM_REG_ENTRY () {	"a1";}
}
unless(defined(&MVMEPROM_REG_CONFBLK)) {
    sub MVMEPROM_REG_CONFBLK () {	"a2";}
}
unless(defined(&MVMEPROM_REG_NBARGSTART)) {
    sub MVMEPROM_REG_NBARGSTART () {	"a3";}
}
unless(defined(&MVMEPROM_REG_NBARGEND)) {
    sub MVMEPROM_REG_NBARGEND () {	"a4";}
}
unless(defined(&MVMEPROM_REG_ARGSTART)) {
    sub MVMEPROM_REG_ARGSTART () {	"a5";}
}
unless(defined(&MVMEPROM_REG_ARGEND)) {
    sub MVMEPROM_REG_ARGEND () {	"a6";}
}
unless(defined(&RB_NOSYM)) {
    eval 'sub RB_NOSYM () {0x400;}' unless defined(&RB_NOSYM);
}
1;
