require '_h2ph_pre.ph';

unless(defined(&SK_VENDORID)) {
    sub SK_VENDORID () {	0x1148;}
}
unless(defined(&SK_DEVICEID_GE)) {
    sub SK_DEVICEID_GE () {	0x4300;}
}
unless(defined(&SK_WIN_BASE)) {
    sub SK_WIN_BASE () {	0x0080;}
}
unless(defined(&SK_WIN_LEN)) {
    sub SK_WIN_LEN () {	0x80;}
}
unless(defined(&SK_WIN_MASK)) {
    sub SK_WIN_MASK () {	0x3f80;}
}
unless(defined(&SK_REG_MASK)) {
    sub SK_REG_MASK () {	0x7f;}
}
unless(defined(&SK_WIN)) {
    sub SK_WIN {
	local($reg) = @_;
	eval q(((($reg) &  &SK_WIN_MASK) /  &SK_WIN_LEN));
    }
}
unless(defined(&SK_REG)) {
    sub SK_REG {
	local($reg) = @_;
	eval q((($reg) &  &SK_REG_MASK));
    }
}
unless(defined(&SK_PORT_A)) {
    sub SK_PORT_A () {	0;}
}
unless(defined(&SK_PORT_B)) {
    sub SK_PORT_B () {	1;}
}
unless(defined(&SK_IF_READ_4)) {
    sub SK_IF_READ_4 {
	local($sc_if, $skip, $reg) = @_;
	eval q( &sk_win_read_4( ($sc_if->{sk_softc}), $reg + (( ($sc_if->{sk_port}) * ($skip + 1)) *  &SK_WIN_LEN)));
    }
}
unless(defined(&SK_IF_READ_2)) {
    sub SK_IF_READ_2 {
	local($sc_if, $skip, $reg) = @_;
	eval q( &sk_win_read_2( ($sc_if->{sk_softc}), $reg + (( ($sc_if->{sk_port}) * ($skip + 1)) *  &SK_WIN_LEN)));
    }
}
unless(defined(&SK_IF_READ_1)) {
    sub SK_IF_READ_1 {
	local($sc_if, $skip, $reg) = @_;
	eval q( &sk_win_read_1( ($sc_if->{sk_softc}), $reg + (( ($sc_if->{sk_port}) * ($skip + 1)) *  &SK_WIN_LEN)));
    }
}
unless(defined(&SK_IF_WRITE_4)) {
    sub SK_IF_WRITE_4 {
	local($sc_if, $skip, $reg, $val) = @_;
	eval q( &sk_win_write_4( ($sc_if->{sk_softc}), $reg + (( ($sc_if->{sk_port}) * ($skip + 1)) *  &SK_WIN_LEN), $val));
    }
}
unless(defined(&SK_IF_WRITE_2)) {
    sub SK_IF_WRITE_2 {
	local($sc_if, $skip, $reg, $val) = @_;
	eval q( &sk_win_write_2( ($sc_if->{sk_softc}), $reg + (( ($sc_if->{sk_port}) * ($skip + 1)) *  &SK_WIN_LEN), $val));
    }
}
unless(defined(&SK_IF_WRITE_1)) {
    sub SK_IF_WRITE_1 {
	local($sc_if, $skip, $reg, $val) = @_;
	eval q( &sk_win_write_1( ($sc_if->{sk_softc}), $reg + (( ($sc_if->{sk_port}) * ($skip + 1)) *  &SK_WIN_LEN), $val));
    }
}
unless(defined(&SK_RAP)) {
    sub SK_RAP () {	0x0000;}
}
unless(defined(&SK_CSR)) {
    sub SK_CSR () {	0x0004;}
}
unless(defined(&SK_LED)) {
    sub SK_LED () {	0x0006;}
}
unless(defined(&SK_ISR)) {
    sub SK_ISR () {	0x0008;}
}
unless(defined(&SK_IMR)) {
    sub SK_IMR () {	0x000c;}
}
unless(defined(&SK_IESR)) {
    sub SK_IESR () {	0x0010;}
}
unless(defined(&SK_IEMR)) {
    sub SK_IEMR () {	0x0014;}
}
unless(defined(&SK_ISSR)) {
    sub SK_ISSR () {	0x0018;}
}
unless(defined(&SK_XM_IMR0)) {
    sub SK_XM_IMR0 () {	0x0020;}
}
unless(defined(&SK_XM_ISR0)) {
    sub SK_XM_ISR0 () {	0x0028;}
}
unless(defined(&SK_XM_PHYADDR0)) {
    sub SK_XM_PHYADDR0 () {	0x0030;}
}
unless(defined(&SK_XM_PHYDATA0)) {
    sub SK_XM_PHYDATA0 () {	0x0034;}
}
unless(defined(&SK_XM_IMR1)) {
    sub SK_XM_IMR1 () {	0x0040;}
}
unless(defined(&SK_XM_ISR1)) {
    sub SK_XM_ISR1 () {	0x0048;}
}
unless(defined(&SK_XM_PHYADDR1)) {
    sub SK_XM_PHYADDR1 () {	0x0050;}
}
unless(defined(&SK_XM_PHYDATA1)) {
    sub SK_XM_PHYDATA1 () {	0x0054;}
}
unless(defined(&SK_BMU_RX_CSR0)) {
    sub SK_BMU_RX_CSR0 () {	0x0060;}
}
unless(defined(&SK_BMU_RX_CSR1)) {
    sub SK_BMU_RX_CSR1 () {	0x0064;}
}
unless(defined(&SK_BMU_TXS_CSR0)) {
    sub SK_BMU_TXS_CSR0 () {	0x0068;}
}
unless(defined(&SK_BMU_TXA_CSR0)) {
    sub SK_BMU_TXA_CSR0 () {	0x006c;}
}
unless(defined(&SK_BMU_TXS_CSR1)) {
    sub SK_BMU_TXS_CSR1 () {	0x0070;}
}
unless(defined(&SK_BMU_TXA_CSR1)) {
    sub SK_BMU_TXA_CSR1 () {	0x0074;}
}
unless(defined(&SK_CSR_SW_RESET)) {
    sub SK_CSR_SW_RESET () {	0x0001;}
}
unless(defined(&SK_CSR_SW_UNRESET)) {
    sub SK_CSR_SW_UNRESET () {	0x0002;}
}
unless(defined(&SK_CSR_MASTER_RESET)) {
    sub SK_CSR_MASTER_RESET () {	0x0004;}
}
unless(defined(&SK_CSR_MASTER_UNRESET)) {
    sub SK_CSR_MASTER_UNRESET () {	0x0008;}
}
unless(defined(&SK_CSR_MASTER_STOP)) {
    sub SK_CSR_MASTER_STOP () {	0x0010;}
}
unless(defined(&SK_CSR_MASTER_DONE)) {
    sub SK_CSR_MASTER_DONE () {	0x0020;}
}
unless(defined(&SK_CSR_SW_IRQ_CLEAR)) {
    sub SK_CSR_SW_IRQ_CLEAR () {	0x0040;}
}
unless(defined(&SK_CSR_SW_IRQ_SET)) {
    sub SK_CSR_SW_IRQ_SET () {	0x0080;}
}
unless(defined(&SK_CSR_SLOTSIZE)) {
    sub SK_CSR_SLOTSIZE () {	0x0100;}
}
unless(defined(&SK_CSR_BUSCLOCK)) {
    sub SK_CSR_BUSCLOCK () {	0x0200;}
}
unless(defined(&SK_LED_GREEN_OFF)) {
    sub SK_LED_GREEN_OFF () {	0x01;}
}
unless(defined(&SK_LED_GREEN_ON)) {
    sub SK_LED_GREEN_ON () {	0x02;}
}
unless(defined(&SK_ISR_TX2_AS_CHECK)) {
    sub SK_ISR_TX2_AS_CHECK () {	0x00000001;}
}
unless(defined(&SK_ISR_TX2_AS_EOF)) {
    sub SK_ISR_TX2_AS_EOF () {	0x00000002;}
}
unless(defined(&SK_ISR_TX2_AS_EOB)) {
    sub SK_ISR_TX2_AS_EOB () {	0x00000004;}
}
unless(defined(&SK_ISR_TX2_S_CHECK)) {
    sub SK_ISR_TX2_S_CHECK () {	0x00000008;}
}
unless(defined(&SK_ISR_TX2_S_EOF)) {
    sub SK_ISR_TX2_S_EOF () {	0x00000010;}
}
unless(defined(&SK_ISR_TX2_S_EOB)) {
    sub SK_ISR_TX2_S_EOB () {	0x00000020;}
}
unless(defined(&SK_ISR_TX1_AS_CHECK)) {
    sub SK_ISR_TX1_AS_CHECK () {	0x00000040;}
}
unless(defined(&SK_ISR_TX1_AS_EOF)) {
    sub SK_ISR_TX1_AS_EOF () {	0x00000080;}
}
unless(defined(&SK_ISR_TX1_AS_EOB)) {
    sub SK_ISR_TX1_AS_EOB () {	0x00000100;}
}
unless(defined(&SK_ISR_TX1_S_CHECK)) {
    sub SK_ISR_TX1_S_CHECK () {	0x00000200;}
}
unless(defined(&SK_ISR_TX1_S_EOF)) {
    sub SK_ISR_TX1_S_EOF () {	0x00000400;}
}
unless(defined(&SK_ISR_TX1_S_EOB)) {
    sub SK_ISR_TX1_S_EOB () {	0x00000800;}
}
unless(defined(&SK_ISR_RX2_CHECK)) {
    sub SK_ISR_RX2_CHECK () {	0x00001000;}
}
unless(defined(&SK_ISR_RX2_EOF)) {
    sub SK_ISR_RX2_EOF () {	0x00002000;}
}
unless(defined(&SK_ISR_RX2_EOB)) {
    sub SK_ISR_RX2_EOB () {	0x00004000;}
}
unless(defined(&SK_ISR_RX1_CHECK)) {
    sub SK_ISR_RX1_CHECK () {	0x00008000;}
}
unless(defined(&SK_ISR_RX1_EOF)) {
    sub SK_ISR_RX1_EOF () {	0x00010000;}
}
unless(defined(&SK_ISR_RX1_EOB)) {
    sub SK_ISR_RX1_EOB () {	0x00020000;}
}
unless(defined(&SK_ISR_LINK2_OFLOW)) {
    sub SK_ISR_LINK2_OFLOW () {	0x00040000;}
}
unless(defined(&SK_ISR_MAC2)) {
    sub SK_ISR_MAC2 () {	0x00080000;}
}
unless(defined(&SK_ISR_LINK1_OFLOW)) {
    sub SK_ISR_LINK1_OFLOW () {	0x00100000;}
}
unless(defined(&SK_ISR_MAC1)) {
    sub SK_ISR_MAC1 () {	0x00200000;}
}
unless(defined(&SK_ISR_TIMER)) {
    sub SK_ISR_TIMER () {	0x00400000;}
}
unless(defined(&SK_ISR_EXTERNAL_REG)) {
    sub SK_ISR_EXTERNAL_REG () {	0x00800000;}
}
unless(defined(&SK_ISR_SW)) {
    sub SK_ISR_SW () {	0x01000000;}
}
unless(defined(&SK_ISR_I2C_RDY)) {
    sub SK_ISR_I2C_RDY () {	0x02000000;}
}
unless(defined(&SK_ISR_TX2_TIMEO)) {
    sub SK_ISR_TX2_TIMEO () {	0x04000000;}
}
unless(defined(&SK_ISR_TX1_TIMEO)) {
    sub SK_ISR_TX1_TIMEO () {	0x08000000;}
}
unless(defined(&SK_ISR_RX2_TIMEO)) {
    sub SK_ISR_RX2_TIMEO () {	0x10000000;}
}
unless(defined(&SK_ISR_RX1_TIMEO)) {
    sub SK_ISR_RX1_TIMEO () {	0x20000000;}
}
unless(defined(&SK_ISR_RSVD)) {
    sub SK_ISR_RSVD () {	0x40000000;}
}
unless(defined(&SK_ISR_HWERR)) {
    sub SK_ISR_HWERR () {	0x80000000;}
}
unless(defined(&SK_IMR_TX2_AS_CHECK)) {
    sub SK_IMR_TX2_AS_CHECK () {	0x00000001;}
}
unless(defined(&SK_IMR_TX2_AS_EOF)) {
    sub SK_IMR_TX2_AS_EOF () {	0x00000002;}
}
unless(defined(&SK_IMR_TX2_AS_EOB)) {
    sub SK_IMR_TX2_AS_EOB () {	0x00000004;}
}
unless(defined(&SK_IMR_TX2_S_CHECK)) {
    sub SK_IMR_TX2_S_CHECK () {	0x00000008;}
}
unless(defined(&SK_IMR_TX2_S_EOF)) {
    sub SK_IMR_TX2_S_EOF () {	0x00000010;}
}
unless(defined(&SK_IMR_TX2_S_EOB)) {
    sub SK_IMR_TX2_S_EOB () {	0x00000020;}
}
unless(defined(&SK_IMR_TX1_AS_CHECK)) {
    sub SK_IMR_TX1_AS_CHECK () {	0x00000040;}
}
unless(defined(&SK_IMR_TX1_AS_EOF)) {
    sub SK_IMR_TX1_AS_EOF () {	0x00000080;}
}
unless(defined(&SK_IMR_TX1_AS_EOB)) {
    sub SK_IMR_TX1_AS_EOB () {	0x00000100;}
}
unless(defined(&SK_IMR_TX1_S_CHECK)) {
    sub SK_IMR_TX1_S_CHECK () {	0x00000200;}
}
unless(defined(&SK_IMR_TX1_S_EOF)) {
    sub SK_IMR_TX1_S_EOF () {	0x00000400;}
}
unless(defined(&SK_IMR_TX1_S_EOB)) {
    sub SK_IMR_TX1_S_EOB () {	0x00000800;}
}
unless(defined(&SK_IMR_RX2_CHECK)) {
    sub SK_IMR_RX2_CHECK () {	0x00001000;}
}
unless(defined(&SK_IMR_RX2_EOF)) {
    sub SK_IMR_RX2_EOF () {	0x00002000;}
}
unless(defined(&SK_IMR_RX2_EOB)) {
    sub SK_IMR_RX2_EOB () {	0x00004000;}
}
unless(defined(&SK_IMR_RX1_CHECK)) {
    sub SK_IMR_RX1_CHECK () {	0x00008000;}
}
unless(defined(&SK_IMR_RX1_EOF)) {
    sub SK_IMR_RX1_EOF () {	0x00010000;}
}
unless(defined(&SK_IMR_RX1_EOB)) {
    sub SK_IMR_RX1_EOB () {	0x00020000;}
}
unless(defined(&SK_IMR_LINK2_OFLOW)) {
    sub SK_IMR_LINK2_OFLOW () {	0x00040000;}
}
unless(defined(&SK_IMR_MAC2)) {
    sub SK_IMR_MAC2 () {	0x00080000;}
}
unless(defined(&SK_IMR_LINK1_OFLOW)) {
    sub SK_IMR_LINK1_OFLOW () {	0x00100000;}
}
unless(defined(&SK_IMR_MAC1)) {
    sub SK_IMR_MAC1 () {	0x00200000;}
}
unless(defined(&SK_IMR_TIMER)) {
    sub SK_IMR_TIMER () {	0x00400000;}
}
unless(defined(&SK_IMR_EXTERNAL_REG)) {
    sub SK_IMR_EXTERNAL_REG () {	0x00800000;}
}
unless(defined(&SK_IMR_SW)) {
    sub SK_IMR_SW () {	0x01000000;}
}
unless(defined(&SK_IMR_I2C_RDY)) {
    sub SK_IMR_I2C_RDY () {	0x02000000;}
}
unless(defined(&SK_IMR_TX2_TIMEO)) {
    sub SK_IMR_TX2_TIMEO () {	0x04000000;}
}
unless(defined(&SK_IMR_TX1_TIMEO)) {
    sub SK_IMR_TX1_TIMEO () {	0x08000000;}
}
unless(defined(&SK_IMR_RX2_TIMEO)) {
    sub SK_IMR_RX2_TIMEO () {	0x10000000;}
}
unless(defined(&SK_IMR_RX1_TIMEO)) {
    sub SK_IMR_RX1_TIMEO () {	0x20000000;}
}
unless(defined(&SK_IMR_RSVD)) {
    sub SK_IMR_RSVD () {	0x40000000;}
}
unless(defined(&SK_IMR_HWERR)) {
    sub SK_IMR_HWERR () {	0x80000000;}
}
unless(defined(&SK_INTRS1)) {
    sub SK_INTRS1 () {	( &SK_IMR_RX1_EOF| &SK_IMR_TX1_S_EOF| &SK_IMR_MAC1);}
}
unless(defined(&SK_INTRS2)) {
    sub SK_INTRS2 () {	( &SK_IMR_RX2_EOF| &SK_IMR_TX2_S_EOF| &SK_IMR_MAC2);}
}
unless(defined(&SK_IESR_PAR_RX2)) {
    sub SK_IESR_PAR_RX2 () {	0x00000001;}
}
unless(defined(&SK_IESR_PAR_RX1)) {
    sub SK_IESR_PAR_RX1 () {	0x00000002;}
}
unless(defined(&SK_IESR_PAR_MAC2)) {
    sub SK_IESR_PAR_MAC2 () {	0x00000004;}
}
unless(defined(&SK_IESR_PAR_MAC1)) {
    sub SK_IESR_PAR_MAC1 () {	0x00000008;}
}
unless(defined(&SK_IESR_PAR_WR_RAM)) {
    sub SK_IESR_PAR_WR_RAM () {	0x00000010;}
}
unless(defined(&SK_IESR_PAR_RD_RAM)) {
    sub SK_IESR_PAR_RD_RAM () {	0x00000020;}
}
unless(defined(&SK_IESR_NO_TSTAMP_MAC2)) {
    sub SK_IESR_NO_TSTAMP_MAC2 () {	0x00000040;}
}
unless(defined(&SK_IESR_NO_TSTAMO_MAC1)) {
    sub SK_IESR_NO_TSTAMO_MAC1 () {	0x00000080;}
}
unless(defined(&SK_IESR_NO_STS_MAC2)) {
    sub SK_IESR_NO_STS_MAC2 () {	0x00000100;}
}
unless(defined(&SK_IESR_NO_STS_MAC1)) {
    sub SK_IESR_NO_STS_MAC1 () {	0x00000200;}
}
unless(defined(&SK_IESR_IRQ_STS)) {
    sub SK_IESR_IRQ_STS () {	0x00000400;}
}
unless(defined(&SK_IESR_MASTERERR)) {
    sub SK_IESR_MASTERERR () {	0x00000800;}
}
unless(defined(&SK_IEMR_PAR_RX2)) {
    sub SK_IEMR_PAR_RX2 () {	0x00000001;}
}
unless(defined(&SK_IEMR_PAR_RX1)) {
    sub SK_IEMR_PAR_RX1 () {	0x00000002;}
}
unless(defined(&SK_IEMR_PAR_MAC2)) {
    sub SK_IEMR_PAR_MAC2 () {	0x00000004;}
}
unless(defined(&SK_IEMR_PAR_MAC1)) {
    sub SK_IEMR_PAR_MAC1 () {	0x00000008;}
}
unless(defined(&SK_IEMR_PAR_WR_RAM)) {
    sub SK_IEMR_PAR_WR_RAM () {	0x00000010;}
}
unless(defined(&SK_IEMR_PAR_RD_RAM)) {
    sub SK_IEMR_PAR_RD_RAM () {	0x00000020;}
}
unless(defined(&SK_IEMR_NO_TSTAMP_MAC2)) {
    sub SK_IEMR_NO_TSTAMP_MAC2 () {	0x00000040;}
}
unless(defined(&SK_IEMR_NO_TSTAMO_MAC1)) {
    sub SK_IEMR_NO_TSTAMO_MAC1 () {	0x00000080;}
}
unless(defined(&SK_IEMR_NO_STS_MAC2)) {
    sub SK_IEMR_NO_STS_MAC2 () {	0x00000100;}
}
unless(defined(&SK_IEMR_NO_STS_MAC1)) {
    sub SK_IEMR_NO_STS_MAC1 () {	0x00000200;}
}
unless(defined(&SK_IEMR_IRQ_STS)) {
    sub SK_IEMR_IRQ_STS () {	0x00000400;}
}
unless(defined(&SK_IEMR_MASTERERR)) {
    sub SK_IEMR_MASTERERR () {	0x00000800;}
}
unless(defined(&SK_MAC0_0)) {
    sub SK_MAC0_0 () {	0x0100;}
}
unless(defined(&SK_MAC0_1)) {
    sub SK_MAC0_1 () {	0x0104;}
}
unless(defined(&SK_MAC1_0)) {
    sub SK_MAC1_0 () {	0x0108;}
}
unless(defined(&SK_MAC1_1)) {
    sub SK_MAC1_1 () {	0x010c;}
}
unless(defined(&SK_MAC2_0)) {
    sub SK_MAC2_0 () {	0x0110;}
}
unless(defined(&SK_MAC2_1)) {
    sub SK_MAC2_1 () {	0x0114;}
}
unless(defined(&SK_CONNTYPE)) {
    sub SK_CONNTYPE () {	0x0118;}
}
unless(defined(&SK_PMDTYPE)) {
    sub SK_PMDTYPE () {	0x0119;}
}
unless(defined(&SK_CONFIG)) {
    sub SK_CONFIG () {	0x011a;}
}
unless(defined(&SK_CHIPVER)) {
    sub SK_CHIPVER () {	0x011b;}
}
unless(defined(&SK_EPROM0)) {
    sub SK_EPROM0 () {	0x011c;}
}
unless(defined(&SK_EPROM1)) {
    sub SK_EPROM1 () {	0x011d;}
}
unless(defined(&SK_EPROM2)) {
    sub SK_EPROM2 () {	0x011e;}
}
unless(defined(&SK_EPROM3)) {
    sub SK_EPROM3 () {	0x011f;}
}
unless(defined(&SK_EP_ADDR)) {
    sub SK_EP_ADDR () {	0x0120;}
}
unless(defined(&SK_EP_DATA)) {
    sub SK_EP_DATA () {	0x0124;}
}
unless(defined(&SK_EP_LOADCTL)) {
    sub SK_EP_LOADCTL () {	0x0128;}
}
unless(defined(&SK_EP_LOADTST)) {
    sub SK_EP_LOADTST () {	0x0129;}
}
unless(defined(&SK_TIMERINIT)) {
    sub SK_TIMERINIT () {	0x0130;}
}
unless(defined(&SK_TIMER)) {
    sub SK_TIMER () {	0x0134;}
}
unless(defined(&SK_TIMERCTL)) {
    sub SK_TIMERCTL () {	0x0138;}
}
unless(defined(&SK_TIMERTST)) {
    sub SK_TIMERTST () {	0x0139;}
}
unless(defined(&SK_IMTIMERINIT)) {
    sub SK_IMTIMERINIT () {	0x0140;}
}
unless(defined(&SK_IMTIMER)) {
    sub SK_IMTIMER () {	0x0144;}
}
unless(defined(&SK_IMTIMERCTL)) {
    sub SK_IMTIMERCTL () {	0x0148;}
}
unless(defined(&SK_IMTIMERTST)) {
    sub SK_IMTIMERTST () {	0x0149;}
}
unless(defined(&SK_IMMR)) {
    sub SK_IMMR () {	0x014c;}
}
unless(defined(&SK_IHWEMR)) {
    sub SK_IHWEMR () {	0x0150;}
}
unless(defined(&SK_TESTCTL1)) {
    sub SK_TESTCTL1 () {	0x0158;}
}
unless(defined(&SK_TESTCTL2)) {
    sub SK_TESTCTL2 () {	0x0159;}
}
unless(defined(&SK_GPIO)) {
    sub SK_GPIO () {	0x015c;}
}
unless(defined(&SK_I2CHWCTL)) {
    sub SK_I2CHWCTL () {	0x0160;}
}
unless(defined(&SK_I2CHWDATA)) {
    sub SK_I2CHWDATA () {	0x0164;}
}
unless(defined(&SK_I2CHWIRQ)) {
    sub SK_I2CHWIRQ () {	0x0168;}
}
unless(defined(&SK_I2CSW)) {
    sub SK_I2CSW () {	0x016c;}
}
unless(defined(&SK_BLNKINIT)) {
    sub SK_BLNKINIT () {	0x0170;}
}
unless(defined(&SK_BLNKCOUNT)) {
    sub SK_BLNKCOUNT () {	0x0174;}
}
unless(defined(&SK_BLNKCTL)) {
    sub SK_BLNKCTL () {	0x0178;}
}
unless(defined(&SK_BLNKSTS)) {
    sub SK_BLNKSTS () {	0x0179;}
}
unless(defined(&SK_BLNKTST)) {
    sub SK_BLNKTST () {	0x017a;}
}
unless(defined(&SK_IMCTL_STOP)) {
    sub SK_IMCTL_STOP () {	0x02;}
}
unless(defined(&SK_IMCTL_START)) {
    sub SK_IMCTL_START () {	0x04;}
}
unless(defined(&SK_IMTIMER_TICKS)) {
    sub SK_IMTIMER_TICKS () {	54;}
}
unless(defined(&SK_IM_USECS)) {
    sub SK_IM_USECS {
	local($x) = @_;
	eval q((($x) *  &SK_IMTIMER_TICKS));
    }
}
unless(defined(&SK_RAMSIZE_512K_64)) {
    sub SK_RAMSIZE_512K_64 () {	0x1;}
}
unless(defined(&SK_RAMSIZE_1024K_128)) {
    sub SK_RAMSIZE_1024K_128 () {	0x2;}
}
unless(defined(&SK_RAMSIZE_1024K_64)) {
    sub SK_RAMSIZE_1024K_64 () {	0x3;}
}
unless(defined(&SK_RAMSIZE_2048K_128)) {
    sub SK_RAMSIZE_2048K_128 () {	0x4;}
}
unless(defined(&SK_RBOFF_0)) {
    sub SK_RBOFF_0 () {	0x0;}
}
unless(defined(&SK_RBOFF_80000)) {
    sub SK_RBOFF_80000 () {	0x80000;}
}
unless(defined(&SK_PHYTYPE_XMAC)) {
    sub SK_PHYTYPE_XMAC () {	0;}
}
unless(defined(&SK_PHYTYPE_BCOM)) {
    sub SK_PHYTYPE_BCOM () {	1;}
}
unless(defined(&SK_PHYTYPE_LONE)) {
    sub SK_PHYTYPE_LONE () {	2;}
}
unless(defined(&SK_PHYTYPE_NAT)) {
    sub SK_PHYTYPE_NAT () {	3;}
}
unless(defined(&SK_PHYADDR_XMAC)) {
    sub SK_PHYADDR_XMAC () {	0x0;}
}
unless(defined(&SK_PHYADDR_BCOM)) {
    sub SK_PHYADDR_BCOM () {	0x1;}
}
unless(defined(&SK_PHYADDR_LONE)) {
    sub SK_PHYADDR_LONE () {	0x3;}
}
unless(defined(&SK_PHYADDR_NAT)) {
    sub SK_PHYADDR_NAT () {	0x0;}
}
unless(defined(&SK_CONFIG_SINGLEMAC)) {
    sub SK_CONFIG_SINGLEMAC () {	0x01;}
}
unless(defined(&SK_CONFIG_DIS_DSL_CLK)) {
    sub SK_CONFIG_DIS_DSL_CLK () {	0x02;}
}
unless(defined(&SK_PMD_1000BASELX)) {
    sub SK_PMD_1000BASELX () {	0x4c;}
}
unless(defined(&SK_PMD_1000BASESX)) {
    sub SK_PMD_1000BASESX () {	0x53;}
}
unless(defined(&SK_PMD_1000BASECX)) {
    sub SK_PMD_1000BASECX () {	0x43;}
}
unless(defined(&SK_PMD_1000BASETX)) {
    sub SK_PMD_1000BASETX () {	0x54;}
}
unless(defined(&SK_GPIO_DAT0)) {
    sub SK_GPIO_DAT0 () {	0x00000001;}
}
unless(defined(&SK_GPIO_DAT1)) {
    sub SK_GPIO_DAT1 () {	0x00000002;}
}
unless(defined(&SK_GPIO_DAT2)) {
    sub SK_GPIO_DAT2 () {	0x00000004;}
}
unless(defined(&SK_GPIO_DAT3)) {
    sub SK_GPIO_DAT3 () {	0x00000008;}
}
unless(defined(&SK_GPIO_DAT4)) {
    sub SK_GPIO_DAT4 () {	0x00000010;}
}
unless(defined(&SK_GPIO_DAT5)) {
    sub SK_GPIO_DAT5 () {	0x00000020;}
}
unless(defined(&SK_GPIO_DAT6)) {
    sub SK_GPIO_DAT6 () {	0x00000040;}
}
unless(defined(&SK_GPIO_DAT7)) {
    sub SK_GPIO_DAT7 () {	0x00000080;}
}
unless(defined(&SK_GPIO_DAT8)) {
    sub SK_GPIO_DAT8 () {	0x00000100;}
}
unless(defined(&SK_GPIO_DAT9)) {
    sub SK_GPIO_DAT9 () {	0x00000200;}
}
unless(defined(&SK_GPIO_DIR0)) {
    sub SK_GPIO_DIR0 () {	0x00010000;}
}
unless(defined(&SK_GPIO_DIR1)) {
    sub SK_GPIO_DIR1 () {	0x00020000;}
}
unless(defined(&SK_GPIO_DIR2)) {
    sub SK_GPIO_DIR2 () {	0x00040000;}
}
unless(defined(&SK_GPIO_DIR3)) {
    sub SK_GPIO_DIR3 () {	0x00080000;}
}
unless(defined(&SK_GPIO_DIR4)) {
    sub SK_GPIO_DIR4 () {	0x00100000;}
}
unless(defined(&SK_GPIO_DIR5)) {
    sub SK_GPIO_DIR5 () {	0x00200000;}
}
unless(defined(&SK_GPIO_DIR6)) {
    sub SK_GPIO_DIR6 () {	0x00400000;}
}
unless(defined(&SK_GPIO_DIR7)) {
    sub SK_GPIO_DIR7 () {	0x00800000;}
}
unless(defined(&SK_GPIO_DIR8)) {
    sub SK_GPIO_DIR8 () {	0x01000000;}
}
unless(defined(&SK_GPIO_DIR9)) {
    sub SK_GPIO_DIR9 () {	0x02000000;}
}
unless(defined(&SK_RAMADDR)) {
    sub SK_RAMADDR () {	0x0180;}
}
unless(defined(&SK_RAMDATA0)) {
    sub SK_RAMDATA0 () {	0x0184;}
}
unless(defined(&SK_RAMDATA1)) {
    sub SK_RAMDATA1 () {	0x0188;}
}
unless(defined(&SK_TO0)) {
    sub SK_TO0 () {	0x0190;}
}
unless(defined(&SK_TO1)) {
    sub SK_TO1 () {	0x0191;}
}
unless(defined(&SK_TO2)) {
    sub SK_TO2 () {	0x0192;}
}
unless(defined(&SK_TO3)) {
    sub SK_TO3 () {	0x0193;}
}
unless(defined(&SK_TO4)) {
    sub SK_TO4 () {	0x0194;}
}
unless(defined(&SK_TO5)) {
    sub SK_TO5 () {	0x0195;}
}
unless(defined(&SK_TO6)) {
    sub SK_TO6 () {	0x0196;}
}
unless(defined(&SK_TO7)) {
    sub SK_TO7 () {	0x0197;}
}
unless(defined(&SK_TO8)) {
    sub SK_TO8 () {	0x0198;}
}
unless(defined(&SK_TO9)) {
    sub SK_TO9 () {	0x0199;}
}
unless(defined(&SK_TO10)) {
    sub SK_TO10 () {	0x019a;}
}
unless(defined(&SK_TO11)) {
    sub SK_TO11 () {	0x019b;}
}
unless(defined(&SK_RITIMEO_TMR)) {
    sub SK_RITIMEO_TMR () {	0x019c;}
}
unless(defined(&SK_RAMCTL)) {
    sub SK_RAMCTL () {	0x01a0;}
}
unless(defined(&SK_RITIMER_TST)) {
    sub SK_RITIMER_TST () {	0x01a2;}
}
unless(defined(&SK_RAMCTL_RESET)) {
    sub SK_RAMCTL_RESET () {	0x0001;}
}
unless(defined(&SK_RAMCTL_UNRESET)) {
    sub SK_RAMCTL_UNRESET () {	0x0002;}
}
unless(defined(&SK_RAMCTL_CLR_IRQ_WPAR)) {
    sub SK_RAMCTL_CLR_IRQ_WPAR () {	0x0100;}
}
unless(defined(&SK_RAMCTL_CLR_IRQ_RPAR)) {
    sub SK_RAMCTL_CLR_IRQ_RPAR () {	0x0200;}
}
unless(defined(&SK_MINIT_RX1)) {
    sub SK_MINIT_RX1 () {	0x01b0;}
}
unless(defined(&SK_MINIT_RX2)) {
    sub SK_MINIT_RX2 () {	0x01b1;}
}
unless(defined(&SK_MINIT_TX1)) {
    sub SK_MINIT_TX1 () {	0x01b2;}
}
unless(defined(&SK_MINIT_TX2)) {
    sub SK_MINIT_TX2 () {	0x01b3;}
}
unless(defined(&SK_MTIMEO_RX1)) {
    sub SK_MTIMEO_RX1 () {	0x01b4;}
}
unless(defined(&SK_MTIMEO_RX2)) {
    sub SK_MTIMEO_RX2 () {	0x01b5;}
}
unless(defined(&SK_MTIMEO_TX1)) {
    sub SK_MTIMEO_TX1 () {	0x01b6;}
}
unless(defined(&SK_MTIEMO_TX2)) {
    sub SK_MTIEMO_TX2 () {	0x01b7;}
}
unless(defined(&SK_MACARB_CTL)) {
    sub SK_MACARB_CTL () {	0x01b8;}
}
unless(defined(&SK_MTIMER_TST)) {
    sub SK_MTIMER_TST () {	0x01ba;}
}
unless(defined(&SK_RCINIT_RX1)) {
    sub SK_RCINIT_RX1 () {	0x01c0;}
}
unless(defined(&SK_RCINIT_RX2)) {
    sub SK_RCINIT_RX2 () {	0x01c1;}
}
unless(defined(&SK_RCINIT_TX1)) {
    sub SK_RCINIT_TX1 () {	0x01c2;}
}
unless(defined(&SK_RCINIT_TX2)) {
    sub SK_RCINIT_TX2 () {	0x01c3;}
}
unless(defined(&SK_RCTIMEO_RX1)) {
    sub SK_RCTIMEO_RX1 () {	0x01c4;}
}
unless(defined(&SK_RCTIMEO_RX2)) {
    sub SK_RCTIMEO_RX2 () {	0x01c5;}
}
unless(defined(&SK_RCTIMEO_TX1)) {
    sub SK_RCTIMEO_TX1 () {	0x01c6;}
}
unless(defined(&SK_RCTIMEO_TX2)) {
    sub SK_RCTIMEO_TX2 () {	0x01c7;}
}
unless(defined(&SK_RECOVERY_CTL)) {
    sub SK_RECOVERY_CTL () {	0x01c8;}
}
unless(defined(&SK_RCTIMER_TST)) {
    sub SK_RCTIMER_TST () {	0x01ca;}
}
unless(defined(&SK_RXPA1_TINIT)) {
    sub SK_RXPA1_TINIT () {	0x01d0;}
}
unless(defined(&SK_RXPA2_TINIT)) {
    sub SK_RXPA2_TINIT () {	0x01d4;}
}
unless(defined(&SK_TXPA1_TINIT)) {
    sub SK_TXPA1_TINIT () {	0x01d8;}
}
unless(defined(&SK_TXPA2_TINIT)) {
    sub SK_TXPA2_TINIT () {	0x01dc;}
}
unless(defined(&SK_RXPA1_TIMEO)) {
    sub SK_RXPA1_TIMEO () {	0x01e0;}
}
unless(defined(&SK_RXPA2_TIMEO)) {
    sub SK_RXPA2_TIMEO () {	0x01e4;}
}
unless(defined(&SK_TXPA1_TIMEO)) {
    sub SK_TXPA1_TIMEO () {	0x01e8;}
}
unless(defined(&SK_TXPA2_TIMEO)) {
    sub SK_TXPA2_TIMEO () {	0x01ec;}
}
unless(defined(&SK_PKTARB_CTL)) {
    sub SK_PKTARB_CTL () {	0x01f0;}
}
unless(defined(&SK_PKTATB_TST)) {
    sub SK_PKTATB_TST () {	0x01f2;}
}
unless(defined(&SK_PKTARB_TIMEOUT)) {
    sub SK_PKTARB_TIMEOUT () {	0x2000;}
}
unless(defined(&SK_PKTARBCTL_RESET)) {
    sub SK_PKTARBCTL_RESET () {	0x0001;}
}
unless(defined(&SK_PKTARBCTL_UNRESET)) {
    sub SK_PKTARBCTL_UNRESET () {	0x0002;}
}
unless(defined(&SK_PKTARBCTL_RXTO1_OFF)) {
    sub SK_PKTARBCTL_RXTO1_OFF () {	0x0004;}
}
unless(defined(&SK_PKTARBCTL_RXTO1_ON)) {
    sub SK_PKTARBCTL_RXTO1_ON () {	0x0008;}
}
unless(defined(&SK_PKTARBCTL_RXTO2_OFF)) {
    sub SK_PKTARBCTL_RXTO2_OFF () {	0x0010;}
}
unless(defined(&SK_PKTARBCTL_RXTO2_ON)) {
    sub SK_PKTARBCTL_RXTO2_ON () {	0x0020;}
}
unless(defined(&SK_PKTARBCTL_TXTO1_OFF)) {
    sub SK_PKTARBCTL_TXTO1_OFF () {	0x0040;}
}
unless(defined(&SK_PKTARBCTL_TXTO1_ON)) {
    sub SK_PKTARBCTL_TXTO1_ON () {	0x0080;}
}
unless(defined(&SK_PKTARBCTL_TXTO2_OFF)) {
    sub SK_PKTARBCTL_TXTO2_OFF () {	0x0100;}
}
unless(defined(&SK_PKTARBCTL_TXTO2_ON)) {
    sub SK_PKTARBCTL_TXTO2_ON () {	0x0200;}
}
unless(defined(&SK_PKTARBCTL_CLR_IRQ_RXTO1)) {
    sub SK_PKTARBCTL_CLR_IRQ_RXTO1 () {	0x0400;}
}
unless(defined(&SK_PKTARBCTL_CLR_IRQ_RXTO2)) {
    sub SK_PKTARBCTL_CLR_IRQ_RXTO2 () {	0x0800;}
}
unless(defined(&SK_PKTARBCTL_CLR_IRQ_TXTO1)) {
    sub SK_PKTARBCTL_CLR_IRQ_TXTO1 () {	0x1000;}
}
unless(defined(&SK_PKTARBCTL_CLR_IRQ_TXTO2)) {
    sub SK_PKTARBCTL_CLR_IRQ_TXTO2 () {	0x2000;}
}
unless(defined(&SK_MINIT_XMAC_B2)) {
    sub SK_MINIT_XMAC_B2 () {	54;}
}
unless(defined(&SK_MINIT_XMAC_C1)) {
    sub SK_MINIT_XMAC_C1 () {	63;}
}
unless(defined(&SK_MACARBCTL_RESET)) {
    sub SK_MACARBCTL_RESET () {	0x0001;}
}
unless(defined(&SK_MACARBCTL_UNRESET)) {
    sub SK_MACARBCTL_UNRESET () {	0x0002;}
}
unless(defined(&SK_MACARBCTL_FASTOE_OFF)) {
    sub SK_MACARBCTL_FASTOE_OFF () {	0x0004;}
}
unless(defined(&SK_MACARBCRL_FASTOE_ON)) {
    sub SK_MACARBCRL_FASTOE_ON () {	0x0008;}
}
unless(defined(&SK_RCINIT_XMAC_B2)) {
    sub SK_RCINIT_XMAC_B2 () {	54;}
}
unless(defined(&SK_RCINIT_XMAC_C1)) {
    sub SK_RCINIT_XMAC_C1 () {	0;}
}
unless(defined(&SK_RECOVERYCTL_RX1_OFF)) {
    sub SK_RECOVERYCTL_RX1_OFF () {	0x0001;}
}
unless(defined(&SK_RECOVERYCTL_RX1_ON)) {
    sub SK_RECOVERYCTL_RX1_ON () {	0x0002;}
}
unless(defined(&SK_RECOVERYCTL_RX2_OFF)) {
    sub SK_RECOVERYCTL_RX2_OFF () {	0x0004;}
}
unless(defined(&SK_RECOVERYCTL_RX2_ON)) {
    sub SK_RECOVERYCTL_RX2_ON () {	0x0008;}
}
unless(defined(&SK_RECOVERYCTL_TX1_OFF)) {
    sub SK_RECOVERYCTL_TX1_OFF () {	0x0010;}
}
unless(defined(&SK_RECOVERYCTL_TX1_ON)) {
    sub SK_RECOVERYCTL_TX1_ON () {	0x0020;}
}
unless(defined(&SK_RECOVERYCTL_TX2_OFF)) {
    sub SK_RECOVERYCTL_TX2_OFF () {	0x0040;}
}
unless(defined(&SK_RECOVERYCTL_TX2_ON)) {
    sub SK_RECOVERYCTL_TX2_ON () {	0x0080;}
}
unless(defined(&SK_RECOVERY_XMAC_B2)) {
    sub SK_RECOVERY_XMAC_B2 () {	( &SK_RECOVERYCTL_RX1_ON| &SK_RECOVERYCTL_RX2_ON|  &SK_RECOVERYCTL_TX1_ON| &SK_RECOVERYCTL_TX2_ON);}
}
unless(defined(&SK_RECOVERY_XMAC_C1)) {
    sub SK_RECOVERY_XMAC_C1 () {	( &SK_RECOVERYCTL_RX1_OFF| &SK_RECOVERYCTL_RX2_OFF|  &SK_RECOVERYCTL_TX1_OFF| &SK_RECOVERYCTL_TX2_OFF);}
}
unless(defined(&SK_TXAR1_TIMERINIT)) {
    sub SK_TXAR1_TIMERINIT () {	0x0200;}
}
unless(defined(&SK_TXAR1_TIMERVAL)) {
    sub SK_TXAR1_TIMERVAL () {	0x0204;}
}
unless(defined(&SK_TXAR1_LIMITINIT)) {
    sub SK_TXAR1_LIMITINIT () {	0x0208;}
}
unless(defined(&SK_TXAR1_LIMITCNT)) {
    sub SK_TXAR1_LIMITCNT () {	0x020c;}
}
unless(defined(&SK_TXAR1_COUNTERCTL)) {
    sub SK_TXAR1_COUNTERCTL () {	0x0210;}
}
unless(defined(&SK_TXAR1_COUNTERTST)) {
    sub SK_TXAR1_COUNTERTST () {	0x0212;}
}
unless(defined(&SK_TXAR1_COUNTERSTS)) {
    sub SK_TXAR1_COUNTERSTS () {	0x0212;}
}
unless(defined(&SK_TXAR2_TIMERINIT)) {
    sub SK_TXAR2_TIMERINIT () {	0x0280;}
}
unless(defined(&SK_TXAR2_TIMERVAL)) {
    sub SK_TXAR2_TIMERVAL () {	0x0284;}
}
unless(defined(&SK_TXAR2_LIMITINIT)) {
    sub SK_TXAR2_LIMITINIT () {	0x0288;}
}
unless(defined(&SK_TXAR2_LIMITCNT)) {
    sub SK_TXAR2_LIMITCNT () {	0x028c;}
}
unless(defined(&SK_TXAR2_COUNTERCTL)) {
    sub SK_TXAR2_COUNTERCTL () {	0x0290;}
}
unless(defined(&SK_TXAR2_COUNTERTST)) {
    sub SK_TXAR2_COUNTERTST () {	0x0291;}
}
unless(defined(&SK_TXAR2_COUNTERSTS)) {
    sub SK_TXAR2_COUNTERSTS () {	0x0292;}
}
unless(defined(&SK_TXARCTL_OFF)) {
    sub SK_TXARCTL_OFF () {	0x01;}
}
unless(defined(&SK_TXARCTL_ON)) {
    sub SK_TXARCTL_ON () {	0x02;}
}
unless(defined(&SK_TXARCTL_RATECTL_OFF)) {
    sub SK_TXARCTL_RATECTL_OFF () {	0x04;}
}
unless(defined(&SK_TXARCTL_RATECTL_ON)) {
    sub SK_TXARCTL_RATECTL_ON () {	0x08;}
}
unless(defined(&SK_TXARCTL_ALLOC_OFF)) {
    sub SK_TXARCTL_ALLOC_OFF () {	0x10;}
}
unless(defined(&SK_TXARCTL_ALLOC_ON)) {
    sub SK_TXARCTL_ALLOC_ON () {	0x20;}
}
unless(defined(&SK_TXARCTL_FSYNC_OFF)) {
    sub SK_TXARCTL_FSYNC_OFF () {	0x40;}
}
unless(defined(&SK_TXARCTL_FSYNC_ON)) {
    sub SK_TXARCTL_FSYNC_ON () {	0x80;}
}
unless(defined(&SK_EXTREG_BASE)) {
    sub SK_EXTREG_BASE () {	0x300;}
}
unless(defined(&SK_EXTREG_END)) {
    sub SK_EXTREG_END () {	0x37c;}
}
unless(defined(&SK_PCI_BASE)) {
    sub SK_PCI_BASE () {	0x0380;}
}
unless(defined(&SK_PCI_END)) {
    sub SK_PCI_END () {	0x03fc;}
}
unless(defined(&SK_PCI_REG)) {
    sub SK_PCI_REG {
	local($reg) = @_;
	eval q((($reg) +  &SK_PCI_BASE));
    }
}
unless(defined(&SK_RXQ1_BUFCNT)) {
    sub SK_RXQ1_BUFCNT () {	0x0400;}
}
unless(defined(&SK_RXQ1_BUFCTL)) {
    sub SK_RXQ1_BUFCTL () {	0x0402;}
}
unless(defined(&SK_RXQ1_NEXTDESC)) {
    sub SK_RXQ1_NEXTDESC () {	0x0404;}
}
unless(defined(&SK_RXQ1_RXBUF_LO)) {
    sub SK_RXQ1_RXBUF_LO () {	0x0408;}
}
unless(defined(&SK_RXQ1_RXBUF_HI)) {
    sub SK_RXQ1_RXBUF_HI () {	0x040c;}
}
unless(defined(&SK_RXQ1_RXSTAT)) {
    sub SK_RXQ1_RXSTAT () {	0x0410;}
}
unless(defined(&SK_RXQ1_TIMESTAMP)) {
    sub SK_RXQ1_TIMESTAMP () {	0x0414;}
}
unless(defined(&SK_RXQ1_CSUM1)) {
    sub SK_RXQ1_CSUM1 () {	0x0418;}
}
unless(defined(&SK_RXQ1_CSUM2)) {
    sub SK_RXQ1_CSUM2 () {	0x041a;}
}
unless(defined(&SK_RXQ1_CSUM1_START)) {
    sub SK_RXQ1_CSUM1_START () {	0x041c;}
}
unless(defined(&SK_RXQ1_CSUM2_START)) {
    sub SK_RXQ1_CSUM2_START () {	0x041e;}
}
unless(defined(&SK_RXQ1_CURADDR_LO)) {
    sub SK_RXQ1_CURADDR_LO () {	0x0420;}
}
unless(defined(&SK_RXQ1_CURADDR_HI)) {
    sub SK_RXQ1_CURADDR_HI () {	0x0424;}
}
unless(defined(&SK_RXQ1_CURCNT_LO)) {
    sub SK_RXQ1_CURCNT_LO () {	0x0428;}
}
unless(defined(&SK_RXQ1_CURCNT_HI)) {
    sub SK_RXQ1_CURCNT_HI () {	0x042c;}
}
unless(defined(&SK_RXQ1_CURBYTES)) {
    sub SK_RXQ1_CURBYTES () {	0x0430;}
}
unless(defined(&SK_RXQ1_BMU_CSR)) {
    sub SK_RXQ1_BMU_CSR () {	0x0434;}
}
unless(defined(&SK_RXQ1_WATERMARK)) {
    sub SK_RXQ1_WATERMARK () {	0x0438;}
}
unless(defined(&SK_RXQ1_FLAG)) {
    sub SK_RXQ1_FLAG () {	0x043a;}
}
unless(defined(&SK_RXQ1_TEST1)) {
    sub SK_RXQ1_TEST1 () {	0x043c;}
}
unless(defined(&SK_RXQ1_TEST2)) {
    sub SK_RXQ1_TEST2 () {	0x0440;}
}
unless(defined(&SK_RXQ1_TEST3)) {
    sub SK_RXQ1_TEST3 () {	0x0444;}
}
unless(defined(&SK_RXQ2_BUFCNT)) {
    sub SK_RXQ2_BUFCNT () {	0x0480;}
}
unless(defined(&SK_RXQ2_BUFCTL)) {
    sub SK_RXQ2_BUFCTL () {	0x0482;}
}
unless(defined(&SK_RXQ2_NEXTDESC)) {
    sub SK_RXQ2_NEXTDESC () {	0x0484;}
}
unless(defined(&SK_RXQ2_RXBUF_LO)) {
    sub SK_RXQ2_RXBUF_LO () {	0x0488;}
}
unless(defined(&SK_RXQ2_RXBUF_HI)) {
    sub SK_RXQ2_RXBUF_HI () {	0x048c;}
}
unless(defined(&SK_RXQ2_RXSTAT)) {
    sub SK_RXQ2_RXSTAT () {	0x0490;}
}
unless(defined(&SK_RXQ2_TIMESTAMP)) {
    sub SK_RXQ2_TIMESTAMP () {	0x0494;}
}
unless(defined(&SK_RXQ2_CSUM1)) {
    sub SK_RXQ2_CSUM1 () {	0x0498;}
}
unless(defined(&SK_RXQ2_CSUM2)) {
    sub SK_RXQ2_CSUM2 () {	0x049a;}
}
unless(defined(&SK_RXQ2_CSUM1_START)) {
    sub SK_RXQ2_CSUM1_START () {	0x049c;}
}
unless(defined(&SK_RXQ2_CSUM2_START)) {
    sub SK_RXQ2_CSUM2_START () {	0x049e;}
}
unless(defined(&SK_RXQ2_CURADDR_LO)) {
    sub SK_RXQ2_CURADDR_LO () {	0x04a0;}
}
unless(defined(&SK_RXQ2_CURADDR_HI)) {
    sub SK_RXQ2_CURADDR_HI () {	0x04a4;}
}
unless(defined(&SK_RXQ2_CURCNT_LO)) {
    sub SK_RXQ2_CURCNT_LO () {	0x04a8;}
}
unless(defined(&SK_RXQ2_CURCNT_HI)) {
    sub SK_RXQ2_CURCNT_HI () {	0x04ac;}
}
unless(defined(&SK_RXQ2_CURBYTES)) {
    sub SK_RXQ2_CURBYTES () {	0x04b0;}
}
unless(defined(&SK_RXQ2_BMU_CSR)) {
    sub SK_RXQ2_BMU_CSR () {	0x04b4;}
}
unless(defined(&SK_RXQ2_WATERMARK)) {
    sub SK_RXQ2_WATERMARK () {	0x04b8;}
}
unless(defined(&SK_RXQ2_FLAG)) {
    sub SK_RXQ2_FLAG () {	0x04ba;}
}
unless(defined(&SK_RXQ2_TEST1)) {
    sub SK_RXQ2_TEST1 () {	0x04bc;}
}
unless(defined(&SK_RXQ2_TEST2)) {
    sub SK_RXQ2_TEST2 () {	0x04c0;}
}
unless(defined(&SK_RXQ2_TEST3)) {
    sub SK_RXQ2_TEST3 () {	0x04c4;}
}
unless(defined(&SK_RXBMU_CLR_IRQ_ERR)) {
    sub SK_RXBMU_CLR_IRQ_ERR () {	0x00000001;}
}
unless(defined(&SK_RXBMU_CLR_IRQ_EOF)) {
    sub SK_RXBMU_CLR_IRQ_EOF () {	0x00000002;}
}
unless(defined(&SK_RXBMU_CLR_IRQ_EOB)) {
    sub SK_RXBMU_CLR_IRQ_EOB () {	0x00000004;}
}
unless(defined(&SK_RXBMU_CLR_IRQ_PAR)) {
    sub SK_RXBMU_CLR_IRQ_PAR () {	0x00000008;}
}
unless(defined(&SK_RXBMU_RX_START)) {
    sub SK_RXBMU_RX_START () {	0x00000010;}
}
unless(defined(&SK_RXBMU_RX_STOP)) {
    sub SK_RXBMU_RX_STOP () {	0x00000020;}
}
unless(defined(&SK_RXBMU_POLL_OFF)) {
    sub SK_RXBMU_POLL_OFF () {	0x00000040;}
}
unless(defined(&SK_RXBMU_POLL_ON)) {
    sub SK_RXBMU_POLL_ON () {	0x00000080;}
}
unless(defined(&SK_RXBMU_TRANSFER_SM_RESET)) {
    sub SK_RXBMU_TRANSFER_SM_RESET () {	0x00000100;}
}
unless(defined(&SK_RXBMU_TRANSFER_SM_UNRESET)) {
    sub SK_RXBMU_TRANSFER_SM_UNRESET () {	0x00000200;}
}
unless(defined(&SK_RXBMU_DESCWR_SM_RESET)) {
    sub SK_RXBMU_DESCWR_SM_RESET () {	0x00000400;}
}
unless(defined(&SK_RXBMU_DESCWR_SM_UNRESET)) {
    sub SK_RXBMU_DESCWR_SM_UNRESET () {	0x00000800;}
}
unless(defined(&SK_RXBMU_DESCRD_SM_RESET)) {
    sub SK_RXBMU_DESCRD_SM_RESET () {	0x00001000;}
}
unless(defined(&SK_RXBMU_DESCRD_SM_UNRESET)) {
    sub SK_RXBMU_DESCRD_SM_UNRESET () {	0x00002000;}
}
unless(defined(&SK_RXBMU_SUPERVISOR_SM_RESET)) {
    sub SK_RXBMU_SUPERVISOR_SM_RESET () {	0x00004000;}
}
unless(defined(&SK_RXBMU_SUPERVISOR_SM_UNRESET)) {
    sub SK_RXBMU_SUPERVISOR_SM_UNRESET () {	0x00008000;}
}
unless(defined(&SK_RXBMU_PFI_SM_RESET)) {
    sub SK_RXBMU_PFI_SM_RESET () {	0x00010000;}
}
unless(defined(&SK_RXBMU_PFI_SM_UNRESET)) {
    sub SK_RXBMU_PFI_SM_UNRESET () {	0x00020000;}
}
unless(defined(&SK_RXBMU_FIFO_RESET)) {
    sub SK_RXBMU_FIFO_RESET () {	0x00040000;}
}
unless(defined(&SK_RXBMU_FIFO_UNRESET)) {
    sub SK_RXBMU_FIFO_UNRESET () {	0x00080000;}
}
unless(defined(&SK_RXBMU_DESC_RESET)) {
    sub SK_RXBMU_DESC_RESET () {	0x00100000;}
}
unless(defined(&SK_RXBMU_DESC_UNRESET)) {
    sub SK_RXBMU_DESC_UNRESET () {	0x00200000;}
}
unless(defined(&SK_RXBMU_SUPERVISOR_IDLE)) {
    sub SK_RXBMU_SUPERVISOR_IDLE () {	0x01000000;}
}
unless(defined(&SK_RXBMU_ONLINE)) {
    sub SK_RXBMU_ONLINE () {	( &SK_RXBMU_TRANSFER_SM_UNRESET| &SK_RXBMU_DESCWR_SM_UNRESET|  &SK_RXBMU_DESCRD_SM_UNRESET| &SK_RXBMU_SUPERVISOR_SM_UNRESET|  &SK_RXBMU_PFI_SM_UNRESET| &SK_RXBMU_FIFO_UNRESET|  &SK_RXBMU_DESC_UNRESET);}
}
unless(defined(&SK_RXBMU_OFFLINE)) {
    sub SK_RXBMU_OFFLINE () {	( &SK_RXBMU_TRANSFER_SM_RESET| &SK_RXBMU_DESCWR_SM_RESET|  &SK_RXBMU_DESCRD_SM_RESET| &SK_RXBMU_SUPERVISOR_SM_RESET|  &SK_RXBMU_PFI_SM_RESET| &SK_RXBMU_FIFO_RESET|  &SK_RXBMU_DESC_RESET);}
}
unless(defined(&SK_TXQS1_BUFCNT)) {
    sub SK_TXQS1_BUFCNT () {	0x0600;}
}
unless(defined(&SK_TXQS1_BUFCTL)) {
    sub SK_TXQS1_BUFCTL () {	0x0602;}
}
unless(defined(&SK_TXQS1_NEXTDESC)) {
    sub SK_TXQS1_NEXTDESC () {	0x0604;}
}
unless(defined(&SK_TXQS1_RXBUF_LO)) {
    sub SK_TXQS1_RXBUF_LO () {	0x0608;}
}
unless(defined(&SK_TXQS1_RXBUF_HI)) {
    sub SK_TXQS1_RXBUF_HI () {	0x060c;}
}
unless(defined(&SK_TXQS1_RXSTAT)) {
    sub SK_TXQS1_RXSTAT () {	0x0610;}
}
unless(defined(&SK_TXQS1_CSUM_STARTVAL)) {
    sub SK_TXQS1_CSUM_STARTVAL () {	0x0614;}
}
unless(defined(&SK_TXQS1_CSUM_STARTPOS)) {
    sub SK_TXQS1_CSUM_STARTPOS () {	0x0618;}
}
unless(defined(&SK_TXQS1_CSUM_WRITEPOS)) {
    sub SK_TXQS1_CSUM_WRITEPOS () {	0x061a;}
}
unless(defined(&SK_TXQS1_CURADDR_LO)) {
    sub SK_TXQS1_CURADDR_LO () {	0x0620;}
}
unless(defined(&SK_TXQS1_CURADDR_HI)) {
    sub SK_TXQS1_CURADDR_HI () {	0x0624;}
}
unless(defined(&SK_TXQS1_CURCNT_LO)) {
    sub SK_TXQS1_CURCNT_LO () {	0x0628;}
}
unless(defined(&SK_TXQS1_CURCNT_HI)) {
    sub SK_TXQS1_CURCNT_HI () {	0x062c;}
}
unless(defined(&SK_TXQS1_CURBYTES)) {
    sub SK_TXQS1_CURBYTES () {	0x0630;}
}
unless(defined(&SK_TXQS1_BMU_CSR)) {
    sub SK_TXQS1_BMU_CSR () {	0x0634;}
}
unless(defined(&SK_TXQS1_WATERMARK)) {
    sub SK_TXQS1_WATERMARK () {	0x0638;}
}
unless(defined(&SK_TXQS1_FLAG)) {
    sub SK_TXQS1_FLAG () {	0x063a;}
}
unless(defined(&SK_TXQS1_TEST1)) {
    sub SK_TXQS1_TEST1 () {	0x063c;}
}
unless(defined(&SK_TXQS1_TEST2)) {
    sub SK_TXQS1_TEST2 () {	0x0640;}
}
unless(defined(&SK_TXQS1_TEST3)) {
    sub SK_TXQS1_TEST3 () {	0x0644;}
}
unless(defined(&SK_TXQA1_BUFCNT)) {
    sub SK_TXQA1_BUFCNT () {	0x0680;}
}
unless(defined(&SK_TXQA1_BUFCTL)) {
    sub SK_TXQA1_BUFCTL () {	0x0682;}
}
unless(defined(&SK_TXQA1_NEXTDESC)) {
    sub SK_TXQA1_NEXTDESC () {	0x0684;}
}
unless(defined(&SK_TXQA1_RXBUF_LO)) {
    sub SK_TXQA1_RXBUF_LO () {	0x0688;}
}
unless(defined(&SK_TXQA1_RXBUF_HI)) {
    sub SK_TXQA1_RXBUF_HI () {	0x068c;}
}
unless(defined(&SK_TXQA1_RXSTAT)) {
    sub SK_TXQA1_RXSTAT () {	0x0690;}
}
unless(defined(&SK_TXQA1_CSUM_STARTVAL)) {
    sub SK_TXQA1_CSUM_STARTVAL () {	0x0694;}
}
unless(defined(&SK_TXQA1_CSUM_STARTPOS)) {
    sub SK_TXQA1_CSUM_STARTPOS () {	0x0698;}
}
unless(defined(&SK_TXQA1_CSUM_WRITEPOS)) {
    sub SK_TXQA1_CSUM_WRITEPOS () {	0x069a;}
}
unless(defined(&SK_TXQA1_CURADDR_LO)) {
    sub SK_TXQA1_CURADDR_LO () {	0x06a0;}
}
unless(defined(&SK_TXQA1_CURADDR_HI)) {
    sub SK_TXQA1_CURADDR_HI () {	0x06a4;}
}
unless(defined(&SK_TXQA1_CURCNT_LO)) {
    sub SK_TXQA1_CURCNT_LO () {	0x06a8;}
}
unless(defined(&SK_TXQA1_CURCNT_HI)) {
    sub SK_TXQA1_CURCNT_HI () {	0x06ac;}
}
unless(defined(&SK_TXQA1_CURBYTES)) {
    sub SK_TXQA1_CURBYTES () {	0x06b0;}
}
unless(defined(&SK_TXQA1_BMU_CSR)) {
    sub SK_TXQA1_BMU_CSR () {	0x06b4;}
}
unless(defined(&SK_TXQA1_WATERMARK)) {
    sub SK_TXQA1_WATERMARK () {	0x06b8;}
}
unless(defined(&SK_TXQA1_FLAG)) {
    sub SK_TXQA1_FLAG () {	0x06ba;}
}
unless(defined(&SK_TXQA1_TEST1)) {
    sub SK_TXQA1_TEST1 () {	0x06bc;}
}
unless(defined(&SK_TXQA1_TEST2)) {
    sub SK_TXQA1_TEST2 () {	0x06c0;}
}
unless(defined(&SK_TXQA1_TEST3)) {
    sub SK_TXQA1_TEST3 () {	0x06c4;}
}
unless(defined(&SK_TXQS2_BUFCNT)) {
    sub SK_TXQS2_BUFCNT () {	0x0700;}
}
unless(defined(&SK_TXQS2_BUFCTL)) {
    sub SK_TXQS2_BUFCTL () {	0x0702;}
}
unless(defined(&SK_TXQS2_NEXTDESC)) {
    sub SK_TXQS2_NEXTDESC () {	0x0704;}
}
unless(defined(&SK_TXQS2_RXBUF_LO)) {
    sub SK_TXQS2_RXBUF_LO () {	0x0708;}
}
unless(defined(&SK_TXQS2_RXBUF_HI)) {
    sub SK_TXQS2_RXBUF_HI () {	0x070c;}
}
unless(defined(&SK_TXQS2_RXSTAT)) {
    sub SK_TXQS2_RXSTAT () {	0x0710;}
}
unless(defined(&SK_TXQS2_CSUM_STARTVAL)) {
    sub SK_TXQS2_CSUM_STARTVAL () {	0x0714;}
}
unless(defined(&SK_TXQS2_CSUM_STARTPOS)) {
    sub SK_TXQS2_CSUM_STARTPOS () {	0x0718;}
}
unless(defined(&SK_TXQS2_CSUM_WRITEPOS)) {
    sub SK_TXQS2_CSUM_WRITEPOS () {	0x071a;}
}
unless(defined(&SK_TXQS2_CURADDR_LO)) {
    sub SK_TXQS2_CURADDR_LO () {	0x0720;}
}
unless(defined(&SK_TXQS2_CURADDR_HI)) {
    sub SK_TXQS2_CURADDR_HI () {	0x0724;}
}
unless(defined(&SK_TXQS2_CURCNT_LO)) {
    sub SK_TXQS2_CURCNT_LO () {	0x0728;}
}
unless(defined(&SK_TXQS2_CURCNT_HI)) {
    sub SK_TXQS2_CURCNT_HI () {	0x072c;}
}
unless(defined(&SK_TXQS2_CURBYTES)) {
    sub SK_TXQS2_CURBYTES () {	0x0730;}
}
unless(defined(&SK_TXQS2_BMU_CSR)) {
    sub SK_TXQS2_BMU_CSR () {	0x0734;}
}
unless(defined(&SK_TXQS2_WATERMARK)) {
    sub SK_TXQS2_WATERMARK () {	0x0738;}
}
unless(defined(&SK_TXQS2_FLAG)) {
    sub SK_TXQS2_FLAG () {	0x073a;}
}
unless(defined(&SK_TXQS2_TEST1)) {
    sub SK_TXQS2_TEST1 () {	0x073c;}
}
unless(defined(&SK_TXQS2_TEST2)) {
    sub SK_TXQS2_TEST2 () {	0x0740;}
}
unless(defined(&SK_TXQS2_TEST3)) {
    sub SK_TXQS2_TEST3 () {	0x0744;}
}
unless(defined(&SK_TXQA2_BUFCNT)) {
    sub SK_TXQA2_BUFCNT () {	0x0780;}
}
unless(defined(&SK_TXQA2_BUFCTL)) {
    sub SK_TXQA2_BUFCTL () {	0x0782;}
}
unless(defined(&SK_TXQA2_NEXTDESC)) {
    sub SK_TXQA2_NEXTDESC () {	0x0784;}
}
unless(defined(&SK_TXQA2_RXBUF_LO)) {
    sub SK_TXQA2_RXBUF_LO () {	0x0788;}
}
unless(defined(&SK_TXQA2_RXBUF_HI)) {
    sub SK_TXQA2_RXBUF_HI () {	0x078c;}
}
unless(defined(&SK_TXQA2_RXSTAT)) {
    sub SK_TXQA2_RXSTAT () {	0x0790;}
}
unless(defined(&SK_TXQA2_CSUM_STARTVAL)) {
    sub SK_TXQA2_CSUM_STARTVAL () {	0x0794;}
}
unless(defined(&SK_TXQA2_CSUM_STARTPOS)) {
    sub SK_TXQA2_CSUM_STARTPOS () {	0x0798;}
}
unless(defined(&SK_TXQA2_CSUM_WRITEPOS)) {
    sub SK_TXQA2_CSUM_WRITEPOS () {	0x079a;}
}
unless(defined(&SK_TXQA2_CURADDR_LO)) {
    sub SK_TXQA2_CURADDR_LO () {	0x07a0;}
}
unless(defined(&SK_TXQA2_CURADDR_HI)) {
    sub SK_TXQA2_CURADDR_HI () {	0x07a4;}
}
unless(defined(&SK_TXQA2_CURCNT_LO)) {
    sub SK_TXQA2_CURCNT_LO () {	0x07a8;}
}
unless(defined(&SK_TXQA2_CURCNT_HI)) {
    sub SK_TXQA2_CURCNT_HI () {	0x07ac;}
}
unless(defined(&SK_TXQA2_CURBYTES)) {
    sub SK_TXQA2_CURBYTES () {	0x07b0;}
}
unless(defined(&SK_TXQA2_BMU_CSR)) {
    sub SK_TXQA2_BMU_CSR () {	0x07b4;}
}
unless(defined(&SK_TXQA2_WATERMARK)) {
    sub SK_TXQA2_WATERMARK () {	0x07b8;}
}
unless(defined(&SK_TXQA2_FLAG)) {
    sub SK_TXQA2_FLAG () {	0x07ba;}
}
unless(defined(&SK_TXQA2_TEST1)) {
    sub SK_TXQA2_TEST1 () {	0x07bc;}
}
unless(defined(&SK_TXQA2_TEST2)) {
    sub SK_TXQA2_TEST2 () {	0x07c0;}
}
unless(defined(&SK_TXQA2_TEST3)) {
    sub SK_TXQA2_TEST3 () {	0x07c4;}
}
unless(defined(&SK_TXBMU_CLR_IRQ_ERR)) {
    sub SK_TXBMU_CLR_IRQ_ERR () {	0x00000001;}
}
unless(defined(&SK_TXBMU_CLR_IRQ_EOF)) {
    sub SK_TXBMU_CLR_IRQ_EOF () {	0x00000002;}
}
unless(defined(&SK_TXBMU_CLR_IRQ_EOB)) {
    sub SK_TXBMU_CLR_IRQ_EOB () {	0x00000004;}
}
unless(defined(&SK_TXBMU_TX_START)) {
    sub SK_TXBMU_TX_START () {	0x00000010;}
}
unless(defined(&SK_TXBMU_TX_STOP)) {
    sub SK_TXBMU_TX_STOP () {	0x00000020;}
}
unless(defined(&SK_TXBMU_POLL_OFF)) {
    sub SK_TXBMU_POLL_OFF () {	0x00000040;}
}
unless(defined(&SK_TXBMU_POLL_ON)) {
    sub SK_TXBMU_POLL_ON () {	0x00000080;}
}
unless(defined(&SK_TXBMU_TRANSFER_SM_RESET)) {
    sub SK_TXBMU_TRANSFER_SM_RESET () {	0x00000100;}
}
unless(defined(&SK_TXBMU_TRANSFER_SM_UNRESET)) {
    sub SK_TXBMU_TRANSFER_SM_UNRESET () {	0x00000200;}
}
unless(defined(&SK_TXBMU_DESCWR_SM_RESET)) {
    sub SK_TXBMU_DESCWR_SM_RESET () {	0x00000400;}
}
unless(defined(&SK_TXBMU_DESCWR_SM_UNRESET)) {
    sub SK_TXBMU_DESCWR_SM_UNRESET () {	0x00000800;}
}
unless(defined(&SK_TXBMU_DESCRD_SM_RESET)) {
    sub SK_TXBMU_DESCRD_SM_RESET () {	0x00001000;}
}
unless(defined(&SK_TXBMU_DESCRD_SM_UNRESET)) {
    sub SK_TXBMU_DESCRD_SM_UNRESET () {	0x00002000;}
}
unless(defined(&SK_TXBMU_SUPERVISOR_SM_RESET)) {
    sub SK_TXBMU_SUPERVISOR_SM_RESET () {	0x00004000;}
}
unless(defined(&SK_TXBMU_SUPERVISOR_SM_UNRESET)) {
    sub SK_TXBMU_SUPERVISOR_SM_UNRESET () {	0x00008000;}
}
unless(defined(&SK_TXBMU_PFI_SM_RESET)) {
    sub SK_TXBMU_PFI_SM_RESET () {	0x00010000;}
}
unless(defined(&SK_TXBMU_PFI_SM_UNRESET)) {
    sub SK_TXBMU_PFI_SM_UNRESET () {	0x00020000;}
}
unless(defined(&SK_TXBMU_FIFO_RESET)) {
    sub SK_TXBMU_FIFO_RESET () {	0x00040000;}
}
unless(defined(&SK_TXBMU_FIFO_UNRESET)) {
    sub SK_TXBMU_FIFO_UNRESET () {	0x00080000;}
}
unless(defined(&SK_TXBMU_DESC_RESET)) {
    sub SK_TXBMU_DESC_RESET () {	0x00100000;}
}
unless(defined(&SK_TXBMU_DESC_UNRESET)) {
    sub SK_TXBMU_DESC_UNRESET () {	0x00200000;}
}
unless(defined(&SK_TXBMU_SUPERVISOR_IDLE)) {
    sub SK_TXBMU_SUPERVISOR_IDLE () {	0x01000000;}
}
unless(defined(&SK_TXBMU_ONLINE)) {
    sub SK_TXBMU_ONLINE () {	( &SK_TXBMU_TRANSFER_SM_UNRESET| &SK_TXBMU_DESCWR_SM_UNRESET|  &SK_TXBMU_DESCRD_SM_UNRESET| &SK_TXBMU_SUPERVISOR_SM_UNRESET|  &SK_TXBMU_PFI_SM_UNRESET| &SK_TXBMU_FIFO_UNRESET|  &SK_TXBMU_DESC_UNRESET);}
}
unless(defined(&SK_TXBMU_OFFLINE)) {
    sub SK_TXBMU_OFFLINE () {	( &SK_TXBMU_TRANSFER_SM_RESET| &SK_TXBMU_DESCWR_SM_RESET|  &SK_TXBMU_DESCRD_SM_RESET| &SK_TXBMU_SUPERVISOR_SM_RESET|  &SK_TXBMU_PFI_SM_RESET| &SK_TXBMU_FIFO_RESET|  &SK_TXBMU_DESC_RESET);}
}
unless(defined(&SK_RXRB1_START)) {
    sub SK_RXRB1_START () {	0x0800;}
}
unless(defined(&SK_RXRB1_END)) {
    sub SK_RXRB1_END () {	0x0804;}
}
unless(defined(&SK_RXRB1_WR_PTR)) {
    sub SK_RXRB1_WR_PTR () {	0x0808;}
}
unless(defined(&SK_RXRB1_RD_PTR)) {
    sub SK_RXRB1_RD_PTR () {	0x080c;}
}
unless(defined(&SK_RXRB1_UTHR_PAUSE)) {
    sub SK_RXRB1_UTHR_PAUSE () {	0x0810;}
}
unless(defined(&SK_RXRB1_LTHR_PAUSE)) {
    sub SK_RXRB1_LTHR_PAUSE () {	0x0814;}
}
unless(defined(&SK_RXRB1_UTHR_HIPRIO)) {
    sub SK_RXRB1_UTHR_HIPRIO () {	0x0818;}
}
unless(defined(&SK_RXRB1_UTHR_LOPRIO)) {
    sub SK_RXRB1_UTHR_LOPRIO () {	0x081c;}
}
unless(defined(&SK_RXRB1_PKTCNT)) {
    sub SK_RXRB1_PKTCNT () {	0x0820;}
}
unless(defined(&SK_RXRB1_LVL)) {
    sub SK_RXRB1_LVL () {	0x0824;}
}
unless(defined(&SK_RXRB1_CTLTST)) {
    sub SK_RXRB1_CTLTST () {	0x0828;}
}
unless(defined(&SK_RXRB2_START)) {
    sub SK_RXRB2_START () {	0x0880;}
}
unless(defined(&SK_RXRB2_END)) {
    sub SK_RXRB2_END () {	0x0884;}
}
unless(defined(&SK_RXRB2_WR_PTR)) {
    sub SK_RXRB2_WR_PTR () {	0x0888;}
}
unless(defined(&SK_RXRB2_RD_PTR)) {
    sub SK_RXRB2_RD_PTR () {	0x088c;}
}
unless(defined(&SK_RXRB2_UTHR_PAUSE)) {
    sub SK_RXRB2_UTHR_PAUSE () {	0x0890;}
}
unless(defined(&SK_RXRB2_LTHR_PAUSE)) {
    sub SK_RXRB2_LTHR_PAUSE () {	0x0894;}
}
unless(defined(&SK_RXRB2_UTHR_HIPRIO)) {
    sub SK_RXRB2_UTHR_HIPRIO () {	0x0898;}
}
unless(defined(&SK_RXRB2_UTHR_LOPRIO)) {
    sub SK_RXRB2_UTHR_LOPRIO () {	0x089c;}
}
unless(defined(&SK_RXRB2_PKTCNT)) {
    sub SK_RXRB2_PKTCNT () {	0x08a0;}
}
unless(defined(&SK_RXRB2_LVL)) {
    sub SK_RXRB2_LVL () {	0x08a4;}
}
unless(defined(&SK_RXRB2_CTLTST)) {
    sub SK_RXRB2_CTLTST () {	0x08a8;}
}
unless(defined(&SK_TXRBS1_START)) {
    sub SK_TXRBS1_START () {	0x0a00;}
}
unless(defined(&SK_TXRBS1_END)) {
    sub SK_TXRBS1_END () {	0x0a04;}
}
unless(defined(&SK_TXRBS1_WR_PTR)) {
    sub SK_TXRBS1_WR_PTR () {	0x0a08;}
}
unless(defined(&SK_TXRBS1_RD_PTR)) {
    sub SK_TXRBS1_RD_PTR () {	0x0a0c;}
}
unless(defined(&SK_TXRBS1_PKTCNT)) {
    sub SK_TXRBS1_PKTCNT () {	0x0a20;}
}
unless(defined(&SK_TXRBS1_LVL)) {
    sub SK_TXRBS1_LVL () {	0x0a24;}
}
unless(defined(&SK_TXRBS1_CTLTST)) {
    sub SK_TXRBS1_CTLTST () {	0x0a28;}
}
unless(defined(&SK_TXRBA1_START)) {
    sub SK_TXRBA1_START () {	0x0a80;}
}
unless(defined(&SK_TXRBA1_END)) {
    sub SK_TXRBA1_END () {	0x0a84;}
}
unless(defined(&SK_TXRBA1_WR_PTR)) {
    sub SK_TXRBA1_WR_PTR () {	0x0a88;}
}
unless(defined(&SK_TXRBA1_RD_PTR)) {
    sub SK_TXRBA1_RD_PTR () {	0x0a8c;}
}
unless(defined(&SK_TXRBA1_PKTCNT)) {
    sub SK_TXRBA1_PKTCNT () {	0x0aa0;}
}
unless(defined(&SK_TXRBA1_LVL)) {
    sub SK_TXRBA1_LVL () {	0x0aa4;}
}
unless(defined(&SK_TXRBA1_CTLTST)) {
    sub SK_TXRBA1_CTLTST () {	0x0aa8;}
}
unless(defined(&SK_TXRBS2_START)) {
    sub SK_TXRBS2_START () {	0x0b00;}
}
unless(defined(&SK_TXRBS2_END)) {
    sub SK_TXRBS2_END () {	0x0b04;}
}
unless(defined(&SK_TXRBS2_WR_PTR)) {
    sub SK_TXRBS2_WR_PTR () {	0x0b08;}
}
unless(defined(&SK_TXRBS2_RD_PTR)) {
    sub SK_TXRBS2_RD_PTR () {	0x0b0c;}
}
unless(defined(&SK_TXRBS2_PKTCNT)) {
    sub SK_TXRBS2_PKTCNT () {	0x0b20;}
}
unless(defined(&SK_TXRBS2_LVL)) {
    sub SK_TXRBS2_LVL () {	0x0b24;}
}
unless(defined(&SK_TXRBS2_CTLTST)) {
    sub SK_TXRBS2_CTLTST () {	0x0b28;}
}
unless(defined(&SK_TXRBA2_START)) {
    sub SK_TXRBA2_START () {	0x0b80;}
}
unless(defined(&SK_TXRBA2_END)) {
    sub SK_TXRBA2_END () {	0x0b84;}
}
unless(defined(&SK_TXRBA2_WR_PTR)) {
    sub SK_TXRBA2_WR_PTR () {	0x0b88;}
}
unless(defined(&SK_TXRBA2_RD_PTR)) {
    sub SK_TXRBA2_RD_PTR () {	0x0b8c;}
}
unless(defined(&SK_TXRBA2_PKTCNT)) {
    sub SK_TXRBA2_PKTCNT () {	0x0ba0;}
}
unless(defined(&SK_TXRBA2_LVL)) {
    sub SK_TXRBA2_LVL () {	0x0ba4;}
}
unless(defined(&SK_TXRBA2_CTLTST)) {
    sub SK_TXRBA2_CTLTST () {	0x0ba8;}
}
unless(defined(&SK_RBCTL_RESET)) {
    sub SK_RBCTL_RESET () {	0x00000001;}
}
unless(defined(&SK_RBCTL_UNRESET)) {
    sub SK_RBCTL_UNRESET () {	0x00000002;}
}
unless(defined(&SK_RBCTL_OFF)) {
    sub SK_RBCTL_OFF () {	0x00000004;}
}
unless(defined(&SK_RBCTL_ON)) {
    sub SK_RBCTL_ON () {	0x00000008;}
}
unless(defined(&SK_RBCTL_STORENFWD_OFF)) {
    sub SK_RBCTL_STORENFWD_OFF () {	0x00000010;}
}
unless(defined(&SK_RBCTL_STORENFWD_ON)) {
    sub SK_RBCTL_STORENFWD_ON () {	0x00000020;}
}
unless(defined(&SK_RXF1_END)) {
    sub SK_RXF1_END () {	0x0c00;}
}
unless(defined(&SK_RXF1_WPTR)) {
    sub SK_RXF1_WPTR () {	0x0c04;}
}
unless(defined(&SK_RXF1_RPTR)) {
    sub SK_RXF1_RPTR () {	0x0c0c;}
}
unless(defined(&SK_RXF1_PKTCNT)) {
    sub SK_RXF1_PKTCNT () {	0x0c10;}
}
unless(defined(&SK_RXF1_LVL)) {
    sub SK_RXF1_LVL () {	0x0c14;}
}
unless(defined(&SK_RXF1_MACCTL)) {
    sub SK_RXF1_MACCTL () {	0x0c18;}
}
unless(defined(&SK_RXF1_CTL)) {
    sub SK_RXF1_CTL () {	0x0c1c;}
}
unless(defined(&SK_RXLED1_CNTINIT)) {
    sub SK_RXLED1_CNTINIT () {	0x0c20;}
}
unless(defined(&SK_RXLED1_COUNTER)) {
    sub SK_RXLED1_COUNTER () {	0x0c24;}
}
unless(defined(&SK_RXLED1_CTL)) {
    sub SK_RXLED1_CTL () {	0x0c28;}
}
unless(defined(&SK_RXLED1_TST)) {
    sub SK_RXLED1_TST () {	0x0c29;}
}
unless(defined(&SK_LINK_SYNC1_CINIT)) {
    sub SK_LINK_SYNC1_CINIT () {	0x0c30;}
}
unless(defined(&SK_LINK_SYNC1_COUNTER)) {
    sub SK_LINK_SYNC1_COUNTER () {	0x0c34;}
}
unless(defined(&SK_LINK_SYNC1_CTL)) {
    sub SK_LINK_SYNC1_CTL () {	0x0c38;}
}
unless(defined(&SK_LINK_SYNC1_TST)) {
    sub SK_LINK_SYNC1_TST () {	0x0c39;}
}
unless(defined(&SK_LINKLED1_CTL)) {
    sub SK_LINKLED1_CTL () {	0x0c3c;}
}
unless(defined(&SK_FIFO_END)) {
    sub SK_FIFO_END () {	0x3f;}
}
unless(defined(&SK_RXF2_END)) {
    sub SK_RXF2_END () {	0x0c80;}
}
unless(defined(&SK_RXF2_WPTR)) {
    sub SK_RXF2_WPTR () {	0x0c84;}
}
unless(defined(&SK_RXF2_RPTR)) {
    sub SK_RXF2_RPTR () {	0x0c8c;}
}
unless(defined(&SK_RXF2_PKTCNT)) {
    sub SK_RXF2_PKTCNT () {	0x0c90;}
}
unless(defined(&SK_RXF2_LVL)) {
    sub SK_RXF2_LVL () {	0x0c94;}
}
unless(defined(&SK_RXF2_MACCTL)) {
    sub SK_RXF2_MACCTL () {	0x0c98;}
}
unless(defined(&SK_RXF2_CTL)) {
    sub SK_RXF2_CTL () {	0x0c9c;}
}
unless(defined(&SK_RXLED2_CNTINIT)) {
    sub SK_RXLED2_CNTINIT () {	0x0ca0;}
}
unless(defined(&SK_RXLED2_COUNTER)) {
    sub SK_RXLED2_COUNTER () {	0x0ca4;}
}
unless(defined(&SK_RXLED2_CTL)) {
    sub SK_RXLED2_CTL () {	0x0ca8;}
}
unless(defined(&SK_RXLED2_TST)) {
    sub SK_RXLED2_TST () {	0x0ca9;}
}
unless(defined(&SK_LINK_SYNC2_CINIT)) {
    sub SK_LINK_SYNC2_CINIT () {	0x0cb0;}
}
unless(defined(&SK_LINK_SYNC2_COUNTER)) {
    sub SK_LINK_SYNC2_COUNTER () {	0x0cb4;}
}
unless(defined(&SK_LINK_SYNC2_CTL)) {
    sub SK_LINK_SYNC2_CTL () {	0x0cb8;}
}
unless(defined(&SK_LINK_SYNC2_TST)) {
    sub SK_LINK_SYNC2_TST () {	0x0cb9;}
}
unless(defined(&SK_LINKLED2_CTL)) {
    sub SK_LINKLED2_CTL () {	0x0cbc;}
}
unless(defined(&SK_RXMACCTL_CLR_IRQ_NOSTS)) {
    sub SK_RXMACCTL_CLR_IRQ_NOSTS () {	0x00000001;}
}
unless(defined(&SK_RXMACCTL_CLR_IRQ_NOTSTAMP)) {
    sub SK_RXMACCTL_CLR_IRQ_NOTSTAMP () {	0x00000002;}
}
unless(defined(&SK_RXMACCTL_TSTAMP_OFF)) {
    sub SK_RXMACCTL_TSTAMP_OFF () {	0x00000004;}
}
unless(defined(&SK_RXMACCTL_RSTAMP_ON)) {
    sub SK_RXMACCTL_RSTAMP_ON () {	0x00000008;}
}
unless(defined(&SK_RXMACCTL_FLUSH_OFF)) {
    sub SK_RXMACCTL_FLUSH_OFF () {	0x00000010;}
}
unless(defined(&SK_RXMACCTL_FLUSH_ON)) {
    sub SK_RXMACCTL_FLUSH_ON () {	0x00000020;}
}
unless(defined(&SK_RXMACCTL_PAUSE_OFF)) {
    sub SK_RXMACCTL_PAUSE_OFF () {	0x00000040;}
}
unless(defined(&SK_RXMACCTL_PAUSE_ON)) {
    sub SK_RXMACCTL_PAUSE_ON () {	0x00000080;}
}
unless(defined(&SK_RXMACCTL_AFULL_OFF)) {
    sub SK_RXMACCTL_AFULL_OFF () {	0x00000100;}
}
unless(defined(&SK_RXMACCTL_AFULL_ON)) {
    sub SK_RXMACCTL_AFULL_ON () {	0x00000200;}
}
unless(defined(&SK_RXMACCTL_VALIDTIME_PATCH_OFF)) {
    sub SK_RXMACCTL_VALIDTIME_PATCH_OFF () {	0x00000400;}
}
unless(defined(&SK_RXMACCTL_VALIDTIME_PATCH_ON)) {
    sub SK_RXMACCTL_VALIDTIME_PATCH_ON () {	0x00000800;}
}
unless(defined(&SK_RXMACCTL_RXRDY_PATCH_OFF)) {
    sub SK_RXMACCTL_RXRDY_PATCH_OFF () {	0x00001000;}
}
unless(defined(&SK_RXMACCTL_RXRDY_PATCH_ON)) {
    sub SK_RXMACCTL_RXRDY_PATCH_ON () {	0x00002000;}
}
unless(defined(&SK_RXMACCTL_STS_TIMEO)) {
    sub SK_RXMACCTL_STS_TIMEO () {	0x00ff0000;}
}
unless(defined(&SK_RXMACCTL_TSTAMP_TIMEO)) {
    sub SK_RXMACCTL_TSTAMP_TIMEO () {	0xff000000;}
}
unless(defined(&SK_RXLEDCTL_ENABLE)) {
    sub SK_RXLEDCTL_ENABLE () {	0x0001;}
}
unless(defined(&SK_RXLEDCTL_COUNTER_STOP)) {
    sub SK_RXLEDCTL_COUNTER_STOP () {	0x0002;}
}
unless(defined(&SK_RXLEDCTL_COUNTER_START)) {
    sub SK_RXLEDCTL_COUNTER_START () {	0x0004;}
}
unless(defined(&SK_LINKLED_OFF)) {
    sub SK_LINKLED_OFF () {	0x0001;}
}
unless(defined(&SK_LINKLED_ON)) {
    sub SK_LINKLED_ON () {	0x0002;}
}
unless(defined(&SK_LINKLED_LINKSYNC_OFF)) {
    sub SK_LINKLED_LINKSYNC_OFF () {	0x0004;}
}
unless(defined(&SK_LINKLED_LINKSYNC_ON)) {
    sub SK_LINKLED_LINKSYNC_ON () {	0x0008;}
}
unless(defined(&SK_LINKLED_BLINK_OFF)) {
    sub SK_LINKLED_BLINK_OFF () {	0x0010;}
}
unless(defined(&SK_LINKLED_BLINK_ON)) {
    sub SK_LINKLED_BLINK_ON () {	0x0020;}
}
unless(defined(&SK_TXF1_END)) {
    sub SK_TXF1_END () {	0x0d00;}
}
unless(defined(&SK_TXF1_WPTR)) {
    sub SK_TXF1_WPTR () {	0x0d04;}
}
unless(defined(&SK_TXF1_RPTR)) {
    sub SK_TXF1_RPTR () {	0x0d0c;}
}
unless(defined(&SK_TXF1_PKTCNT)) {
    sub SK_TXF1_PKTCNT () {	0x0d10;}
}
unless(defined(&SK_TXF1_LVL)) {
    sub SK_TXF1_LVL () {	0x0d14;}
}
unless(defined(&SK_TXF1_MACCTL)) {
    sub SK_TXF1_MACCTL () {	0x0d18;}
}
unless(defined(&SK_TXF1_CTL)) {
    sub SK_TXF1_CTL () {	0x0d1c;}
}
unless(defined(&SK_TXLED1_CNTINIT)) {
    sub SK_TXLED1_CNTINIT () {	0x0d20;}
}
unless(defined(&SK_TXLED1_COUNTER)) {
    sub SK_TXLED1_COUNTER () {	0x0d24;}
}
unless(defined(&SK_TXLED1_CTL)) {
    sub SK_TXLED1_CTL () {	0x0d28;}
}
unless(defined(&SK_TXLED1_TST)) {
    sub SK_TXLED1_TST () {	0x0d29;}
}
unless(defined(&SK_TXF2_END)) {
    sub SK_TXF2_END () {	0x0d80;}
}
unless(defined(&SK_TXF2_WPTR)) {
    sub SK_TXF2_WPTR () {	0x0d84;}
}
unless(defined(&SK_TXF2_RPTR)) {
    sub SK_TXF2_RPTR () {	0x0d8c;}
}
unless(defined(&SK_TXF2_PKTCNT)) {
    sub SK_TXF2_PKTCNT () {	0x0d90;}
}
unless(defined(&SK_TXF2_LVL)) {
    sub SK_TXF2_LVL () {	0x0d94;}
}
unless(defined(&SK_TXF2_MACCTL)) {
    sub SK_TXF2_MACCTL () {	0x0d98;}
}
unless(defined(&SK_TXF2_CTL)) {
    sub SK_TXF2_CTL () {	0x0d9c;}
}
unless(defined(&SK_TXLED2_CNTINIT)) {
    sub SK_TXLED2_CNTINIT () {	0x0da0;}
}
unless(defined(&SK_TXLED2_COUNTER)) {
    sub SK_TXLED2_COUNTER () {	0x0da4;}
}
unless(defined(&SK_TXLED2_CTL)) {
    sub SK_TXLED2_CTL () {	0x0da8;}
}
unless(defined(&SK_TXLED2_TST)) {
    sub SK_TXLED2_TST () {	0x0da9;}
}
unless(defined(&SK_TXMACCTL_XMAC_RESET)) {
    sub SK_TXMACCTL_XMAC_RESET () {	0x00000001;}
}
unless(defined(&SK_TXMACCTL_XMAC_UNRESET)) {
    sub SK_TXMACCTL_XMAC_UNRESET () {	0x00000002;}
}
unless(defined(&SK_TXMACCTL_LOOP_OFF)) {
    sub SK_TXMACCTL_LOOP_OFF () {	0x00000004;}
}
unless(defined(&SK_TXMACCTL_LOOP_ON)) {
    sub SK_TXMACCTL_LOOP_ON () {	0x00000008;}
}
unless(defined(&SK_TXMACCTL_FLUSH_OFF)) {
    sub SK_TXMACCTL_FLUSH_OFF () {	0x00000010;}
}
unless(defined(&SK_TXMACCTL_FLUSH_ON)) {
    sub SK_TXMACCTL_FLUSH_ON () {	0x00000020;}
}
unless(defined(&SK_TXMACCTL_WAITEMPTY_OFF)) {
    sub SK_TXMACCTL_WAITEMPTY_OFF () {	0x00000040;}
}
unless(defined(&SK_TXMACCTL_WAITEMPTY_ON)) {
    sub SK_TXMACCTL_WAITEMPTY_ON () {	0x00000080;}
}
unless(defined(&SK_TXMACCTL_AFULL_OFF)) {
    sub SK_TXMACCTL_AFULL_OFF () {	0x00000100;}
}
unless(defined(&SK_TXMACCTL_AFULL_ON)) {
    sub SK_TXMACCTL_AFULL_ON () {	0x00000200;}
}
unless(defined(&SK_TXMACCTL_TXRDY_PATCH_OFF)) {
    sub SK_TXMACCTL_TXRDY_PATCH_OFF () {	0x00000400;}
}
unless(defined(&SK_TXMACCTL_RXRDY_PATCH_ON)) {
    sub SK_TXMACCTL_RXRDY_PATCH_ON () {	0x00000800;}
}
unless(defined(&SK_TXMACCTL_PKT_RECOVERY_OFF)) {
    sub SK_TXMACCTL_PKT_RECOVERY_OFF () {	0x00001000;}
}
unless(defined(&SK_TXMACCTL_PKT_RECOVERY_ON)) {
    sub SK_TXMACCTL_PKT_RECOVERY_ON () {	0x00002000;}
}
unless(defined(&SK_TXMACCTL_CLR_IRQ_PERR)) {
    sub SK_TXMACCTL_CLR_IRQ_PERR () {	0x00008000;}
}
unless(defined(&SK_TXMACCTL_WAITAFTERFLUSH)) {
    sub SK_TXMACCTL_WAITAFTERFLUSH () {	0x00010000;}
}
unless(defined(&SK_TXLEDCTL_ENABLE)) {
    sub SK_TXLEDCTL_ENABLE () {	0x0001;}
}
unless(defined(&SK_TXLEDCTL_COUNTER_STOP)) {
    sub SK_TXLEDCTL_COUNTER_STOP () {	0x0002;}
}
unless(defined(&SK_TXLEDCTL_COUNTER_START)) {
    sub SK_TXLEDCTL_COUNTER_START () {	0x0004;}
}
unless(defined(&SK_FIFO_RESET)) {
    sub SK_FIFO_RESET () {	0x00000001;}
}
unless(defined(&SK_FIFO_UNRESET)) {
    sub SK_FIFO_UNRESET () {	0x00000002;}
}
unless(defined(&SK_FIFO_OFF)) {
    sub SK_FIFO_OFF () {	0x00000004;}
}
unless(defined(&SK_FIFO_ON)) {
    sub SK_FIFO_ON () {	0x00000008;}
}
unless(defined(&SK_XMAC1_BASE)) {
    sub SK_XMAC1_BASE () {	0x2000;}
}
unless(defined(&SK_XMAC1_END)) {
    sub SK_XMAC1_END () {	0x23ff;}
}
unless(defined(&SK_XMAC2_BASE)) {
    sub SK_XMAC2_BASE () {	0x3000;}
}
unless(defined(&SK_XMAC2_END)) {
    sub SK_XMAC2_END () {	0x33ff;}
}
unless(defined(&SK_XMAC_REG)) {
    sub SK_XMAC_REG {
	local($reg, $mac) = @_;
	eval q(((($reg) * 2) +  &SK_XMAC1_BASE + ($mac * ( &SK_XMAC2_BASE -  &SK_XMAC1_BASE))));
    }
}
unless(defined(&SK_XM_READ_4)) {
    sub SK_XM_READ_4 {
	local($sc, $reg) = @_;
	eval q(( &sk_win_read_2( ($sc->{sk_softc}),  &SK_XMAC_REG($reg,  ($sc->{sk_port}))) & 0xffff) | (( &sk_win_read_2( ($sc->{sk_softc}),  &SK_XMAC_REG($reg + 2,  ($sc->{sk_port}))) << 16) & 0xffff0000));
    }
}
unless(defined(&SK_XM_WRITE_4)) {
    sub SK_XM_WRITE_4 {
	local($sc, $reg, $val) = @_;
	eval q( &sk_win_write_2( ($sc->{sk_softc}),  &SK_XMAC_REG($reg,  ($sc->{sk_port})), (($val) & 0xffff));  &sk_win_write_2( ($sc->{sk_softc}),  &SK_XMAC_REG($reg + 2,  ($sc->{sk_port})), (($val) >> 16) & 0xffff););
    }
}
unless(defined(&SK_XM_READ_2)) {
    sub SK_XM_READ_2 {
	local($sc, $reg) = @_;
	eval q( &sk_win_read_2( ($sc->{sk_softc}),  &SK_XMAC_REG($reg,  ($sc->{sk_port}))));
    }
}
unless(defined(&SK_XM_WRITE_2)) {
    sub SK_XM_WRITE_2 {
	local($sc, $reg, $val) = @_;
	eval q( &sk_win_write_2( ($sc->{sk_softc}),  &SK_XMAC_REG($reg,  ($sc->{sk_port})), $val));
    }
}
unless(defined(&SK_XM_SETBIT_4)) {
    sub SK_XM_SETBIT_4 {
	local($sc, $reg, $x) = @_;
	eval q( &SK_XM_WRITE_4($sc, $reg, ( &SK_XM_READ_4($sc, $reg)) | ($x)));
    }
}
unless(defined(&SK_XM_CLRBIT_4)) {
    sub SK_XM_CLRBIT_4 {
	local($sc, $reg, $x) = @_;
	eval q( &SK_XM_WRITE_4($sc, $reg, ( &SK_XM_READ_4($sc, $reg)) & ~($x)));
    }
}
unless(defined(&SK_XM_SETBIT_2)) {
    sub SK_XM_SETBIT_2 {
	local($sc, $reg, $x) = @_;
	eval q( &SK_XM_WRITE_2($sc, $reg, ( &SK_XM_READ_2($sc, $reg)) | ($x)));
    }
}
unless(defined(&SK_XM_CLRBIT_2)) {
    sub SK_XM_CLRBIT_2 {
	local($sc, $reg, $x) = @_;
	eval q( &SK_XM_WRITE_2($sc, $reg, ( &SK_XM_READ_2($sc, $reg)) & ~($x)));
    }
}
unless(defined(&SK_XM_TX_FIFOTHRESH)) {
    sub SK_XM_TX_FIFOTHRESH () {	512;}
}
unless(defined(&SK_PCI_VENDOR_ID)) {
    sub SK_PCI_VENDOR_ID () {	0x0000;}
}
unless(defined(&SK_PCI_DEVICE_ID)) {
    sub SK_PCI_DEVICE_ID () {	0x0002;}
}
unless(defined(&SK_PCI_COMMAND)) {
    sub SK_PCI_COMMAND () {	0x0004;}
}
unless(defined(&SK_PCI_STATUS)) {
    sub SK_PCI_STATUS () {	0x0006;}
}
unless(defined(&SK_PCI_REVID)) {
    sub SK_PCI_REVID () {	0x0008;}
}
unless(defined(&SK_PCI_CLASSCODE)) {
    sub SK_PCI_CLASSCODE () {	0x0009;}
}
unless(defined(&SK_PCI_CACHELEN)) {
    sub SK_PCI_CACHELEN () {	0x000c;}
}
unless(defined(&SK_PCI_LATENCY_TIMER)) {
    sub SK_PCI_LATENCY_TIMER () {	0x000d;}
}
unless(defined(&SK_PCI_HEADER_TYPE)) {
    sub SK_PCI_HEADER_TYPE () {	0x000e;}
}
unless(defined(&SK_PCI_LOMEM)) {
    sub SK_PCI_LOMEM () {	0x0010;}
}
unless(defined(&SK_PCI_LOIO)) {
    sub SK_PCI_LOIO () {	0x0014;}
}
unless(defined(&SK_PCI_SUBVEN_ID)) {
    sub SK_PCI_SUBVEN_ID () {	0x002c;}
}
unless(defined(&SK_PCI_SYBSYS_ID)) {
    sub SK_PCI_SYBSYS_ID () {	0x002e;}
}
unless(defined(&SK_PCI_BIOSROM)) {
    sub SK_PCI_BIOSROM () {	0x0030;}
}
unless(defined(&SK_PCI_INTLINE)) {
    sub SK_PCI_INTLINE () {	0x003c;}
}
unless(defined(&SK_PCI_INTPIN)) {
    sub SK_PCI_INTPIN () {	0x003d;}
}
unless(defined(&SK_PCI_MINGNT)) {
    sub SK_PCI_MINGNT () {	0x003e;}
}
unless(defined(&SK_PCI_MINLAT)) {
    sub SK_PCI_MINLAT () {	0x003f;}
}
unless(defined(&SK_PCI_OURREG1)) {
    sub SK_PCI_OURREG1 () {	0x0040;}
}
unless(defined(&SK_PCI_OURREG2)) {
    sub SK_PCI_OURREG2 () {	0x0044;}
}
unless(defined(&SK_PCI_CAPID)) {
    sub SK_PCI_CAPID () {	0x0048;}
}
unless(defined(&SK_PCI_NEXTPTR)) {
    sub SK_PCI_NEXTPTR () {	0x0049;}
}
unless(defined(&SK_PCI_PWRMGMTCAP)) {
    sub SK_PCI_PWRMGMTCAP () {	0x004a;}
}
unless(defined(&SK_PCI_PWRMGMTCTRL)) {
    sub SK_PCI_PWRMGMTCTRL () {	0x004c;}
}
unless(defined(&SK_PCI_PME_EVENT)) {
    sub SK_PCI_PME_EVENT () {	0x004f;}
}
unless(defined(&SK_PCI_VPD_CAPID)) {
    sub SK_PCI_VPD_CAPID () {	0x0050;}
}
unless(defined(&SK_PCI_VPD_NEXTPTR)) {
    sub SK_PCI_VPD_NEXTPTR () {	0x0051;}
}
unless(defined(&SK_PCI_VPD_ADDR)) {
    sub SK_PCI_VPD_ADDR () {	0x0052;}
}
unless(defined(&SK_PCI_VPD_DATA)) {
    sub SK_PCI_VPD_DATA () {	0x0054;}
}
unless(defined(&SK_PSTATE_MASK)) {
    sub SK_PSTATE_MASK () {	0x0003;}
}
unless(defined(&SK_PSTATE_D0)) {
    sub SK_PSTATE_D0 () {	0x0000;}
}
unless(defined(&SK_PSTATE_D1)) {
    sub SK_PSTATE_D1 () {	0x0001;}
}
unless(defined(&SK_PSTATE_D2)) {
    sub SK_PSTATE_D2 () {	0x0002;}
}
unless(defined(&SK_PSTATE_D3)) {
    sub SK_PSTATE_D3 () {	0x0003;}
}
unless(defined(&SK_PME_EN)) {
    sub SK_PME_EN () {	0x0010;}
}
unless(defined(&SK_PME_STATUS)) {
    sub SK_PME_STATUS () {	0x8000;}
}
unless(defined(&SK_VPD_FLAG)) {
    sub SK_VPD_FLAG () {	0x8000;}
}
unless(defined(&VPD_RES_ID)) {
    sub VPD_RES_ID () {	0x82;}
}
unless(defined(&VPD_RES_READ)) {
    sub VPD_RES_READ () {	0x90;}
}
unless(defined(&VPD_RES_WRITE)) {
    sub VPD_RES_WRITE () {	0x81;}
}
unless(defined(&VPD_RES_END)) {
    sub VPD_RES_END () {	0x78;}
}
unless(defined(&CSR_WRITE_4)) {
    sub CSR_WRITE_4 {
	local($sc, $reg, $val) = @_;
	eval q( &bus_space_write_4( ($sc->{sk_btag}),  ($sc->{sk_bhandle}), $reg, $val));
    }
}
unless(defined(&CSR_WRITE_2)) {
    sub CSR_WRITE_2 {
	local($sc, $reg, $val) = @_;
	eval q( &bus_space_write_2( ($sc->{sk_btag}),  ($sc->{sk_bhandle}), $reg, $val));
    }
}
unless(defined(&CSR_WRITE_1)) {
    sub CSR_WRITE_1 {
	local($sc, $reg, $val) = @_;
	eval q( &bus_space_write_1( ($sc->{sk_btag}),  ($sc->{sk_bhandle}), $reg, $val));
    }
}
unless(defined(&CSR_READ_4)) {
    sub CSR_READ_4 {
	local($sc, $reg) = @_;
	eval q( &bus_space_read_4( ($sc->{sk_btag}),  ($sc->{sk_bhandle}), $reg));
    }
}
unless(defined(&CSR_READ_2)) {
    sub CSR_READ_2 {
	local($sc, $reg) = @_;
	eval q( &bus_space_read_2( ($sc->{sk_btag}),  ($sc->{sk_bhandle}), $reg));
    }
}
unless(defined(&CSR_READ_1)) {
    sub CSR_READ_1 {
	local($sc, $reg) = @_;
	eval q( &bus_space_read_1( ($sc->{sk_btag}),  ($sc->{sk_bhandle}), $reg));
    }
}
unless(defined(&SK_OPCODE_DEFAULT)) {
    sub SK_OPCODE_DEFAULT () {	0x00550000;}
}
unless(defined(&SK_OPCODE_CSUM)) {
    sub SK_OPCODE_CSUM () {	0x00560000;}
}
unless(defined(&SK_RXCTL_LEN)) {
    sub SK_RXCTL_LEN () {	0x0000ffff;}
}
unless(defined(&SK_RXCTL_OPCODE)) {
    sub SK_RXCTL_OPCODE () {	0x00ff0000;}
}
unless(defined(&SK_RXCTL_TSTAMP_VALID)) {
    sub SK_RXCTL_TSTAMP_VALID () {	0x01000000;}
}
unless(defined(&SK_RXCTL_STATUS_VALID)) {
    sub SK_RXCTL_STATUS_VALID () {	0x02000000;}
}
unless(defined(&SK_RXCTL_DEV0)) {
    sub SK_RXCTL_DEV0 () {	0x04000000;}
}
unless(defined(&SK_RXCTL_EOF_INTR)) {
    sub SK_RXCTL_EOF_INTR () {	0x08000000;}
}
unless(defined(&SK_RXCTL_EOB_INTR)) {
    sub SK_RXCTL_EOB_INTR () {	0x10000000;}
}
unless(defined(&SK_RXCTL_LASTFRAG)) {
    sub SK_RXCTL_LASTFRAG () {	0x20000000;}
}
unless(defined(&SK_RXCTL_FIRSTFRAG)) {
    sub SK_RXCTL_FIRSTFRAG () {	0x40000000;}
}
unless(defined(&SK_RXCTL_OWN)) {
    sub SK_RXCTL_OWN () {	0x80000000;}
}
unless(defined(&SK_RXSTAT)) {
    sub SK_RXSTAT () {	( &SK_OPCODE_DEFAULT| &SK_RXCTL_EOF_INTR| &SK_RXCTL_LASTFRAG|  &SK_RXCTL_FIRSTFRAG| &SK_RXCTL_OWN);}
}
unless(defined(&SK_TXCTL_LEN)) {
    sub SK_TXCTL_LEN () {	0x0000ffff;}
}
unless(defined(&SK_TXCTL_OPCODE)) {
    sub SK_TXCTL_OPCODE () {	0x00ff0000;}
}
unless(defined(&SK_TXCTL_SW)) {
    sub SK_TXCTL_SW () {	0x01000000;}
}
unless(defined(&SK_TXCTL_NOCRC)) {
    sub SK_TXCTL_NOCRC () {	0x02000000;}
}
unless(defined(&SK_TXCTL_STORENFWD)) {
    sub SK_TXCTL_STORENFWD () {	0x04000000;}
}
unless(defined(&SK_TXCTL_EOF_INTR)) {
    sub SK_TXCTL_EOF_INTR () {	0x08000000;}
}
unless(defined(&SK_TXCTL_EOB_INTR)) {
    sub SK_TXCTL_EOB_INTR () {	0x10000000;}
}
unless(defined(&SK_TXCTL_LASTFRAG)) {
    sub SK_TXCTL_LASTFRAG () {	0x20000000;}
}
unless(defined(&SK_TXCTL_FIRSTFRAG)) {
    sub SK_TXCTL_FIRSTFRAG () {	0x40000000;}
}
unless(defined(&SK_TXCTL_OWN)) {
    sub SK_TXCTL_OWN () {	0x80000000;}
}
unless(defined(&SK_TXSTAT)) {
    sub SK_TXSTAT () {	( &SK_OPCODE_DEFAULT| &SK_TXCTL_EOF_INTR| &SK_TXCTL_LASTFRAG| &SK_TXCTL_OWN);}
}
unless(defined(&SK_RXBYTES)) {
    sub SK_RXBYTES {
	local($x) = @_;
	eval q(($x) & 0x0000ffff;);
    }
}
unless(defined(&SK_TXBYTES)) {
    sub SK_TXBYTES () {	 &SK_RXBYTES;}
}
unless(defined(&SK_TX_RING_CNT)) {
    sub SK_TX_RING_CNT () {	512;}
}
unless(defined(&SK_RX_RING_CNT)) {
    sub SK_RX_RING_CNT () {	256;}
}
unless(defined(&SK_JUMBO_FRAMELEN)) {
    sub SK_JUMBO_FRAMELEN () {	9018;}
}
unless(defined(&SK_JUMBO_MTU)) {
    sub SK_JUMBO_MTU () {	( &SK_JUMBO_FRAMELEN- &ETHER_HDR_LEN- &ETHER_CRC_LEN);}
}
unless(defined(&SK_JSLOTS)) {
    sub SK_JSLOTS () {	384;}
}
unless(defined(&SK_JRAWLEN)) {
    sub SK_JRAWLEN () {	( &SK_JUMBO_FRAMELEN +  &ETHER_ALIGN);}
}
unless(defined(&SK_JLEN)) {
    sub SK_JLEN () {	 &SK_JRAWLEN;}
}
unless(defined(&SK_MCLBYTES)) {
    sub SK_MCLBYTES () {	 &SK_JLEN;}
}
unless(defined(&SK_JPAGESZ)) {
    sub SK_JPAGESZ () {	 &PAGE_SIZE;}
}
unless(defined(&SK_RESID)) {
    sub SK_RESID () {	( &SK_JPAGESZ - ( &SK_JLEN *  &SK_JSLOTS) %  &SK_JPAGESZ);}
}
unless(defined(&SK_JMEM)) {
    sub SK_JMEM () {	(( &SK_JLEN *  &SK_JSLOTS) +  &SK_RESID);}
}
unless(defined(&SK_INC)) {
    sub SK_INC {
	local($x, $y) = @_;
	eval q(($x) = ($x + 1) % $y);
    }
}
unless(defined(&SK_MAXUNIT)) {
    sub SK_MAXUNIT () {	256;}
}
unless(defined(&SK_TIMEOUT)) {
    sub SK_TIMEOUT () {	1000;}
}
unless(defined(&ETHER_ALIGN)) {
    sub ETHER_ALIGN () {	2;}
}
if(defined(&__alpha__)) {
    undef(&vtophys) if defined(&vtophys);
    eval 'sub vtophys {
        local($va) = @_;
	    eval q( &alpha_XXX_dmamap($va));
    }' unless defined(&vtophys);
}
unless(defined(&ETHER_CRC_LEN)) {
    eval 'sub ETHER_CRC_LEN () {4;}' unless defined(&ETHER_CRC_LEN);
}
unless(defined(&ETHER_HDR_LEN)) {
    eval 'sub ETHER_HDR_LEN () {14;}' unless defined(&ETHER_HDR_LEN);
}
1;
