require '_h2ph_pre.ph';

unless(defined(&BSD)) {
    sub BSD () {	199306;}
}
unless(defined(&BSD4_3)) {
    sub BSD4_3 () {	1;}
}
unless(defined(&BSD4_4)) {
    sub BSD4_4 () {	1;}
}
unless(defined(&OpenBSD)) {
    sub OpenBSD () {	200012;}
}
unless(defined(&OpenBSD2_8)) {
    sub OpenBSD2_8 () {	1;}
}
unless(defined(&NULL)) {
    if(defined(&__GNUG__)) {
	eval 'sub NULL () { &__null;}' unless defined(&NULL);
    } else {
	eval 'sub NULL () {0;}' unless defined(&NULL);
    }
}
unless(defined(&_LOCORE)) {
    require 'sys/types.ph';
    require 'sys/simplelock.ph';
}
require 'sys/syslimits.ph';
unless(defined(&MAXCOMLEN)) {
    sub MAXCOMLEN () {	16;}
}
unless(defined(&MAXINTERP)) {
    sub MAXINTERP () {	64;}
}
unless(defined(&MAXLOGNAME)) {
    sub MAXLOGNAME () {	12;}
}
unless(defined(&MAXUPRC)) {
    sub MAXUPRC () {	 &CHILD_MAX;}
}
unless(defined(&NCARGS)) {
    sub NCARGS () {	 &ARG_MAX;}
}
unless(defined(&NGROUPS)) {
    sub NGROUPS () {	 &NGROUPS_MAX;}
}
unless(defined(&NOFILE)) {
    sub NOFILE () {	 &OPEN_MAX;}
}
unless(defined(&NOFILE_MAX)) {
    sub NOFILE_MAX () {	1024;}
}
unless(defined(&NOGROUP)) {
    sub NOGROUP () {	65535;}
}
unless(defined(&MAXHOSTNAMELEN)) {
    sub MAXHOSTNAMELEN () {	256;}
}
if(defined(&_KERNEL)) {
    require 'sys/cdefs.ph';
    require 'sys/errno.ph';
    require 'sys/time.ph';
    require 'sys/resource.ph';
    require 'sys/ucred.ph';
    require 'sys/uio.ph';
}
require 'sys/signal.ph';
require 'machine/param.ph';
require 'machine/limits.ph';
unless(defined(&PSWP)) {
    sub PSWP () {	0;}
}
unless(defined(&PVM)) {
    sub PVM () {	4;}
}
unless(defined(&PINOD)) {
    sub PINOD () {	8;}
}
unless(defined(&PRIBIO)) {
    sub PRIBIO () {	16;}
}
unless(defined(&PVFS)) {
    sub PVFS () {	20;}
}
unless(defined(&PZERO)) {
    sub PZERO () {	22;}
}
unless(defined(&PSOCK)) {
    sub PSOCK () {	24;}
}
unless(defined(&PWAIT)) {
    sub PWAIT () {	32;}
}
unless(defined(&PLOCK)) {
    sub PLOCK () {	36;}
}
unless(defined(&PPAUSE)) {
    sub PPAUSE () {	40;}
}
unless(defined(&PUSER)) {
    sub PUSER () {	50;}
}
unless(defined(&MAXPRI)) {
    sub MAXPRI () {	127;}
}
unless(defined(&PRIMASK)) {
    sub PRIMASK () {	0x0ff;}
}
unless(defined(&PCATCH)) {
    sub PCATCH () {	0x100;}
}
unless(defined(&NBPW)) {
    sub NBPW () {	$sizeof{'int'};}
}
unless(defined(&CMASK)) {
    sub CMASK () {	022;}
}
unless(defined(&NODEV)) {
    sub NODEV () {	(-1);}
}
unless(defined(&NETDEV)) {
    sub NETDEV () {	(-2);}
}
unless(defined(&CLBYTES)) {
    sub CLBYTES () {	( &CLSIZE* &NBPG);}
}
unless(defined(&CLOFSET)) {
    sub CLOFSET () {	( &CLSIZE* &NBPG-1);}
}
unless(defined(&claligned)) {
    sub claligned {
	local($x) = @_;
	eval q((((($x)) &CLOFSET)==0));
    }
}
unless(defined(&CLOFF)) {
    sub CLOFF () {	 &CLOFSET;}
}
unless(defined(&CLSHIFT)) {
    sub CLSHIFT () {	( &PGSHIFT+ &CLSIZELOG2);}
}
if((defined(&CLSIZE) ? &CLSIZE : 0)==1) {
    eval 'sub clbase {
        local($i) = @_;
	    eval q(($i));
    }' unless defined(&clbase);
    eval 'sub clrnd {
        local($i) = @_;
	    eval q(($i));
    }' unless defined(&clrnd);
} else {
    eval 'sub clbase {
        local($i) = @_;
	    eval q((($i) &~ ( &CLSIZE-1)));
    }' unless defined(&clbase);
    eval 'sub clrnd {
        local($i) = @_;
	    eval q(((($i) + ( &CLSIZE-1)) &~ ( &CLSIZE-1)));
    }' unless defined(&clrnd);
}
unless(defined(&CBLOCK)) {
    sub CBLOCK () {	64;}
}
unless(defined(&CBQSIZE)) {
    sub CBQSIZE () {	( &CBLOCK/ &NBBY);}
}
unless(defined(&CBSIZE)) {
    sub CBSIZE () {	( &CBLOCK - $sizeof{'struct cblock' } -  &CBQSIZE);}
}
unless(defined(&CROUND)) {
    sub CROUND () {	( &CBLOCK - 1);}
}
unless(defined(&MAXBSIZE)) {
    eval 'sub MAXBSIZE () { &MAXPHYS;}' unless defined(&MAXBSIZE);
}
unless(defined(&MAXFRAG)) {
    sub MAXFRAG () {	8;}
}
unless(defined(&MAXPATHLEN)) {
    sub MAXPATHLEN () {	 &PATH_MAX;}
}
unless(defined(&MAXSYMLINKS)) {
    sub MAXSYMLINKS () {	32;}
}
unless(defined(&setbit)) {
    sub setbit {
	local($a,$i) = @_;
	eval q((($a)[($i)/ &NBBY] |= 1<<(($i)% &NBBY)));
    }
}
unless(defined(&clrbit)) {
    sub clrbit {
	local($a,$i) = @_;
	eval q((($a)[($i)/ &NBBY] &= ~(1<<(($i)% &NBBY))));
    }
}
unless(defined(&isset)) {
    sub isset {
	local($a,$i) = @_;
	eval q((($a)[($i)/ &NBBY] & (1<<(($i)% &NBBY))));
    }
}
unless(defined(&isclr)) {
    sub isclr {
	local($a,$i) = @_;
	eval q(((($a)[($i)/ &NBBY] & (1<<(($i)% &NBBY))) == 0));
    }
}
unless(defined(&howmany)) {
    eval 'sub howmany {
        local($x, $y) = @_;
	    eval q(((($x)+(($y)-1))/($y)));
    }' unless defined(&howmany);
}
unless(defined(&roundup)) {
    sub roundup {
	local($x, $y) = @_;
	eval q((((($x)+(($y)-1))/($y))*($y)));
    }
}
unless(defined(&powerof2)) {
    sub powerof2 {
	local($x) = @_;
	eval q((((($x)-1)($x))==0));
    }
}
unless(defined(&MIN)) {
    sub MIN {
	local($a,$b) = @_;
	eval q(((($a)<($b))?($a):($b)));
    }
}
unless(defined(&MAX)) {
    sub MAX {
	local($a,$b) = @_;
	eval q(((($a)>($b))?($a):($b)));
    }
}
unless(defined(&MINBUCKET)) {
    sub MINBUCKET () {	4;}
}
unless(defined(&MAXALLOCSAVE)) {
    sub MAXALLOCSAVE () {	(2*  &CLBYTES);}
}
unless(defined(&FSHIFT)) {
    sub FSHIFT () {	11;}
}
unless(defined(&FSCALE)) {
    sub FSCALE () {	(1<< &FSHIFT);}
}
unless(defined(&RFNAMEG)) {
    sub RFNAMEG () {	(1<<0);}
}
unless(defined(&RFENVG)) {
    sub RFENVG () {	(1<<1);}
}
unless(defined(&RFFDG)) {
    sub RFFDG () {	(1<<2);}
}
unless(defined(&RFNOTEG)) {
    sub RFNOTEG () {	(1<<3);}
}
unless(defined(&RFPROC)) {
    sub RFPROC () {	(1<<4);}
}
unless(defined(&RFMEM)) {
    sub RFMEM () {	(1<<5);}
}
unless(defined(&RFNOWAIT)) {
    sub RFNOWAIT () {	(1<<6);}
}
unless(defined(&RFCNAMEG)) {
    sub RFCNAMEG () {	(1<<10);}
}
unless(defined(&RFCENVG)) {
    sub RFCENVG () {	(1<<11);}
}
unless(defined(&RFCFDG)) {
    sub RFCFDG () {	(1<<12);}
}
1;
