require '_h2ph_pre.ph';

unless(defined(&NPAIDB_LINK)) {
    sub NPAIDB_LINK () {	0;}
}
unless(defined(&LLC_CLASS_I)) {
    sub LLC_CLASS_I () {	0x1;}
}
unless(defined(&LLC_CLASS_II)) {
    sub LLC_CLASS_II () {	0x3;}
}
unless(defined(&LLC_CLASS_III)) {
    sub LLC_CLASS_III () {	0x4;}
}
unless(defined(&LLC_CLASS_IV)) {
    sub LLC_CLASS_IV () {	0x7;}
}
unless(defined(&np_link)) {
    sub np_link () {	 ($NESIun->{NE}->{NE_link});}
}
unless(defined(&np_rt)) {
    sub np_rt () {	 ($NESIun->{NE}->{NE_rt});}
}
unless(defined(&si_class)) {
    sub si_class () {	 ($NESIun->{SI}->{SI_class});}
}
unless(defined(&si_window)) {
    sub si_window () {	 ($NESIun->{SI}->{SI_window});}
}
unless(defined(&si_trace)) {
    sub si_trace () {	 ($NESIun->{SI}->{SI_trace});}
}
unless(defined(&si_xchxid)) {
    sub si_xchxid () {	 ($NESIun->{SI}->{SI_xchxid});}
}
unless(defined(&si_input)) {
    sub si_input () {	 ($NESIun->{SI}->{SI_input});}
}
unless(defined(&si_ctlinput)) {
    sub si_ctlinput () {	 ($NESIun->{SI}->{SI_ctlinput});}
}
unless(defined(&NPDL_SAPNETMASK)) {
    sub NPDL_SAPNETMASK () {	0x7e;}
}
unless(defined(&i_z)) {
    sub i_z () {	0;}
}
unless(defined(&i_ns)) {
    sub i_ns () {	1;}
}
unless(defined(&i_pf)) {
    sub i_pf () {	0;}
}
unless(defined(&i_nr)) {
    sub i_nr () {	1;}
}
unless(defined(&s_oz)) {
    sub s_oz () {	2;}
}
unless(defined(&s_selector)) {
    sub s_selector () {	3;}
}
unless(defined(&s_pf)) {
    sub s_pf () {	0;}
}
unless(defined(&s_nr)) {
    sub s_nr () {	1;}
}
unless(defined(&u_bb)) {
    sub u_bb () {	2;}
}
unless(defined(&u_select_other)) {
    sub u_select_other () {	3;}
}
unless(defined(&u_pf)) {
    sub u_pf () {	4;}
}
unless(defined(&u_select)) {
    sub u_select () {	5;}
}
unless(defined(&f_vs)) {
    sub f_vs () {	1;}
}
unless(defined(&f_cr)) {
    sub f_cr () {	0;}
}
unless(defined(&f_vr)) {
    sub f_vr () {	1;}
}
unless(defined(&f_wxyzv)) {
    sub f_wxyzv () {	6;}
}
unless(defined(&LLCGBITS)) {
    sub LLCGBITS {
	local($Arg,$Index) = @_;
	eval q(((($Arg) &  ($llc_bitslice[&(Index)]->{bs_mask})) >>  ($llc_bitslice[&(Index)]->{bs_shift})));
    }
}
unless(defined(&LLCSBITS)) {
    sub LLCSBITS {
	local($Arg,$Index,$Val) = @_;
	eval q(($Arg) |= ((($Val) <<  ($llc_bitslice[&(Index)]->{bs_shift})) &  ($llc_bitslice[&(Index)]->{bs_mask})));
    }
}
unless(defined(&LLCCSBITS)) {
    sub LLCCSBITS {
	local($Arg,$Index,$Val) = @_;
	eval q(($Arg) = ((($Val) <<  ($llc_bitslice[&(Index)]->{bs_shift})) &  ($llc_bitslice[&(Index)]->{bs_mask})));
    }
}
unless(defined(&LLC_CMD)) {
    sub LLC_CMD () {	0;}
}
unless(defined(&LLC_RSP)) {
    sub LLC_RSP () {	1;}
}
unless(defined(&LLC_MAXCMDRSP)) {
    sub LLC_MAXCMDRSP () {	2;}
}
unless(defined(&LLCFT_INFO)) {
    sub LLCFT_INFO () {	0*  &LLC_MAXCMDRSP;}
}
unless(defined(&LLCFT_RR)) {
    sub LLCFT_RR () {	1*  &LLC_MAXCMDRSP;}
}
unless(defined(&LLCFT_RNR)) {
    sub LLCFT_RNR () {	2*  &LLC_MAXCMDRSP;}
}
unless(defined(&LLCFT_REJ)) {
    sub LLCFT_REJ () {	3*  &LLC_MAXCMDRSP;}
}
unless(defined(&LLCFT_DM)) {
    sub LLCFT_DM () {	4*  &LLC_MAXCMDRSP;}
}
unless(defined(&LLCFT_SABME)) {
    sub LLCFT_SABME () {	5*  &LLC_MAXCMDRSP;}
}
unless(defined(&LLCFT_DISC)) {
    sub LLCFT_DISC () {	6*  &LLC_MAXCMDRSP;}
}
unless(defined(&LLCFT_UA)) {
    sub LLCFT_UA () {	7*  &LLC_MAXCMDRSP;}
}
unless(defined(&LLCFT_FRMR)) {
    sub LLCFT_FRMR () {	8*  &LLC_MAXCMDRSP;}
}
unless(defined(&LLCFT_UI)) {
    sub LLCFT_UI () {	9*  &LLC_MAXCMDRSP;}
}
unless(defined(&LLCFT_XID)) {
    sub LLCFT_XID () {	10*  &LLC_MAXCMDRSP;}
}
unless(defined(&LLCFT_TEST)) {
    sub LLCFT_TEST () {	11*  &LLC_MAXCMDRSP;}
}
unless(defined(&LLC_ACK_TIMER_EXPIRED)) {
    sub LLC_ACK_TIMER_EXPIRED () {	12*  &LLC_MAXCMDRSP;}
}
unless(defined(&LLC_P_TIMER_EXPIRED)) {
    sub LLC_P_TIMER_EXPIRED () {	13*  &LLC_MAXCMDRSP;}
}
unless(defined(&LLC_REJ_TIMER_EXPIRED)) {
    sub LLC_REJ_TIMER_EXPIRED () {	14*  &LLC_MAXCMDRSP;}
}
unless(defined(&LLC_BUSY_TIMER_EXPIRED)) {
    sub LLC_BUSY_TIMER_EXPIRED () {	15*  &LLC_MAXCMDRSP;}
}
unless(defined(&LLC_INVALID_NR)) {
    sub LLC_INVALID_NR () {	16*  &LLC_MAXCMDRSP;}
}
unless(defined(&LLC_INVALID_NS)) {
    sub LLC_INVALID_NS () {	17*  &LLC_MAXCMDRSP;}
}
unless(defined(&LLC_BAD_PDU)) {
    sub LLC_BAD_PDU () {	18*  &LLC_MAXCMDRSP;}
}
unless(defined(&LLC_LOCAL_BUSY_DETECTED)) {
    sub LLC_LOCAL_BUSY_DETECTED () {	19*  &LLC_MAXCMDRSP;}
}
unless(defined(&LLC_LOCAL_BUSY_CLEARED)) {
    sub LLC_LOCAL_BUSY_CLEARED () {	20*  &LLC_MAXCMDRSP;}
}
unless(defined(&NL_CONNECT_REQUEST)) {
    sub NL_CONNECT_REQUEST () {	21*  &LLC_MAXCMDRSP;}
}
unless(defined(&NL_CONNECT_RESPONSE)) {
    sub NL_CONNECT_RESPONSE () {	22*  &LLC_MAXCMDRSP;}
}
unless(defined(&NL_RESET_REQUEST)) {
    sub NL_RESET_REQUEST () {	23*  &LLC_MAXCMDRSP;}
}
unless(defined(&NL_RESET_RESPONSE)) {
    sub NL_RESET_RESPONSE () {	24*  &LLC_MAXCMDRSP;}
}
unless(defined(&NL_DISCONNECT_REQUEST)) {
    sub NL_DISCONNECT_REQUEST () {	25*  &LLC_MAXCMDRSP;}
}
unless(defined(&NL_DATA_REQUEST)) {
    sub NL_DATA_REQUEST () {	26*  &LLC_MAXCMDRSP;}
}
unless(defined(&NL_INITIATE_PF_CYCLE)) {
    sub NL_INITIATE_PF_CYCLE () {	27*  &LLC_MAXCMDRSP;}
}
unless(defined(&NL_LOCAL_BUSY_DETECTED)) {
    sub NL_LOCAL_BUSY_DETECTED () {	28*  &LLC_MAXCMDRSP;}
}
unless(defined(&LLCFT_NONE)) {
    sub LLCFT_NONE () {	255;}
}
unless(defined(&LLC_CONNECT_INDICATION)) {
    sub LLC_CONNECT_INDICATION () {	1;}
}
unless(defined(&LLC_CONNECT_CONFIRM)) {
    sub LLC_CONNECT_CONFIRM () {	2;}
}
unless(defined(&LLC_DISCONNECT_INDICATION)) {
    sub LLC_DISCONNECT_INDICATION () {	3;}
}
unless(defined(&LLC_RESET_CONFIRM)) {
    sub LLC_RESET_CONFIRM () {	4;}
}
unless(defined(&LLC_RESET_INDICATION_REMOTE)) {
    sub LLC_RESET_INDICATION_REMOTE () {	5;}
}
unless(defined(&LLC_RESET_INDICATION_LOCAL)) {
    sub LLC_RESET_INDICATION_LOCAL () {	6;}
}
unless(defined(&LLC_FRMR_RECEIVED)) {
    sub LLC_FRMR_RECEIVED () {	7;}
}
unless(defined(&LLC_FRMR_SENT)) {
    sub LLC_FRMR_SENT () {	8;}
}
unless(defined(&LLC_DATA_INDICATION)) {
    sub LLC_DATA_INDICATION () {	9;}
}
unless(defined(&LLC_REMOTE_NOT_BUSY)) {
    sub LLC_REMOTE_NOT_BUSY () {	10;}
}
unless(defined(&LLC_REMOTE_BUSY)) {
    sub LLC_REMOTE_BUSY () {	11;}
}
unless(defined(&LLC_PASSITON)) {
    sub LLC_PASSITON () {	255;}
}
unless(defined(&INFORMATION_CONTROL)) {
    sub INFORMATION_CONTROL () {	0x00;}
}
unless(defined(&SUPERVISORY_CONTROL)) {
    sub SUPERVISORY_CONTROL () {	0x02;}
}
unless(defined(&UNUMBERED_CONTROL)) {
    sub UNUMBERED_CONTROL () {	0x03;}
}
unless(defined(&LLC_MAX_SEQUENCE)) {
    sub LLC_MAX_SEQUENCE () {	128;}
}
unless(defined(&LLC_MAX_WINDOW)) {
    sub LLC_MAX_WINDOW () {	127;}
}
unless(defined(&LLC_WINDOW_SIZE)) {
    sub LLC_WINDOW_SIZE () {	7;}
}
unless(defined(&NLHDRSIZEGUESS)) {
    sub NLHDRSIZEGUESS () {	3;}
}
unless(defined(&llcl_frmr_pdu0)) {
    sub llcl_frmr_pdu0 () {	 ($llcl_frmrinfo->{rej_pdu_0});}
}
unless(defined(&llcl_frmr_pdu1)) {
    sub llcl_frmr_pdu1 () {	 ($llcl_frmrinfo->{rej_pdu_1});}
}
unless(defined(&llcl_frmr_control)) {
    sub llcl_frmr_control () {	 ($llcl_frmrinfo->{frmr_control});}
}
unless(defined(&llcl_frmr_control_ext)) {
    sub llcl_frmr_control_ext () {	 ($llcl_frmrinfo->{frmr_control_ext});}
}
unless(defined(&llcl_frmr_cause)) {
    sub llcl_frmr_cause () {	 ($llcl_frmrinfo->{frmr_cause});}
}
unless(defined(&LQNEXT)) {
    sub LQNEXT {
	local($l) = @_;
	eval q((($l)-> ($llcl_q->{q_forw})));
    }
}
unless(defined(&LQEMPTY)) {
    sub LQEMPTY () {	( ($llccb_q->{q_forw}) ==  &llccb_q);}
}
unless(defined(&LQFIRST)) {
    sub LQFIRST () {	( ($llccb_q->{q_forw}));}
}
unless(defined(&LQVALID)) {
    sub LQVALID {
	local($l) = @_;
	eval q((!(($l) ==  &llccb_q)));
    }
}
unless(defined(&LLC_ENQUEUE)) {
    sub LLC_ENQUEUE {
	local($l,$m) = @_;
	eval q( &if (($l)-> &llcl_writeqh ==  &NULL) { ($l)-> &llcl_writeqh = ($m); ($l)-> &llcl_writeqt = ($m); }  &else { ($l)-> ($llcl_writeqt->{m_nextpkt}) = ($m); ($l)-> &llcl_writeqt = ($m); });
    }
}
unless(defined(&LLC_DEQUEUE)) {
    sub LLC_DEQUEUE {
	local($l,$m) = @_;
	eval q( &if (($l)-> &llcl_writeqh ==  &NULL) ($m) =  &NULL;  &else { ($m) = ($l)-> &llcl_writeqh; ($l)-> &llcl_writeqh = ($l)-> ($llcl_writeqh->{m_nextpkt}); });
    }
}
unless(defined(&LLC_SETFRAME)) {
    sub LLC_SETFRAME {
	local($l,$m) = @_;
	eval q({  &if (($l)-> &llcl_slotsfree > 0) { ($l)-> &llcl_slotsfree--; ($l)-> $llcl_output_buffers[($l)-> &llcl_freeslot] = ($m); ($l)-> &llcl_freeslot = (($l)-> &llcl_freeslot+1) % ($l)-> &llcl_window;  &LLC_INC(($l)-> &llcl_projvs); } });
    }
}
unless(defined(&LLADDRLEN)) {
    sub LLADDRLEN {
	local($s) = @_;
	eval q((($s)-> &sdl_alen + ($s)-> &sdl_nlen));
    }
}
unless(defined(&LLSAPADDR)) {
    sub LLSAPADDR {
	local($s) = @_;
	eval q((($s)-> $sdl_data[ &LLADDRLEN($s)-1] & 0xff));
    }
}
unless(defined(&LLSAPLOC)) {
    sub LLSAPLOC {
	local($s,$if) = @_;
	eval q((($s)-> &sdl_nlen + ($if)-> &if_addrlen));
    }
}
unless(defined(&LLC_GETHDR)) {
    sub LLC_GETHDR {
	local($f,$m) = @_;
	eval q({ 'struct mbuf' * &_m = ($m);  &if ( &_m) {  &M_PREPEND( &_m, &LLC_ISFRAMELEN, &M_DONTWAIT);  &bzero( &mtod( &_m,'caddr_t'), &LLC_ISFRAMELEN); }  &else {  &MGETHDR ( &_m, &M_DONTWAIT, &MT_HEADER);  &if ( &_m !=  &NULL) {  ($_m->{m_pkthdr}->{len}) =  ($_m->{m_len}) =  &LLC_UFRAMELEN;  ($_m->{m_next}) =  ($_m->{m_act}) =  &NULL;  &bzero( &mtod( &_m,'caddr_t'), &LLC_UFRAMELEN); }  &else  &return; } ($m) =  &_m; ($f) =  &mtod($m,'struct llc' *); });
    }
}
unless(defined(&LLC_NEWSTATE)) {
    sub LLC_NEWSTATE {
	local($l,$LLCstate) = @_;
	eval q(($l)-> &llcl_statehandler =  &__CONCAT( &llc_state_,$LLCstate));
    }
}
unless(defined(&LLC_STATEEQ)) {
    sub LLC_STATEEQ {
	local($l,$LLCstate) = @_;
	eval q((($l)-> &llcl_statehandler ==  &__CONCAT( &llc_state_,$LLCstate) ? 1: 0));
    }
}
unless(defined(&LLC_ACK_SHIFT)) {
    sub LLC_ACK_SHIFT () {	0;}
}
unless(defined(&LLC_P_SHIFT)) {
    sub LLC_P_SHIFT () {	1;}
}
unless(defined(&LLC_BUSY_SHIFT)) {
    sub LLC_BUSY_SHIFT () {	2;}
}
unless(defined(&LLC_REJ_SHIFT)) {
    sub LLC_REJ_SHIFT () {	3;}
}
unless(defined(&LLC_AGE_SHIFT)) {
    sub LLC_AGE_SHIFT () {	4;}
}
unless(defined(&LLC_DACTION_SHIFT)) {
    sub LLC_DACTION_SHIFT () {	5;}
}
unless(defined(&LLC_TIMER_NOTRUNNING)) {
    sub LLC_TIMER_NOTRUNNING () {	0;}
}
unless(defined(&LLC_TIMER_RUNNING)) {
    sub LLC_TIMER_RUNNING () {	1;}
}
unless(defined(&LLC_TIMER_EXPIRED)) {
    sub LLC_TIMER_EXPIRED () {	2;}
}
unless(defined(&__CONCAT3)) {
    if((defined(&__STDC__) ? &__STDC__ : 0)) {
	eval 'sub __CONCAT3 {
	    local($a,$b,$c) = @_;
    	    eval q($a  $b  $c);
	}' unless defined(&__CONCAT3);
    } else {
	eval 'sub __CONCAT3 {
	    local($a,$b,$c) = @_;
    	    eval q( &abc);
	}' unless defined(&__CONCAT3);
    }
}
unless(defined(&LLC_STARTTIMER)) {
    sub LLC_STARTTIMER {
	local($l,$LLCtimer) = @_;
	eval q({ ($l)-> $llcl_timers[ &__CONCAT3( &LLC_,$LLCtimer, &_SHIFT)] =  &__CONCAT3( &llc_,$LLCtimer, &_timer); ($l)-> &llcl_timerflags |= (1<<  &__CONCAT3( &LLC_,$LLCtimer, &_SHIFT)); });
    }
}
unless(defined(&LLC_STOPTIMER)) {
    sub LLC_STOPTIMER {
	local($l,$LLCtimer) = @_;
	eval q({ ($l)-> $llcl_timers[ &__CONCAT3( &LLC_,$LLCtimer, &_SHIFT)] = 0; ($l)-> &llcl_timerflags &= ~(1<< &__CONCAT3( &LLC_,$LLCtimer, &_SHIFT)); });
    }
}
unless(defined(&LLC_AGETIMER)) {
    sub LLC_AGETIMER {
	local($l,$LLCtimer) = @_;
	eval q( &if (($l)-> $llcl_timers[ &__CONCAT3( &LLC_,$LLCtimer, &_SHIFT)] > 0) ($l)-> $llcl_timers[ &__CONCAT3( &LLC_,$LLCtimer, &_SHIFT)]--;);
    }
}
unless(defined(&LLC_TIMERXPIRED)) {
    sub LLC_TIMERXPIRED {
	local($l,$LLCtimer) = @_;
	eval q(((($l)-> &llcl_timerflags & (1<< &__CONCAT3( &LLC_,$LLCtimer, &_SHIFT))) ? ((($l)-> $llcl_timers[ &__CONCAT3( &LLC_,$LLCtimer, &_SHIFT)] == 0) ?  &LLC_TIMER_EXPIRED :  &LLC_TIMER_RUNNING) :  &LLC_TIMER_NOTRUNNING));
    }
}
unless(defined(&FOR_ALL_LLC_TIMERS)) {
    sub FOR_ALL_LLC_TIMERS {
	local($t) = @_;
	eval q( &for (($t) =  &LLC_ACK_SHIFT; ($t) <  &LLC_AGE_SHIFT; ($t)++));
    }
}
unless(defined(&LLC_SETFLAG)) {
    sub LLC_SETFLAG {
	local($l,$LLCflag,$v) = @_;
	eval q(($l)-> &__CONCAT3( &llcl_,$LLCflag, &_flag) = ($v));
    }
}
unless(defined(&LLC_GETFLAG)) {
    sub LLC_GETFLAG {
	local($l,$LLCflag) = @_;
	eval q(($l)-> &__CONCAT3( &llcl_,$LLCflag, &_flag));
    }
}
unless(defined(&LLC_RESETCOUNTER)) {
    sub LLC_RESETCOUNTER {
	local($l) = @_;
	eval q({ ($l)-> &llcl_vs = ($l)-> &llcl_vr = ($l)-> &llcl_retry = 0;  &llc_resetwindow(($l)); });
    }
}
unless(defined(&LLC_START_ACK_TIMER)) {
    sub LLC_START_ACK_TIMER {
	local($l) = @_;
	eval q( &LLC_STARTTIMER(($l), &ACK));
    }
}
unless(defined(&LLC_STOP_ACK_TIMER)) {
    sub LLC_STOP_ACK_TIMER {
	local($l) = @_;
	eval q( &LLC_STOPTIMER(($l), &ACK));
    }
}
unless(defined(&LLC_START_REJ_TIMER)) {
    sub LLC_START_REJ_TIMER {
	local($l) = @_;
	eval q( &LLC_STARTTIMER(($l), &REJ));
    }
}
unless(defined(&LLC_STOP_REJ_TIMER)) {
    sub LLC_STOP_REJ_TIMER {
	local($l) = @_;
	eval q( &LLC_STOPTIMER(($l), &REJ));
    }
}
unless(defined(&LLC_START_P_TIMER)) {
    sub LLC_START_P_TIMER {
	local($l) = @_;
	eval q({  &LLC_STARTTIMER(($l), &P);  &if ( &LLC_GETFLAG(($l), &P) == 0) ($l)-> &llcl_retry = 0;  &LLC_SETFLAG(($l), &P,1); });
    }
}
unless(defined(&LLC_STOP_P_TIMER)) {
    sub LLC_STOP_P_TIMER {
	local($l) = @_;
	eval q({  &LLC_STOPTIMER(($l), &P);  &LLC_SETFLAG(($l), &P,0); });
    }
}
unless(defined(&LLC_STOP_ALL_TIMERS)) {
    sub LLC_STOP_ALL_TIMERS {
	local($l) = @_;
	eval q({  &LLC_STOPTIMER(($l), &ACK);  &LLC_STOPTIMER(($l), &REJ);  &LLC_STOPTIMER(($l), &BUSY);  &LLC_STOPTIMER(($l), &P); });
    }
}
unless(defined(&LLC_INC)) {
    sub LLC_INC {
	local($i) = @_;
	eval q(($i) = (($i)+1) %  &LLC_MAX_SEQUENCE);
    }
}
unless(defined(&LLC_NR_VALID)) {
    sub LLC_NR_VALID {
	local($l,$nr) = @_;
	eval q((($l)-> &llcl_vs < ($l)-> &llcl_nr_received ? ((($nr) >= ($l)-> &llcl_nr_received) || (($nr) <= ($l)-> &llcl_vs) ? 1: 0) : ((($nr) <= ($l)-> &llcl_vs)  && (($nr) >= ($l)-> &llcl_nr_received) ? 1: 0)));
    }
}
unless(defined(&LLC_UPDATE_P_FLAG)) {
    sub LLC_UPDATE_P_FLAG {
	local($l,$cr,$pf) = @_;
	eval q({  &if (($cr) ==  &LLC_RSP  && ($pf) == 1) {  &LLC_SETFLAG(($l), &P,0);  &LLC_STOPTIMER(($l), &P); } });
    }
}
unless(defined(&LLC_UPDATE_NR_RECEIVED)) {
    sub LLC_UPDATE_NR_RECEIVED {
	local($l,$nr) = @_;
	eval q({  &while (($l)-> &llcl_nr_received != ($nr)) { 'struct mbuf' * &_m;  &register 'short seq';  &seq =  &llc_seq2slot(($l),($l)-> &llcl_nr_received);  &if (( &_m = ($l)-> $llcl_output_buffers[ &seq]) !=  &NULL)  &m_freem( &_m); ($l)-> $llcl_output_buffers[ &seq] =  &NULL;  &LLC_INC(($l)-> &llcl_nr_received); ($l)-> &llcl_slotsfree++; } ($l)-> &llcl_retry = 0;  &if (($l)-> &llcl_slotsfree < ($l)-> &llcl_window) {  &LLC_START_ACK_TIMER($l); }  &else {  &LLC_STOP_ACK_TIMER($l); }  &LLC_STARTTIMER(($l), &DACTION); });
    }
}
unless(defined(&LLC_SET_REMOTE_BUSY)) {
    sub LLC_SET_REMOTE_BUSY {
	local($l,$a) = @_;
	eval q({  &if ( &LLC_GETFLAG(($l), &REMOTE_BUSY) == 0) {  &LLC_SETFLAG(($l), &REMOTE_BUSY,1);  &LLC_STARTTIMER(($l), &BUSY); ($a) =  &LLC_REMOTE_BUSY; }  &else { ($a) = 0; } });
    }
}
unless(defined(&LLC_CLEAR_REMOTE_BUSY)) {
    sub LLC_CLEAR_REMOTE_BUSY {
	local($l,$a) = @_;
	eval q({  &if ( &LLC_GETFLAG(($l), &REMOTE_BUSY) == 1) {  &LLC_SETFLAG(($l), &REMOTE_BUSY,1);  &LLC_STOPTIMER(($l), &BUSY);  &if ( &LLC_STATEEQ(($l), &NORMAL) ||  &LLC_STATEEQ(($l), &REJECT) ||  &LLC_STATEEQ(($l), &BUSY))  &llc_resend(($l), &LLC_CMD,0); ($a) =  &LLC_REMOTE_NOT_BUSY; }  &else { ($a) = 0; } });
    }
}
unless(defined(&LLC_DACKCMD)) {
    sub LLC_DACKCMD () {	0x1;}
}
unless(defined(&LLC_DACKCMDPOLL)) {
    sub LLC_DACKCMDPOLL () {	0x2;}
}
unless(defined(&LLC_DACKRSP)) {
    sub LLC_DACKRSP () {	0x3;}
}
unless(defined(&LLC_DACKRSPFINAL)) {
    sub LLC_DACKRSPFINAL () {	0x4;}
}
unless(defined(&LLC_SENDACKNOWLEDGE)) {
    sub LLC_SENDACKNOWLEDGE {
	local($l,$cmd,$pf) = @_;
	eval q({  &if (($cmd) ==  &LLC_CMD) {  &LLC_SETFLAG(($l), &DACTION,(($pf) == 0?  &LLC_DACKCMD :  &LLC_DACKCMDPOLL)); }  &else {  &LLC_SETFLAG(($l), &DACTION,(($pf) == 0?  &LLC_DACKRSP :  &LLC_DACKRSPFINAL)); } });
    }
}
unless(defined(&LLC_FRMR_W)) {
    sub LLC_FRMR_W () {	(1<<0);}
}
unless(defined(&LLC_FRMR_X)) {
    sub LLC_FRMR_X () {	(1<<1);}
}
unless(defined(&LLC_FRMR_Y)) {
    sub LLC_FRMR_Y () {	(1<<2);}
}
unless(defined(&LLC_FRMR_Z)) {
    sub LLC_FRMR_Z () {	(1<<3);}
}
unless(defined(&LLC_FRMR_V)) {
    sub LLC_FRMR_V () {	(1<<4);}
}
unless(defined(&LLC_SETFRMR)) {
    sub LLC_SETFRMR {
	local($l,$f,$cr,$c) = @_;
	eval q({  &if (($f)-> &llc_control & 0x3) { ($l)-> &llcl_frmr_pdu0 = ($f)-> &llc_control; ($l)-> &llcl_frmr_pdu1 = 0; }  &else { ($l)-> &llcl_frmr_pdu0 = ($f)-> &llc_control; ($l)-> &llcl_frmr_pdu1 = ($f)-> &llc_control_ext; }  &LLCCSBITS(($l)-> &llcl_frmr_control, &f_vs,($l)-> &llcl_vs);  &LLCCSBITS(($l)-> &llcl_frmr_control_ext, &f_cr,($cr));  &LLCSBITS(($l)-> &llcl_frmr_control_ext, &f_vr,($l)-> &llcl_vr);  &LLCCSBITS(($l)-> &llcl_frmr_cause, &f_wxyzv,($c)); });
    }
}
unless(defined(&LLCTR_INTERESTING)) {
    sub LLCTR_INTERESTING () {	1;}
}
unless(defined(&LLCTR_SHOULDKNOW)) {
    sub LLCTR_SHOULDKNOW () {	2;}
}
unless(defined(&LLCTR_URGENT)) {
    sub LLCTR_URGENT () {	3;}
}
if(defined(&LLCDEBUG)) {
    eval 'sub LLC_TRACE {
        local($lp,$l,$msg) = @_;
	    eval q( &llc_trace(($lp),($l),($msg)));
    }' unless defined(&LLC_TRACE);
} else {
    eval 'sub LLC_TRACE {
        local($lp,$l,$msg) = @_;
	    eval q();
    }' unless defined(&LLC_TRACE);
}
unless(defined(&LLC_N2_VALUE)) {
    sub LLC_N2_VALUE () {	15;}
}
unless(defined(&LLC_ACK_TIMER)) {
    sub LLC_ACK_TIMER () {	10;}
}
unless(defined(&LLC_P_TIMER)) {
    sub LLC_P_TIMER () {	4;}
}
unless(defined(&LLC_BUSY_TIMER)) {
    sub LLC_BUSY_TIMER () {	12;}
}
unless(defined(&LLC_REJ_TIMER)) {
    sub LLC_REJ_TIMER () {	12;}
}
unless(defined(&LLC_AGE_TIMER)) {
    sub LLC_AGE_TIMER () {	40;}
}
unless(defined(&LLC_DACTION_TIMER)) {
    sub LLC_DACTION_TIMER () {	2;}
}
if(defined ( &_KERNEL)  && defined( &LLC)) {
    eval 'sub USES_AF_LINK_RTS () {{  &if (! &af_link_rts_init_done) {  &rn_inithead(( &void **) $rt_tables[ &AF_LINK],32);  &af_link_rts_init_done++; } };}' unless defined(&USES_AF_LINK_RTS);
}
1;
