require '_h2ph_pre.ph';

unless(defined(&TWE_MAX_UNITS)) {
    sub TWE_MAX_UNITS () {	16;}
}
unless(defined(&TWE_MAXOFFSETS)) {
    sub TWE_MAXOFFSETS () {	62;}
}
unless(defined(&TWE_MAXCMDS)) {
    sub TWE_MAXCMDS () {	255;}
}
unless(defined(&TWE_SECTOR_SIZE)) {
    sub TWE_SECTOR_SIZE () {	512;}
}
unless(defined(&TWE_ALIGN)) {
    sub TWE_ALIGN () {	512;}
}
unless(defined(&TWE_MAXFER)) {
    sub TWE_MAXFER () {	( &TWE_MAXOFFSETS *  &PAGE_SIZE);}
}
unless(defined(&TWE_CONTROL)) {
    sub TWE_CONTROL () {	0x00;}
}
unless(defined(&TWE_CTRL_CHOSTI)) {
    sub TWE_CTRL_CHOSTI () {	0x00080000;}
}
unless(defined(&TWE_CTRL_CATTNI)) {
    sub TWE_CTRL_CATTNI () {	0x00040000;}
}
unless(defined(&TWE_CTRL_MCMDI)) {
    sub TWE_CTRL_MCMDI () {	0x00020000;}
}
unless(defined(&TWE_CTRL_MRDYI)) {
    sub TWE_CTRL_MRDYI () {	0x00010000;}
}
unless(defined(&TWE_CTRL_ECMDI)) {
    sub TWE_CTRL_ECMDI () {	0x00008000;}
}
unless(defined(&TWE_CTRL_ERDYI)) {
    sub TWE_CTRL_ERDYI () {	0x00004000;}
}
unless(defined(&TWE_CTRL_CERR)) {
    sub TWE_CTRL_CERR () {	0x00000200;}
}
unless(defined(&TWE_CTRL_SRST)) {
    sub TWE_CTRL_SRST () {	0x00000100;}
}
unless(defined(&TWE_CTRL_EINT)) {
    sub TWE_CTRL_EINT () {	0x00000080;}
}
unless(defined(&TWE_CTRL_MINT)) {
    sub TWE_CTRL_MINT () {	0x00000040;}
}
unless(defined(&TWE_CTRL_HOSTI)) {
    sub TWE_CTRL_HOSTI () {	0x00000020;}
}
unless(defined(&TWE_STATUS)) {
    sub TWE_STATUS () {	0x04;}
}
unless(defined(&TWE_STAT_MAJV)) {
    sub TWE_STAT_MAJV () {	0xf0000000;}
}
unless(defined(&TWE_MAJV)) {
    sub TWE_MAJV {
	local($st) = @_;
	eval q(((($st) >> 28) & 0xf));
    }
}
unless(defined(&TWE_STAT_MINV)) {
    sub TWE_STAT_MINV () {	0x0f000000;}
}
unless(defined(&TWE_MINV)) {
    sub TWE_MINV {
	local($st) = @_;
	eval q(((($st) >> 24) & 0xf));
    }
}
unless(defined(&TWE_STAT_PCIPAR)) {
    sub TWE_STAT_PCIPAR () {	0x00800000;}
}
unless(defined(&TWE_STAT_QUEUEE)) {
    sub TWE_STAT_QUEUEE () {	0x00400000;}
}
unless(defined(&TWE_STAT_CPUERR)) {
    sub TWE_STAT_CPUERR () {	0x00200000;}
}
unless(defined(&TWE_STAT_PCIABR)) {
    sub TWE_STAT_PCIABR () {	0x00100000;}
}
unless(defined(&TWE_STAT_HOSTI)) {
    sub TWE_STAT_HOSTI () {	0x00080000;}
}
unless(defined(&TWE_STAT_ATTNI)) {
    sub TWE_STAT_ATTNI () {	0x00040000;}
}
unless(defined(&TWE_STAT_CMDI)) {
    sub TWE_STAT_CMDI () {	0x00020000;}
}
unless(defined(&TWE_STAT_RDYI)) {
    sub TWE_STAT_RDYI () {	0x00010000;}
}
unless(defined(&TWE_STAT_CQF)) {
    sub TWE_STAT_CQF () {	0x00008000;}
}
unless(defined(&TWE_STAT_RQE)) {
    sub TWE_STAT_RQE () {	0x00004000;}
}
unless(defined(&TWE_STAT_CPURDY)) {
    sub TWE_STAT_CPURDY () {	0x00002000;}
}
unless(defined(&TWE_STAT_CQR)) {
    sub TWE_STAT_CQR () {	0x00001000;}
}
unless(defined(&TWE_STAT_FLAGS)) {
    sub TWE_STAT_FLAGS () {	0x00fff000;}
}
unless(defined(&TWE_STAT_BITS)) {
    sub TWE_STAT_BITS () {	"\020\015cqr\016cpurdy\017rqe\20cqf" "\021rdyi\022cmdi\023attni\024hosti\025pciabr\026cpuerr\027queuee\030pcipar";}
}
unless(defined(&TWE_COMMANDQUEUE)) {
    sub TWE_COMMANDQUEUE () {	0x08;}
}
unless(defined(&TWE_CMD_NOP)) {
    sub TWE_CMD_NOP () {	0x0200;}
}
unless(defined(&TWE_CMD_INIT)) {
    sub TWE_CMD_INIT () {	0x0301;}
}
unless(defined(&TWE_CMD_READ)) {
    sub TWE_CMD_READ () {	0x0362;}
}
unless(defined(&TWE_CMD_WRITE)) {
    sub TWE_CMD_WRITE () {	0x0363;}
}
unless(defined(&TWE_CMD_VERIFY)) {
    sub TWE_CMD_VERIFY () {	0x0364;}
}
unless(defined(&TWE_CMD_GPARAM)) {
    sub TWE_CMD_GPARAM () {	0x0252;}
}
unless(defined(&TWE_CMD_SPARAM)) {
    sub TWE_CMD_SPARAM () {	0x0253;}
}
unless(defined(&TWE_CMD_SECINF)) {
    sub TWE_CMD_SECINF () {	0x021a;}
}
unless(defined(&TWE_CMD_AEN)) {
    sub TWE_CMD_AEN () {	0x021c;}
}
unless(defined(&TWE_READYQUEUE)) {
    sub TWE_READYQUEUE () {	0x0c;}
}
unless(defined(&TWE_READYID)) {
    sub TWE_READYID {
	local($u) = @_;
	eval q(((($u) >> 4) & 0xff));
    }
}
unless(defined(&TWE_PARAM_UC)) {
    sub TWE_PARAM_UC () {	0x003;}
}
unless(defined(&TWE_PARAM_UI)) {
    sub TWE_PARAM_UI () {	0x300;}
}
unless(defined(&TWE_PARAM_AEN)) {
    sub TWE_PARAM_AEN () {	0x401;}
}
unless(defined(&TWE_AEN_QEMPTY)) {
    sub TWE_AEN_QEMPTY () {	0x0000;}
}
unless(defined(&TWE_AEN_SRST)) {
    sub TWE_AEN_SRST () {	0x0001;}
}
unless(defined(&TWE_AEN_DMIRROR)) {
    sub TWE_AEN_DMIRROR () {	0x0002;}
}
unless(defined(&TWE_AEN_CERROR)) {
    sub TWE_AEN_CERROR () {	0x0003;}
}
unless(defined(&TWE_AEN_RBFAIL)) {
    sub TWE_AEN_RBFAIL () {	0x0004;}
}
unless(defined(&TWE_AEN_RBDONE)) {
    sub TWE_AEN_RBDONE () {	0x0005;}
}
unless(defined(&TWE_AEN_QFULL)) {
    sub TWE_AEN_QFULL () {	0x00ff;}
}
unless(defined(&TWE_AEN_TUN)) {
    sub TWE_AEN_TUN () {	0x0015;}
}
unless(defined(&TWE_UNITHOST)) {
    sub TWE_UNITHOST {
	local($u, $h) = @_;
	eval q(((($u) & 0xf) | (($h) << 4)));
    }
}
unless(defined(&cmd_io)) {
    sub cmd_io () {	 ($_->{_cmd_io});}
}
unless(defined(&cmd_param)) {
    sub cmd_param () {	 ($_->{_cmd_param});}
}
unless(defined(&cmd_init)) {
    sub cmd_init () {	 ($_->{_cmd_init});}
}
1;
