require '_h2ph_pre.ph';

if(!defined( &_DEVAR_H)) {
    eval 'sub _DEVAR_H () {1;}' unless defined(&_DEVAR_H);
    if(defined( &__OpenBSD__)) {
	eval 'sub __BROKEN_INDIRECT_CONFIG () {1;}' unless defined(&__BROKEN_INDIRECT_CONFIG);
    }
    if(defined( &__NetBSD__) || defined( &__OpenBSD__)) {
	eval 'sub TULIP_CSR_READ {
	    local($sc, $csr) = @_;
    	    eval q( &bus_space_read_4(($sc)-> &tulip_bustag, ($sc)-> &tulip_bushandle, ($sc)-> ($tulip_csrs->{csr})));
	}' unless defined(&TULIP_CSR_READ);
	eval 'sub TULIP_CSR_WRITE {
	    local($sc, $csr, $val) = @_;
    	    eval q( &bus_space_write_4(($sc)-> &tulip_bustag, ($sc)-> &tulip_bushandle, ($sc)-> ($tulip_csrs->{csr}), ($val)));
	}' unless defined(&TULIP_CSR_WRITE);
	eval 'sub TULIP_CSR_READBYTE {
	    local($sc, $csr) = @_;
    	    eval q( &bus_space_read_1(($sc)-> &tulip_bustag, ($sc)-> &tulip_bushandle, ($sc)-> ($tulip_csrs->{csr})));
	}' unless defined(&TULIP_CSR_READBYTE);
	eval 'sub TULIP_CSR_WRITEBYTE {
	    local($sc, $csr, $val) = @_;
    	    eval q( &bus_space_write_1(($sc)-> &tulip_bustag, ($sc)-> &tulip_bushandle, ($sc)-> ($tulip_csrs->{csr}), ($val)));
	}' unless defined(&TULIP_CSR_WRITEBYTE);
    }
    if(defined(&TULIP_IOMAPPED)) {
	eval 'sub TULIP_EISA_CSRSIZE () {16;}' unless defined(&TULIP_EISA_CSRSIZE);
	eval 'sub TULIP_EISA_CSROFFSET () {0;}' unless defined(&TULIP_EISA_CSROFFSET);
	eval 'sub TULIP_PCI_CSRSIZE () {8;}' unless defined(&TULIP_PCI_CSRSIZE);
	eval 'sub TULIP_PCI_CSROFFSET () {0;}' unless defined(&TULIP_PCI_CSROFFSET);
	if(!defined( &__NetBSD__)  && !defined( &__OpenBSD__)) {
	    eval 'sub TULIP_CSR_READ {
	        local($sc, $csr) = @_;
    		eval q(( &inl(($sc)-> ($tulip_csrs->{csr}))));
	    }' unless defined(&TULIP_CSR_READ);
	    eval 'sub TULIP_CSR_WRITE {
	        local($sc, $csr, $val) = @_;
    		eval q( &outl(($sc)-> ($tulip_csrs->{csr}), $val));
	    }' unless defined(&TULIP_CSR_WRITE);
	    eval 'sub TULIP_CSR_READBYTE {
	        local($sc, $csr) = @_;
    		eval q(( &inb(($sc)-> ($tulip_csrs->{csr}))));
	    }' unless defined(&TULIP_CSR_READBYTE);
	    eval 'sub TULIP_CSR_WRITEBYTE {
	        local($sc, $csr, $val) = @_;
    		eval q( &outb(($sc)-> ($tulip_csrs->{csr}), $val));
	    }' unless defined(&TULIP_CSR_WRITEBYTE);
	}
    } else {
	eval 'sub TULIP_PCI_CSRSIZE () {8;}' unless defined(&TULIP_PCI_CSRSIZE);
	eval 'sub TULIP_PCI_CSROFFSET () {0;}' unless defined(&TULIP_PCI_CSROFFSET);
	if(!defined( &__NetBSD__)  && !defined( &__OpenBSD__)) {
	    eval 'sub TULIP_CSR_READ {
	        local($sc, $csr) = @_;
    		eval q((0+ *($sc)-> ($tulip_csrs->{csr})));
	    }' unless defined(&TULIP_CSR_READ);
	    eval 'sub TULIP_CSR_WRITE {
	        local($sc, $csr, $val) = @_;
    		eval q(((*($sc)-> ($tulip_csrs->{csr}) = ($val))));
	    }' unless defined(&TULIP_CSR_WRITE);
	}
    }
    if(defined( &BYTE_ORDER)  && (defined(&BYTE_ORDER) ? &BYTE_ORDER : 0) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : 0)) {
    } else {
	eval 'sub FILT_BO {
	    local($x) = @_;
    	    eval q(($x));
	}' unless defined(&FILT_BO);
	eval 'sub DESC_BO {
	    local($x) = @_;
    	    eval q(($x));
	}' unless defined(&DESC_BO);
    }
    eval 'sub csr_enetrom () { &csr_9;}' unless defined(&csr_enetrom);
    eval 'sub csr_reserved () { &csr_10;}' unless defined(&csr_reserved);
    eval 'sub csr_full_duplex () { &csr_11;}' unless defined(&csr_full_duplex);
    eval 'sub csr_bootrom () { &csr_10;}' unless defined(&csr_bootrom);
    eval 'sub csr_gp () { &csr_12;}' unless defined(&csr_gp);
    eval 'sub csr_watchdog () { &csr_15;}' unless defined(&csr_watchdog);
    eval 'sub csr_gp_timer () { &csr_11;}' unless defined(&csr_gp_timer);
    eval 'sub csr_srom_mii () { &csr_9;}' unless defined(&csr_srom_mii);
    eval 'sub csr_sia_status () { &csr_12;}' unless defined(&csr_sia_status);
    eval 'sub csr_sia_connectivity () { &csr_13;}' unless defined(&csr_sia_connectivity);
    eval 'sub csr_sia_tx_rx () { &csr_14;}' unless defined(&csr_sia_tx_rx);
    eval 'sub csr_sia_general () { &csr_15;}' unless defined(&csr_sia_general);
    if(defined( &__alpha__) || defined( &__mips__)) {
	eval 'sub TULIP_COPY_RXDATA () {1;}' unless defined(&TULIP_COPY_RXDATA);
    }
    eval 'sub TULIP_TXTIMER () {4;}' unless defined(&TULIP_TXTIMER);
    eval 'sub TULIP_RXDESCS () {48;}' unless defined(&TULIP_RXDESCS);
    eval 'sub TULIP_TXDESCS () {128;}' unless defined(&TULIP_TXDESCS);
    eval 'sub TULIP_RXQ_TARGET () {32;}' unless defined(&TULIP_RXQ_TARGET);
    if((defined(&TULIP_RXQ_TARGET) ? &TULIP_RXQ_TARGET : 0) >= (defined(&TULIP_RXDESCS) ? &TULIP_RXDESCS : 0)) {
	die("TULIP_RXQ_TARGET\ must\ be\ less\ than\ TULIP_RXDESCS");
    }
    eval 'sub TULIP_RX_BUFLEN () {(( &MCLBYTES < 2048?  &MCLBYTES : 2048) - 16);}' unless defined(&TULIP_RX_BUFLEN);
    eval("sub TULIP_21040 () { 0; }") unless defined(&TULIP_21040);
    eval("sub TULIP_DE425 () { 1; }") unless defined(&TULIP_DE425);
    eval("sub TULIP_21041 () { 2; }") unless defined(&TULIP_21041);
    eval("sub TULIP_21140 () { 3; }") unless defined(&TULIP_21140);
    eval("sub TULIP_21140A () { 4; }") unless defined(&TULIP_21140A);
    eval("sub TULIP_21142 () { 5; }") unless defined(&TULIP_21142);
    eval("sub TULIP_21143 () { 6; }") unless defined(&TULIP_21143);
    eval("sub TULIP_CHIPID_UNKNOWN () { 7; }") unless defined(&TULIP_CHIPID_UNKNOWN);
    eval("sub TULIP_MEDIA_UNKNOWN () { 0; }") unless defined(&TULIP_MEDIA_UNKNOWN);
    eval("sub TULIP_MEDIA_10BASET () { 1; }") unless defined(&TULIP_MEDIA_10BASET);
    eval("sub TULIP_MEDIA_10BASET_FD () { 2; }") unless defined(&TULIP_MEDIA_10BASET_FD);
    eval("sub TULIP_MEDIA_BNC () { 3; }") unless defined(&TULIP_MEDIA_BNC);
    eval("sub TULIP_MEDIA_AUI () { 4; }") unless defined(&TULIP_MEDIA_AUI);
    eval("sub TULIP_MEDIA_EXTSIA () { 5; }") unless defined(&TULIP_MEDIA_EXTSIA);
    eval("sub TULIP_MEDIA_AUIBNC () { 6; }") unless defined(&TULIP_MEDIA_AUIBNC);
    eval("sub TULIP_MEDIA_100BASETX () { 7; }") unless defined(&TULIP_MEDIA_100BASETX);
    eval("sub TULIP_MEDIA_100BASETX_FD () { 8; }") unless defined(&TULIP_MEDIA_100BASETX_FD);
    eval("sub TULIP_MEDIA_100BASET4 () { 9; }") unless defined(&TULIP_MEDIA_100BASET4);
    eval("sub TULIP_MEDIA_100BASEFX () { 10; }") unless defined(&TULIP_MEDIA_100BASEFX);
    eval("sub TULIP_MEDIA_100BASEFX_FD () { 11; }") unless defined(&TULIP_MEDIA_100BASEFX_FD);
    eval("sub TULIP_MEDIA_MAX () { 12; }") unless defined(&TULIP_MEDIA_MAX);
    eval 'sub TULIP_BIT {
        local($b) = @_;
	    eval q((1 << (($b))));
    }' unless defined(&TULIP_BIT);
    eval 'sub TULIP_FDBIT {
        local($m) = @_;
	    eval q((1 << ( &TULIP_MEDIA_  $m   &_FD)));
    }' unless defined(&TULIP_FDBIT);
    eval 'sub TULIP_MBIT {
        local($m) = @_;
	    eval q((1 << ( &TULIP_MEDIA_  $m )));
    }' unless defined(&TULIP_MBIT);
    eval 'sub TULIP_IS_MEDIA_FD {
        local($m) = @_;
	    eval q(( &TULIP_BIT($m) & ( &TULIP_FDBIT(10 &BASET) | &TULIP_FDBIT(100 &BASETX) | &TULIP_FDBIT(100 &BASEFX))));
    }' unless defined(&TULIP_IS_MEDIA_FD);
    eval 'sub TULIP_CAN_MEDIA_FD {
        local($m) = @_;
	    eval q(( &TULIP_BIT($m) & ( &TULIP_MBIT(10 &BASET) | &TULIP_MBIT(100 &BASETX) | &TULIP_MBIT(100 &BASEFX))));
    }' unless defined(&TULIP_CAN_MEDIA_FD);
    eval 'sub TULIP_FD_MEDIA_OF {
        local($m) = @_;
	    eval q(((($m) + 1)));
    }' unless defined(&TULIP_FD_MEDIA_OF);
    eval 'sub TULIP_HD_MEDIA_OF {
        local($m) = @_;
	    eval q(((($m) - 1)));
    }' unless defined(&TULIP_HD_MEDIA_OF);
    eval 'sub TULIP_IS_MEDIA_100MB {
        local($m) = @_;
	    eval q((($m) >=  &TULIP_MEDIA_100BASETX));
    }' unless defined(&TULIP_IS_MEDIA_100MB);
    eval 'sub TULIP_IS_MEDIA_TP {
        local($m) = @_;
	    eval q((( &TULIP_BIT($m) & ( &TULIP_MBIT( &BNC) | &TULIP_MBIT( &AUI) | &TULIP_MBIT( &AUIBNC) | &TULIP_MBIT( &EXTSIA))) == 0));
    }' unless defined(&TULIP_IS_MEDIA_TP);
    eval 'sub TULIP_SROM_ATTR_MII () {0x0100;}' unless defined(&TULIP_SROM_ATTR_MII);
    eval 'sub TULIP_SROM_ATTR_NWAY () {0x0200;}' unless defined(&TULIP_SROM_ATTR_NWAY);
    eval 'sub TULIP_SROM_ATTR_AUTOSENSE () {0x0400;}' unless defined(&TULIP_SROM_ATTR_AUTOSENSE);
    eval 'sub TULIP_SROM_ATTR_POWERUP () {0x0800;}' unless defined(&TULIP_SROM_ATTR_POWERUP);
    eval 'sub TULIP_SROM_ATTR_NOLINKPASS () {0x1000;}' unless defined(&TULIP_SROM_ATTR_NOLINKPASS);
    eval("sub TULIP_MEDIAINFO_NONE () { 0; }") unless defined(&TULIP_MEDIAINFO_NONE);
    eval("sub TULIP_MEDIAINFO_SIA () { 1; }") unless defined(&TULIP_MEDIAINFO_SIA);
    eval("sub TULIP_MEDIAINFO_GPR () { 2; }") unless defined(&TULIP_MEDIAINFO_GPR);
    eval("sub TULIP_MEDIAINFO_MII () { 3; }") unless defined(&TULIP_MEDIAINFO_MII);
    eval("sub TULIP_MEDIAINFO_RESET () { 4; }") unless defined(&TULIP_MEDIAINFO_RESET);
    eval("sub TULIP_MEDIAINFO_SYM () { 5; }") unless defined(&TULIP_MEDIAINFO_SYM);
    eval 'sub mi_sia_connectivity () { ($mi_un->{un_sia}->{sia_connectivity});}' unless defined(&mi_sia_connectivity);
    eval 'sub mi_sia_tx_rx () { ($mi_un->{un_sia}->{sia_tx_rx});}' unless defined(&mi_sia_tx_rx);
    eval 'sub mi_sia_general () { ($mi_un->{un_sia}->{sia_general});}' unless defined(&mi_sia_general);
    eval 'sub mi_sia_gp_control () { ($mi_un->{un_sia}->{sia_gp_control});}' unless defined(&mi_sia_gp_control);
    eval 'sub mi_sia_gp_data () { ($mi_un->{un_sia}->{sia_gp_data});}' unless defined(&mi_sia_gp_data);
    eval 'sub mi_gpcontrol () { ($mi_un->{un_gpr}->{gpr_gpcontrol});}' unless defined(&mi_gpcontrol);
    eval 'sub mi_gpdata () { ($mi_un->{un_gpr}->{gpr_gpdata});}' unless defined(&mi_gpdata);
    eval 'sub mi_actmask () { ($mi_un->{un_gpr}->{gpr_actmask});}' unless defined(&mi_actmask);
    eval 'sub mi_actdata () { ($mi_un->{un_gpr}->{gpr_actdata});}' unless defined(&mi_actdata);
    eval 'sub mi_default () { ($mi_un->{un_gpr}->{gpr_default});}' unless defined(&mi_default);
    eval 'sub mi_cmdmode () { ($mi_un->{un_gpr}->{gpr_cmdmode});}' unless defined(&mi_cmdmode);
    eval 'sub mi_phyaddr () { ($mi_un->{un_mii}->{mii_phyaddr});}' unless defined(&mi_phyaddr);
    eval 'sub mi_gpr_length () { ($mi_un->{un_mii}->{mii_gpr_length});}' unless defined(&mi_gpr_length);
    eval 'sub mi_gpr_offset () { ($mi_un->{un_mii}->{mii_gpr_offset});}' unless defined(&mi_gpr_offset);
    eval 'sub mi_reset_length () { ($mi_un->{un_mii}->{mii_reset_length});}' unless defined(&mi_reset_length);
    eval 'sub mi_reset_offset () { ($mi_un->{un_mii}->{mii_reset_offset});}' unless defined(&mi_reset_offset);
    eval 'sub mi_capabilities () { ($mi_un->{un_mii}->{mii_capabilities});}' unless defined(&mi_capabilities);
    eval 'sub mi_advertisement () { ($mi_un->{un_mii}->{mii_advertisement});}' unless defined(&mi_advertisement);
    eval 'sub mi_full_duplex () { ($mi_un->{un_mii}->{mii_full_duplex});}' unless defined(&mi_full_duplex);
    eval 'sub mi_tx_threshold () { ($mi_un->{un_mii}->{mii_tx_threshold});}' unless defined(&mi_tx_threshold);
    eval 'sub mi_mediamask () { ($mi_un->{un_mii}->{mii_mediamask});}' unless defined(&mi_mediamask);
    eval 'sub mi_mii_interrupt () { ($mi_un->{un_mii}->{mii_interrupt});}' unless defined(&mi_mii_interrupt);
    eval 'sub mi_phyid () { ($mi_un->{un_mii}->{mii_phyid});}' unless defined(&mi_phyid);
    eval 'sub TULIP_MEDIAINFO_SIA_INIT {
        local($sc, $mi, $chipid, $media) = @_;
	    eval q( &do { ($mi)-> &mi_type =  &TULIP_MEDIAINFO_SIA;  ($sc->{tulip_mediums[&TULIP_MEDIA_##media]}) = ($mi); ($mi)-> &mi_sia_connectivity =  &TULIP_  $chipid   &_SIACONN_  $media; ($mi)-> &mi_sia_tx_rx =  &TULIP_  $chipid   &_SIATXRX_  $media; ($mi)-> &mi_sia_general =  &TULIP_  $chipid   &_SIAGEN_  $media; }  &while (0));
    }' unless defined(&TULIP_MEDIAINFO_SIA_INIT);
    eval 'sub TULIP_MEDIAINFO_ADD_CAPABILITY {
        local($sc, $mi, $media) = @_;
	    eval q( &do {  &if (($sc)-> $tulip_mediums[ &TULIP_MEDIA_  $media] ==  &NULL  && (($mi)-> &mi_capabilities &  &PHYSTS_  $media)) { ($sc)-> $tulip_mediums[ &TULIP_MEDIA_  $media] = ($mi); ($mi)-> &mi_mediamask |=  &TULIP_BIT( &TULIP_MEDIA_  $media); } }  &while (0));
    }' unless defined(&TULIP_MEDIAINFO_ADD_CAPABILITY);
    eval 'sub TULIP_MII_NOPHY () {32;}' unless defined(&TULIP_MII_NOPHY);
    eval("sub TULIP_21040_GENERIC () { 0; }") unless defined(&TULIP_21040_GENERIC);
    eval("sub TULIP_21140_ISV () { 1; }") unless defined(&TULIP_21140_ISV);
    eval("sub TULIP_21142_ISV () { 2; }") unless defined(&TULIP_21142_ISV);
    eval("sub TULIP_21143_ISV () { 3; }") unless defined(&TULIP_21143_ISV);
    eval("sub TULIP_21140_DEC_EB () { 4; }") unless defined(&TULIP_21140_DEC_EB);
    eval("sub TULIP_21140_MII () { 5; }") unless defined(&TULIP_21140_MII);
    eval("sub TULIP_21140_DEC_DE500 () { 6; }") unless defined(&TULIP_21140_DEC_DE500);
    eval("sub TULIP_21140_SMC_9332 () { 7; }") unless defined(&TULIP_21140_SMC_9332);
    eval("sub TULIP_21140_COGENT_EM100 () { 8; }") unless defined(&TULIP_21140_COGENT_EM100);
    eval("sub TULIP_21140_ZNYX_ZX34X () { 9; }") unless defined(&TULIP_21140_ZNYX_ZX34X);
    eval("sub TULIP_21140_ASANTE () { 10; }") unless defined(&TULIP_21140_ASANTE);
    eval("sub TULIP_21140_EN1207 () { 11; }") unless defined(&TULIP_21140_EN1207);
    eval("sub TULIP_21041_GENERIC () { 12; }") unless defined(&TULIP_21041_GENERIC);
    eval("sub TULIP_MEDIAPOLL_TIMER () { 0; }") unless defined(&TULIP_MEDIAPOLL_TIMER);
    eval("sub TULIP_MEDIAPOLL_FASTTIMER () { 1; }") unless defined(&TULIP_MEDIAPOLL_FASTTIMER);
    eval("sub TULIP_MEDIAPOLL_LINKFAIL () { 2; }") unless defined(&TULIP_MEDIAPOLL_LINKFAIL);
    eval("sub TULIP_MEDIAPOLL_LINKPASS () { 3; }") unless defined(&TULIP_MEDIAPOLL_LINKPASS);
    eval("sub TULIP_MEDIAPOLL_START () { 4; }") unless defined(&TULIP_MEDIAPOLL_START);
    eval("sub TULIP_MEDIAPOLL_TXPROBE_OK () { 5; }") unless defined(&TULIP_MEDIAPOLL_TXPROBE_OK);
    eval("sub TULIP_MEDIAPOLL_TXPROBE_FAILED () { 6; }") unless defined(&TULIP_MEDIAPOLL_TXPROBE_FAILED);
    eval("sub TULIP_MEDIAPOLL_MAX () { 7; }") unless defined(&TULIP_MEDIAPOLL_MAX);
    eval("sub TULIP_LINK_DOWN () { 0; }") unless defined(&TULIP_LINK_DOWN);
    eval("sub TULIP_LINK_UP () { 1; }") unless defined(&TULIP_LINK_UP);
    eval("sub TULIP_LINK_UNKNOWN () { 2; }") unless defined(&TULIP_LINK_UNKNOWN);
    if(defined( &__bsdi__)  && (defined(&_BSDI_VERSION) ? &_BSDI_VERSION : 0) >= 199701) {
    }
    eval("sub PHY_MODE_10T () { 0; }") unless defined(&PHY_MODE_10T);
    eval("sub PHY_MODE_100TX () { 1; }") unless defined(&PHY_MODE_100TX);
    eval("sub PHY_MODE_100T4 () { 2; }") unless defined(&PHY_MODE_100T4);
    eval("sub PHY_MODE_FULLDUPLEX () { 3; }") unless defined(&PHY_MODE_FULLDUPLEX);
    eval("sub PHY_MODE_MAX () { 4; }") unless defined(&PHY_MODE_MAX);
    eval 'sub PHY_NEED_HARD_RESET () {0x0001;}' unless defined(&PHY_NEED_HARD_RESET);
    eval 'sub PHY_DUAL_CYCLE_TA () {0x0002;}' unless defined(&PHY_DUAL_CYCLE_TA);
    if(defined(&TULIP_DEBUG)) {
    }
    eval("sub TULIP_PROBE_INACTIVE () { 0; }") unless defined(&TULIP_PROBE_INACTIVE);
    eval("sub TULIP_PROBE_PHYRESET () { 1; }") unless defined(&TULIP_PROBE_PHYRESET);
    eval("sub TULIP_PROBE_PHYAUTONEG () { 2; }") unless defined(&TULIP_PROBE_PHYAUTONEG);
    eval("sub TULIP_PROBE_GPRTEST () { 3; }") unless defined(&TULIP_PROBE_GPRTEST);
    eval("sub TULIP_PROBE_MEDIATEST () { 4; }") unless defined(&TULIP_PROBE_MEDIATEST);
    eval("sub TULIP_PROBE_FAILED () { 5; }") unless defined(&TULIP_PROBE_FAILED);
    if(defined( &__bsdi__)) {
	if((defined(&_BSDI_VERSION) ? &_BSDI_VERSION : 0) < 199401) {
	} else {
	    if((defined(&_BSDI_VERSION) ? &_BSDI_VERSION : 0) >= 199701) {
		eval 'sub tulip_ifmedia () { ($tulip_mii->{mii_media});}' unless defined(&tulip_ifmedia);
	    }
	}
    }
    if(defined( &__NetBSD__) || defined( &__OpenBSD__)) {
	if(!defined( &__OpenBSD__)) {
	}
    }
    if(!defined( &tulip_ifmedia)  && defined( &IFM_ETHER)) {
    }
    if(!defined( &__NetBSD__)) {
    }
    eval 'sub TULIP_WANTSETUP () {0x00000001;}' unless defined(&TULIP_WANTSETUP);
    eval 'sub TULIP_WANTHASHPERFECT () {0x00000002;}' unless defined(&TULIP_WANTHASHPERFECT);
    eval 'sub TULIP_WANTHASHONLY () {0x00000004;}' unless defined(&TULIP_WANTHASHONLY);
    eval 'sub TULIP_DOINGSETUP () {0x00000008;}' unless defined(&TULIP_DOINGSETUP);
    eval 'sub TULIP_PRINTMEDIA () {0x00000010;}' unless defined(&TULIP_PRINTMEDIA);
    eval 'sub TULIP_TXPROBE_ACTIVE () {0x00000020;}' unless defined(&TULIP_TXPROBE_ACTIVE);
    eval 'sub TULIP_ALLMULTI () {0x00000040;}' unless defined(&TULIP_ALLMULTI);
    eval 'sub TULIP_WANTRXACT () {0x00000080;}' unless defined(&TULIP_WANTRXACT);
    eval 'sub TULIP_RXACT () {0x00000100;}' unless defined(&TULIP_RXACT);
    eval 'sub TULIP_INRESET () {0x00000200;}' unless defined(&TULIP_INRESET);
    eval 'sub TULIP_NEEDRESET () {0x00000400;}' unless defined(&TULIP_NEEDRESET);
    eval 'sub TULIP_SQETEST () {0x00000800;}' unless defined(&TULIP_SQETEST);
    eval 'sub TULIP_xxxxxx0 () {0x00001000;}' unless defined(&TULIP_xxxxxx0);
    eval 'sub TULIP_xxxxxx1 () {0x00002000;}' unless defined(&TULIP_xxxxxx1);
    eval 'sub TULIP_WANTTXSTART () {0x00004000;}' unless defined(&TULIP_WANTTXSTART);
    eval 'sub TULIP_NEWTXTHRESH () {0x00008000;}' unless defined(&TULIP_NEWTXTHRESH);
    eval 'sub TULIP_NOAUTOSENSE () {0x00010000;}' unless defined(&TULIP_NOAUTOSENSE);
    eval 'sub TULIP_PRINTLINKUP () {0x00020000;}' unless defined(&TULIP_PRINTLINKUP);
    eval 'sub TULIP_LINKUP () {0x00040000;}' unless defined(&TULIP_LINKUP);
    eval 'sub TULIP_RXBUFSLOW () {0x00080000;}' unless defined(&TULIP_RXBUFSLOW);
    eval 'sub TULIP_NOMESSAGES () {0x00100000;}' unless defined(&TULIP_NOMESSAGES);
    eval 'sub TULIP_SYSTEMERROR () {0x00200000;}' unless defined(&TULIP_SYSTEMERROR);
    eval 'sub TULIP_TIMEOUTPENDING () {0x00400000;}' unless defined(&TULIP_TIMEOUTPENDING);
    eval 'sub TULIP_xxxxxx2 () {0x00800000;}' unless defined(&TULIP_xxxxxx2);
    eval 'sub TULIP_TRYNWAY () {0x01000000;}' unless defined(&TULIP_TRYNWAY);
    eval 'sub TULIP_DIDNWAY () {0x02000000;}' unless defined(&TULIP_DIDNWAY);
    eval 'sub TULIP_RXIGNORE () {0x04000000;}' unless defined(&TULIP_RXIGNORE);
    eval 'sub TULIP_PROBE1STPASS () {0x08000000;}' unless defined(&TULIP_PROBE1STPASS);
    eval 'sub TULIP_DEVICEPROBE () {0x10000000;}' unless defined(&TULIP_DEVICEPROBE);
    eval 'sub TULIP_PROMISC () {0x20000000;}' unless defined(&TULIP_PROMISC);
    eval 'sub TULIP_HASHONLY () {0x40000000;}' unless defined(&TULIP_HASHONLY);
    eval 'sub TULIP_xxxxxx3 () {0x80000000;}' unless defined(&TULIP_xxxxxx3);
    eval 'sub TULIP_HAVE_GPR () {0x00000001;}' unless defined(&TULIP_HAVE_GPR);
    eval 'sub TULIP_HAVE_RXBADOVRFLW () {0x00000002;}' unless defined(&TULIP_HAVE_RXBADOVRFLW);
    eval 'sub TULIP_HAVE_POWERMGMT () {0x00000004;}' unless defined(&TULIP_HAVE_POWERMGMT);
    eval 'sub TULIP_HAVE_MII () {0x00000008;}' unless defined(&TULIP_HAVE_MII);
    eval 'sub TULIP_HAVE_SIANWAY () {0x00000010;}' unless defined(&TULIP_HAVE_SIANWAY);
    eval 'sub TULIP_HAVE_DUALSENSE () {0x00000020;}' unless defined(&TULIP_HAVE_DUALSENSE);
    eval 'sub TULIP_HAVE_SIAGP () {0x00000040;}' unless defined(&TULIP_HAVE_SIAGP);
    eval 'sub TULIP_HAVE_BROKEN_HASH () {0x00000080;}' unless defined(&TULIP_HAVE_BROKEN_HASH);
    eval 'sub TULIP_HAVE_ISVSROM () {0x00000100;}' unless defined(&TULIP_HAVE_ISVSROM);
    eval 'sub TULIP_HAVE_BASEROM () {0x00000200;}' unless defined(&TULIP_HAVE_BASEROM);
    eval 'sub TULIP_HAVE_SLAVEDROM () {0x00000400;}' unless defined(&TULIP_HAVE_SLAVEDROM);
    eval 'sub TULIP_HAVE_SLAVEDINTR () {0x00000800;}' unless defined(&TULIP_HAVE_SLAVEDINTR);
    eval 'sub TULIP_HAVE_SHAREDINTR () {0x00001000;}' unless defined(&TULIP_HAVE_SHAREDINTR);
    eval 'sub TULIP_HAVE_OKROM () {0x00002000;}' unless defined(&TULIP_HAVE_OKROM);
    eval 'sub TULIP_HAVE_NOMEDIA () {0x00004000;}' unless defined(&TULIP_HAVE_NOMEDIA);
    eval 'sub TULIP_HAVE_STOREFWD () {0x00008000;}' unless defined(&TULIP_HAVE_STOREFWD);
    eval 'sub TULIP_HAVE_SIA100 () {0x00010000;}' unless defined(&TULIP_HAVE_SIA100);
    eval 'sub TULIP_HAVE_OKSROM () {0x00020000;}' unless defined(&TULIP_HAVE_OKSROM);
    eval 'sub tulip_probe_count () { ($tulip_probe->{probe_count});}' unless defined(&tulip_probe_count);
    eval 'sub tulip_probe_timeout () { ($tulip_probe->{probe_timeout});}' unless defined(&tulip_probe_timeout);
    eval 'sub tulip_probe_state () { ($tulip_probe->{probe_state});}' unless defined(&tulip_probe_state);
    eval 'sub tulip_probe_media () { ($tulip_probe->{probe_media});}' unless defined(&tulip_probe_media);
    eval 'sub tulip_probe_mediamask () { ($tulip_probe->{probe_mediamask});}' unless defined(&tulip_probe_mediamask);
    eval 'sub tulip_probe_passes () { ($tulip_probe->{probe_passes});}' unless defined(&tulip_probe_passes);
    if(defined( &TULIP_DEBUG)) {
    }
    if(defined( &TULIP_PERFSTATS)) {
	eval 'sub TULIP_PERF_CURRENT () {0;}' unless defined(&TULIP_PERF_CURRENT);
	eval 'sub TULIP_PERF_PREVIOUS () {1;}' unless defined(&TULIP_PERF_PREVIOUS);
	eval 'sub TULIP_PERF_TOTAL () {2;}' unless defined(&TULIP_PERF_TOTAL);
	eval 'sub TULIP_PERF_MAX () {3;}' unless defined(&TULIP_PERF_MAX);
	eval 'sub tulip_curperfstats () { $tulip_perfstats[ &TULIP_PERF_CURRENT];}' unless defined(&tulip_curperfstats);
    }
    if(defined( &__NetBSD__)) {
    } else {
    }
    if(defined( &__NetBSD__)  && (defined(&NRND) ? &NRND : 0) > 0) {
    }
    if(defined( &IFM_ETHER)) {
	eval 'sub TULIP_DO_AUTOSENSE {
	    local($sc) = @_;
    	    eval q(( &IFM_SUBTYPE(($sc)-> ($tulip_ifmedia->{ifm_media})) ==  &IFM_AUTO));
	}' unless defined(&TULIP_DO_AUTOSENSE);
    } else {
	eval 'sub TULIP_DO_AUTOSENSE {
	    local($sc) = @_;
    	    eval q(((($sc)-> &tulip_flags &  &TULIP_NOAUTOSENSE) == 0));
	}' unless defined(&TULIP_DO_AUTOSENSE);
    }
    if(defined( &TULIP_HDR_DATA)) {
	if(defined( &TULIP_EISA)) {
	} else {
	}
	if(defined( &IFM_ETHER)) {
	}
	eval 'sub TULIP_SROM_LASTCONNIDX () {($sizeof{ &tulip_srom_conninfo}/$sizeof{ $tulip_srom_conninfo[0]} - 1);}' unless defined(&TULIP_SROM_LASTCONNIDX);
    }
    eval 'sub TULIP_MAX_DEVICES () {32;}' unless defined(&TULIP_MAX_DEVICES);
    if(defined( &TULIP_USE_SOFTINTR)  && defined( &TULIP_HDR_DATA)) {
    }
    if(defined(&notyet)) {
	eval 'sub SIOCGADDRROM () { &_IOW(ord(\'i\'), 240, \'struct ifreq\');}' unless defined(&SIOCGADDRROM);
	eval 'sub SIOCGCHIPID () { &_IOWR(ord(\'i\'), 241, \'struct ifreq\');}' unless defined(&SIOCGCHIPID);
    }
    if(defined( &__FreeBSD__)) {
	if(defined( &TULIP_HDR_DATA)) {
	}
	if((defined(&BSD) ? &BSD : 0) >= 199506) {
	    eval 'sub TULIP_IFP_TO_SOFTC {
	        local($ifp) = @_;
    		eval q(((($ifp)-> &if_softc)));
	    }' unless defined(&TULIP_IFP_TO_SOFTC);
	    if((defined(&NBPFILTER) ? &NBPFILTER : 0) > 0) {
		eval 'sub TULIP_BPF_MTAP {
		    local($sc, $m) = @_;
    		    eval q( &bpf_mtap(($sc)-> &tulip_if, $m));
		}' unless defined(&TULIP_BPF_MTAP);
		eval 'sub TULIP_BPF_TAP {
		    local($sc, $p, $l) = @_;
    		    eval q( &bpf_tap(($sc)-> &tulip_if, $p, $l));
		}' unless defined(&TULIP_BPF_TAP);
		eval 'sub TULIP_BPF_ATTACH {
		    local($sc) = @_;
    		    eval q( &bpfattach(($sc)-> &tulip_if,  &DLT_EN10MB, $sizeof{\'struct ether_header\'}));
		}' unless defined(&TULIP_BPF_ATTACH);
	    }
	    eval 'sub tulip_intrfunc_t () { &void;}' unless defined(&tulip_intrfunc_t);
	    eval 'sub TULIP_VOID_INTRFUNC () {1;}' unless defined(&TULIP_VOID_INTRFUNC);
	    eval 'sub IFF_NOTRAILERS () {0;}' unless defined(&IFF_NOTRAILERS);
	    eval 'sub CLBYTES () { &PAGE_SIZE;}' unless defined(&CLBYTES);
	    if(0) {
		eval 'sub TULIP_KVATOPHYS {
		    local($sc, $va) = @_;
    		    eval q( &kvtop($va));
		}' unless defined(&TULIP_KVATOPHYS);
	    }
	    eval 'sub TULIP_EADDR_FMT () {"%6D";}' unless defined(&TULIP_EADDR_FMT);
	    eval 'sub TULIP_EADDR_ARGS {
	        local($addr) = @_;
    		eval q($addr, \\":\\");
	    }' unless defined(&TULIP_EADDR_ARGS);
	} else {
	    eval 'sub TULIP_IFP_TO_SOFTC {
	        local($ifp) = @_;
    		eval q(( &TULIP_UNIT_TO_SOFTC(($ifp)-> &if_unit)));
	    }' unless defined(&TULIP_IFP_TO_SOFTC);
	    require 'sys/devconf.ph';
	    eval 'sub TULIP_DEVCONF () {1;}' unless defined(&TULIP_DEVCONF);
	}
	if(defined( &TULIP_USE_SOFTINTR)) {
	}
	eval 'sub TULIP_UNIT_TO_SOFTC {
	    local($unit) = @_;
    	    eval q(( $tulips[$unit]));
	}' unless defined(&TULIP_UNIT_TO_SOFTC);
	eval 'sub TULIP_BURSTSIZE {
	    local($unit) = @_;
    	    eval q( &pci_max_burst_len);
	}' unless defined(&TULIP_BURSTSIZE);
	eval 'sub loudprintf () { &if  &printf;}' unless defined(&loudprintf);
    }
    if(defined( &__bsdi__)) {
	eval 'sub TULIP_UNIT_TO_SOFTC {
	    local($unit) = @_;
    	    eval q((  ($decd->{cd_devs[$unit]})));
	}' unless defined(&TULIP_UNIT_TO_SOFTC);
	eval 'sub TULIP_IFP_TO_SOFTC {
	    local($ifp) = @_;
    	    eval q(( &TULIP_UNIT_TO_SOFTC(($ifp)-> &if_unit)));
	}' unless defined(&TULIP_IFP_TO_SOFTC);
	eval 'sub TULIP_ETHER_IFATTACH {
	    local($sc) = @_;
    	    eval q( &ether_attach(($sc)-> &tulip_if));
	}' unless defined(&TULIP_ETHER_IFATTACH);
	if((defined(&_BSDI_VERSION) ? &_BSDI_VERSION : 0) >= 199510) {
	    if(0) {
		eval 'sub TULIP_BURSTSIZE {
		    local($unit) = @_;
    		    eval q( &log2_burst_size);
		}' unless defined(&TULIP_BURSTSIZE);
	    }
	    eval 'sub loudprintf () { &aprint_verbose;}' unless defined(&loudprintf);
	    eval 'sub printf () {(* ($sc->{tulip_pf}));}' unless defined(&printf);
	    eval 'sub MCNT {
	        local($x) = @_;
    		eval q(($sizeof{$x} / $sizeof{\'struct ifmedia_entry\'}));
	    }' unless defined(&MCNT);
	}
 elsif((defined(&_BSDI_VERSION) ? &_BSDI_VERSION : 0) <= 199401) {
	    eval 'sub DRQNONE () {0;}' unless defined(&DRQNONE);
	    eval 'sub loudprintf () { &printf;}' unless defined(&loudprintf);
	}
    }
    if(defined( &__NetBSD__) || defined( &__OpenBSD__)) {
	eval 'sub TULIP_UNIT_TO_SOFTC {
	    local($unit) = @_;
    	    eval q((  ($de_cd->{cd_devs[$unit]})));
	}' unless defined(&TULIP_UNIT_TO_SOFTC);
	eval 'sub TULIP_IFP_TO_SOFTC {
	    local($ifp) = @_;
    	    eval q(((($ifp)-> &if_softc)));
	}' unless defined(&TULIP_IFP_TO_SOFTC);
	eval 'sub tulip_unit () { ($tulip_dev->{dv_unit});}' unless defined(&tulip_unit);
	if(defined( &__OpenBSD__)) {
	    eval 'sub tulip_xname () { ($tulip_dev->{dv_cfdata}->{cf_driver}->{cd_name});}' unless defined(&tulip_xname);
	} else {
	    eval 'sub tulip_xname () { ($tulip_if->{if_xname});}' unless defined(&tulip_xname);
	}
	eval 'sub TULIP_RAISESPL () {
	    eval q( &splnet());
	}' unless defined(&TULIP_RAISESPL);
	eval 'sub TULIP_RAISESOFTSPL () {
	    eval q( &splsoftnet());
	}' unless defined(&TULIP_RAISESOFTSPL);
	eval 'sub TULIP_RESTORESPL {
	    local($s) = @_;
    	    eval q( &splx($s));
	}' unless defined(&TULIP_RESTORESPL);
	eval 'sub loudprintf () { &printf;}' unless defined(&loudprintf);
	if(!defined( &__OpenBSD__)) {
	    eval 'sub tulip_if () { ($tulip_ec->{ec_if});}' unless defined(&tulip_if);
	    eval 'sub tulip_enaddr () { &tulip_enaddr;}' unless defined(&tulip_enaddr);
	    eval 'sub tulip_multicnt () { ($tulip_ec->{ec_multicnt});}' unless defined(&tulip_multicnt);
	    eval 'sub TULIP_ETHERCOM {
	        local($sc) = @_;
    		eval q((($sc)-> &tulip_ec));
	    }' unless defined(&TULIP_ETHERCOM);
	    eval 'sub TULIP_ARP_IFINIT {
	        local($sc, $ifa) = @_;
    		eval q( &arp_ifinit(($sc)-> &tulip_if, ($ifa)));
	    }' unless defined(&TULIP_ARP_IFINIT);
	    eval 'sub TULIP_ETHER_IFATTACH {
	        local($sc) = @_;
    		eval q( &ether_ifattach(($sc)-> &tulip_if, ($sc)-> &tulip_enaddr));
	    }' unless defined(&TULIP_ETHER_IFATTACH);
	    eval 'sub TULIP_PRINTF_FMT () {"%s";}' unless defined(&TULIP_PRINTF_FMT);
	    eval 'sub TULIP_PRINTF_ARGS () { ($sc->{tulip_xname});}' unless defined(&TULIP_PRINTF_ARGS);
	} else {
	    eval 'sub TULIP_PRINTF_FMT () {"%s%d";}' unless defined(&TULIP_PRINTF_FMT);
	    eval 'sub TULIP_PRINTF_ARGS () { ($sc->{tulip_xname}),  ($sc->{tulip_unit});}' unless defined(&TULIP_PRINTF_ARGS);
	}
    }
    if(defined( &__alpha__)) {
	eval 'sub TULIP_KVATOPHYS {
	    local($sc, $va) = @_;
    	    eval q( &alpha_XXX_dmamap(($va)));
	}' unless defined(&TULIP_KVATOPHYS);
    }
    unless(defined(&TULIP_PRINTF_FMT)) {
	eval 'sub TULIP_PRINTF_FMT () {"%s%d";}' unless defined(&TULIP_PRINTF_FMT);
    }
    unless(defined(&TULIP_PRINTF_ARGS)) {
	eval 'sub TULIP_PRINTF_ARGS () { ($sc->{tulip_name}),  ($sc->{tulip_unit});}' unless defined(&TULIP_PRINTF_ARGS);
    }
    unless(defined(&TULIP_BURSTSIZE)) {
	eval 'sub TULIP_BURSTSIZE {
	    local($unit) = @_;
    	    eval q(3);
	}' unless defined(&TULIP_BURSTSIZE);
    }
    unless(defined(&tulip_if)) {
	eval 'sub tulip_if () { ($tulip_ac->{ac_if});}' unless defined(&tulip_if);
    }
    unless(defined(&tulip_unit)) {
	eval 'sub tulip_unit () { ($tulip_if->{if_unit});}' unless defined(&tulip_unit);
    }
    eval 'sub tulip_name () { ($tulip_if->{if_name});}' unless defined(&tulip_name);
    unless(defined(&tulip_enaddr)) {
	eval 'sub tulip_enaddr () { ($tulip_ac->{ac_enaddr});}' unless defined(&tulip_enaddr);
    }
    unless(defined(&tulip_multicnt)) {
	eval 'sub tulip_multicnt () { ($tulip_ac->{ac_multicnt});}' unless defined(&tulip_multicnt);
    }
    if(!defined( &TULIP_ETHERCOM)) {
	eval 'sub TULIP_ETHERCOM {
	    local($sc) = @_;
    	    eval q((($sc)-> &tulip_ac));
	}' unless defined(&TULIP_ETHERCOM);
    }
    if(!defined( &TULIP_ARP_IFINIT)) {
	eval 'sub TULIP_ARP_IFINIT {
	    local($sc, $ifa) = @_;
    	    eval q( &arp_ifinit( &TULIP_ETHERCOM($sc), ($ifa)));
	}' unless defined(&TULIP_ARP_IFINIT);
    }
    if(!defined( &TULIP_ETHER_IFATTACH)) {
	eval 'sub TULIP_ETHER_IFATTACH {
	    local($sc) = @_;
    	    eval q( &ether_ifattach(($sc)-> &tulip_if));
	}' unless defined(&TULIP_ETHER_IFATTACH);
    }
    if(!defined( &tulip_bpf)  && (!defined( &__bsdi__) || (defined(&_BSDI_VERSION) ? &_BSDI_VERSION : 0) >= 199401)) {
	eval 'sub tulip_bpf () { ($tulip_if->{if_bpf});}' unless defined(&tulip_bpf);
    }
    if(!defined( &tulip_intrfunc_t)) {
	eval 'sub tulip_intrfunc_t () {\'int\';}' unless defined(&tulip_intrfunc_t);
    }
    if(!defined( &TULIP_KVATOPHYS)) {
	eval 'sub TULIP_KVATOPHYS {
	    local($sc, $va) = @_;
    	    eval q( &vtophys($va));
	}' unless defined(&TULIP_KVATOPHYS);
    }
    unless(defined(&TULIP_RAISESPL)) {
	eval 'sub TULIP_RAISESPL () {
	    eval q( &splimp());
	}' unless defined(&TULIP_RAISESPL);
    }
    unless(defined(&TULIP_RAISESOFTSPL)) {
	eval 'sub TULIP_RAISESOFTSPL () {
	    eval q( &splnet());
	}' unless defined(&TULIP_RAISESOFTSPL);
    }
    unless(defined(&TULUP_RESTORESPL)) {
	eval 'sub TULIP_RESTORESPL {
	    local($s) = @_;
    	    eval q( &splx($s));
	}' unless defined(&TULIP_RESTORESPL);
    }
    if(!defined( &TULIP_BPF_MTAP)  && (defined(&NBPFILTER) ? &NBPFILTER : 0) > 0) {
	eval 'sub TULIP_BPF_MTAP {
	    local($sc, $m) = @_;
    	    eval q( &bpf_mtap(($sc)-> &tulip_bpf, $m));
	}' unless defined(&TULIP_BPF_MTAP);
	eval 'sub TULIP_BPF_TAP {
	    local($sc, $p, $l) = @_;
    	    eval q( &bpf_tap(($sc)-> &tulip_bpf, $p, $l));
	}' unless defined(&TULIP_BPF_TAP);
	eval 'sub TULIP_BPF_ATTACH {
	    local($sc) = @_;
    	    eval q( &bpfattach(($sc)-> &tulip_bpf, ($sc)-> &tulip_if,  &DLT_EN10MB, $sizeof{\'struct ether_header\'}));
	}' unless defined(&TULIP_BPF_ATTACH);
    }
    if(defined( &TULIP_PERFSTATS)) {
	eval 'sub TULIP_PERFMERGE {
	    local($sc, $member) = @_;
    	    eval q( &do { ($sc)-> ($tulip_perfstats[&TULIP_PERF_TOTAL]->{member})  += ($sc)-> ($tulip_perfstats[&TULIP_PERF_CURRENT]->{member}); ($sc)-> ($tulip_perfstats[&TULIP_PERF_PREVIOUS]->{member})  = ($sc)-> ($tulip_perfstats[&TULIP_PERF_CURRENT]->{member}); ($sc)-> ($tulip_perfstats[&TULIP_PERF_CURRENT]->{member}) = 0; }  &while (0));
	}' unless defined(&TULIP_PERFMERGE);
	eval 'sub TULIP_PERFSTART {
	    local($name) = @_;
    	    eval q( &const  &tulip_cycle_t  &perfstart_  $name =  &TULIP_PERFREAD(););
	}' unless defined(&TULIP_PERFSTART);
	eval 'sub TULIP_PERFEND {
	    local($name) = @_;
    	    eval q( &do { ( &sc)-> ($tulip_curperfstats->{perf_})  $name   &_cycles +=  &TULIP_PERFDIFF( &perfstart_  $name,  &TULIP_PERFREAD()); ( &sc)-> ($tulip_curperfstats->{perf_})  $name ++; }  &while (0));
	}' unless defined(&TULIP_PERFEND);
	if(defined( &__i386__)) {
	    eval 'sub TULIP_PERFDIFF {
	        local($s, $f) = @_;
    		eval q((($f) - ($s)));
	    }' unless defined(&TULIP_PERFDIFF);
	}
 elsif(defined( &__alpha__)) {
	    eval 'sub TULIP_PERFDIFF {
	        local($s, $f) = @_;
    		eval q(( (($f) - ($s))));
	    }' unless defined(&TULIP_PERFDIFF);
	}
    } else {
	eval 'sub TULIP_PERFSTART {
	    local($name) = @_;
    	    eval q();
	}' unless defined(&TULIP_PERFSTART);
	eval 'sub TULIP_PERFEND {
	    local($name) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&TULIP_PERFEND);
	eval 'sub TULIP_PERFMERGE {
	    local($s,$n) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&TULIP_PERFMERGE);
    }
    if(!defined( &TULIP_EADDR_FMT)) {
	eval 'sub TULIP_EADDR_FMT () {"%s";}' unless defined(&TULIP_EADDR_FMT);
	eval 'sub TULIP_EADDR_ARGS {
	    local($addr) = @_;
    	    eval q( &ether_sprintf($addr));
	}' unless defined(&TULIP_EADDR_ARGS);
    }
    eval 'sub TULIP_CRC32_POLY () {0xedb88320;}' unless defined(&TULIP_CRC32_POLY);
    eval 'sub TULIP_MAX_TXSEG () {30;}' unless defined(&TULIP_MAX_TXSEG);
    eval 'sub TULIP_ADDREQUAL {
        local($a1, $a2) = @_;
	    eval q(([0] == [0]  && [1] == [1]  && [2] == ($a2)[2]));
    }' unless defined(&TULIP_ADDREQUAL);
    eval 'sub TULIP_ADDRBRDCST {
        local($a1) = @_;
	    eval q(([0] == 0xffff  && [1] == 0xffff  && ($a1)[2] == 0xffff));
    }' unless defined(&TULIP_ADDRBRDCST);
}
1;
