require '_h2ph_pre.ph';

unless(defined(&PCMCIA_CCR_DCOR0)) {
    sub PCMCIA_CCR_DCOR0 () {	0x20;}
}
unless(defined(&PCMCIA_CCR_DCOR0_MRST_SFRST)) {
    sub PCMCIA_CCR_DCOR0_MRST_SFRST () {	0x80;}
}
unless(defined(&PCMCIA_CCR_DCOR0_MRST_SFPWDN)) {
    sub PCMCIA_CCR_DCOR0_MRST_SFPWDN () {	0x40;}
}
unless(defined(&PCMCIA_CCR_DCOR0_LED3_SFRST)) {
    sub PCMCIA_CCR_DCOR0_LED3_SFRST () {	0x20;}
}
unless(defined(&PCMCIA_CCR_DCOR0_LED3_SFPWDN)) {
    sub PCMCIA_CCR_DCOR0_LED3_SFPWDN () {	0x10;}
}
unless(defined(&PCMCIA_CCR_DCOR0_BUS)) {
    sub PCMCIA_CCR_DCOR0_BUS () {	0x08;}
}
unless(defined(&PCMCIA_CCR_DCOR0_DECODE)) {
    sub PCMCIA_CCR_DCOR0_DECODE () {	0x04;}
}
unless(defined(&PCMCIA_CCR_DCOR0_SFINT)) {
    sub PCMCIA_CCR_DCOR0_SFINT () {	0x01;}
}
unless(defined(&PCMCIA_CCR_DCOR1)) {
    sub PCMCIA_CCR_DCOR1 () {	0x22;}
}
unless(defined(&PCMCIA_CCR_DCOR1_SFCSR_WAIT)) {
    sub PCMCIA_CCR_DCOR1_SFCSR_WAIT () {	0xc0;}
}
unless(defined(&PCMCIA_CCR_DCOR1_SHADOW_SFIOB)) {
    sub PCMCIA_CCR_DCOR1_SHADOW_SFIOB () {	0x20;}
}
unless(defined(&PCMCIA_CCR_DCOR1_SHADOW_SFCSR)) {
    sub PCMCIA_CCR_DCOR1_SHADOW_SFCSR () {	0x10;}
}
unless(defined(&PCMCIA_CCR_DCOR1_FORCE_LEVIREQ)) {
    sub PCMCIA_CCR_DCOR1_FORCE_LEVIREQ () {	0x08;}
}
unless(defined(&PCMCIA_CCR_DCOR1_D6)) {
    sub PCMCIA_CCR_DCOR1_D6 () {	0x04;}
}
unless(defined(&PCMCIA_CCR_DCOR1_SF_STSCHG)) {
    sub PCMCIA_CCR_DCOR1_SF_STSCHG () {	0x02;}
}
unless(defined(&PCMCIA_CCR_DCOR1_SF_IREQ)) {
    sub PCMCIA_CCR_DCOR1_SF_IREQ () {	0x01;}
}
unless(defined(&PCMCIA_CCR_DCOR2)) {
    sub PCMCIA_CCR_DCOR2 () {	0x24;}
}
unless(defined(&PCMCIA_CCR_DCOR2_SHADOW_SFCOR)) {
    sub PCMCIA_CCR_DCOR2_SHADOW_SFCOR () {	0x10;}
}
unless(defined(&PCMCIA_CCR_DCOR2_SMEM_BASE)) {
    sub PCMCIA_CCR_DCOR2_SMEM_BASE () {	0x0f;}
}
unless(defined(&PCMCIA_CCR_DCOR3)) {
    sub PCMCIA_CCR_DCOR3 () {	0x26;}
}
unless(defined(&PCMCIA_CCR_DCOR4)) {
    sub PCMCIA_CCR_DCOR4 () {	0x28;}
}
unless(defined(&PCMCIA_CCR_SFCOR)) {
    sub PCMCIA_CCR_SFCOR () {	0x40;}
}
unless(defined(&PCMCIA_CCR_SFCOR_SRESET)) {
    sub PCMCIA_CCR_SFCOR_SRESET () {	0x80;}
}
unless(defined(&PCMCIA_CCR_SFCOR_LEVIREQ)) {
    sub PCMCIA_CCR_SFCOR_LEVIREQ () {	0x40;}
}
unless(defined(&PCMCIA_CCR_SFCOR_IRQ_STSCHG)) {
    sub PCMCIA_CCR_SFCOR_IRQ_STSCHG () {	0x20;}
}
unless(defined(&PCMCIA_CCR_SFCOR_CFINDEX)) {
    sub PCMCIA_CCR_SFCOR_CFINDEX () {	0x18;}
}
unless(defined(&PCMCIA_CCR_SFCOR_IREQ_ENABLE)) {
    sub PCMCIA_CCR_SFCOR_IREQ_ENABLE () {	0x04;}
}
unless(defined(&PCMCIA_CCR_SFCOR_ADDR_DECODE)) {
    sub PCMCIA_CCR_SFCOR_ADDR_DECODE () {	0x02;}
}
unless(defined(&PCMCIA_CCR_SFCOR_FUNC_ENABLE)) {
    sub PCMCIA_CCR_SFCOR_FUNC_ENABLE () {	0x01;}
}
unless(defined(&PCMCIA_CCR_SFCSR)) {
    sub PCMCIA_CCR_SFCSR () {	0x42;}
}
unless(defined(&PCMCIA_CCR_SFCSR_IOIS8)) {
    sub PCMCIA_CCR_SFCSR_IOIS8 () {	0x20;}
}
unless(defined(&PCMCIA_CCR_SFCSR_AUDIO)) {
    sub PCMCIA_CCR_SFCSR_AUDIO () {	0x08;}
}
unless(defined(&PCMCIA_CCR_SFCSR_PWRDWN)) {
    sub PCMCIA_CCR_SFCSR_PWRDWN () {	0x04;}
}
unless(defined(&PCMCIA_CCR_SFCSR_INTR)) {
    sub PCMCIA_CCR_SFCSR_INTR () {	0x02;}
}
unless(defined(&PCMCIA_CCR_SFCSR_INTRACK)) {
    sub PCMCIA_CCR_SFCSR_INTRACK () {	0x01;}
}
unless(defined(&PCMCIA_CCR_SFIOBASE0)) {
    sub PCMCIA_CCR_SFIOBASE0 () {	0x4a;}
}
unless(defined(&PCMCIA_CCR_SFIOBASE1)) {
    sub PCMCIA_CCR_SFIOBASE1 () {	0x4c;}
}
unless(defined(&PCMCIA_CCR_SFILR)) {
    sub PCMCIA_CCR_SFILR () {	0x52;}
}
unless(defined(&PCMCIA_CCR_SIZE_DINGO)) {
    sub PCMCIA_CCR_SIZE_DINGO () {	0x54;}
}
unless(defined(&CR)) {
    sub CR () {	0x0;}
}
unless(defined(&ESR)) {
    sub ESR () {	0x0;}
}
unless(defined(&PR)) {
    sub PR () {	0x1;}
}
unless(defined(&EDP)) {
    sub EDP () {	0x2;}
}
unless(defined(&ISR0)) {
    sub ISR0 () {	0x6;}
}
unless(defined(&GIR)) {
    sub GIR () {	0x7;}
}
unless(defined(&PTR)) {
    sub PTR () {	0xd;}
}
unless(defined(&TSO0)) {
    sub TSO0 () {	0x8;}
}
unless(defined(&TSO1)) {
    sub TSO1 () {	0x9;}
}
unless(defined(&TSO2)) {
    sub TSO2 () {	0xa;}
}
unless(defined(&DO0)) {
    sub DO0 () {	0xc;}
}
unless(defined(&DO1)) {
    sub DO1 () {	0xd;}
}
unless(defined(&RSR)) {
    sub RSR () {	0xc;}
}
unless(defined(&TPR)) {
    sub TPR () {	0xd;}
}
unless(defined(&RBC0)) {
    sub RBC0 () {	0xe;}
}
unless(defined(&RBC1)) {
    sub RBC1 () {	0xf;}
}
unless(defined(&IMR0)) {
    sub IMR0 () {	0xc;}
}
unless(defined(&IMR1)) {
    sub IMR1 () {	0xd;}
}
unless(defined(&ECR)) {
    sub ECR () {	0xe;}
}
unless(defined(&RBS0)) {
    sub RBS0 () {	0x8;}
}
unless(defined(&RBS1)) {
    sub RBS1 () {	0x9;}
}
unless(defined(&LED)) {
    sub LED () {	0xa;}
}
unless(defined(&LED3)) {
    sub LED3 () {	0xb;}
}
unless(defined(&MSR)) {
    sub MSR () {	0xc;}
}
unless(defined(&GP2)) {
    sub GP2 () {	0xd;}
}
unless(defined(&TPT0)) {
    sub TPT0 () {	0xa;}
}
unless(defined(&TPT1)) {
    sub TPT1 () {	0xb;}
}
unless(defined(&GP0)) {
    sub GP0 () {	0x8;}
}
unless(defined(&GP1)) {
    sub GP1 () {	0x9;}
}
unless(defined(&BV)) {
    sub BV () {	0xa;}
}
unless(defined(&EES)) {
    sub EES () {	0xb;}
}
unless(defined(&RHSA0)) {
    sub RHSA0 () {	0xa;}
}
unless(defined(&CMD0)) {
    sub CMD0 () {	0x8;}
}
unless(defined(&RXST0)) {
    sub RXST0 () {	0x9;}
}
unless(defined(&TXST0)) {
    sub TXST0 () {	0xb;}
}
unless(defined(&TXST1)) {
    sub TXST1 () {	0xc;}
}
unless(defined(&RX0MSK)) {
    sub RX0MSK () {	0xd;}
}
unless(defined(&TX0MSK)) {
    sub TX0MSK () {	0xe;}
}
unless(defined(&TX1MSK)) {
    sub TX1MSK () {	0xf;}
}
unless(defined(&SWC0)) {
    sub SWC0 () {	0x8;}
}
unless(defined(&SWC1)) {
    sub SWC1 () {	0x9;}
}
unless(defined(&IA)) {
    sub IA () {	0x8;}
}
unless(defined(&TX_PKT)) {
    sub TX_PKT () {	0x01;}
}
unless(defined(&SOFT_RESET)) {
    sub SOFT_RESET () {	0x02;}
}
unless(defined(&ENABLE_INT)) {
    sub ENABLE_INT () {	0x04;}
}
unless(defined(&FORCE_INT)) {
    sub FORCE_INT () {	0x08;}
}
unless(defined(&CLR_TX_FIFO)) {
    sub CLR_TX_FIFO () {	0x10;}
}
unless(defined(&CLR_RX_OVERRUN)) {
    sub CLR_RX_OVERRUN () {	0x20;}
}
unless(defined(&RESTART_TX)) {
    sub RESTART_TX () {	0x40;}
}
unless(defined(&FULL_PKT_RCV)) {
    sub FULL_PKT_RCV () {	0x01;}
}
unless(defined(&PKT_REJECTED)) {
    sub PKT_REJECTED () {	0x04;}
}
unless(defined(&TX_PKT_PEND)) {
    sub TX_PKT_PEND () {	0x08;}
}
unless(defined(&INCOR_POLARITY)) {
    sub INCOR_POLARITY () {	0x10;}
}
unless(defined(&MEDIA_SELECT)) {
    sub MEDIA_SELECT () {	0x20;}
}
unless(defined(&DO_OFF_MASK)) {
    sub DO_OFF_MASK () {	0x1fff;}
}
unless(defined(&DO_CHG_OFFSET)) {
    sub DO_CHG_OFFSET () {	0x2000;}
}
unless(defined(&DO_SHM_MODE)) {
    sub DO_SHM_MODE () {	0x4000;}
}
unless(defined(&DO_SKIP_RX_PKT)) {
    sub DO_SKIP_RX_PKT () {	0x8000;}
}
unless(defined(&RBC_COUNT_MASK)) {
    sub RBC_COUNT_MASK () {	0x1fff;}
}
unless(defined(&RBC_RX_FULL)) {
    sub RBC_RX_FULL () {	0x2000;}
}
unless(defined(&RBC_RX_PARTIAL)) {
    sub RBC_RX_PARTIAL () {	0x4000;}
}
unless(defined(&RBC_RX_PKT_REJ)) {
    sub RBC_RX_PKT_REJ () {	0x8000;}
}
unless(defined(&ISR_TX_OFLOW)) {
    sub ISR_TX_OFLOW () {	0x01;}
}
unless(defined(&ISR_PKT_TX)) {
    sub ISR_PKT_TX () {	0x02;}
}
unless(defined(&ISR_MAC_INT)) {
    sub ISR_MAC_INT () {	0x04;}
}
unless(defined(&ISR_RX_EARLY)) {
    sub ISR_RX_EARLY () {	0x10;}
}
unless(defined(&ISR_RX_FULL)) {
    sub ISR_RX_FULL () {	0x20;}
}
unless(defined(&ISR_RX_PKT_REJ)) {
    sub ISR_RX_PKT_REJ () {	0x40;}
}
unless(defined(&ISR_FORCED_INT)) {
    sub ISR_FORCED_INT () {	0x80;}
}
unless(defined(&ECR_EARLY_TX)) {
    sub ECR_EARLY_TX () {	0x01;}
}
unless(defined(&ECR_EARLY_RX)) {
    sub ECR_EARLY_RX () {	0x02;}
}
unless(defined(&ECR_FULL_DUPLEX)) {
    sub ECR_FULL_DUPLEX () {	0x04;}
}
unless(defined(&ECR_LNK_PLS_DIS)) {
    sub ECR_LNK_PLS_DIS () {	0x20;}
}
unless(defined(&ECR_SW_COMPAT)) {
    sub ECR_SW_COMPAT () {	0x80;}
}
unless(defined(&GP1_WR)) {
    sub GP1_WR () {	0x01;}
}
unless(defined(&GP2_WR)) {
    sub GP2_WR () {	0x02;}
}
unless(defined(&GP1_OUT)) {
    sub GP1_OUT () {	0x04;}
}
unless(defined(&GP2_OUT)) {
    sub GP2_OUT () {	0x08;}
}
unless(defined(&GP1_RD)) {
    sub GP1_RD () {	0x10;}
}
unless(defined(&GP2_RD)) {
    sub GP2_RD () {	0x20;}
}
unless(defined(&POWER_UP)) {
    sub POWER_UP () {	0x01;}
}
unless(defined(&LED0_SHIFT)) {
    sub LED0_SHIFT () {	0;}
}
unless(defined(&LED0_MASK)) {
    sub LED0_MASK () {	0x7;}
}
unless(defined(&LED1_SHIFT)) {
    sub LED1_SHIFT () {	3;}
}
unless(defined(&LED1_MASK)) {
    sub LED1_MASK () {	0x38;}
}
unless(defined(&LED0_RX_ENA)) {
    sub LED0_RX_ENA () {	0x40;}
}
unless(defined(&LED1_RX_ENA)) {
    sub LED1_RX_ENA () {	0x80;}
}
unless(defined(&LED3_SHIFT)) {
    sub LED3_SHIFT () {	0;}
}
unless(defined(&LED3_MASK)) {
    sub LED3_MASK () {	0x7;}
}
unless(defined(&LED3_RX_ENA)) {
    sub LED3_RX_ENA () {	0x40;}
}
unless(defined(&LED_DISABLE)) {
    sub LED_DISABLE () {	0;}
}
unless(defined(&LED_COLL_ACT)) {
    sub LED_COLL_ACT () {	1;}
}
unless(defined(&LED_COLL_INACT)) {
    sub LED_COLL_INACT () {	2;}
}
unless(defined(&LED_10MB_LINK)) {
    sub LED_10MB_LINK () {	3;}
}
unless(defined(&LED_100MB_LINK)) {
    sub LED_100MB_LINK () {	4;}
}
unless(defined(&LED_LINK)) {
    sub LED_LINK () {	5;}
}
unless(defined(&LED_AUTO)) {
    sub LED_AUTO () {	6;}
}
unless(defined(&LED_TX_ACT)) {
    sub LED_TX_ACT () {	7;}
}
unless(defined(&SRAM_128K_EXT)) {
    sub SRAM_128K_EXT () {	0x01;}
}
unless(defined(&RBS_BIT16)) {
    sub RBS_BIT16 () {	0x02;}
}
unless(defined(&SELECT_MII)) {
    sub SELECT_MII () {	0x08;}
}
unless(defined(&HASH_TBL_ENA)) {
    sub HASH_TBL_ENA () {	0x20;}
}
unless(defined(&GP3_WR)) {
    sub GP3_WR () {	0x01;}
}
unless(defined(&GP4_WR)) {
    sub GP4_WR () {	0x02;}
}
unless(defined(&GP3_OUT)) {
    sub GP3_OUT () {	0x04;}
}
unless(defined(&GP4_OUT)) {
    sub GP4_OUT () {	0x08;}
}
unless(defined(&GP3_RD)) {
    sub GP3_RD () {	0x10;}
}
unless(defined(&GP4_RD)) {
    sub GP4_RD () {	0x20;}
}
unless(defined(&RSR_NOTMCAST)) {
    sub RSR_NOTMCAST () {	0x01;}
}
unless(defined(&RSR_BCAST)) {
    sub RSR_BCAST () {	0x02;}
}
unless(defined(&RSR_TOO_LONG)) {
    sub RSR_TOO_LONG () {	0x04;}
}
unless(defined(&RSR_ALIGNERR)) {
    sub RSR_ALIGNERR () {	0x10;}
}
unless(defined(&RSR_CRCERR)) {
    sub RSR_CRCERR () {	0x20;}
}
unless(defined(&RSR_RX_OK)) {
    sub RSR_RX_OK () {	0x80;}
}
unless(defined(&ONLINE)) {
    sub ONLINE () {	0x04;}
}
unless(defined(&OFFLINE)) {
    sub OFFLINE () {	0x08;}
}
unless(defined(&ENABLE_RX)) {
    sub ENABLE_RX () {	0x20;}
}
unless(defined(&DISABLE_RX)) {
    sub DISABLE_RX () {	0x80;}
}
unless(defined(&PKT_TOO_LONG)) {
    sub PKT_TOO_LONG () {	0x02;}
}
unless(defined(&CRC_ERR)) {
    sub CRC_ERR () {	0x08;}
}
unless(defined(&RX_OVERRUN)) {
    sub RX_OVERRUN () {	0x10;}
}
unless(defined(&RX_ABORT)) {
    sub RX_ABORT () {	0x40;}
}
unless(defined(&RX_OK)) {
    sub RX_OK () {	0x80;}
}
unless(defined(&CARRIER_LOST)) {
    sub CARRIER_LOST () {	0x01;}
}
unless(defined(&EXCESSIVE_COLL)) {
    sub EXCESSIVE_COLL () {	0x02;}
}
unless(defined(&TX_UNDERRUN)) {
    sub TX_UNDERRUN () {	0x08;}
}
unless(defined(&LATE_COLLISION)) {
    sub LATE_COLLISION () {	0x10;}
}
unless(defined(&SQE)) {
    sub SQE () {	0x20;}
}
unless(defined(&TX_ABORT)) {
    sub TX_ABORT () {	0x40;}
}
unless(defined(&TX_OK)) {
    sub TX_OK () {	0x80;}
}
unless(defined(&SWC1_IND_ADDR)) {
    sub SWC1_IND_ADDR () {	0x01;}
}
unless(defined(&SWC1_MCAST_PROM)) {
    sub SWC1_MCAST_PROM () {	0x02;}
}
unless(defined(&SWC1_PROMISC)) {
    sub SWC1_PROMISC () {	0x04;}
}
unless(defined(&SWC1_BCAST_DIS)) {
    sub SWC1_BCAST_DIS () {	0x08;}
}
unless(defined(&SWC1_MEDIA_SEL)) {
    sub SWC1_MEDIA_SEL () {	0x40;}
}
unless(defined(&SWC1_AUTO_MEDIA)) {
    sub SWC1_AUTO_MEDIA () {	0x80;}
}
unless(defined(&PAGE)) {
    sub PAGE {
	local($sc, $page) = @_;
	eval q( &bus_space_write_1(( ($sc->{sc_bst})), ( ($sc->{sc_bsh})), ( ($sc->{sc_offset})) +  &PR, ($page)));
    }
}
unless(defined(&MDC_LOW)) {
    sub MDC_LOW () {	 &GP3_OUT;}
}
unless(defined(&MDC_HIGH)) {
    sub MDC_HIGH () {	( &GP3_OUT |  &GP3_WR);}
}
unless(defined(&MDIO_LOW)) {
    sub MDIO_LOW () {	 &GP4_OUT;}
}
unless(defined(&MDIO_HIGH)) {
    sub MDIO_HIGH () {	( &GP4_OUT |  &GP4_WR);}
}
unless(defined(&MDIO)) {
    sub MDIO () {	 &GP4_RD;}
}
unless(defined(&XEMEDIA_ETHER)) {
    sub XEMEDIA_ETHER () {	0x01;}
}
unless(defined(&XEMEDIA_TOKEN)) {
    sub XEMEDIA_TOKEN () {	0x02;}
}
unless(defined(&XEMEDIA_ARC)) {
    sub XEMEDIA_ARC () {	0x04;}
}
unless(defined(&XEMEDIA_WIRELESS)) {
    sub XEMEDIA_WIRELESS () {	0x08;}
}
unless(defined(&XEMEDIA_MODEM)) {
    sub XEMEDIA_MODEM () {	0x10;}
}
unless(defined(&XEMEDIA_GSM)) {
    sub XEMEDIA_GSM () {	0x20;}
}
unless(defined(&XEPROD_IDMASK)) {
    sub XEPROD_IDMASK () {	0x0f;}
}
unless(defined(&XEPROD_POCKET)) {
    sub XEPROD_POCKET () {	0x10;}
}
unless(defined(&XEPROD_EXTERNAL)) {
    sub XEPROD_EXTERNAL () {	0x20;}
}
unless(defined(&XEPROD_CREDITCARD)) {
    sub XEPROD_CREDITCARD () {	0x40;}
}
unless(defined(&XEPROD_CARDBUS)) {
    sub XEPROD_CARDBUS () {	0x80;}
}
1;
