require '_h2ph_pre.ph';

unless(defined(&TL_MAXFRAGS)) {
    sub TL_MAXFRAGS () {	10;}
}
unless(defined(&TL_RX_LIST_CNT)) {
    sub TL_RX_LIST_CNT () {	20;}
}
unless(defined(&TL_TX_LIST_CNT)) {
    sub TL_TX_LIST_CNT () {	20;}
}
unless(defined(&TL_MIN_FRAMELEN)) {
    sub TL_MIN_FRAMELEN () {	64;}
}
unless(defined(&TX_THR)) {
    sub TX_THR () {	0x00000004;}
}
unless(defined(&TL_FLAG_FORCEDELAY)) {
    sub TL_FLAG_FORCEDELAY () {	1;}
}
unless(defined(&TL_FLAG_SCHEDDELAY)) {
    sub TL_FLAG_SCHEDDELAY () {	2;}
}
unless(defined(&TL_FLAG_DELAYTIMEO)) {
    sub TL_FLAG_DELAYTIMEO () {	3;}
}
unless(defined(&TL_PHYADDR_MIN)) {
    sub TL_PHYADDR_MIN () {	0x00;}
}
unless(defined(&TL_PHYADDR_MAX)) {
    sub TL_PHYADDR_MAX () {	0x1f;}
}
unless(defined(&PHY_UNKNOWN)) {
    sub PHY_UNKNOWN () {	6;}
}
unless(defined(&TL_PHYS_IDLE)) {
    sub TL_PHYS_IDLE () {	-1;}
}
unless(defined(&TI_VENDORID)) {
    sub TI_VENDORID () {	0x104c;}
}
unless(defined(&TI_DEVICEID_THUNDERLAN)) {
    sub TI_DEVICEID_THUNDERLAN () {	0x0500;}
}
unless(defined(&TI_PHY_VENDORID)) {
    sub TI_PHY_VENDORID () {	0x4000;}
}
unless(defined(&TI_PHY_10BT)) {
    sub TI_PHY_10BT () {	0x501f;}
}
unless(defined(&TI_PHY_100VGPMI)) {
    sub TI_PHY_100VGPMI () {	0x502f;}
}
unless(defined(&NS_PHY_VENDORID)) {
    sub NS_PHY_VENDORID () {	0x2000;}
}
unless(defined(&NS_PHY_83840A)) {
    sub NS_PHY_83840A () {	0x5c0f;}
}
unless(defined(&LEVEL1_PHY_VENDORID)) {
    sub LEVEL1_PHY_VENDORID () {	0x7810;}
}
unless(defined(&LEVEL1_PHY_LXT970)) {
    sub LEVEL1_PHY_LXT970 () {	0x000f;}
}
unless(defined(&INTEL_PHY_VENDORID)) {
    sub INTEL_PHY_VENDORID () {	0x0a28;}
}
unless(defined(&INTEL_PHY_82555)) {
    sub INTEL_PHY_82555 () {	0x015f;}
}
unless(defined(&SEEQ_PHY_VENDORID)) {
    sub SEEQ_PHY_VENDORID () {	0x0016;}
}
unless(defined(&SEEQ_PHY_80220)) {
    sub SEEQ_PHY_80220 () {	0xf83f;}
}
unless(defined(&COMPAQ_VENDORID)) {
    sub COMPAQ_VENDORID () {	0x0e11;}
}
unless(defined(&COMPAQ_DEVICEID_NETEL_10_100)) {
    sub COMPAQ_DEVICEID_NETEL_10_100 () {	0xae32;}
}
unless(defined(&COMPAQ_DEVICEID_NETEL_UNKNOWN)) {
    sub COMPAQ_DEVICEID_NETEL_UNKNOWN () {	0xae33;}
}
unless(defined(&COMPAQ_DEVICEID_NETEL_10)) {
    sub COMPAQ_DEVICEID_NETEL_10 () {	0xae34;}
}
unless(defined(&COMPAQ_DEVICEID_NETFLEX_3P_INTEGRATED)) {
    sub COMPAQ_DEVICEID_NETFLEX_3P_INTEGRATED () {	0xae35;}
}
unless(defined(&COMPAQ_DEVICEID_NETEL_10_100_DUAL)) {
    sub COMPAQ_DEVICEID_NETEL_10_100_DUAL () {	0xae40;}
}
unless(defined(&COMPAQ_DEVICEID_NETEL_10_100_PROLIANT)) {
    sub COMPAQ_DEVICEID_NETEL_10_100_PROLIANT () {	0xae43;}
}
unless(defined(&COMPAQ_DEVICEID_NETEL_10_100_EMBEDDED)) {
    sub COMPAQ_DEVICEID_NETEL_10_100_EMBEDDED () {	0xb011;}
}
unless(defined(&COMPAQ_DEVICEID_NETEL_10_T2_UTP_COAX)) {
    sub COMPAQ_DEVICEID_NETEL_10_T2_UTP_COAX () {	0xb012;}
}
unless(defined(&COMPAQ_DEVICEID_NETEL_10_100_TX_UTP)) {
    sub COMPAQ_DEVICEID_NETEL_10_100_TX_UTP () {	0xb030;}
}
unless(defined(&COMPAQ_DEVICEID_NETFLEX_3P)) {
    sub COMPAQ_DEVICEID_NETFLEX_3P () {	0xf130;}
}
unless(defined(&COMPAQ_DEVICEID_NETFLEX_3P_BNC)) {
    sub COMPAQ_DEVICEID_NETFLEX_3P_BNC () {	0xf150;}
}
unless(defined(&OLICOM_VENDORID)) {
    sub OLICOM_VENDORID () {	0x108d;}
}
unless(defined(&OLICOM_DEVICEID_OC2183)) {
    sub OLICOM_DEVICEID_OC2183 () {	0x0013;}
}
unless(defined(&OLICOM_DEVICEID_OC2325)) {
    sub OLICOM_DEVICEID_OC2325 () {	0x0012;}
}
unless(defined(&OLICOM_DEVICEID_OC2326)) {
    sub OLICOM_DEVICEID_OC2326 () {	0x0014;}
}
unless(defined(&TL_PCI_LOIO)) {
    sub TL_PCI_LOIO () {	0x10;}
}
unless(defined(&TL_PCI_LOMEM)) {
    sub TL_PCI_LOMEM () {	0x14;}
}
unless(defined(&TL_PCI_LATENCY_TIMER)) {
    sub TL_PCI_LATENCY_TIMER () {	0x0c;}
}
unless(defined(&TL_DIO_ADDR_INC)) {
    sub TL_DIO_ADDR_INC () {	0x8000;}
}
unless(defined(&TL_DIO_RAM_SEL)) {
    sub TL_DIO_RAM_SEL () {	0x4000;}
}
unless(defined(&TL_DIO_ADDR_MASK)) {
    sub TL_DIO_ADDR_MASK () {	0x3fff;}
}
unless(defined(&TL_INTR_INVALID)) {
    sub TL_INTR_INVALID () {	0x0;}
}
unless(defined(&TL_INTR_TXEOF)) {
    sub TL_INTR_TXEOF () {	0x1;}
}
unless(defined(&TL_INTR_STATOFLOW)) {
    sub TL_INTR_STATOFLOW () {	0x2;}
}
unless(defined(&TL_INTR_RXEOF)) {
    sub TL_INTR_RXEOF () {	0x3;}
}
unless(defined(&TL_INTR_DUMMY)) {
    sub TL_INTR_DUMMY () {	0x4;}
}
unless(defined(&TL_INTR_TXEOC)) {
    sub TL_INTR_TXEOC () {	0x5;}
}
unless(defined(&TL_INTR_ADCHK)) {
    sub TL_INTR_ADCHK () {	0x6;}
}
unless(defined(&TL_INTR_RXEOC)) {
    sub TL_INTR_RXEOC () {	0x7;}
}
unless(defined(&TL_INT_MASK)) {
    sub TL_INT_MASK () {	0x001c;}
}
unless(defined(&TL_VEC_MASK)) {
    sub TL_VEC_MASK () {	0x1fe0;}
}
unless(defined(&TL_CMD_GO)) {
    sub TL_CMD_GO () {	0x80000000;}
}
unless(defined(&TL_CMD_STOP)) {
    sub TL_CMD_STOP () {	0x40000000;}
}
unless(defined(&TL_CMD_ACK)) {
    sub TL_CMD_ACK () {	0x20000000;}
}
unless(defined(&TL_CMD_CHSEL7)) {
    sub TL_CMD_CHSEL7 () {	0x10000000;}
}
unless(defined(&TL_CMD_CHSEL6)) {
    sub TL_CMD_CHSEL6 () {	0x08000000;}
}
unless(defined(&TL_CMD_CHSEL5)) {
    sub TL_CMD_CHSEL5 () {	0x04000000;}
}
unless(defined(&TL_CMD_CHSEL4)) {
    sub TL_CMD_CHSEL4 () {	0x02000000;}
}
unless(defined(&TL_CMD_CHSEL3)) {
    sub TL_CMD_CHSEL3 () {	0x01000000;}
}
unless(defined(&TL_CMD_CHSEL2)) {
    sub TL_CMD_CHSEL2 () {	0x00800000;}
}
unless(defined(&TL_CMD_CHSEL1)) {
    sub TL_CMD_CHSEL1 () {	0x00400000;}
}
unless(defined(&TL_CMD_CHSEL0)) {
    sub TL_CMD_CHSEL0 () {	0x00200000;}
}
unless(defined(&TL_CMD_EOC)) {
    sub TL_CMD_EOC () {	0x00100000;}
}
unless(defined(&TL_CMD_RT)) {
    sub TL_CMD_RT () {	0x00080000;}
}
unless(defined(&TL_CMD_NES)) {
    sub TL_CMD_NES () {	0x00040000;}
}
unless(defined(&TL_CMD_ZERO0)) {
    sub TL_CMD_ZERO0 () {	0x00020000;}
}
unless(defined(&TL_CMD_ZERO1)) {
    sub TL_CMD_ZERO1 () {	0x00010000;}
}
unless(defined(&TL_CMD_ADRST)) {
    sub TL_CMD_ADRST () {	0x00008000;}
}
unless(defined(&TL_CMD_LDTMR)) {
    sub TL_CMD_LDTMR () {	0x00004000;}
}
unless(defined(&TL_CMD_LDTHR)) {
    sub TL_CMD_LDTHR () {	0x00002000;}
}
unless(defined(&TL_CMD_REQINT)) {
    sub TL_CMD_REQINT () {	0x00001000;}
}
unless(defined(&TL_CMD_INTSOFF)) {
    sub TL_CMD_INTSOFF () {	0x00000800;}
}
unless(defined(&TL_CMD_INTSON)) {
    sub TL_CMD_INTSON () {	0x00000400;}
}
unless(defined(&TL_CMD_RSVD0)) {
    sub TL_CMD_RSVD0 () {	0x00000200;}
}
unless(defined(&TL_CMD_RSVD1)) {
    sub TL_CMD_RSVD1 () {	0x00000100;}
}
unless(defined(&TL_CMD_ACK7)) {
    sub TL_CMD_ACK7 () {	0x00000080;}
}
unless(defined(&TL_CMD_ACK6)) {
    sub TL_CMD_ACK6 () {	0x00000040;}
}
unless(defined(&TL_CMD_ACK5)) {
    sub TL_CMD_ACK5 () {	0x00000020;}
}
unless(defined(&TL_CMD_ACK4)) {
    sub TL_CMD_ACK4 () {	0x00000010;}
}
unless(defined(&TL_CMD_ACK3)) {
    sub TL_CMD_ACK3 () {	0x00000008;}
}
unless(defined(&TL_CMD_ACK2)) {
    sub TL_CMD_ACK2 () {	0x00000004;}
}
unless(defined(&TL_CMD_ACK1)) {
    sub TL_CMD_ACK1 () {	0x00000002;}
}
unless(defined(&TL_CMD_ACK0)) {
    sub TL_CMD_ACK0 () {	0x00000001;}
}
unless(defined(&TL_CMD_CHSEL_MASK)) {
    sub TL_CMD_CHSEL_MASK () {	0x01fe0000;}
}
unless(defined(&TL_CMD_ACK_MASK)) {
    sub TL_CMD_ACK_MASK () {	0xff;}
}
unless(defined(&TL_EEPROM_EADDR)) {
    sub TL_EEPROM_EADDR () {	0x83;}
}
unless(defined(&TL_EEPROM_EADDR2)) {
    sub TL_EEPROM_EADDR2 () {	0x99;}
}
unless(defined(&TL_EEPROM_EADDR3)) {
    sub TL_EEPROM_EADDR3 () {	0xaf;}
}
unless(defined(&TL_EEPROM_EADDR_OC)) {
    sub TL_EEPROM_EADDR_OC () {	0xf8;}
}
unless(defined(&TL_HOSTCMD)) {
    sub TL_HOSTCMD () {	0x00;}
}
unless(defined(&TL_CH_PARM)) {
    sub TL_CH_PARM () {	0x04;}
}
unless(defined(&TL_DIO_ADDR)) {
    sub TL_DIO_ADDR () {	0x08;}
}
unless(defined(&TL_HOST_INT)) {
    sub TL_HOST_INT () {	0x0a;}
}
unless(defined(&TL_DIO_DATA)) {
    sub TL_DIO_DATA () {	0x0c;}
}
unless(defined(&TL_NETCMD)) {
    sub TL_NETCMD () {	0x00;}
}
unless(defined(&TL_NETSIO)) {
    sub TL_NETSIO () {	0x01;}
}
unless(defined(&TL_NETSTS)) {
    sub TL_NETSTS () {	0x02;}
}
unless(defined(&TL_NETMASK)) {
    sub TL_NETMASK () {	0x03;}
}
unless(defined(&TL_NETCONFIG)) {
    sub TL_NETCONFIG () {	0x04;}
}
unless(defined(&TL_MANTEST)) {
    sub TL_MANTEST () {	0x06;}
}
unless(defined(&TL_VENID_LSB)) {
    sub TL_VENID_LSB () {	0x08;}
}
unless(defined(&TL_VENID_MSB)) {
    sub TL_VENID_MSB () {	0x09;}
}
unless(defined(&TL_DEVID_LSB)) {
    sub TL_DEVID_LSB () {	0x0a;}
}
unless(defined(&TL_DEVID_MSB)) {
    sub TL_DEVID_MSB () {	0x0b;}
}
unless(defined(&TL_REVISION)) {
    sub TL_REVISION () {	0x0c;}
}
unless(defined(&TL_SUBCLASS)) {
    sub TL_SUBCLASS () {	0x0d;}
}
unless(defined(&TL_MINLAT)) {
    sub TL_MINLAT () {	0x0e;}
}
unless(defined(&TL_MAXLAT)) {
    sub TL_MAXLAT () {	0x0f;}
}
unless(defined(&TL_AREG0_B5)) {
    sub TL_AREG0_B5 () {	0x10;}
}
unless(defined(&TL_AREG0_B4)) {
    sub TL_AREG0_B4 () {	0x11;}
}
unless(defined(&TL_AREG0_B3)) {
    sub TL_AREG0_B3 () {	0x12;}
}
unless(defined(&TL_AREG0_B2)) {
    sub TL_AREG0_B2 () {	0x13;}
}
unless(defined(&TL_AREG0_B1)) {
    sub TL_AREG0_B1 () {	0x14;}
}
unless(defined(&TL_AREG0_B0)) {
    sub TL_AREG0_B0 () {	0x15;}
}
unless(defined(&TL_AREG1_B5)) {
    sub TL_AREG1_B5 () {	0x16;}
}
unless(defined(&TL_AREG1_B4)) {
    sub TL_AREG1_B4 () {	0x17;}
}
unless(defined(&TL_AREG1_B3)) {
    sub TL_AREG1_B3 () {	0x18;}
}
unless(defined(&TL_AREG1_B2)) {
    sub TL_AREG1_B2 () {	0x19;}
}
unless(defined(&TL_AREG1_B1)) {
    sub TL_AREG1_B1 () {	0x1a;}
}
unless(defined(&TL_AREG1_B0)) {
    sub TL_AREG1_B0 () {	0x1b;}
}
unless(defined(&TL_AREG2_B5)) {
    sub TL_AREG2_B5 () {	0x1c;}
}
unless(defined(&TL_AREG2_B4)) {
    sub TL_AREG2_B4 () {	0x1d;}
}
unless(defined(&TL_AREG2_B3)) {
    sub TL_AREG2_B3 () {	0x1e;}
}
unless(defined(&TL_AREG2_B2)) {
    sub TL_AREG2_B2 () {	0x1f;}
}
unless(defined(&TL_AREG2_B1)) {
    sub TL_AREG2_B1 () {	0x20;}
}
unless(defined(&TL_AREG2_B0)) {
    sub TL_AREG2_B0 () {	0x21;}
}
unless(defined(&TL_AREG3_B5)) {
    sub TL_AREG3_B5 () {	0x22;}
}
unless(defined(&TL_AREG3_B4)) {
    sub TL_AREG3_B4 () {	0x23;}
}
unless(defined(&TL_AREG3_B3)) {
    sub TL_AREG3_B3 () {	0x24;}
}
unless(defined(&TL_AREG3_B2)) {
    sub TL_AREG3_B2 () {	0x25;}
}
unless(defined(&TL_AREG3_B1)) {
    sub TL_AREG3_B1 () {	0x26;}
}
unless(defined(&TL_AREG3_B0)) {
    sub TL_AREG3_B0 () {	0x27;}
}
unless(defined(&TL_HASH1)) {
    sub TL_HASH1 () {	0x28;}
}
unless(defined(&TL_HASH2)) {
    sub TL_HASH2 () {	0x2c;}
}
unless(defined(&TL_TXGOODFRAMES)) {
    sub TL_TXGOODFRAMES () {	0x30;}
}
unless(defined(&TL_TXUNDERRUN)) {
    sub TL_TXUNDERRUN () {	0x33;}
}
unless(defined(&TL_RXGOODFRAMES)) {
    sub TL_RXGOODFRAMES () {	0x34;}
}
unless(defined(&TL_RXOVERRUN)) {
    sub TL_RXOVERRUN () {	0x37;}
}
unless(defined(&TL_DEFEREDTX)) {
    sub TL_DEFEREDTX () {	0x38;}
}
unless(defined(&TL_CRCERROR)) {
    sub TL_CRCERROR () {	0x3a;}
}
unless(defined(&TL_CODEERROR)) {
    sub TL_CODEERROR () {	0x3b;}
}
unless(defined(&TL_MULTICOLTX)) {
    sub TL_MULTICOLTX () {	0x3c;}
}
unless(defined(&TL_SINGLECOLTX)) {
    sub TL_SINGLECOLTX () {	0x3e;}
}
unless(defined(&TL_EXCESSIVECOL)) {
    sub TL_EXCESSIVECOL () {	0x40;}
}
unless(defined(&TL_LATECOL)) {
    sub TL_LATECOL () {	0x41;}
}
unless(defined(&TL_CARRIERLOSS)) {
    sub TL_CARRIERLOSS () {	0x42;}
}
unless(defined(&TL_ACOMMIT)) {
    sub TL_ACOMMIT () {	0x43;}
}
unless(defined(&TL_LDREG)) {
    sub TL_LDREG () {	0x44;}
}
unless(defined(&TL_BSIZEREG)) {
    sub TL_BSIZEREG () {	0x45;}
}
unless(defined(&TL_MAXRX)) {
    sub TL_MAXRX () {	0x46;}
}
unless(defined(&TL_SIO_MINTEN)) {
    sub TL_SIO_MINTEN () {	0x80;}
}
unless(defined(&TL_SIO_ECLOK)) {
    sub TL_SIO_ECLOK () {	0x40;}
}
unless(defined(&TL_SIO_ETXEN)) {
    sub TL_SIO_ETXEN () {	0x20;}
}
unless(defined(&TL_SIO_EDATA)) {
    sub TL_SIO_EDATA () {	0x10;}
}
unless(defined(&TL_SIO_NMRST)) {
    sub TL_SIO_NMRST () {	0x08;}
}
unless(defined(&TL_SIO_MCLK)) {
    sub TL_SIO_MCLK () {	0x04;}
}
unless(defined(&TL_SIO_MTXEN)) {
    sub TL_SIO_MTXEN () {	0x02;}
}
unless(defined(&TL_SIO_MDATA)) {
    sub TL_SIO_MDATA () {	0x01;}
}
unless(defined(&TL_CFG_RCLKTEST)) {
    sub TL_CFG_RCLKTEST () {	0x8000;}
}
unless(defined(&TL_CFG_TCLKTEST)) {
    sub TL_CFG_TCLKTEST () {	0x4000;}
}
unless(defined(&TL_CFG_BITRATE)) {
    sub TL_CFG_BITRATE () {	0x2000;}
}
unless(defined(&TL_CFG_RXCRC)) {
    sub TL_CFG_RXCRC () {	0x1000;}
}
unless(defined(&TL_CFG_PEF)) {
    sub TL_CFG_PEF () {	0x0800;}
}
unless(defined(&TL_CFG_ONEFRAG)) {
    sub TL_CFG_ONEFRAG () {	0x0400;}
}
unless(defined(&TL_CFG_ONECHAN)) {
    sub TL_CFG_ONECHAN () {	0x0200;}
}
unless(defined(&TL_CFG_MTEST)) {
    sub TL_CFG_MTEST () {	0x0100;}
}
unless(defined(&TL_CFG_PHYEN)) {
    sub TL_CFG_PHYEN () {	0x0080;}
}
unless(defined(&TL_CFG_MACSEL6)) {
    sub TL_CFG_MACSEL6 () {	0x0040;}
}
unless(defined(&TL_CFG_MACSEL5)) {
    sub TL_CFG_MACSEL5 () {	0x0020;}
}
unless(defined(&TL_CFG_MACSEL4)) {
    sub TL_CFG_MACSEL4 () {	0x0010;}
}
unless(defined(&TL_CFG_MACSEL3)) {
    sub TL_CFG_MACSEL3 () {	0x0008;}
}
unless(defined(&TL_CFG_MACSEL2)) {
    sub TL_CFG_MACSEL2 () {	0x0004;}
}
unless(defined(&TL_CFG_MACSEL1)) {
    sub TL_CFG_MACSEL1 () {	0x0002;}
}
unless(defined(&TL_CFG_MACSEL0)) {
    sub TL_CFG_MACSEL0 () {	0x0001;}
}
unless(defined(&TL_STS_MIRQ)) {
    sub TL_STS_MIRQ () {	0x80;}
}
unless(defined(&TL_STS_HBEAT)) {
    sub TL_STS_HBEAT () {	0x40;}
}
unless(defined(&TL_STS_TXSTOP)) {
    sub TL_STS_TXSTOP () {	0x20;}
}
unless(defined(&TL_STS_RXSTOP)) {
    sub TL_STS_RXSTOP () {	0x10;}
}
unless(defined(&TL_CMD_NRESET)) {
    sub TL_CMD_NRESET () {	0x80;}
}
unless(defined(&TL_CMD_NWRAP)) {
    sub TL_CMD_NWRAP () {	0x40;}
}
unless(defined(&TL_CMD_CSF)) {
    sub TL_CMD_CSF () {	0x20;}
}
unless(defined(&TL_CMD_CAF)) {
    sub TL_CMD_CAF () {	0x10;}
}
unless(defined(&TL_CMD_NOBRX)) {
    sub TL_CMD_NOBRX () {	0x08;}
}
unless(defined(&TL_CMD_DUPLEX)) {
    sub TL_CMD_DUPLEX () {	0x04;}
}
unless(defined(&TL_CMD_TRFRAM)) {
    sub TL_CMD_TRFRAM () {	0x02;}
}
unless(defined(&TL_CMD_TXPACE)) {
    sub TL_CMD_TXPACE () {	0x01;}
}
unless(defined(&TL_MASK_MASK7)) {
    sub TL_MASK_MASK7 () {	0x80;}
}
unless(defined(&TL_MASK_MASK6)) {
    sub TL_MASK_MASK6 () {	0x40;}
}
unless(defined(&TL_MASK_MASK5)) {
    sub TL_MASK_MASK5 () {	0x20;}
}
unless(defined(&TL_MASK_MASK4)) {
    sub TL_MASK_MASK4 () {	0x10;}
}
if(defined(&ANSI_DOESNT_ALLOW_BITFIELDS)) {
} else {
}
unless(defined(&TL_MII_STARTDELIM)) {
    sub TL_MII_STARTDELIM () {	0x01;}
}
unless(defined(&TL_MII_READOP)) {
    sub TL_MII_READOP () {	0x02;}
}
unless(defined(&TL_MII_WRITEOP)) {
    sub TL_MII_WRITEOP () {	0x01;}
}
unless(defined(&TL_MII_TURNAROUND)) {
    sub TL_MII_TURNAROUND () {	0x02;}
}
unless(defined(&TL_LAST_FRAG)) {
    sub TL_LAST_FRAG () {	0x80000000;}
}
unless(defined(&TL_CSTAT_UNUSED)) {
    sub TL_CSTAT_UNUSED () {	0x8000;}
}
unless(defined(&TL_CSTAT_FRAMECMP)) {
    sub TL_CSTAT_FRAMECMP () {	0x4000;}
}
unless(defined(&TL_CSTAT_READY)) {
    sub TL_CSTAT_READY () {	0x3000;}
}
unless(defined(&TL_CSTAT_UNUSED13)) {
    sub TL_CSTAT_UNUSED13 () {	0x2000;}
}
unless(defined(&TL_CSTAT_UNUSED12)) {
    sub TL_CSTAT_UNUSED12 () {	0x1000;}
}
unless(defined(&TL_CSTAT_EOC)) {
    sub TL_CSTAT_EOC () {	0x0800;}
}
unless(defined(&TL_CSTAT_RXERROR)) {
    sub TL_CSTAT_RXERROR () {	0x0400;}
}
unless(defined(&TL_CSTAT_PASSCRC)) {
    sub TL_CSTAT_PASSCRC () {	0x0200;}
}
unless(defined(&TL_CSTAT_DPRIO)) {
    sub TL_CSTAT_DPRIO () {	0x0100;}
}
unless(defined(&TL_FRAME_MASK)) {
    sub TL_FRAME_MASK () {	0x00ffffff;}
}
unless(defined(&tl_tx_goodframes)) {
    sub tl_tx_goodframes {
	local($x) = @_;
	eval q(( ($x->{tl_txstat}) &  &TL_FRAME_MASK));
    }
}
unless(defined(&tl_tx_underrun)) {
    sub tl_tx_underrun {
	local($x) = @_;
	eval q((( ($x->{tl_txstat}) & ~ &TL_FRAME_MASK) >> 24));
    }
}
unless(defined(&tl_rx_goodframes)) {
    sub tl_rx_goodframes {
	local($x) = @_;
	eval q(( ($x->{tl_rxstat}) &  &TL_FRAME_MASK));
    }
}
unless(defined(&tl_rx_overrun)) {
    sub tl_rx_overrun {
	local($x) = @_;
	eval q((( ($x->{tl_rxstat}) & ~ &TL_FRAME_MASK) >> 24));
    }
}
unless(defined(&TL_AC_MTXER)) {
    sub TL_AC_MTXER () {	0x01;}
}
unless(defined(&TL_AC_MTXD1)) {
    sub TL_AC_MTXD1 () {	0x02;}
}
unless(defined(&TL_AC_MTXD2)) {
    sub TL_AC_MTXD2 () {	0x04;}
}
unless(defined(&TL_AC_MTXD3)) {
    sub TL_AC_MTXD3 () {	0x08;}
}
unless(defined(&CSR_WRITE_4)) {
    sub CSR_WRITE_4 {
	local($sc, $reg, $val) = @_;
	eval q( &bus_space_write_4( ($sc->{tl_btag}),  ($sc->{tl_bhandle}), $reg, $val));
    }
}
unless(defined(&CSR_WRITE_2)) {
    sub CSR_WRITE_2 {
	local($sc, $reg, $val) = @_;
	eval q( &bus_space_write_2( ($sc->{tl_btag}),  ($sc->{tl_bhandle}), $reg, $val));
    }
}
unless(defined(&CSR_WRITE_1)) {
    sub CSR_WRITE_1 {
	local($sc, $reg, $val) = @_;
	eval q( &bus_space_write_1( ($sc->{tl_btag}),  ($sc->{tl_bhandle}), $reg, $val));
    }
}
unless(defined(&CSR_READ_4)) {
    sub CSR_READ_4 {
	local($sc, $reg) = @_;
	eval q( &bus_space_read_4( ($sc->{tl_btag}),  ($sc->{tl_bhandle}), $reg));
    }
}
unless(defined(&CSR_READ_2)) {
    sub CSR_READ_2 {
	local($sc, $reg) = @_;
	eval q( &bus_space_read_2( ($sc->{tl_btag}),  ($sc->{tl_bhandle}), $reg));
    }
}
unless(defined(&CSR_READ_1)) {
    sub CSR_READ_1 {
	local($sc, $reg) = @_;
	eval q( &bus_space_read_1( ($sc->{tl_btag}),  ($sc->{tl_bhandle}), $reg));
    }
}
unless(defined(&CMD_PUT)) {
    sub CMD_PUT {
	local($sc, $x) = @_;
	eval q( &CSR_WRITE_4($sc,  &TL_HOSTCMD, $x));
    }
}
unless(defined(&CMD_SET)) {
    sub CMD_SET {
	local($sc, $x) = @_;
	eval q( &CSR_WRITE_4($sc,  &TL_HOSTCMD,  &CSR_READ_4($sc,  &TL_HOSTCMD) | ($x)));
    }
}
unless(defined(&CMD_CLR)) {
    sub CMD_CLR {
	local($sc, $x) = @_;
	eval q( &CSR_WRITE_4($sc,  &TL_HOSTCMD,  &CSR_READ_4($sc,  &TL_HOSTCMD) & ~($x)));
    }
}
unless(defined(&EEPROM_START)) {
    sub EEPROM_START () {	 &tl_dio_setbit( &sc,  &TL_NETSIO,  &TL_SIO_ECLOK);  &tl_dio_setbit( &sc,  &TL_NETSIO,  &TL_SIO_EDATA);  &tl_dio_setbit( &sc,  &TL_NETSIO,  &TL_SIO_ETXEN);  &tl_dio_clrbit( &sc,  &TL_NETSIO,  &TL_SIO_EDATA);  &tl_dio_clrbit( &sc,  &TL_NETSIO,  &TL_SIO_ECLOK);;}
}
unless(defined(&EEPROM_STOP)) {
    sub EEPROM_STOP () {	 &tl_dio_clrbit( &sc,  &TL_NETSIO,  &TL_SIO_ETXEN);  &tl_dio_clrbit( &sc,  &TL_NETSIO,  &TL_SIO_EDATA);  &tl_dio_setbit( &sc,  &TL_NETSIO,  &TL_SIO_ECLOK);  &tl_dio_setbit( &sc,  &TL_NETSIO,  &TL_SIO_ETXEN);  &tl_dio_setbit( &sc,  &TL_NETSIO,  &TL_SIO_EDATA);  &tl_dio_clrbit( &sc,  &TL_NETSIO,  &TL_SIO_ETXEN);  &tl_dio_clrbit( &sc,  &TL_NETSIO,  &TL_SIO_ECLOK);;}
}
unless(defined(&PHY_BMCR)) {
    sub PHY_BMCR () {	0x00;}
}
unless(defined(&PHY_BMCR_RESET)) {
    sub PHY_BMCR_RESET () {	0x8000;}
}
unless(defined(&PHY_BMCR_LOOPBK)) {
    sub PHY_BMCR_LOOPBK () {	0x4000;}
}
unless(defined(&PHY_BMCR_SPEEDSEL)) {
    sub PHY_BMCR_SPEEDSEL () {	0x2000;}
}
unless(defined(&PHY_BMCR_AUTONEGENBL)) {
    sub PHY_BMCR_AUTONEGENBL () {	0x1000;}
}
unless(defined(&PHY_BMCR_RSVD0)) {
    sub PHY_BMCR_RSVD0 () {	0x0800;}
}
unless(defined(&PHY_BMCR_PWRDOWN)) {
    sub PHY_BMCR_PWRDOWN () {	0x0800;}
}
unless(defined(&PHY_BMCR_ISOLATE)) {
    sub PHY_BMCR_ISOLATE () {	0x0400;}
}
unless(defined(&PHY_BMCR_AUTONEGRSTR)) {
    sub PHY_BMCR_AUTONEGRSTR () {	0x0200;}
}
unless(defined(&PHY_BMCR_DUPLEX)) {
    sub PHY_BMCR_DUPLEX () {	0x0100;}
}
unless(defined(&PHY_BMCR_COLLTEST)) {
    sub PHY_BMCR_COLLTEST () {	0x0080;}
}
unless(defined(&PHY_BMCR_RSVD1)) {
    sub PHY_BMCR_RSVD1 () {	0x0040;}
}
unless(defined(&PHY_BMCR_RSVD2)) {
    sub PHY_BMCR_RSVD2 () {	0x0020;}
}
unless(defined(&PHY_BMCR_RSVD3)) {
    sub PHY_BMCR_RSVD3 () {	0x0010;}
}
unless(defined(&PHY_BMCR_RSVD4)) {
    sub PHY_BMCR_RSVD4 () {	0x0008;}
}
unless(defined(&PHY_BMCR_RSVD5)) {
    sub PHY_BMCR_RSVD5 () {	0x0004;}
}
unless(defined(&PHY_BMCR_RSVD6)) {
    sub PHY_BMCR_RSVD6 () {	0x0002;}
}
unless(defined(&PHY_BMCR_RSVD7)) {
    sub PHY_BMCR_RSVD7 () {	0x0001;}
}
unless(defined(&PHY_BMSR)) {
    sub PHY_BMSR () {	0x01;}
}
unless(defined(&PHY_BMSR_100BT4)) {
    sub PHY_BMSR_100BT4 () {	0x8000;}
}
unless(defined(&PHY_BMSR_100BTXFULL)) {
    sub PHY_BMSR_100BTXFULL () {	0x4000;}
}
unless(defined(&PHY_BMSR_100BTXHALF)) {
    sub PHY_BMSR_100BTXHALF () {	0x2000;}
}
unless(defined(&PHY_BMSR_10BTFULL)) {
    sub PHY_BMSR_10BTFULL () {	0x1000;}
}
unless(defined(&PHY_BMSR_10BTHALF)) {
    sub PHY_BMSR_10BTHALF () {	0x0800;}
}
unless(defined(&PHY_BMSR_RSVD1)) {
    sub PHY_BMSR_RSVD1 () {	0x0400;}
}
unless(defined(&PHY_BMSR_RSVD2)) {
    sub PHY_BMSR_RSVD2 () {	0x0200;}
}
unless(defined(&PHY_BMSR_RSVD3)) {
    sub PHY_BMSR_RSVD3 () {	0x0100;}
}
unless(defined(&PHY_BMSR_RSVD4)) {
    sub PHY_BMSR_RSVD4 () {	0x0080;}
}
unless(defined(&PHY_BMSR_MFPRESUP)) {
    sub PHY_BMSR_MFPRESUP () {	0x0040;}
}
unless(defined(&PHY_BMSR_AUTONEGCOMP)) {
    sub PHY_BMSR_AUTONEGCOMP () {	0x0020;}
}
unless(defined(&PHY_BMSR_REMFAULT)) {
    sub PHY_BMSR_REMFAULT () {	0x0010;}
}
unless(defined(&PHY_BMSR_CANAUTONEG)) {
    sub PHY_BMSR_CANAUTONEG () {	0x0008;}
}
unless(defined(&PHY_BMSR_LINKSTAT)) {
    sub PHY_BMSR_LINKSTAT () {	0x0004;}
}
unless(defined(&PHY_BMSR_JABBER)) {
    sub PHY_BMSR_JABBER () {	0x0002;}
}
unless(defined(&PHY_BMSR_EXTENDED)) {
    sub PHY_BMSR_EXTENDED () {	0x0001;}
}
unless(defined(&PHY_CTL_IGLINK)) {
    sub PHY_CTL_IGLINK () {	0x8000;}
}
unless(defined(&PHY_CTL_SWAPOL)) {
    sub PHY_CTL_SWAPOL () {	0x4000;}
}
unless(defined(&PHY_CTL_AUISEL)) {
    sub PHY_CTL_AUISEL () {	0x2000;}
}
unless(defined(&PHY_CTL_SQEEN)) {
    sub PHY_CTL_SQEEN () {	0x1000;}
}
unless(defined(&PHY_CTL_MTEST)) {
    sub PHY_CTL_MTEST () {	0x0800;}
}
unless(defined(&PHY_CTL_NFEW)) {
    sub PHY_CTL_NFEW () {	0x0004;}
}
unless(defined(&PHY_CTL_INTEN)) {
    sub PHY_CTL_INTEN () {	0x0002;}
}
unless(defined(&PHY_CTL_TINT)) {
    sub PHY_CTL_TINT () {	0x0001;}
}
unless(defined(&TL_PHY_GENCTL)) {
    sub TL_PHY_GENCTL () {	0x00;}
}
unless(defined(&TL_PHY_GENSTS)) {
    sub TL_PHY_GENSTS () {	0x01;}
}
unless(defined(&TL_PHY_VENID)) {
    sub TL_PHY_VENID () {	0x02;}
}
unless(defined(&TL_PHY_DEVID)) {
    sub TL_PHY_DEVID () {	0x03;}
}
unless(defined(&TL_PHY_ANAR)) {
    sub TL_PHY_ANAR () {	0x04;}
}
unless(defined(&TL_PHY_LPAR)) {
    sub TL_PHY_LPAR () {	0x05;}
}
unless(defined(&TL_PHY_ANEXP)) {
    sub TL_PHY_ANEXP () {	0x06;}
}
unless(defined(&TL_PHY_PHYID)) {
    sub TL_PHY_PHYID () {	0x10;}
}
unless(defined(&TL_PHY_CTL)) {
    sub TL_PHY_CTL () {	0x11;}
}
unless(defined(&TL_PHY_STS)) {
    sub TL_PHY_STS () {	0x12;}
}
unless(defined(&TL_LPAR_RMFLT)) {
    sub TL_LPAR_RMFLT () {	0x2000;}
}
unless(defined(&TL_LPAR_RSVD0)) {
    sub TL_LPAR_RSVD0 () {	0x1000;}
}
unless(defined(&TL_LPAR_RSVD1)) {
    sub TL_LPAR_RSVD1 () {	0x0800;}
}
unless(defined(&TL_LPAR_100BT4)) {
    sub TL_LPAR_100BT4 () {	0x0400;}
}
unless(defined(&TL_LPAR_100BTXFULL)) {
    sub TL_LPAR_100BTXFULL () {	0x0200;}
}
unless(defined(&TL_LPAR_100BTXHALF)) {
    sub TL_LPAR_100BTXHALF () {	0x0100;}
}
unless(defined(&TL_LPAR_10BTFULL)) {
    sub TL_LPAR_10BTFULL () {	0x0080;}
}
unless(defined(&TL_LPAR_10BTHALF)) {
    sub TL_LPAR_10BTHALF () {	0x0040;}
}
unless(defined(&PHY_ANAR)) {
    sub PHY_ANAR () {	 &TL_PHY_ANAR;}
}
unless(defined(&PHY_ANAR_NEXTPAGE)) {
    sub PHY_ANAR_NEXTPAGE () {	0x8000;}
}
unless(defined(&PHY_ANAR_RSVD0)) {
    sub PHY_ANAR_RSVD0 () {	0x4000;}
}
unless(defined(&PHY_ANAR_TLRFLT)) {
    sub PHY_ANAR_TLRFLT () {	0x2000;}
}
unless(defined(&PHY_ANAR_RSVD1)) {
    sub PHY_ANAR_RSVD1 () {	0x1000;}
}
unless(defined(&PHY_RSVD_RSDV2)) {
    sub PHY_RSVD_RSDV2 () {	0x0800;}
}
unless(defined(&PHY_RSVD_RSVD3)) {
    sub PHY_RSVD_RSVD3 () {	0x0400;}
}
unless(defined(&PHY_ANAR_100BT4)) {
    sub PHY_ANAR_100BT4 () {	0x0200;}
}
unless(defined(&PHY_ANAR_100BTXFULL)) {
    sub PHY_ANAR_100BTXFULL () {	0x0100;}
}
unless(defined(&PHY_ANAR_100BTXHALF)) {
    sub PHY_ANAR_100BTXHALF () {	0x0080;}
}
unless(defined(&PHY_ANAR_10BTFULL)) {
    sub PHY_ANAR_10BTFULL () {	0x0040;}
}
unless(defined(&PHY_ANAR_10BTHALF)) {
    sub PHY_ANAR_10BTHALF () {	0x0020;}
}
unless(defined(&PHY_ANAR_PROTO4)) {
    sub PHY_ANAR_PROTO4 () {	0x0010;}
}
unless(defined(&PHY_ANAR_PROTO3)) {
    sub PHY_ANAR_PROTO3 () {	0x0008;}
}
unless(defined(&PHY_ANAR_PROTO2)) {
    sub PHY_ANAR_PROTO2 () {	0x0004;}
}
unless(defined(&PHY_AHAR_PROTO1)) {
    sub PHY_AHAR_PROTO1 () {	0x0002;}
}
unless(defined(&PHY_AHAR_PROTO0)) {
    sub PHY_AHAR_PROTO0 () {	0x0001;}
}
unless(defined(&TL_DP83840_PCS)) {
    sub TL_DP83840_PCS () {	0x17;}
}
unless(defined(&TL_DP83840_PCS_LED4_MODE)) {
    sub TL_DP83840_PCS_LED4_MODE () {	0x0002;}
}
unless(defined(&TL_DP83840_PCS_F_CONNECT)) {
    sub TL_DP83840_PCS_F_CONNECT () {	0x0020;}
}
unless(defined(&TL_DP83840_PCS_BIT8)) {
    sub TL_DP83840_PCS_BIT8 () {	0x0100;}
}
unless(defined(&TL_DP83840_PCS_BIT10)) {
    sub TL_DP83840_PCS_BIT10 () {	0x0400;}
}
unless(defined(&TL_DP83840_PAR)) {
    sub TL_DP83840_PAR () {	0x19;}
}
unless(defined(&PAR_RSVD0)) {
    sub PAR_RSVD0 () {	0x8000;}
}
unless(defined(&PAR_RSVD1)) {
    sub PAR_RSVD1 () {	0x4000;}
}
unless(defined(&PAR_RSVD2)) {
    sub PAR_RSVD2 () {	0x2000;}
}
unless(defined(&PAR_RSVD3)) {
    sub PAR_RSVD3 () {	0x1000;}
}
unless(defined(&PAR_DIS_CRS_JAB)) {
    sub PAR_DIS_CRS_JAB () {	0x0800;}
}
unless(defined(&PAR_AN_EN_STAT)) {
    sub PAR_AN_EN_STAT () {	0x0400;}
}
unless(defined(&PAR_RSVD4)) {
    sub PAR_RSVD4 () {	0x0200;}
}
unless(defined(&PAR_FEFI_EN)) {
    sub PAR_FEFI_EN () {	0x0100;}
}
unless(defined(&PAR_DUPLEX_STAT)) {
    sub PAR_DUPLEX_STAT () {	0x0080;}
}
unless(defined(&PAR_SPEED_10)) {
    sub PAR_SPEED_10 () {	0x0040;}
}
unless(defined(&PAR_CIM_STATUS)) {
    sub PAR_CIM_STATUS () {	0x0020;}
}
unless(defined(&PAR_PHYADDR4)) {
    sub PAR_PHYADDR4 () {	0x0010;}
}
unless(defined(&PAR_PHYADDR3)) {
    sub PAR_PHYADDR3 () {	0x0008;}
}
unless(defined(&PAR_PHYADDR2)) {
    sub PAR_PHYADDR2 () {	0x0004;}
}
unless(defined(&PAR_PHYADDR1)) {
    sub PAR_PHYADDR1 () {	0x0002;}
}
unless(defined(&PAR_PHYADDR0)) {
    sub PAR_PHYADDR0 () {	0x0001;}
}
unless(defined(&EEPROM_CTL_READ)) {
    sub EEPROM_CTL_READ () {	0xa1;}
}
unless(defined(&EEPROM_CTL_WRITE)) {
    sub EEPROM_CTL_WRITE () {	0xa0;}
}
if(defined(&__alpha__)) {
    undef(&vtophys) if defined(&vtophys);
    eval 'sub vtophys {
        local($va) = @_;
	    eval q( &alpha_XXX_dmamap($va));
    }' unless defined(&vtophys);
}
1;
