require '_h2ph_pre.ph';

unless(defined(&AN_TIMEOUT)) {
    sub AN_TIMEOUT () {	65536;}
}
unless(defined(&AN_DEFAULT_NETNAME)) {
    sub AN_DEFAULT_NETNAME () {	"ANY";}
}
unless(defined(&AN_DEFAULT_NODENAME)) {
    sub AN_DEFAULT_NODENAME () {	"OpenBSD";}
}
unless(defined(&AN_DEFAULT_IBSS)) {
    sub AN_DEFAULT_IBSS () {	"OpenBSD IBSS";}
}
unless(defined(&CSR_WRITE_2)) {
    sub CSR_WRITE_2 {
	local($sc, $reg, $val) = @_;
	eval q( &bus_space_write_2( ($sc->{an_btag}),  ($sc->{an_bhandle}), $reg, $val));
    }
}
unless(defined(&CSR_READ_2)) {
    sub CSR_READ_2 {
	local($sc, $reg) = @_;
	eval q( &bus_space_read_2( ($sc->{an_btag}),  ($sc->{an_bhandle}), $reg));
    }
}
unless(defined(&CSR_WRITE_1)) {
    sub CSR_WRITE_1 {
	local($sc, $reg, $val) = @_;
	eval q( &bus_space_write_1( ($sc->{an_btag}),  ($sc->{an_bhandle}), $reg, $val));
    }
}
unless(defined(&CSR_READ_1)) {
    sub CSR_READ_1 {
	local($sc, $reg) = @_;
	eval q( &bus_space_read_1( ($sc->{an_btag}),  ($sc->{an_bhandle}), $reg));
    }
}
unless(defined(&AN_IOSIZ)) {
    sub AN_IOSIZ () {	0x40;}
}
unless(defined(&AN_COMMAND)) {
    sub AN_COMMAND () {	0x00;}
}
unless(defined(&AN_PARAM0)) {
    sub AN_PARAM0 () {	0x02;}
}
unless(defined(&AN_PARAM1)) {
    sub AN_PARAM1 () {	0x04;}
}
unless(defined(&AN_PARAM2)) {
    sub AN_PARAM2 () {	0x06;}
}
unless(defined(&AN_STATUS)) {
    sub AN_STATUS () {	0x08;}
}
unless(defined(&AN_RESP0)) {
    sub AN_RESP0 () {	0x0a;}
}
unless(defined(&AN_RESP1)) {
    sub AN_RESP1 () {	0x0c;}
}
unless(defined(&AN_RESP2)) {
    sub AN_RESP2 () {	0x0e;}
}
unless(defined(&AN_LINKSTAT)) {
    sub AN_LINKSTAT () {	0x10;}
}
unless(defined(&AN_CMD_BUSY)) {
    sub AN_CMD_BUSY () {	0x8000;}
}
unless(defined(&AN_CMD_NO_ACK)) {
    sub AN_CMD_NO_ACK () {	0x0080;}
}
unless(defined(&AN_CMD_CODE_MASK)) {
    sub AN_CMD_CODE_MASK () {	0x003f;}
}
unless(defined(&AN_CMD_QUAL_MASK)) {
    sub AN_CMD_QUAL_MASK () {	0x7f00;}
}
unless(defined(&AN_CMD_NOOP)) {
    sub AN_CMD_NOOP () {	0x0000;}
}
unless(defined(&AN_CMD_ENABLE)) {
    sub AN_CMD_ENABLE () {	0x0001;}
}
unless(defined(&AN_CMD_DISABLE)) {
    sub AN_CMD_DISABLE () {	0x0002;}
}
unless(defined(&AN_CMD_FORCE_SYNCLOSS)) {
    sub AN_CMD_FORCE_SYNCLOSS () {	0x0003;}
}
unless(defined(&AN_CMD_FW_RESTART)) {
    sub AN_CMD_FW_RESTART () {	0x0004;}
}
unless(defined(&AN_CMD_HOST_SLEEP)) {
    sub AN_CMD_HOST_SLEEP () {	0x0005;}
}
unless(defined(&AN_CMD_MAGIC_PKT)) {
    sub AN_CMD_MAGIC_PKT () {	0x0006;}
}
unless(defined(&AN_CMD_READCFG)) {
    sub AN_CMD_READCFG () {	0x0008;}
}
unless(defined(&AN_CMD_ALLOC_MEM)) {
    sub AN_CMD_ALLOC_MEM () {	0x000a;}
}
unless(defined(&AN_CMD_TX)) {
    sub AN_CMD_TX () {	0x000b;}
}
unless(defined(&AN_CMD_DEALLOC_MEM)) {
    sub AN_CMD_DEALLOC_MEM () {	0x000c;}
}
unless(defined(&AN_CMD_NOOP2)) {
    sub AN_CMD_NOOP2 () {	0x0010;}
}
unless(defined(&AN_CMD_ACCESS)) {
    sub AN_CMD_ACCESS () {	0x0021;}
}
unless(defined(&AN_CMD_ALLOC_BUF)) {
    sub AN_CMD_ALLOC_BUF () {	0x0028;}
}
unless(defined(&AN_CMD_PSP_NODES)) {
    sub AN_CMD_PSP_NODES () {	0x0030;}
}
unless(defined(&AN_CMD_SET_PHYREG)) {
    sub AN_CMD_SET_PHYREG () {	0x003e;}
}
unless(defined(&AN_CMD_TX_TEST)) {
    sub AN_CMD_TX_TEST () {	0x003f;}
}
unless(defined(&AN_CMD_SLEEP)) {
    sub AN_CMD_SLEEP () {	0x0085;}
}
unless(defined(&AN_CMD_SAVECFG)) {
    sub AN_CMD_SAVECFG () {	0x0108;}
}
unless(defined(&AN_RECLAIM)) {
    sub AN_RECLAIM () {	0x0100;}
}
unless(defined(&AN_ACCESS_READ)) {
    sub AN_ACCESS_READ () {	0x0000;}
}
unless(defined(&AN_ACCESS_WRITE)) {
    sub AN_ACCESS_WRITE () {	0x0100;}
}
unless(defined(&AN_PROGRAM_DISABLE)) {
    sub AN_PROGRAM_DISABLE () {	0x0000;}
}
unless(defined(&AN_PROGRAM_ENABLE_RAM)) {
    sub AN_PROGRAM_ENABLE_RAM () {	0x0100;}
}
unless(defined(&AN_PROGRAM_ENABLE_NVRAM)) {
    sub AN_PROGRAM_ENABLE_NVRAM () {	0x0200;}
}
unless(defined(&AN_PROGRAM_NVRAM)) {
    sub AN_PROGRAM_NVRAM () {	0x0300;}
}
unless(defined(&AN_STAT_CMD_CODE)) {
    sub AN_STAT_CMD_CODE () {	0x003f;}
}
unless(defined(&AN_STAT_CMD_RESULT)) {
    sub AN_STAT_CMD_RESULT () {	0x7f00;}
}
unless(defined(&AN_LINKSTAT_ASSOCIATED)) {
    sub AN_LINKSTAT_ASSOCIATED () {	0x0400;}
}
unless(defined(&AN_LINKSTAT_AUTHFAIL)) {
    sub AN_LINKSTAT_AUTHFAIL () {	0x0300;}
}
unless(defined(&AN_LINKSTAT_ASSOC_FAIL)) {
    sub AN_LINKSTAT_ASSOC_FAIL () {	0x8400;}
}
unless(defined(&AN_LINKSTAT_DISASSOC)) {
    sub AN_LINKSTAT_DISASSOC () {	0x8200;}
}
unless(defined(&AN_LINKSTAT_DEAUTH)) {
    sub AN_LINKSTAT_DEAUTH () {	0x8100;}
}
unless(defined(&AN_LINKSTAT_SYNCLOST_TSF)) {
    sub AN_LINKSTAT_SYNCLOST_TSF () {	0x8004;}
}
unless(defined(&AN_LINKSTAT_SYNCLOST_HOSTREQ)) {
    sub AN_LINKSTAT_SYNCLOST_HOSTREQ () {	0x8003;}
}
unless(defined(&AN_LINKSTAT_SYNCLOST_AVGRETRY)) {
    sub AN_LINKSTAT_SYNCLOST_AVGRETRY () {	0x8002;}
}
unless(defined(&AN_LINKSTAT_SYNCLOST_MAXRETRY)) {
    sub AN_LINKSTAT_SYNCLOST_MAXRETRY () {	0x8001;}
}
unless(defined(&AN_LINKSTAT_SYNCLOST_MISSBEACON)) {
    sub AN_LINKSTAT_SYNCLOST_MISSBEACON () {	0x8000;}
}
unless(defined(&AN_RX_FID)) {
    sub AN_RX_FID () {	0x20;}
}
unless(defined(&AN_ALLOC_FID)) {
    sub AN_ALLOC_FID () {	0x22;}
}
unless(defined(&AN_TX_CMP_FID)) {
    sub AN_TX_CMP_FID () {	0x24;}
}
unless(defined(&AN_SEL0)) {
    sub AN_SEL0 () {	0x18;}
}
unless(defined(&AN_SEL1)) {
    sub AN_SEL1 () {	0x1a;}
}
unless(defined(&AN_OFF0)) {
    sub AN_OFF0 () {	0x1c;}
}
unless(defined(&AN_OFF1)) {
    sub AN_OFF1 () {	0x1e;}
}
unless(defined(&AN_DATA0)) {
    sub AN_DATA0 () {	0x36;}
}
unless(defined(&AN_DATA1)) {
    sub AN_DATA1 () {	0x38;}
}
unless(defined(&AN_BAP0)) {
    sub AN_BAP0 () {	 &AN_DATA0;}
}
unless(defined(&AN_BAP1)) {
    sub AN_BAP1 () {	 &AN_DATA1;}
}
unless(defined(&AN_OFF_BUSY)) {
    sub AN_OFF_BUSY () {	0x8000;}
}
unless(defined(&AN_OFF_ERR)) {
    sub AN_OFF_ERR () {	0x4000;}
}
unless(defined(&AN_OFF_DONE)) {
    sub AN_OFF_DONE () {	0x2000;}
}
unless(defined(&AN_OFF_DATAOFF)) {
    sub AN_OFF_DATAOFF () {	0x0fff;}
}
unless(defined(&AN_EVENT_STAT)) {
    sub AN_EVENT_STAT () {	0x30;}
}
unless(defined(&AN_INT_EN)) {
    sub AN_INT_EN () {	0x32;}
}
unless(defined(&AN_EVENT_ACK)) {
    sub AN_EVENT_ACK () {	0x34;}
}
unless(defined(&AN_EV_CLR_STUCK_BUSY)) {
    sub AN_EV_CLR_STUCK_BUSY () {	0x4000;}
}
unless(defined(&AN_EV_WAKEREQUEST)) {
    sub AN_EV_WAKEREQUEST () {	0x2000;}
}
unless(defined(&AN_EV_AWAKE)) {
    sub AN_EV_AWAKE () {	0x0100;}
}
unless(defined(&AN_EV_LINKSTAT)) {
    sub AN_EV_LINKSTAT () {	0x0080;}
}
unless(defined(&AN_EV_CMD)) {
    sub AN_EV_CMD () {	0x0010;}
}
unless(defined(&AN_EV_ALLOC)) {
    sub AN_EV_ALLOC () {	0x0008;}
}
unless(defined(&AN_EV_TX_EXC)) {
    sub AN_EV_TX_EXC () {	0x0004;}
}
unless(defined(&AN_EV_TX)) {
    sub AN_EV_TX () {	0x0002;}
}
unless(defined(&AN_EV_RX)) {
    sub AN_EV_RX () {	0x0001;}
}
unless(defined(&AN_INTRS)) {
    sub AN_INTRS () {	( &AN_EV_RX| &AN_EV_TX| &AN_EV_TX_EXC| &AN_EV_ALLOC| &AN_EV_LINKSTAT);}
}
unless(defined(&AN_SW0)) {
    sub AN_SW0 () {	0x28;}
}
unless(defined(&AN_SW1)) {
    sub AN_SW1 () {	0x2a;}
}
unless(defined(&AN_SW2)) {
    sub AN_SW2 () {	0x2c;}
}
unless(defined(&AN_SW3)) {
    sub AN_SW3 () {	0x2e;}
}
unless(defined(&AN_CNTL)) {
    sub AN_CNTL () {	0x14;}
}
unless(defined(&AN_CNTL_AUX_ENA)) {
    sub AN_CNTL_AUX_ENA () {	0xc000;}
}
unless(defined(&AN_CNTL_AUX_ENA_STAT)) {
    sub AN_CNTL_AUX_ENA_STAT () {	0xc000;}
}
unless(defined(&AN_CNTL_AUX_DIS_STAT)) {
    sub AN_CNTL_AUX_DIS_STAT () {	0x0000;}
}
unless(defined(&AN_CNTL_AUX_ENA_CNTL)) {
    sub AN_CNTL_AUX_ENA_CNTL () {	0x8000;}
}
unless(defined(&AN_CNTL_AUX_DIS_CNTL)) {
    sub AN_CNTL_AUX_DIS_CNTL () {	0x4000;}
}
unless(defined(&AN_AUX_PAGE)) {
    sub AN_AUX_PAGE () {	0x3a;}
}
unless(defined(&AN_AUX_OFFSET)) {
    sub AN_AUX_OFFSET () {	0x3c;}
}
unless(defined(&AN_AUX_DATA)) {
    sub AN_AUX_DATA () {	0x3e;}
}
unless(defined(&AN_RID_GENCONFIG)) {
    sub AN_RID_GENCONFIG () {	0xff10;}
}
unless(defined(&AN_OPMODE_IBSS_ADHOC)) {
    sub AN_OPMODE_IBSS_ADHOC () {	0x0000;}
}
unless(defined(&AN_OPMODE_INFRASTRUCTURE_STATION)) {
    sub AN_OPMODE_INFRASTRUCTURE_STATION () {	0x0001;}
}
unless(defined(&AN_OPMODE_AP)) {
    sub AN_OPMODE_AP () {	0x0002;}
}
unless(defined(&AN_OPMODE_AP_REPEATER)) {
    sub AN_OPMODE_AP_REPEATER () {	0x0003;}
}
unless(defined(&AN_OPMODE_UNMODIFIED_PAYLOAD)) {
    sub AN_OPMODE_UNMODIFIED_PAYLOAD () {	0x0100;}
}
unless(defined(&AN_OPMODE_AIRONET_EXTENSIONS)) {
    sub AN_OPMODE_AIRONET_EXTENSIONS () {	0x0200;}
}
unless(defined(&AN_OPMODE_AP_EXTENSIONS)) {
    sub AN_OPMODE_AP_EXTENSIONS () {	0x0400;}
}
unless(defined(&AN_RXMODE_BC_MC_ADDR)) {
    sub AN_RXMODE_BC_MC_ADDR () {	0x0000;}
}
unless(defined(&AN_RXMODE_BC_ADDR)) {
    sub AN_RXMODE_BC_ADDR () {	0x0001;}
}
unless(defined(&AN_RXMODE_ADDR)) {
    sub AN_RXMODE_ADDR () {	0x0002;}
}
unless(defined(&AN_RXMODE_80211_MONITOR_CURBSS)) {
    sub AN_RXMODE_80211_MONITOR_CURBSS () {	0x0003;}
}
unless(defined(&AN_RXMODE_80211_MONITOR_ANYBSS)) {
    sub AN_RXMODE_80211_MONITOR_ANYBSS () {	0x0004;}
}
unless(defined(&AN_RXMODE_LAN_MONITOR_CURBSS)) {
    sub AN_RXMODE_LAN_MONITOR_CURBSS () {	0x0005;}
}
unless(defined(&AN_RXMODE_NO_8023_HEADER)) {
    sub AN_RXMODE_NO_8023_HEADER () {	0x0100;}
}
unless(defined(&AN_RATE_1MBPS)) {
    sub AN_RATE_1MBPS () {	0x0002;}
}
unless(defined(&AN_RATE_2MBPS)) {
    sub AN_RATE_2MBPS () {	0x0004;}
}
unless(defined(&AN_RATE_5_5MBPS)) {
    sub AN_RATE_5_5MBPS () {	0x000b;}
}
unless(defined(&AN_RATE_11MBPS)) {
    sub AN_RATE_11MBPS () {	0x0016;}
}
unless(defined(&AN_DEVTYPE_PC4500)) {
    sub AN_DEVTYPE_PC4500 () {	0x0065;}
}
unless(defined(&AN_DEVTYPE_PC4800)) {
    sub AN_DEVTYPE_PC4800 () {	0x006d;}
}
unless(defined(&AN_SCANMODE_ACTIVE)) {
    sub AN_SCANMODE_ACTIVE () {	0x0000;}
}
unless(defined(&AN_SCANMODE_PASSIVE)) {
    sub AN_SCANMODE_PASSIVE () {	0x0001;}
}
unless(defined(&AN_SCANMODE_AIRONET_ACTIVE)) {
    sub AN_SCANMODE_AIRONET_ACTIVE () {	0x0002;}
}
unless(defined(&AN_AUTHTYPE_NONE)) {
    sub AN_AUTHTYPE_NONE () {	0x0000;}
}
unless(defined(&AN_AUTHTYPE_OPEN)) {
    sub AN_AUTHTYPE_OPEN () {	0x0001;}
}
unless(defined(&AN_AUTHTYPE_SHAREDKEY)) {
    sub AN_AUTHTYPE_SHAREDKEY () {	0x0002;}
}
unless(defined(&AN_AUTHTYPE_EXCLUDE_UNENCRYPTED)) {
    sub AN_AUTHTYPE_EXCLUDE_UNENCRYPTED () {	0x0004;}
}
unless(defined(&AN_PSAVE_NONE)) {
    sub AN_PSAVE_NONE () {	0x0000;}
}
unless(defined(&AN_PSAVE_CAM)) {
    sub AN_PSAVE_CAM () {	0x0001;}
}
unless(defined(&AN_PSAVE_PSP)) {
    sub AN_PSAVE_PSP () {	0x0002;}
}
unless(defined(&AN_PSAVE_PSP_CAM)) {
    sub AN_PSAVE_PSP_CAM () {	0x0003;}
}
unless(defined(&AN_RADIOTYPE_80211_FH)) {
    sub AN_RADIOTYPE_80211_FH () {	0x0001;}
}
unless(defined(&AN_RADIOTYPE_80211_DS)) {
    sub AN_RADIOTYPE_80211_DS () {	0x0002;}
}
unless(defined(&AN_RADIOTYPE_LM2000_DS)) {
    sub AN_RADIOTYPE_LM2000_DS () {	0x0004;}
}
unless(defined(&AN_DIVERSITY_FACTORY_DEFAULT)) {
    sub AN_DIVERSITY_FACTORY_DEFAULT () {	0x0000;}
}
unless(defined(&AN_DIVERSITY_ANTENNA_1_ONLY)) {
    sub AN_DIVERSITY_ANTENNA_1_ONLY () {	0x0001;}
}
unless(defined(&AN_DIVERSITY_ANTENNA_2_ONLY)) {
    sub AN_DIVERSITY_ANTENNA_2_ONLY () {	0x0002;}
}
unless(defined(&AN_DIVERSITY_ANTENNA_1_AND_2)) {
    sub AN_DIVERSITY_ANTENNA_1_AND_2 () {	0x0003;}
}
unless(defined(&AN_TXPOWER_FACTORY_DEFAULT)) {
    sub AN_TXPOWER_FACTORY_DEFAULT () {	0x0000;}
}
unless(defined(&AN_TXPOWER_50MW)) {
    sub AN_TXPOWER_50MW () {	50;}
}
unless(defined(&AN_TXPOWER_100MW)) {
    sub AN_TXPOWER_100MW () {	100;}
}
unless(defined(&AN_TXPOWER_250MW)) {
    sub AN_TXPOWER_250MW () {	250;}
}
unless(defined(&AN_RID_SSIDLIST)) {
    sub AN_RID_SSIDLIST () {	0xff11;}
}
unless(defined(&AN_DEF_SSID_LEN)) {
    sub AN_DEF_SSID_LEN () {	7;}
}
unless(defined(&AN_DEF_SSID)) {
    sub AN_DEF_SSID () {	"tsunami";}
}
unless(defined(&AN_RID_APLIST)) {
    sub AN_RID_APLIST () {	0xff12;}
}
unless(defined(&AN_RID_DRVNAME)) {
    sub AN_RID_DRVNAME () {	0xff13;}
}
unless(defined(&AN_RID_ENCAP)) {
    sub AN_RID_ENCAP () {	0xff14;}
}
unless(defined(&AN_ENCAP_ACTION_RX)) {
    sub AN_ENCAP_ACTION_RX () {	0x0001;}
}
unless(defined(&AN_ENCAP_ACTION_TX)) {
    sub AN_ENCAP_ACTION_TX () {	0x0002;}
}
unless(defined(&AN_RXENCAP_NONE)) {
    sub AN_RXENCAP_NONE () {	0x0000;}
}
unless(defined(&AN_RXENCAP_RFC1024)) {
    sub AN_RXENCAP_RFC1024 () {	0x0001;}
}
unless(defined(&AN_TXENCAP_RFC1024)) {
    sub AN_TXENCAP_RFC1024 () {	0x0000;}
}
unless(defined(&AN_TXENCAP_80211)) {
    sub AN_TXENCAP_80211 () {	0x0002;}
}
unless(defined(&AN_RID_ACTUALCFG)) {
    sub AN_RID_ACTUALCFG () {	0xff20;}
}
unless(defined(&AN_RID_CAPABILITIES)) {
    sub AN_RID_CAPABILITIES () {	0xff00;}
}
unless(defined(&AN_RID_APINFO)) {
    sub AN_RID_APINFO () {	0xff01;}
}
unless(defined(&AN_RID_RADIOINFO)) {
    sub AN_RID_RADIOINFO () {	0xff02;}
}
unless(defined(&AN_RID_STATUS)) {
    sub AN_RID_STATUS () {	0xff50;}
}
unless(defined(&AN_STATUS_OPMODE_CONFIGURED)) {
    sub AN_STATUS_OPMODE_CONFIGURED () {	0x0001;}
}
unless(defined(&AN_STATUS_OPMODE_MAC_ENABLED)) {
    sub AN_STATUS_OPMODE_MAC_ENABLED () {	0x0002;}
}
unless(defined(&AN_STATUS_OPMODE_RX_ENABLED)) {
    sub AN_STATUS_OPMODE_RX_ENABLED () {	0x0004;}
}
unless(defined(&AN_STATUS_OPMODE_IN_SYNC)) {
    sub AN_STATUS_OPMODE_IN_SYNC () {	0x0010;}
}
unless(defined(&AN_STATUS_OPMODE_ASSOCIATED)) {
    sub AN_STATUS_OPMODE_ASSOCIATED () {	0x0020;}
}
unless(defined(&AN_STATUS_OPMODE_ERROR)) {
    sub AN_STATUS_OPMODE_ERROR () {	0x8000;}
}
unless(defined(&AN_RID_16BITS_CUM)) {
    sub AN_RID_16BITS_CUM () {	0xff60;}
}
unless(defined(&AN_RID_16BITS_DELTA)) {
    sub AN_RID_16BITS_DELTA () {	0xff61;}
}
unless(defined(&AN_RID_16BITS_DELTACLR)) {
    sub AN_RID_16BITS_DELTACLR () {	0xff62;}
}
unless(defined(&AN_RID_32BITS_CUM)) {
    sub AN_RID_32BITS_CUM () {	0xff68;}
}
unless(defined(&AN_RID_32BITS_DELTA)) {
    sub AN_RID_32BITS_DELTA () {	0xff69;}
}
unless(defined(&AN_RID_32BITS_DELTACLR)) {
    sub AN_RID_32BITS_DELTACLR () {	0xff6a;}
}
unless(defined(&AN_RXGAP_MAX)) {
    sub AN_RXGAP_MAX () {	8;}
}
unless(defined(&AN_RXGAP_MAX)) {
    sub AN_RXGAP_MAX () {	8;}
}
unless(defined(&AN_TXSTAT_EXCESS_RETRY)) {
    sub AN_TXSTAT_EXCESS_RETRY () {	0x0002;}
}
unless(defined(&AN_TXSTAT_LIFE_EXCEEDED)) {
    sub AN_TXSTAT_LIFE_EXCEEDED () {	0x0004;}
}
unless(defined(&AN_TXSTAT_AID_FAIL)) {
    sub AN_TXSTAT_AID_FAIL () {	0x0008;}
}
unless(defined(&AN_TXSTAT_MAC_DISABLED)) {
    sub AN_TXSTAT_MAC_DISABLED () {	0x0010;}
}
unless(defined(&AN_TXSTAT_ASSOC_LOST)) {
    sub AN_TXSTAT_ASSOC_LOST () {	0x0020;}
}
unless(defined(&AN_TXCTL_RSVD)) {
    sub AN_TXCTL_RSVD () {	0x0001;}
}
unless(defined(&AN_TXCTL_TXOK_INTR)) {
    sub AN_TXCTL_TXOK_INTR () {	0x0002;}
}
unless(defined(&AN_TXCTL_TXERR_INTR)) {
    sub AN_TXCTL_TXERR_INTR () {	0x0004;}
}
unless(defined(&AN_TXCTL_HEADER_TYPE)) {
    sub AN_TXCTL_HEADER_TYPE () {	0x0008;}
}
unless(defined(&AN_TXCTL_PAYLOAD_TYPE)) {
    sub AN_TXCTL_PAYLOAD_TYPE () {	0x0010;}
}
unless(defined(&AN_TXCTL_NORELEASE)) {
    sub AN_TXCTL_NORELEASE () {	0x0020;}
}
unless(defined(&AN_TXCTL_NORETRIES)) {
    sub AN_TXCTL_NORETRIES () {	0x0040;}
}
unless(defined(&AN_TXCTL_CLEAR_AID)) {
    sub AN_TXCTL_CLEAR_AID () {	0x0080;}
}
unless(defined(&AN_TXCTL_STRICT_ORDER)) {
    sub AN_TXCTL_STRICT_ORDER () {	0x0100;}
}
unless(defined(&AN_TXCTL_USE_RTS)) {
    sub AN_TXCTL_USE_RTS () {	0x0200;}
}
unless(defined(&AN_HEADERTYPE_8023)) {
    sub AN_HEADERTYPE_8023 () {	0x0000;}
}
unless(defined(&AN_HEADERTYPE_80211)) {
    sub AN_HEADERTYPE_80211 () {	0x0008;}
}
unless(defined(&AN_PAYLOADTYPE_ETHER)) {
    sub AN_PAYLOADTYPE_ETHER () {	0x0000;}
}
unless(defined(&AN_PAYLOADTYPE_LLC)) {
    sub AN_PAYLOADTYPE_LLC () {	0x0010;}
}
unless(defined(&AN_TXCTL_80211)) {
    sub AN_TXCTL_80211 () {	( &AN_TXCTL_TXOK_INTR| &AN_TXCTL_TXERR_INTR| &AN_HEADERTYPE_80211|  &AN_PAYLOADTYPE_LLC| &AN_TXCTL_NORELEASE);}
}
unless(defined(&AN_TXCTL_8023)) {
    sub AN_TXCTL_8023 () {	( &AN_TXCTL_TXOK_INTR| &AN_TXCTL_TXERR_INTR| &AN_HEADERTYPE_8023|  &AN_PAYLOADTYPE_ETHER| &AN_TXCTL_NORELEASE);}
}
unless(defined(&AN_TXGAP_80211)) {
    sub AN_TXGAP_80211 () {	0;}
}
unless(defined(&AN_TXGAP_8023)) {
    sub AN_TXGAP_8023 () {	0;}
}
unless(defined(&AN_TX_RING_CNT)) {
    sub AN_TX_RING_CNT () {	4;}
}
unless(defined(&AN_INC)) {
    sub AN_INC {
	local($x, $y) = @_;
	eval q(($x) = ($x + 1) % $y);
    }
}
if(defined(&ANCACHE)) {
}
unless(defined(&AN_802_3_OFFSET)) {
    sub AN_802_3_OFFSET () {	0x2e;}
}
unless(defined(&AN_802_11_OFFSET)) {
    sub AN_802_11_OFFSET () {	0x44;}
}
unless(defined(&AN_802_11_OFFSET_RAW)) {
    sub AN_802_11_OFFSET_RAW () {	0x3c;}
}
unless(defined(&AN_STAT_BADCRC)) {
    sub AN_STAT_BADCRC () {	0x0001;}
}
unless(defined(&AN_STAT_UNDECRYPTABLE)) {
    sub AN_STAT_UNDECRYPTABLE () {	0x0002;}
}
unless(defined(&AN_STAT_ERRSTAT)) {
    sub AN_STAT_ERRSTAT () {	0x0003;}
}
unless(defined(&AN_STAT_MAC_PORT)) {
    sub AN_STAT_MAC_PORT () {	0x0700;}
}
unless(defined(&AN_STAT_1042)) {
    sub AN_STAT_1042 () {	0x2000;}
}
unless(defined(&AN_STAT_TUNNEL)) {
    sub AN_STAT_TUNNEL () {	0x4000;}
}
unless(defined(&AN_STAT_WMP_MSG)) {
    sub AN_STAT_WMP_MSG () {	0x6000;}
}
unless(defined(&AN_RXSTAT_MSG_TYPE)) {
    sub AN_RXSTAT_MSG_TYPE () {	0xe000;}
}
unless(defined(&AN_ENC_TX_802_3)) {
    sub AN_ENC_TX_802_3 () {	0x00;}
}
unless(defined(&AN_ENC_TX_802_11)) {
    sub AN_ENC_TX_802_11 () {	0x11;}
}
unless(defined(&AN_ENC_TX_E_II)) {
    sub AN_ENC_TX_E_II () {	0x0e;}
}
unless(defined(&AN_ENC_TX_1042)) {
    sub AN_ENC_TX_1042 () {	0x00;}
}
unless(defined(&AN_ENC_TX_TUNNEL)) {
    sub AN_ENC_TX_TUNNEL () {	0xf8;}
}
unless(defined(&AN_TXCNTL_MACPORT)) {
    sub AN_TXCNTL_MACPORT () {	0x00ff;}
}
unless(defined(&AN_TXCNTL_STRUCTTYPE)) {
    sub AN_TXCNTL_STRUCTTYPE () {	0xff00;}
}
unless(defined(&AN_SNAP_K1)) {
    sub AN_SNAP_K1 () {	0xaa;}
}
unless(defined(&AN_SNAP_K2)) {
    sub AN_SNAP_K2 () {	0x00;}
}
unless(defined(&AN_SNAP_CONTROL)) {
    sub AN_SNAP_CONTROL () {	0x03;}
}
unless(defined(&AN_SNAP_WORD0)) {
    sub AN_SNAP_WORD0 () {	( &AN_SNAP_K1 | ( &AN_SNAP_K1 << 8));}
}
unless(defined(&AN_SNAP_WORD1)) {
    sub AN_SNAP_WORD1 () {	( &AN_SNAP_K2 | ( &AN_SNAP_CONTROL << 8));}
}
unless(defined(&AN_SNAPHDR_LEN)) {
    sub AN_SNAPHDR_LEN () {	0x6;}
}
1;
