require '_h2ph_pre.ph';

unless(defined(&_PATH_DISKTAB)) {
    sub _PATH_DISKTAB () {	"/etc/disktab";}
}
unless(defined(&DISKTAB)) {
    sub DISKTAB () {	"/etc/disktab";}
}
require 'machine/disklabel.ph';
unless(defined(&MAXMAXPARTITIONS)) {
    sub MAXMAXPARTITIONS () {	22;}
}
if((defined(&MAXPARTITIONS) ? &MAXPARTITIONS : 0) > (defined(&MAXMAXPARTITIONS) ? &MAXMAXPARTITIONS : 0)) {
}
unless(defined(&DISKUNIT)) {
    sub DISKUNIT {
	local($dev) = @_;
	eval q(( &minor($dev) /  &MAXPARTITIONS));
    }
}
unless(defined(&DISKPART)) {
    sub DISKPART {
	local($dev) = @_;
	eval q(( &minor($dev) %  &MAXPARTITIONS));
    }
}
unless(defined(&DISKMINOR)) {
    sub DISKMINOR {
	local($unit, $part) = @_;
	eval q(((($unit) *  &MAXPARTITIONS) + ($part)));
    }
}
unless(defined(&MAKEDISKDEV)) {
    sub MAKEDISKDEV {
	local($maj, $unit, $part) = @_;
	eval q(( &makedev(($maj),  &DISKMINOR(($unit), ($part)))));
    }
}
unless(defined(&DISKLABELDEV)) {
    sub DISKLABELDEV {
	local($dev) = @_;
	eval q(( &MAKEDISKDEV( &major($dev),  &DISKUNIT($dev),  &RAW_PART)));
    }
}
unless(defined(&DISKMAGIC)) {
    sub DISKMAGIC () {	(0x82564557);}
}
unless(defined(&_LOCORE)) {
    eval 'sub d_packname () { ($d_un->{un_d_packname});}' unless defined(&d_packname);
    eval 'sub d_boot0 () { ($d_un->{un_b}->{un_d_boot0});}' unless defined(&d_boot0);
    eval 'sub d_boot1 () { ($d_un->{un_b}->{un_d_boot1});}' unless defined(&d_boot1);
    eval 'sub NDDATA () {5;}' unless defined(&NDDATA);
    eval 'sub NSPARE () {5;}' unless defined(&NSPARE);
    eval 'sub p_cpg () { ($__partition_u1->{cpg});}' unless defined(&p_cpg);
    eval 'sub p_sgs () { ($__partition_u1->{sgs});}' unless defined(&p_sgs);
} else {
}
unless(defined(&DTYPE_SMD)) {
    sub DTYPE_SMD () {	1;}
}
unless(defined(&DTYPE_MSCP)) {
    sub DTYPE_MSCP () {	2;}
}
unless(defined(&DTYPE_DEC)) {
    sub DTYPE_DEC () {	3;}
}
unless(defined(&DTYPE_SCSI)) {
    sub DTYPE_SCSI () {	4;}
}
unless(defined(&DTYPE_ESDI)) {
    sub DTYPE_ESDI () {	5;}
}
unless(defined(&DTYPE_ST506)) {
    sub DTYPE_ST506 () {	6;}
}
unless(defined(&DTYPE_HPIB)) {
    sub DTYPE_HPIB () {	7;}
}
unless(defined(&DTYPE_HPFL)) {
    sub DTYPE_HPFL () {	8;}
}
unless(defined(&DTYPE_FLOPPY)) {
    sub DTYPE_FLOPPY () {	10;}
}
unless(defined(&DTYPE_CCD)) {
    sub DTYPE_CCD () {	11;}
}
unless(defined(&DTYPE_VND)) {
    sub DTYPE_VND () {	12;}
}
unless(defined(&DTYPE_ATAPI)) {
    sub DTYPE_ATAPI () {	13;}
}
unless(defined(&DTYPE_RAID)) {
    sub DTYPE_RAID () {	14;}
}
if(defined(&DKTYPENAMES)) {
    eval 'sub DKMAXTYPES () {($sizeof{ &dktypenames} / $sizeof{ $dktypenames[0]} - 1);}' unless defined(&DKMAXTYPES);
}
unless(defined(&FS_UNUSED)) {
    sub FS_UNUSED () {	0;}
}
unless(defined(&FS_SWAP)) {
    sub FS_SWAP () {	1;}
}
unless(defined(&FS_V6)) {
    sub FS_V6 () {	2;}
}
unless(defined(&FS_V7)) {
    sub FS_V7 () {	3;}
}
unless(defined(&FS_SYSV)) {
    sub FS_SYSV () {	4;}
}
unless(defined(&FS_V71K)) {
    sub FS_V71K () {	5;}
}
unless(defined(&FS_V8)) {
    sub FS_V8 () {	6;}
}
unless(defined(&FS_BSDFFS)) {
    sub FS_BSDFFS () {	7;}
}
unless(defined(&FS_MSDOS)) {
    sub FS_MSDOS () {	8;}
}
unless(defined(&FS_BSDLFS)) {
    sub FS_BSDLFS () {	9;}
}
unless(defined(&FS_OTHER)) {
    sub FS_OTHER () {	10;}
}
unless(defined(&FS_HPFS)) {
    sub FS_HPFS () {	11;}
}
unless(defined(&FS_ISO9660)) {
    sub FS_ISO9660 () {	12;}
}
unless(defined(&FS_BOOT)) {
    sub FS_BOOT () {	13;}
}
unless(defined(&FS_ADOS)) {
    sub FS_ADOS () {	14;}
}
unless(defined(&FS_HFS)) {
    sub FS_HFS () {	15;}
}
unless(defined(&FS_ADFS)) {
    sub FS_ADFS () {	16;}
}
unless(defined(&FS_EXT2FS)) {
    sub FS_EXT2FS () {	17;}
}
unless(defined(&FS_CCD)) {
    sub FS_CCD () {	18;}
}
if(defined(&DKTYPENAMES)) {
    eval 'sub FSMAXTYPES () {($sizeof{ &fstypenames} / $sizeof{ $fstypenames[0]} - 1);}' unless defined(&FSMAXTYPES);
}
unless(defined(&D_REMOVABLE)) {
    sub D_REMOVABLE () {	0x01;}
}
unless(defined(&D_ECC)) {
    sub D_ECC () {	0x02;}
}
unless(defined(&D_BADSECT)) {
    sub D_BADSECT () {	0x04;}
}
unless(defined(&D_RAMDISK)) {
    sub D_RAMDISK () {	0x08;}
}
unless(defined(&D_CHAIN)) {
    sub D_CHAIN () {	0x10;}
}
unless(defined(&d_smdflags)) {
    sub d_smdflags () {	 $d_drivedata[0];}
}
unless(defined(&D_SSE)) {
    sub D_SSE () {	0x1;}
}
unless(defined(&d_mindist)) {
    sub d_mindist () {	 $d_drivedata[1];}
}
unless(defined(&d_maxdist)) {
    sub d_maxdist () {	 $d_drivedata[2];}
}
unless(defined(&d_sdist)) {
    sub d_sdist () {	 $d_drivedata[3];}
}
unless(defined(&d_precompcyl)) {
    sub d_precompcyl () {	 $d_drivedata[0];}
}
unless(defined(&d_gap3)) {
    sub d_gap3 () {	 $d_drivedata[1];}
}
unless(defined(&d_blind)) {
    sub d_blind () {	 $d_drivedata[0];}
}
unless(defined(&_LOCORE)) {
    if(defined(&_KERNEL)) {
	if(defined(&CD9660)) {
	}
    }
}
if(!defined( &_KERNEL)  && !defined( &_LOCORE)) {
    require 'sys/cdefs.ph';
}
1;
