require '_h2ph_pre.ph';

unless(defined(&_MIPS_CPU_H_)) {
    eval 'sub _MIPS_CPU_H_ () {1;}' unless defined(&_MIPS_CPU_H_);
    require 'machine/psl.ph';
    eval 'sub KUSEG_ADDR () {0x0;}' unless defined(&KUSEG_ADDR);
    eval 'sub CACHED_MEMORY_ADDR () {0x80000000;}' unless defined(&CACHED_MEMORY_ADDR);
    eval 'sub UNCACHED_MEMORY_ADDR () {0xa0000000;}' unless defined(&UNCACHED_MEMORY_ADDR);
    eval 'sub KSEG2_ADDR () {0xc0000000;}' unless defined(&KSEG2_ADDR);
    eval 'sub MAX_MEM_ADDR () {0xbe000000;}' unless defined(&MAX_MEM_ADDR);
    eval 'sub RESERVED_ADDR () {0xbfc80000;}' unless defined(&RESERVED_ADDR);
    eval 'sub CACHED_TO_PHYS {
        local($x) = @_;
	    eval q((($x) & 0x1fffffff));
    }' unless defined(&CACHED_TO_PHYS);
    eval 'sub PHYS_TO_CACHED {
        local($x) = @_;
	    eval q((($x) |  &CACHED_MEMORY_ADDR));
    }' unless defined(&PHYS_TO_CACHED);
    eval 'sub UNCACHED_TO_PHYS {
        local($x) = @_;
	    eval q((($x) & 0x1fffffff));
    }' unless defined(&UNCACHED_TO_PHYS);
    eval 'sub PHYS_TO_UNCACHED {
        local($x) = @_;
	    eval q((($x) |  &UNCACHED_MEMORY_ADDR));
    }' unless defined(&PHYS_TO_UNCACHED);
    eval 'sub VA_TO_CINDEX {
        local($x) = @_;
	    eval q((($x) & 0xffffff |  &CACHED_MEMORY_ADDR));
    }' unless defined(&VA_TO_CINDEX);
    eval 'sub CACHED_TO_UNCACHED {
        local($x) = @_;
	    eval q(( &PHYS_TO_UNCACHED( &CACHED_TO_PHYS($x))));
    }' unless defined(&CACHED_TO_UNCACHED);
    if(defined(&_KERNEL)) {
	eval 'sub CR_BR_DELAY () {0x80000000;}' unless defined(&CR_BR_DELAY);
	eval 'sub CR_COP_ERR () {0x30000000;}' unless defined(&CR_COP_ERR);
	eval 'sub CR_EXC_CODE () {0x0000007c;}' unless defined(&CR_EXC_CODE);
	eval 'sub CR_IP () {0x0000ff00;}' unless defined(&CR_IP);
	eval 'sub CR_EXC_CODE_SHIFT () {2;}' unless defined(&CR_EXC_CODE_SHIFT);
	eval 'sub SR_COP_USABILITY () {0xf0000000;}' unless defined(&SR_COP_USABILITY);
	eval 'sub SR_COP_0_BIT () {0x10000000;}' unless defined(&SR_COP_0_BIT);
	eval 'sub SR_COP_1_BIT () {0x20000000;}' unless defined(&SR_COP_1_BIT);
	eval 'sub SR_RP () {0x08000000;}' unless defined(&SR_RP);
	eval 'sub SR_FR_32 () {0x04000000;}' unless defined(&SR_FR_32);
	eval 'sub SR_RE () {0x02000000;}' unless defined(&SR_RE);
	eval 'sub SR_BOOT_EXC_VEC () {0x00400000;}' unless defined(&SR_BOOT_EXC_VEC);
	eval 'sub SR_TLB_SHUTDOWN () {0x00200000;}' unless defined(&SR_TLB_SHUTDOWN);
	eval 'sub SR_SOFT_RESET () {0x00100000;}' unless defined(&SR_SOFT_RESET);
	eval 'sub SR_DIAG_CH () {0x00040000;}' unless defined(&SR_DIAG_CH);
	eval 'sub SR_DIAG_CE () {0x00020000;}' unless defined(&SR_DIAG_CE);
	eval 'sub SR_DIAG_PE () {0x00010000;}' unless defined(&SR_DIAG_PE);
	eval 'sub SR_KX () {0x00000080;}' unless defined(&SR_KX);
	eval 'sub SR_SX () {0x00000040;}' unless defined(&SR_SX);
	eval 'sub SR_UX () {0x00000020;}' unless defined(&SR_UX);
	eval 'sub SR_KSU_MASK () {0x00000018;}' unless defined(&SR_KSU_MASK);
	eval 'sub SR_KSU_USER () {0x00000010;}' unless defined(&SR_KSU_USER);
	eval 'sub SR_KSU_SUPER () {0x00000008;}' unless defined(&SR_KSU_SUPER);
	eval 'sub SR_KSU_KERNEL () {0x00000000;}' unless defined(&SR_KSU_KERNEL);
	eval 'sub SR_ERL () {0x00000004;}' unless defined(&SR_ERL);
	eval 'sub SR_EXL () {0x00000002;}' unless defined(&SR_EXL);
	eval 'sub SR_INT_ENAB () {0x00000001;}' unless defined(&SR_INT_ENAB);
	eval 'sub INT_MASK () {0xff00;}' unless defined(&INT_MASK);
	eval 'sub INT_MASK_5 () {0x8000;}' unless defined(&INT_MASK_5);
	eval 'sub INT_MASK_4 () {0x4000;}' unless defined(&INT_MASK_4);
	eval 'sub INT_MASK_3 () {0x2000;}' unless defined(&INT_MASK_3);
	eval 'sub INT_MASK_2 () {0x1000;}' unless defined(&INT_MASK_2);
	eval 'sub INT_MASK_1 () {0x0800;}' unless defined(&INT_MASK_1);
	eval 'sub INT_MASK_0 () {0x0400;}' unless defined(&INT_MASK_0);
	eval 'sub HARD_INT_MASK () {0xfc00;}' unless defined(&HARD_INT_MASK);
	eval 'sub SOFT_INT_MASK_1 () {0x0200;}' unless defined(&SOFT_INT_MASK_1);
	eval 'sub SOFT_INT_MASK_0 () {0x0100;}' unless defined(&SOFT_INT_MASK_0);
	eval 'sub CNTXT_PTE_BASE () {0xff800000;}' unless defined(&CNTXT_PTE_BASE);
	eval 'sub CNTXT_BAD_VPN2 () {0x007ffff0;}' unless defined(&CNTXT_BAD_VPN2);
	eval 'sub RESET_EXC_VEC () {0xbfc00000;}' unless defined(&RESET_EXC_VEC);
	eval 'sub TLB_MISS_EXC_VEC () {0x80000000;}' unless defined(&TLB_MISS_EXC_VEC);
	eval 'sub XTLB_MISS_EXC_VEC () {0x80000080;}' unless defined(&XTLB_MISS_EXC_VEC);
	eval 'sub CACHE_ERR_EXC_VEC () {0x80000100;}' unless defined(&CACHE_ERR_EXC_VEC);
	eval 'sub GEN_EXC_VEC () {0x80000180;}' unless defined(&GEN_EXC_VEC);
	eval 'sub COP_0_TLB_INDEX () {$0;}' unless defined(&COP_0_TLB_INDEX);
	eval 'sub COP_0_TLB_RANDOM () {$1;}' unless defined(&COP_0_TLB_RANDOM);
	eval 'sub COP_0_TLB_LO0 () {$2;}' unless defined(&COP_0_TLB_LO0);
	eval 'sub COP_0_TLB_LO1 () {$3;}' unless defined(&COP_0_TLB_LO1);
	eval 'sub COP_0_TLB_CONTEXT () {$4;}' unless defined(&COP_0_TLB_CONTEXT);
	eval 'sub COP_0_TLB_PG_MASK () {$5;}' unless defined(&COP_0_TLB_PG_MASK);
	eval 'sub COP_0_TLB_WIRED () {$6;}' unless defined(&COP_0_TLB_WIRED);
	eval 'sub COP_0_BAD_VADDR () {$8;}' unless defined(&COP_0_BAD_VADDR);
	eval 'sub COP_0_COUNT () {$9;}' unless defined(&COP_0_COUNT);
	eval 'sub COP_0_TLB_HI () {$10;}' unless defined(&COP_0_TLB_HI);
	eval 'sub COP_0_COMPARE () {$11;}' unless defined(&COP_0_COMPARE);
	eval 'sub COP_0_STATUS_REG () {$12;}' unless defined(&COP_0_STATUS_REG);
	eval 'sub COP_0_CAUSE_REG () {$13;}' unless defined(&COP_0_CAUSE_REG);
	eval 'sub COP_0_EXC_PC () {$14;}' unless defined(&COP_0_EXC_PC);
	eval 'sub COP_0_PRID () {$15;}' unless defined(&COP_0_PRID);
	eval 'sub COP_0_CONFIG () {$16;}' unless defined(&COP_0_CONFIG);
	eval 'sub COP_0_LLADDR () {$17;}' unless defined(&COP_0_LLADDR);
	eval 'sub COP_0_WATCH_LO () {$18;}' unless defined(&COP_0_WATCH_LO);
	eval 'sub COP_0_WATCH_HI () {$19;}' unless defined(&COP_0_WATCH_HI);
	eval 'sub COP_0_TLB_XCONTEXT () {$20;}' unless defined(&COP_0_TLB_XCONTEXT);
	eval 'sub COP_0_ECC () {$26;}' unless defined(&COP_0_ECC);
	eval 'sub COP_0_CACHE_ERR () {$27;}' unless defined(&COP_0_CACHE_ERR);
	eval 'sub COP_0_TAG_LO () {$28;}' unless defined(&COP_0_TAG_LO);
	eval 'sub COP_0_TAG_HI () {$29;}' unless defined(&COP_0_TAG_HI);
	eval 'sub COP_0_ERROR_PC () {$30;}' unless defined(&COP_0_ERROR_PC);
	eval 'sub BREAK_INSTR () {0x0000000d;}' unless defined(&BREAK_INSTR);
	eval 'sub BREAK_VAL_MASK () {0x03ff0000;}' unless defined(&BREAK_VAL_MASK);
	eval 'sub BREAK_VAL_SHIFT () {16;}' unless defined(&BREAK_VAL_SHIFT);
	eval 'sub BREAK_KDB_VAL () {512;}' unless defined(&BREAK_KDB_VAL);
	eval 'sub BREAK_SSTEP_VAL () {513;}' unless defined(&BREAK_SSTEP_VAL);
	eval 'sub BREAK_BRKPT_VAL () {514;}' unless defined(&BREAK_BRKPT_VAL);
	eval 'sub BREAK_SOVER_VAL () {515;}' unless defined(&BREAK_SOVER_VAL);
	eval 'sub BREAK_DDB_VAL () {516;}' unless defined(&BREAK_DDB_VAL);
	eval 'sub BREAK_KDB () {( &BREAK_INSTR | ( &BREAK_KDB_VAL <<  &BREAK_VAL_SHIFT));}' unless defined(&BREAK_KDB);
	eval 'sub BREAK_SSTEP () {( &BREAK_INSTR | ( &BREAK_SSTEP_VAL <<  &BREAK_VAL_SHIFT));}' unless defined(&BREAK_SSTEP);
	eval 'sub BREAK_BRKPT () {( &BREAK_INSTR | ( &BREAK_BRKPT_VAL <<  &BREAK_VAL_SHIFT));}' unless defined(&BREAK_BRKPT);
	eval 'sub BREAK_SOVER () {( &BREAK_INSTR | ( &BREAK_SOVER_VAL <<  &BREAK_VAL_SHIFT));}' unless defined(&BREAK_SOVER);
	eval 'sub BREAK_DDB () {( &BREAK_INSTR | ( &BREAK_DDB_VAL <<  &BREAK_VAL_SHIFT));}' unless defined(&BREAK_DDB);
	eval 'sub MIN_CACHE_SIZE () {(16* 1024);}' unless defined(&MIN_CACHE_SIZE);
	eval 'sub MAX_CACHE_SIZE () {(256* 1024);}' unless defined(&MAX_CACHE_SIZE);
	eval 'sub FPC_ID () {$0;}' unless defined(&FPC_ID);
	eval 'sub FPC_CSR () {$31;}' unless defined(&FPC_CSR);
	eval 'sub FPC_ROUNDING_BITS () {0x00000003;}' unless defined(&FPC_ROUNDING_BITS);
	eval 'sub FPC_ROUND_RN () {0x00000000;}' unless defined(&FPC_ROUND_RN);
	eval 'sub FPC_ROUND_RZ () {0x00000001;}' unless defined(&FPC_ROUND_RZ);
	eval 'sub FPC_ROUND_RP () {0x00000002;}' unless defined(&FPC_ROUND_RP);
	eval 'sub FPC_ROUND_RM () {0x00000003;}' unless defined(&FPC_ROUND_RM);
	eval 'sub FPC_STICKY_BITS () {0x0000007c;}' unless defined(&FPC_STICKY_BITS);
	eval 'sub FPC_STICKY_INEXACT () {0x00000004;}' unless defined(&FPC_STICKY_INEXACT);
	eval 'sub FPC_STICKY_UNDERFLOW () {0x00000008;}' unless defined(&FPC_STICKY_UNDERFLOW);
	eval 'sub FPC_STICKY_OVERFLOW () {0x00000010;}' unless defined(&FPC_STICKY_OVERFLOW);
	eval 'sub FPC_STICKY_DIV0 () {0x00000020;}' unless defined(&FPC_STICKY_DIV0);
	eval 'sub FPC_STICKY_INVALID () {0x00000040;}' unless defined(&FPC_STICKY_INVALID);
	eval 'sub FPC_ENABLE_BITS () {0x00000f80;}' unless defined(&FPC_ENABLE_BITS);
	eval 'sub FPC_ENABLE_INEXACT () {0x00000080;}' unless defined(&FPC_ENABLE_INEXACT);
	eval 'sub FPC_ENABLE_UNDERFLOW () {0x00000100;}' unless defined(&FPC_ENABLE_UNDERFLOW);
	eval 'sub FPC_ENABLE_OVERFLOW () {0x00000200;}' unless defined(&FPC_ENABLE_OVERFLOW);
	eval 'sub FPC_ENABLE_DIV0 () {0x00000400;}' unless defined(&FPC_ENABLE_DIV0);
	eval 'sub FPC_ENABLE_INVALID () {0x00000800;}' unless defined(&FPC_ENABLE_INVALID);
	eval 'sub FPC_EXCEPTION_BITS () {0x0003f000;}' unless defined(&FPC_EXCEPTION_BITS);
	eval 'sub FPC_EXCEPTION_INEXACT () {0x00001000;}' unless defined(&FPC_EXCEPTION_INEXACT);
	eval 'sub FPC_EXCEPTION_UNDERFLOW () {0x00002000;}' unless defined(&FPC_EXCEPTION_UNDERFLOW);
	eval 'sub FPC_EXCEPTION_OVERFLOW () {0x00004000;}' unless defined(&FPC_EXCEPTION_OVERFLOW);
	eval 'sub FPC_EXCEPTION_DIV0 () {0x00008000;}' unless defined(&FPC_EXCEPTION_DIV0);
	eval 'sub FPC_EXCEPTION_INVALID () {0x00010000;}' unless defined(&FPC_EXCEPTION_INVALID);
	eval 'sub FPC_EXCEPTION_UNIMPL () {0x00020000;}' unless defined(&FPC_EXCEPTION_UNIMPL);
	eval 'sub FPC_COND_BIT () {0x00800000;}' unless defined(&FPC_COND_BIT);
	eval 'sub FPC_FLUSH_BIT () {0x01000000;}' unless defined(&FPC_FLUSH_BIT);
	eval 'sub FPC_MBZ_BITS () {0xfe7c0000;}' unless defined(&FPC_MBZ_BITS);
	eval 'sub OPCODE_SHIFT () {26;}' unless defined(&OPCODE_SHIFT);
	eval 'sub OPCODE_C1 () {0x11;}' unless defined(&OPCODE_C1);
	eval 'sub VMTLB_PF_NUM () {0x3fffffc0;}' unless defined(&VMTLB_PF_NUM);
	eval 'sub VMTLB_ATTR_MASK () {0x00000038;}' unless defined(&VMTLB_ATTR_MASK);
	eval 'sub VMTLB_MOD_BIT () {0x00000004;}' unless defined(&VMTLB_MOD_BIT);
	eval 'sub VMTLB_VALID_BIT () {0x00000002;}' unless defined(&VMTLB_VALID_BIT);
	eval 'sub VMTLB_GLOBAL_BIT () {0x00000001;}' unless defined(&VMTLB_GLOBAL_BIT);
	eval 'sub VMTLB_PHYS_PAGE_SHIFT () {6;}' unless defined(&VMTLB_PHYS_PAGE_SHIFT);
	eval 'sub VMTLB_VIRT_PAGE_NUM () {0xffffe000;}' unless defined(&VMTLB_VIRT_PAGE_NUM);
	eval 'sub VMTLB_PID () {0x000000ff;}' unless defined(&VMTLB_PID);
	eval 'sub VMTLB_PID_SHIFT () {0;}' unless defined(&VMTLB_PID_SHIFT);
	eval 'sub VMTLB_VIRT_PAGE_SHIFT () {12;}' unless defined(&VMTLB_VIRT_PAGE_SHIFT);
	eval 'sub VMWIRED_ENTRIES () {8;}' unless defined(&VMWIRED_ENTRIES);
	eval 'sub VMNUM_PIDS () {256;}' unless defined(&VMNUM_PIDS);
	eval 'sub VMTLB_NOT_FOUND () {0;}' unless defined(&VMTLB_NOT_FOUND);
	eval 'sub VMTLB_FOUND () {1;}' unless defined(&VMTLB_FOUND);
	eval 'sub VMTLB_FOUND_WITH_PATCH () {2;}' unless defined(&VMTLB_FOUND_WITH_PATCH);
	eval 'sub VMTLB_PROBE_ERROR () {3;}' unless defined(&VMTLB_PROBE_ERROR);
	eval 'sub COPY_SIGCODE () {1;}' unless defined(&COPY_SIGCODE);
	eval 'sub cpu_wait {
	    local($p) = @_;
    	    eval q();
	}' unless defined(&cpu_wait);
	eval 'sub cpu_set_init_frame {
	    local($p, $fp) = @_;
    	    eval q();
	}' unless defined(&cpu_set_init_frame);
	eval 'sub cpu_swapout {
	    local($p) = @_;
    	    eval q( &panic(\\"cpu_swapout: can\'t get here\\"););
	}' unless defined(&cpu_swapout);
	unless(defined(&_LOCORE)) {
	    eval 'sub CLKF_USERMODE {
	        local($framep) = @_;
    		eval q((($framep)-> &sr &  &SR_KSU_USER));
	    }' unless defined(&CLKF_USERMODE);
	    eval 'sub CLKF_BASEPRI {
	        local($framep) = @_;
    		eval q(((~($framep)-> &sr & ( &INT_MASK| &SR_INT_ENAB)) == 0));
	    }' unless defined(&CLKF_BASEPRI);
	    eval 'sub CLKF_PC {
	        local($framep) = @_;
    		eval q((($framep)-> &pc));
	    }' unless defined(&CLKF_PC);
	    eval 'sub CLKF_INTR {
	        local($framep) = @_;
    		eval q((0));
	    }' unless defined(&CLKF_INTR);
	    eval 'sub need_resched () {
	        eval q({  &want_resched = 1;  &aston(); });
	    }' unless defined(&need_resched);
	    eval 'sub need_proftick {
	        local($p) = @_;
    		eval q({ ($p)-> &p_flag |=  &P_OWEUPC;  &aston(); });
	    }' unless defined(&need_proftick);
	    eval 'sub signotify {
	        local($p) = @_;
    		eval q( &aston());
	    }' unless defined(&signotify);
	    eval 'sub aston () {
	        eval q(( &astpending = 1));
	    }' unless defined(&aston);
	    if((defined(&BYTE_ORDER) ? &BYTE_ORDER : 0) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : 0)) {
	    } else {
	    }
	    eval 'sub CPU_CONSDEV () {1;}' unless defined(&CPU_CONSDEV);
	    eval 'sub CPU_MAXID () {2;}' unless defined(&CPU_MAXID);
	    eval 'sub CTL_MACHDEP_NAMES () {{ { 0, 0}, { "console_device",  &CTLTYPE_STRUCT }, };}' unless defined(&CTL_MACHDEP_NAMES);
	}
    }
    eval 'sub MIPS_R2000 () {0x01;}' unless defined(&MIPS_R2000);
    eval 'sub MIPS_R3000 () {0x02;}' unless defined(&MIPS_R3000);
    eval 'sub MIPS_R6000 () {0x03;}' unless defined(&MIPS_R6000);
    eval 'sub MIPS_R4000 () {0x04;}' unless defined(&MIPS_R4000);
    eval 'sub MIPS_R3LSI () {0x05;}' unless defined(&MIPS_R3LSI);
    eval 'sub MIPS_R6000A () {0x06;}' unless defined(&MIPS_R6000A);
    eval 'sub MIPS_R3IDT () {0x07;}' unless defined(&MIPS_R3IDT);
    eval 'sub MIPS_R10000 () {0x09;}' unless defined(&MIPS_R10000);
    eval 'sub MIPS_R4200 () {0x0a;}' unless defined(&MIPS_R4200);
    eval 'sub MIPS_R4300 () {0x0b;}' unless defined(&MIPS_R4300);
    eval 'sub MIPS_R4100 () {0x0c;}' unless defined(&MIPS_R4100);
    eval 'sub MIPS_R8000 () {0x10;}' unless defined(&MIPS_R8000);
    eval 'sub MIPS_R4600 () {0x20;}' unless defined(&MIPS_R4600);
    eval 'sub MIPS_R4700 () {0x21;}' unless defined(&MIPS_R4700);
    eval 'sub MIPS_R3TOSH () {0x22;}' unless defined(&MIPS_R3TOSH);
    eval 'sub MIPS_R5000 () {0x23;}' unless defined(&MIPS_R5000);
    eval 'sub MIPS_RM52X0 () {0x28;}' unless defined(&MIPS_RM52X0);
    eval 'sub MIPS_SOFT () {0x00;}' unless defined(&MIPS_SOFT);
    eval 'sub MIPS_R2360 () {0x01;}' unless defined(&MIPS_R2360);
    eval 'sub MIPS_R2010 () {0x02;}' unless defined(&MIPS_R2010);
    eval 'sub MIPS_R3010 () {0x03;}' unless defined(&MIPS_R3010);
    eval 'sub MIPS_R6010 () {0x04;}' unless defined(&MIPS_R6010);
    eval 'sub MIPS_R4010 () {0x05;}' unless defined(&MIPS_R4010);
    eval 'sub MIPS_R31LSI () {0x06;}' unless defined(&MIPS_R31LSI);
    eval 'sub MIPS_R10010 () {0x09;}' unless defined(&MIPS_R10010);
    eval 'sub MIPS_R4210 () {0x0a;}' unless defined(&MIPS_R4210);
    eval 'sub MIPS_UNKF1 () {0x0b;}' unless defined(&MIPS_UNKF1);
    eval 'sub MIPS_R8000 () {0x10;}' unless defined(&MIPS_R8000);
    eval 'sub MIPS_R4600 () {0x20;}' unless defined(&MIPS_R4600);
    eval 'sub MIPS_R3SONY () {0x21;}' unless defined(&MIPS_R3SONY);
    eval 'sub MIPS_R3TOSH () {0x22;}' unless defined(&MIPS_R3TOSH);
    eval 'sub MIPS_R5010 () {0x23;}' unless defined(&MIPS_R5010);
    eval 'sub MIPS_RM5230 () {0x28;}' unless defined(&MIPS_RM5230);
    if(defined( &_KERNEL)  && !defined( &_LOCORE)) {
	eval 'sub enablertclock () {
	    eval q();
	}' unless defined(&enablertclock);
    }
}
1;
