require '_h2ph_pre.ph';

unless(defined(&CY8_SVCACKR)) {
    sub CY8_SVCACKR () {	0x100;}
}
unless(defined(&CY8_SVCACKT)) {
    sub CY8_SVCACKT () {	0x200;}
}
unless(defined(&CY8_SVCACKM)) {
    sub CY8_SVCACKM () {	0x300;}
}
unless(defined(&CY_CD1400_MEMSPACING)) {
    sub CY_CD1400_MEMSPACING () {	0x400;}
}
unless(defined(&CY32_ADDR_FIX)) {
    sub CY32_ADDR_FIX () {	0xe00;}
}
unless(defined(&CY16_RESET)) {
    sub CY16_RESET () {	0x1400;}
}
unless(defined(&CY_CLEAR_INTR)) {
    sub CY_CLEAR_INTR () {	0x1800;}
}
unless(defined(&CY_MAX_CD1400s)) {
    sub CY_MAX_CD1400s () {	8;}
}
unless(defined(&CY_PCI_INTENA)) {
    sub CY_PCI_INTENA () {	0x68;}
}
unless(defined(&CY_CLOCK)) {
    sub CY_CLOCK () {	25000000;}
}
unless(defined(&CY_BUSTYPE_ISA)) {
    sub CY_BUSTYPE_ISA () {	0;}
}
unless(defined(&CY_BUSTYPE_PCI)) {
    sub CY_BUSTYPE_PCI () {	1;}
}
unless(defined(&RX_FIFO_THRESHOLD)) {
    sub RX_FIFO_THRESHOLD () {	6;}
}
unless(defined(&RX_DTR_THRESHOLD)) {
    sub RX_DTR_THRESHOLD () {	9;}
}
unless(defined(&CY_MAX_PORTS)) {
    sub CY_MAX_PORTS () {	( &CD1400_NO_OF_CHANNELS *  &CY_MAX_CD1400s);}
}
unless(defined(&CY_PORT)) {
    sub CY_PORT {
	local($x) = @_;
	eval q(( &minor($x) & 0xf));
    }
}
unless(defined(&CY_CARD)) {
    sub CY_CARD {
	local($x) = @_;
	eval q((( &minor($x) >> 5) & 3));
    }
}
unless(defined(&CY_DIALOUT)) {
    sub CY_DIALOUT {
	local($x) = @_;
	eval q((( &minor($x) & 0x80) != 0));
    }
}
unless(defined(&CY_DIALIN)) {
    sub CY_DIALIN {
	local($x) = @_;
	eval q((! &CY_DIALOUT($x)));
    }
}
unless(defined(&cd_read_reg)) {
    sub cd_read_reg {
	local($cy,$reg) = @_;
	eval q( &bus_space_read_1( ($cy->{cy_memt}),  ($cy->{cy_memh}),  ($cy->{cy_chip_offs})+((($reg<<1))<< ($cy->{cy_bustype}))));
    }
}
unless(defined(&cd_write_reg)) {
    sub cd_write_reg {
	local($cy,$reg,$val) = @_;
	eval q( &bus_space_write_1( ($cy->{cy_memt}),  ($cy->{cy_memh}),  ($cy->{cy_chip_offs})+((($reg<<1))<< ($cy->{cy_bustype})), ($val)));
    }
}
unless(defined(&cd_read_reg_sc)) {
    sub cd_read_reg_sc {
	local($sc,$chip,$reg) = @_;
	eval q( &bus_space_read_1( ($sc->{sc_memt}),  ($sc->{sc_memh}),  ($sc->{sc_cd1400_offs[$chip]})+ ((($reg<<1))<< ($sc->{sc_bustype}))));
    }
}
unless(defined(&cd_write_reg_sc)) {
    sub cd_write_reg_sc {
	local($sc,$chip,$reg,$val) = @_;
	eval q( &bus_space_write_1( ($sc->{sc_memt}),  ($sc->{sc_memh}),  ($sc->{sc_cd1400_offs[$chip]})+ ((($reg<<1))<< ($sc->{sc_bustype})), ($val)));
    }
}
unless(defined(&IBUF_SIZE)) {
    sub IBUF_SIZE () {	(2*512);}
}
if(defined(&CY_DEBUG1)) {
}
unless(defined(&CYF_CARRIER_CHANGED)) {
    sub CYF_CARRIER_CHANGED () {	0x01;}
}
unless(defined(&CYF_START_BREAK)) {
    sub CYF_START_BREAK () {	0x02;}
}
unless(defined(&CYF_END_BREAK)) {
    sub CYF_END_BREAK () {	0x04;}
}
unless(defined(&CYF_STOP)) {
    sub CYF_STOP () {	0x08;}
}
unless(defined(&CYF_SEND_NUL)) {
    sub CYF_SEND_NUL () {	0x10;}
}
unless(defined(&CYF_START)) {
    sub CYF_START () {	0x20;}
}
if(defined(&CY_DEBUG1)) {
}
1;
