#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 name["english"] = "IIS perl.exe problem";
 name["francais"] = "IIS perl.exe problem";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "It was possible to
get the physical location of a
virtual web directory of this host by 
issuing the command :

	GET /scripts/no-such-file.pl HTTP/1.0
	
Usually, the less the crackers know about your
system, the better it feels, so you should
correct this problem.

Solution : user perlis.dll instead of perl.exe.

Risk factor : Low";

 desc["francais"] = "Il s'est avr possible
d'obtenir l'emplacement physique du
dossier web virtuel de ce serveur
en entrant la commande :

	GET /scripts/no-such-file.pl HTTP/1.0
	
D'habitude, moins les pirates en savent sur
votre systme, mieux il se porte, donc vous
devriez corriger ce problme.

Solution : utilisez perlis.dll plutot que
perl.exe.

Facteur de risque : Faible";

 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Attempts to find the location of the remote web root";
 summary["francais"] = "Essaye de trouver le chemin d'accs  la racine web distante";
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_ATTACK);
 
 
 script_copyright(english:"This script is Copyright (C) 1999 Renaud Deraison",
		francais:"Ce script est Copyright (C) 1999 Renaud Deraison");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes");
 
 exit(0);
}

#
# The script code starts here
#

port = get_kb_item("Services/www");
if(!port)port = 80;
if(get_port_state(port))
{
 soc = open_sock_tcp(port);
 if(soc)
 {
  d = string("GET /scripts/no-such-file.pl HTTP/1.0\r\n\r\n");
  send(socket:soc, data:d);
  r = recv(socket:soc, length:2048);
  r = tolower(r);
  if("perl script" >< r)security_warning(port);
  close(soc);
 }
}
