require '_h2ph_pre.ph';

unless(defined(&_VM_OBJECT_)) {
    eval 'sub _VM_OBJECT_ () {1;}' unless defined(&_VM_OBJECT_);
    require 'vm/vm_page.ph';
    require 'vm/vm_pager.ph';
    if(!defined( &UVM)) {
	eval 'sub OBJ_CANPERSIST () {0x0001;}' unless defined(&OBJ_CANPERSIST);
	eval 'sub OBJ_INTERNAL () {0x0002;}' unless defined(&OBJ_INTERNAL);
	eval 'sub OBJ_ACTIVE () {0x0004;}' unless defined(&OBJ_ACTIVE);
	eval 'sub OBJ_FADING () {0x0008;}' unless defined(&OBJ_FADING);
	eval 'sub OBJ_WAITING () {0x8000;}' unless defined(&OBJ_WAITING);
	if(defined(&_KERNEL)) {
	    eval 'sub vm_object_cache_lock () {
	        eval q( &simple_lock( &vm_cache_lock));
	    }' unless defined(&vm_object_cache_lock);
	    eval 'sub vm_object_cache_unlock () {
	        eval q( &simple_unlock( &vm_cache_lock));
	    }' unless defined(&vm_object_cache_unlock);
	}
	eval 'sub vm_object_lock_init {
	    local($object) = @_;
    	    eval q( &simple_lock_init(($object)-> &Lock));
	}' unless defined(&vm_object_lock_init);
	eval 'sub vm_object_lock {
	    local($object) = @_;
    	    eval q( &simple_lock(($object)-> &Lock));
	}' unless defined(&vm_object_lock);
	eval 'sub vm_object_unlock {
	    local($object) = @_;
    	    eval q( &simple_unlock(($object)-> &Lock));
	}' unless defined(&vm_object_unlock);
	eval 'sub vm_object_lock_try {
	    local($object) = @_;
    	    eval q( &simple_lock_try(($object)-> &Lock));
	}' unless defined(&vm_object_lock_try);
	eval 'sub vm_object_sleep {
	    local($event, $object, $interruptible, $where) = @_;
    	    eval q( &do { ($object)-> &flags |=  &OBJ_WAITING;  &thread_sleep_msg(($event), ($object)-> &Lock, ($interruptible), ($where), 0); }  &while (0));
	}' unless defined(&vm_object_sleep);
	eval 'sub vm_object_wakeup {
	    local($object) = @_;
    	    eval q( &do {  &if (($object)-> &flags &  &OBJ_WAITING) { ($object)-> &flags &= ~ &OBJ_WAITING;  &thread_wakeup(($object)); } }  &while (0));
	}' unless defined(&vm_object_wakeup);
	eval 'sub vm_object_paging {
	    local($object) = @_;
    	    eval q((($object)-> &paging_in_progress != 0));
	}' unless defined(&vm_object_paging);
	unless(defined(&DIAGNOSTIC)) {
	    eval 'sub vm_object_paging_begin {
	        local($object) = @_;
    		eval q( &do { ($object)-> &paging_in_progress++; }  &while (0));
	    }' unless defined(&vm_object_paging_begin);
	} else {
	    eval 'sub vm_object_paging_begin {
	        local($object) = @_;
    		eval q( &do {  &if (($object)-> &paging_in_progress == 0xdead)  &panic(\\"vm_object_paging_begin\\"); ($object)-> &paging_in_progress++; }  &while (0));
	    }' unless defined(&vm_object_paging_begin);
	}
	eval 'sub vm_object_paging_end {
	    local($object) = @_;
    	    eval q( &do {  &if (--(($object)-> &paging_in_progress) == 0)  &vm_object_wakeup(($object)); }  &while (0));
	}' unless defined(&vm_object_paging_end);
	eval 'sub vm_object_paging_wait {
	    local($object,$msg) = @_;
    	    eval q( &do {  &while ( &vm_object_paging(($object))) {  &vm_object_sleep(($object), ($object),  &FALSE, ($msg));  &vm_object_lock(($object)); } }  &while (0));
	}' unless defined(&vm_object_paging_wait);
	if(defined(&_KERNEL)) {
	}
    }
}
1;
