require '_h2ph_pre.ph';

unless(defined(&_MVME68K_PMAP_H_)) {
    eval 'sub _MVME68K_PMAP_H_ () {1;}' unless defined(&_MVME68K_PMAP_H_);
    require 'machine/pte.ph';
    if(defined( &M68040)) {
	eval 'sub M68K_SEG_SIZE () {( &mmutype ==  &MMU_68040 ? 0x40000 :  &NBSEG);}' unless defined(&M68K_SEG_SIZE);
    } else {
	eval 'sub M68K_SEG_SIZE () { &NBSEG;}' unless defined(&M68K_SEG_SIZE);
    }
    eval 'sub m68k_trunc_seg {
        local($x) = @_;
	    eval q(((($x)) & ~( &M68K_SEG_SIZE-1)));
    }' unless defined(&m68k_trunc_seg);
    eval 'sub m68k_round_seg {
        local($x) = @_;
	    eval q( &m68k_trunc_seg(($x) +  &M68K_SEG_SIZE-1));
    }' unless defined(&m68k_round_seg);
    eval 'sub MAXKL2SIZE () {32;}' unless defined(&MAXKL2SIZE);
    eval 'sub MAXUL2SIZE () {8;}' unless defined(&MAXUL2SIZE);
    eval 'sub l2tobm {
        local($n) = @_;
	    eval q((1<< ($n)));
    }' unless defined(&l2tobm);
    eval 'sub bmtol2 {
        local($n) = @_;
	    eval q(( &ffs($n) - 1));
    }' unless defined(&bmtol2);
    eval 'sub PMAP_ACTIVATE {
        local($pmapp, $pcbp, $iscurproc) = @_;
	    eval q( &if (-> &pm_stchanged) { -> &pcb_ustp =  &m68k_btop(-> &pm_stpa);  &if  &loadustp(($pcbp)-> &pcb_ustp); ($pmapp)-> &pm_stchanged =  &FALSE; });
    }' unless defined(&PMAP_ACTIVATE);
    eval 'sub PMAP_DEACTIVATE {
        local($pmapp, $pcbp) = @_;
	    eval q();
    }' unless defined(&PMAP_DEACTIVATE);
    eval 'sub PV_CI () {0x01;}' unless defined(&PV_CI);
    eval 'sub PV_PTPAGE () {0x02;}' unless defined(&PV_PTPAGE);
    eval 'sub NPVPPG () {170;}' unless defined(&NPVPPG);
    if(defined(&_KERNEL)) {
	eval 'sub pmap_kernel () {
	    eval q(( &kernel_pmap_store));
	}' unless defined(&pmap_kernel);
	eval 'sub active_pmap {
	    local($pm) = @_;
    	    eval q((($pm) ==  &pmap_kernel() || ($pm) ==  ($curproc->{p_vmspace}->{vm_map}->{pmap})));
	}' unless defined(&active_pmap);
	eval 'sub pmap_page_index {
	    local($pa) = @_;
    	    eval q( &atop($pa -  &vm_first_phys));
	}' unless defined(&pmap_page_index);
	eval 'sub pmap_resident_count {
	    local($pmap) = @_;
    	    eval q((($pmap)-> ($pm_stats->{resident_count})));
	}' unless defined(&pmap_resident_count);
	eval 'sub pmap_wired_count {
	    local($pmap) = @_;
    	    eval q((($pmap)-> ($pm_stats->{wired_count})));
	}' unless defined(&pmap_wired_count);
    }
}
1;
