require '_h2ph_pre.ph';

if(defined( &__NetBSD__)) {
    require 'sys/param.ph';
    require 'sys/systm.ph';
    require 'sys/mbuf.ph';
    require 'sys/protosw.ph';
    require 'sys/socket.ph';
    require 'sys/ioctl.ph';
    require 'sys/errno.ph';
    require 'sys/malloc.ph';
    require 'sys/kernel.ph';
    require 'sys/proc.ph';
    require 'sys/device.ph';
    require 'net/if.ph';
    if(defined( &SIOCSIFMEDIA)) {
	require 'net/if_media.ph';
    }
    require 'net/if_types.ph';
    require 'net/if_dl.ph';
    require 'net/route.ph';
    require 'net/netisr.ph';
    require 'bpfilter.ph';
    if((defined(&NBPFILTER) ? &NBPFILTER : 0) > 0) {
	require 'net/bpf.ph';
	require 'net/bpfdesc.ph';
    }
    if(defined(&INET)) {
	require 'netinet/in.ph';
	require 'netinet/in_systm.ph';
	require 'netinet/in_var.ph';
	require 'netinet/ip.ph';
    }
    if(defined(&NS)) {
	require 'netns/ns.ph';
	require 'netns/ns_if.ph';
    }
    require 'vm/vm.ph';
    require 'vm/vm_param.ph';
    require 'vm/vm_kern.ph';
    require 'net/if_ether.ph';
    if(defined( &INET)) {
	require 'netinet/if_inarp.ph';
    }
    require 'machine/bus.ph';
    require 'machine/intr.ph';
    require 'dev/pci/pcireg.ph';
    require 'dev/pci/pcivar.ph';
    require 'dev/pci/pcidevs.ph';
    require 'dev/pci/if_wxreg.ph';
    eval 'sub wx_dev () { ($w->{dev});}' unless defined(&wx_dev);
    eval 'sub wx_enaddr () { ($w->{enaddr});}' unless defined(&wx_enaddr);
    eval 'sub wx_cmdw () { ($w->{cmdw});}' unless defined(&wx_cmdw);
    eval 'sub wx_media () { ($w->{ifm});}' unless defined(&wx_media);
    eval 'sub wx_next () { ($w->{next});}' unless defined(&wx_next);
    eval 'sub wx_if () { ($w->{ethercom}->{ec_if});}' unless defined(&wx_if);
    eval 'sub wx_name () { ($w->{dev}->{dv_xname});}' unless defined(&wx_name);
    eval 'sub IOCTL_CMD_TYPE () {\'u_long\';}' unless defined(&IOCTL_CMD_TYPE);
    eval 'sub WXMALLOC {
        local($len) = @_;
	    eval q( &malloc($len,  &M_DEVBUF,  &M_NOWAIT));
    }' unless defined(&WXMALLOC);
    eval 'sub WXFREE {
        local($ptr) = @_;
	    eval q( &free($ptr,  &M_DEVBUF));
    }' unless defined(&WXFREE);
    eval 'sub SOFTC_IFP {
        local($ifp) = @_;
	    eval q( ($ifp->{if_softc}));
    }' unless defined(&SOFTC_IFP);
    eval 'sub WX_BPFTAP_ARG {
        local($ifp) = @_;
	    eval q(($ifp)-> &if_bpf);
    }' unless defined(&WX_BPFTAP_ARG);
    eval 'sub TIMEOUT {
        local($sc, $func, $arg, $time) = @_;
	    eval q( &timeout($func, $arg, $time));
    }' unless defined(&TIMEOUT);
    eval 'sub VTIMEOUT {
        local($sc, $func, $arg, $time) = @_;
	    eval q( &timeout($func, $arg, $time));
    }' unless defined(&VTIMEOUT);
    eval 'sub UNTIMEOUT {
        local($f, $arg, $sc) = @_;
	    eval q( &untimeout($f, $arg));
    }' unless defined(&UNTIMEOUT);
    eval 'sub INLINE () { &inline;}' unless defined(&INLINE);
    eval 'sub vm_offset_t () { &vaddr_t;}' unless defined(&vm_offset_t);
    unless(defined(&IFM_1000_SX)) {
	eval 'sub IFM_1000_SX () { &IFM_1000_FX;}' unless defined(&IFM_1000_SX);
    }
    eval 'sub READ_CSR () { &_read_csr;}' unless defined(&READ_CSR);
    eval 'sub WRITE_CSR () { &_write_csr;}' unless defined(&WRITE_CSR);
}
 elsif(defined( &__FreeBSD__)) {
    require 'sys/param.ph';
    require 'sys/systm.ph';
    require 'sys/mbuf.ph';
    require 'sys/protosw.ph';
    require 'sys/socket.ph';
    require 'sys/malloc.ph';
    require 'sys/kernel.ph';
    require 'net/if.ph';
    require 'net/if_dl.ph';
    require 'net/if_media.ph';
    if(defined(&NS)) {
	require 'netns/ns.ph';
	require 'netns/ns_if.ph';
    }
    require 'net/bpf.ph';
    require 'sys/sockio.ph';
    require 'sys/bus.ph';
    require 'machine/bus.ph';
    require 'sys/rman.ph';
    require 'machine/resource.ph';
    require 'net/ethernet.ph';
    require 'net/if_arp.ph';
    require 'vm/vm.ph';
    require 'vm/pmap.ph';
    require 'machine/clock.ph';
    require 'pci/pcivar.ph';
    require 'pci/pcireg.ph';
    require 'pci/if_wxreg.ph';
    require 'opt_bdg.ph';
    if(defined(&BRIDGE)) {
	require 'net/if_types.ph';
	require 'net/bridge.ph';
    }
    eval 'sub wx_dev () { ($w->{dev});}' unless defined(&wx_dev);
    eval 'sub wx_enaddr () { ($w->{arpcom}->{ac_enaddr});}' unless defined(&wx_enaddr);
    eval 'sub wx_cmdw () { ($w->{cmdw});}' unless defined(&wx_cmdw);
    eval 'sub wx_media () { ($w->{ifm});}' unless defined(&wx_media);
    eval 'sub wx_next () { ($w->{next});}' unless defined(&wx_next);
    eval 'sub wx_if () { ($w->{arpcom}->{ac_if});}' unless defined(&wx_if);
    eval 'sub wx_name () { ($w->{name});}' unless defined(&wx_name);
    eval 'sub IOCTL_CMD_TYPE () {\'u_long\';}' unless defined(&IOCTL_CMD_TYPE);
    eval 'sub WXMALLOC {
        local($len) = @_;
	    eval q( &malloc($len,  &M_DEVBUF,  &M_NOWAIT));
    }' unless defined(&WXMALLOC);
    eval 'sub WXFREE {
        local($ptr) = @_;
	    eval q( &free($ptr,  &M_DEVBUF));
    }' unless defined(&WXFREE);
    eval 'sub SOFTC_IFP {
        local($ifp) = @_;
	    eval q( ($ifp->{if_softc}));
    }' unless defined(&SOFTC_IFP);
    eval 'sub WX_BPFTAP_ARG {
        local($ifp) = @_;
	    eval q($ifp);
    }' unless defined(&WX_BPFTAP_ARG);
    eval 'sub VTIMEOUT {
        local($sc, $func, $arg, $time) = @_;
	    eval q(  &timeout($func, $arg, $time));
    }' unless defined(&VTIMEOUT);
    eval 'sub TIMEOUT {
        local($sc, $func, $arg, $time) = @_;
	    eval q(($sc)-> ($w->{sch}) =  &timeout($func, $arg, $time));
    }' unless defined(&TIMEOUT);
    eval 'sub UNTIMEOUT {
        local($f, $arg, $sc) = @_;
	    eval q( &untimeout($f, $arg, ($sc)-> ($w->{sch})));
    }' unless defined(&UNTIMEOUT);
    eval 'sub INLINE () { &__inline;}' unless defined(&INLINE);
    eval 'sub READ_CSR {
        local($sc, $reg) = @_;
	    eval q( &bus_space_read_4(($sc)-> ($w->{st}), ($sc)-> ($w->{sh}), ($reg)));
    }' unless defined(&READ_CSR);
    eval 'sub WRITE_CSR {
        local($sc, $reg, $val) = @_;
	    eval q( &bus_space_write_4(($sc)-> ($w->{st}), ($sc)-> ($w->{sh}), ($reg), ($val)));
    }' unless defined(&WRITE_CSR);
}
 elsif(defined( &__OpenBSD__)) {
    require 'sys/param.ph';
    require 'sys/systm.ph';
    require 'sys/mbuf.ph';
    require 'sys/protosw.ph';
    require 'sys/socket.ph';
    require 'sys/ioctl.ph';
    require 'sys/errno.ph';
    require 'sys/malloc.ph';
    require 'sys/kernel.ph';
    require 'sys/proc.ph';
    require 'sys/device.ph';
    require 'net/if.ph';
    require 'net/if_dl.ph';
    require 'net/if_types.ph';
    require 'net/if_media.ph';
    if(defined(&INET)) {
	require 'netinet/in.ph';
	require 'netinet/in_systm.ph';
	require 'netinet/in_var.ph';
	require 'netinet/ip.ph';
	require 'netinet/if_ether.ph';
    }
    if(defined(&NS)) {
	require 'netns/ns.ph';
	require 'netns/ns_if.ph';
    }
    require 'bpfilter.ph';
    if((defined(&NBPFILTER) ? &NBPFILTER : 0) > 0) {
	require 'net/bpf.ph';
	require 'net/bpfdesc.ph';
    }
    require 'vm/vm.ph';
    require 'vm/vm_param.ph';
    require 'vm/vm_kern.ph';
    require 'machine/bus.ph';
    require 'machine/intr.ph';
    require 'dev/pci/pcireg.ph';
    require 'dev/pci/pcivar.ph';
    require 'dev/pci/pcidevs.ph';
    require 'dev/pci/if_wxreg.ph';
    eval 'sub wx_dev () { ($w->{dev});}' unless defined(&wx_dev);
    eval 'sub wx_enaddr () { ($w->{arpcom}->{ac_enaddr});}' unless defined(&wx_enaddr);
    eval 'sub wx_cmdw () { ($w->{cmdw});}' unless defined(&wx_cmdw);
    eval 'sub wx_media () { ($w->{ifm});}' unless defined(&wx_media);
    eval 'sub wx_next () { ($w->{next});}' unless defined(&wx_next);
    eval 'sub wx_if () { ($w->{arpcom}->{ac_if});}' unless defined(&wx_if);
    eval 'sub wx_name () { ($w->{dev}->{dv_xname});}' unless defined(&wx_name);
    eval 'sub IOCTL_CMD_TYPE () {\'u_long\';}' unless defined(&IOCTL_CMD_TYPE);
    eval 'sub WXMALLOC {
        local($len) = @_;
	    eval q( &malloc($len,  &M_DEVBUF,  &M_NOWAIT));
    }' unless defined(&WXMALLOC);
    eval 'sub WXFREE {
        local($ptr) = @_;
	    eval q( &free($ptr,  &M_DEVBUF));
    }' unless defined(&WXFREE);
    eval 'sub SOFTC_IFP {
        local($ifp) = @_;
	    eval q( ($ifp->{if_softc}));
    }' unless defined(&SOFTC_IFP);
    eval 'sub WX_BPFTAP_ARG {
        local($ifp) = @_;
	    eval q(($ifp)-> &if_bpf);
    }' unless defined(&WX_BPFTAP_ARG);
    eval 'sub TIMEOUT {
        local($sc, $func, $arg, $time) = @_;
	    eval q( &timeout($func, $arg, $time));
    }' unless defined(&TIMEOUT);
    eval 'sub VTIMEOUT {
        local($sc, $func, $arg, $time) = @_;
	    eval q( &timeout($func, $arg, $time));
    }' unless defined(&VTIMEOUT);
    eval 'sub UNTIMEOUT {
        local($f, $arg, $sc) = @_;
	    eval q( &untimeout($f, $arg));
    }' unless defined(&UNTIMEOUT);
    eval 'sub INLINE () { &inline;}' unless defined(&INLINE);
    eval 'sub vm_offset_t () { &vaddr_t;}' unless defined(&vm_offset_t);
    eval 'sub READ_CSR () { &_read_csr;}' unless defined(&READ_CSR);
    eval 'sub WRITE_CSR () { &_write_csr;}' unless defined(&WRITE_CSR);
}
unless(defined(&WX_RX_OFFSET_VALUE)) {
    sub WX_RX_OFFSET_VALUE () {	2;}
}
unless(defined(&WX_MAX_TDESC)) {
    sub WX_MAX_TDESC () {	256;}
}
unless(defined(&T_NXT_IDX)) {
    sub T_NXT_IDX {
	local($x) = @_;
	eval q((($x + 1) & ( &WX_MAX_TDESC - 1)));
    }
}
unless(defined(&T_PREV_IDX)) {
    sub T_PREV_IDX {
	local($x) = @_;
	eval q((($x - 1) & ( &WX_MAX_TDESC - 1)));
    }
}
unless(defined(&WX_MAX_RDESC)) {
    sub WX_MAX_RDESC () {	64;}
}
if(defined(&PADDED_CELL)) {
    eval 'sub RXINCR () {2;}' unless defined(&RXINCR);
} else {
    eval 'sub RXINCR () {1;}' unless defined(&RXINCR);
}
unless(defined(&R_NXT_IDX)) {
    sub R_NXT_IDX {
	local($x) = @_;
	eval q((($x +  &RXINCR) & ( &WX_MAX_RDESC - 1)));
    }
}
unless(defined(&R_PREV_IDX)) {
    sub R_PREV_IDX {
	local($x) = @_;
	eval q((($x -  &RXINCR) & ( &WX_MAX_RDESC - 1)));
    }
}
1;
