require '_h2ph_pre.ph';

unless(defined(&VR_PAR0)) {
    sub VR_PAR0 () {	0x00;}
}
unless(defined(&VR_PAR1)) {
    sub VR_PAR1 () {	0x04;}
}
unless(defined(&VR_RXCFG)) {
    sub VR_RXCFG () {	0x06;}
}
unless(defined(&VR_TXCFG)) {
    sub VR_TXCFG () {	0x07;}
}
unless(defined(&VR_COMMAND)) {
    sub VR_COMMAND () {	0x08;}
}
unless(defined(&VR_ISR)) {
    sub VR_ISR () {	0x0c;}
}
unless(defined(&VR_IMR)) {
    sub VR_IMR () {	0x0e;}
}
unless(defined(&VR_MAR0)) {
    sub VR_MAR0 () {	0x10;}
}
unless(defined(&VR_MAR1)) {
    sub VR_MAR1 () {	0x14;}
}
unless(defined(&VR_RXADDR)) {
    sub VR_RXADDR () {	0x18;}
}
unless(defined(&VR_TXADDR)) {
    sub VR_TXADDR () {	0x1c;}
}
unless(defined(&VR_CURRXDESC0)) {
    sub VR_CURRXDESC0 () {	0x20;}
}
unless(defined(&VR_CURRXDESC1)) {
    sub VR_CURRXDESC1 () {	0x24;}
}
unless(defined(&VR_CURRXDESC2)) {
    sub VR_CURRXDESC2 () {	0x28;}
}
unless(defined(&VR_CURRXDESC3)) {
    sub VR_CURRXDESC3 () {	0x2c;}
}
unless(defined(&VR_NEXTRXDESC0)) {
    sub VR_NEXTRXDESC0 () {	0x30;}
}
unless(defined(&VR_NEXTRXDESC1)) {
    sub VR_NEXTRXDESC1 () {	0x34;}
}
unless(defined(&VR_NEXTRXDESC2)) {
    sub VR_NEXTRXDESC2 () {	0x38;}
}
unless(defined(&VR_NEXTRXDESC3)) {
    sub VR_NEXTRXDESC3 () {	0x3c;}
}
unless(defined(&VR_CURTXDESC0)) {
    sub VR_CURTXDESC0 () {	0x40;}
}
unless(defined(&VR_CURTXDESC1)) {
    sub VR_CURTXDESC1 () {	0x44;}
}
unless(defined(&VR_CURTXDESC2)) {
    sub VR_CURTXDESC2 () {	0x48;}
}
unless(defined(&VR_CURTXDESC3)) {
    sub VR_CURTXDESC3 () {	0x4c;}
}
unless(defined(&VR_NEXTTXDESC0)) {
    sub VR_NEXTTXDESC0 () {	0x50;}
}
unless(defined(&VR_NEXTTXDESC1)) {
    sub VR_NEXTTXDESC1 () {	0x54;}
}
unless(defined(&VR_NEXTTXDESC2)) {
    sub VR_NEXTTXDESC2 () {	0x58;}
}
unless(defined(&VR_NEXTTXDESC3)) {
    sub VR_NEXTTXDESC3 () {	0x5c;}
}
unless(defined(&VR_CURRXDMA)) {
    sub VR_CURRXDMA () {	0x60;}
}
unless(defined(&VR_CURTXDMA)) {
    sub VR_CURTXDMA () {	0x64;}
}
unless(defined(&VR_TALLYCNT)) {
    sub VR_TALLYCNT () {	0x68;}
}
unless(defined(&VR_PHYADDR)) {
    sub VR_PHYADDR () {	0x6c;}
}
unless(defined(&VR_MIISTAT)) {
    sub VR_MIISTAT () {	0x6d;}
}
unless(defined(&VR_BCR0)) {
    sub VR_BCR0 () {	0x6e;}
}
unless(defined(&VR_BCR1)) {
    sub VR_BCR1 () {	0x6f;}
}
unless(defined(&VR_MIICMD)) {
    sub VR_MIICMD () {	0x70;}
}
unless(defined(&VR_MIIADDR)) {
    sub VR_MIIADDR () {	0x71;}
}
unless(defined(&VR_MIIDATA)) {
    sub VR_MIIDATA () {	0x72;}
}
unless(defined(&VR_EECSR)) {
    sub VR_EECSR () {	0x74;}
}
unless(defined(&VR_TEST)) {
    sub VR_TEST () {	0x75;}
}
unless(defined(&VR_GPIO)) {
    sub VR_GPIO () {	0x76;}
}
unless(defined(&VR_CONFIG)) {
    sub VR_CONFIG () {	0x78;}
}
unless(defined(&VR_MPA_CNT)) {
    sub VR_MPA_CNT () {	0x7c;}
}
unless(defined(&VR_CRC_CNT)) {
    sub VR_CRC_CNT () {	0x7e;}
}
unless(defined(&VR_RXCFG_RX_ERRPKTS)) {
    sub VR_RXCFG_RX_ERRPKTS () {	0x01;}
}
unless(defined(&VR_RXCFG_RX_RUNT)) {
    sub VR_RXCFG_RX_RUNT () {	0x02;}
}
unless(defined(&VR_RXCFG_RX_MULTI)) {
    sub VR_RXCFG_RX_MULTI () {	0x04;}
}
unless(defined(&VR_RXCFG_RX_BROAD)) {
    sub VR_RXCFG_RX_BROAD () {	0x08;}
}
unless(defined(&VR_RXCFG_RX_PROMISC)) {
    sub VR_RXCFG_RX_PROMISC () {	0x10;}
}
unless(defined(&VR_RXCFG_RX_THRESH)) {
    sub VR_RXCFG_RX_THRESH () {	0xe0;}
}
unless(defined(&VR_RXTHRESH_32BYTES)) {
    sub VR_RXTHRESH_32BYTES () {	0x00;}
}
unless(defined(&VR_RXTHRESH_64BYTES)) {
    sub VR_RXTHRESH_64BYTES () {	0x20;}
}
unless(defined(&VR_RXTHRESH_128BYTES)) {
    sub VR_RXTHRESH_128BYTES () {	0x40;}
}
unless(defined(&VR_RXTHRESH_256BYTES)) {
    sub VR_RXTHRESH_256BYTES () {	0x60;}
}
unless(defined(&VR_RXTHRESH_512BYTES)) {
    sub VR_RXTHRESH_512BYTES () {	0x80;}
}
unless(defined(&VR_RXTHRESH_768BYTES)) {
    sub VR_RXTHRESH_768BYTES () {	0xa0;}
}
unless(defined(&VR_RXTHRESH_1024BYTES)) {
    sub VR_RXTHRESH_1024BYTES () {	0xc0;}
}
unless(defined(&VR_RXTHRESH_STORENFWD)) {
    sub VR_RXTHRESH_STORENFWD () {	0xe0;}
}
unless(defined(&VR_TXCFG_RSVD0)) {
    sub VR_TXCFG_RSVD0 () {	0x01;}
}
unless(defined(&VR_TXCFG_LOOPBKMODE)) {
    sub VR_TXCFG_LOOPBKMODE () {	0x06;}
}
unless(defined(&VR_TXCFG_BACKOFF)) {
    sub VR_TXCFG_BACKOFF () {	0x08;}
}
unless(defined(&VR_TXCFG_RSVD1)) {
    sub VR_TXCFG_RSVD1 () {	0x10;}
}
unless(defined(&VR_TXCFG_TX_THRESH)) {
    sub VR_TXCFG_TX_THRESH () {	0xe0;}
}
unless(defined(&VR_TXTHRESH_32BYTES)) {
    sub VR_TXTHRESH_32BYTES () {	0x00;}
}
unless(defined(&VR_TXTHRESH_64BYTES)) {
    sub VR_TXTHRESH_64BYTES () {	0x20;}
}
unless(defined(&VR_TXTHRESH_128BYTES)) {
    sub VR_TXTHRESH_128BYTES () {	0x40;}
}
unless(defined(&VR_TXTHRESH_256BYTES)) {
    sub VR_TXTHRESH_256BYTES () {	0x60;}
}
unless(defined(&VR_TXTHRESH_512BYTES)) {
    sub VR_TXTHRESH_512BYTES () {	0x80;}
}
unless(defined(&VR_TXTHRESH_768BYTES)) {
    sub VR_TXTHRESH_768BYTES () {	0xa0;}
}
unless(defined(&VR_TXTHRESH_1024BYTES)) {
    sub VR_TXTHRESH_1024BYTES () {	0xc0;}
}
unless(defined(&VR_TXTHRESH_STORENFWD)) {
    sub VR_TXTHRESH_STORENFWD () {	0xe0;}
}
unless(defined(&VR_CMD_INIT)) {
    sub VR_CMD_INIT () {	0x0001;}
}
unless(defined(&VR_CMD_START)) {
    sub VR_CMD_START () {	0x0002;}
}
unless(defined(&VR_CMD_STOP)) {
    sub VR_CMD_STOP () {	0x0004;}
}
unless(defined(&VR_CMD_RX_ON)) {
    sub VR_CMD_RX_ON () {	0x0008;}
}
unless(defined(&VR_CMD_TX_ON)) {
    sub VR_CMD_TX_ON () {	0x0010;}
}
unless(defined(&VR_CMD_TX_GO)) {
    sub VR_CMD_TX_GO () {	0x0020;}
}
unless(defined(&VR_CMD_RX_GO)) {
    sub VR_CMD_RX_GO () {	0x0040;}
}
unless(defined(&VR_CMD_RSVD)) {
    sub VR_CMD_RSVD () {	0x0080;}
}
unless(defined(&VR_CMD_RX_EARLY)) {
    sub VR_CMD_RX_EARLY () {	0x0100;}
}
unless(defined(&VR_CMD_TX_EARLY)) {
    sub VR_CMD_TX_EARLY () {	0x0200;}
}
unless(defined(&VR_CMD_FULLDUPLEX)) {
    sub VR_CMD_FULLDUPLEX () {	0x0400;}
}
unless(defined(&VR_CMD_TX_NOPOLL)) {
    sub VR_CMD_TX_NOPOLL () {	0x0800;}
}
unless(defined(&VR_CMD_RESET)) {
    sub VR_CMD_RESET () {	0x8000;}
}
unless(defined(&VR_ISR_RX_OK)) {
    sub VR_ISR_RX_OK () {	0x0001;}
}
unless(defined(&VR_ISR_TX_OK)) {
    sub VR_ISR_TX_OK () {	0x0002;}
}
unless(defined(&VR_ISR_RX_ERR)) {
    sub VR_ISR_RX_ERR () {	0x0004;}
}
unless(defined(&VR_ISR_TX_ABRT)) {
    sub VR_ISR_TX_ABRT () {	0x0008;}
}
unless(defined(&VR_ISR_TX_UNDERRUN)) {
    sub VR_ISR_TX_UNDERRUN () {	0x0010;}
}
unless(defined(&VR_ISR_RX_NOBUF)) {
    sub VR_ISR_RX_NOBUF () {	0x0020;}
}
unless(defined(&VR_ISR_BUSERR)) {
    sub VR_ISR_BUSERR () {	0x0040;}
}
unless(defined(&VR_ISR_STATSOFLOW)) {
    sub VR_ISR_STATSOFLOW () {	0x0080;}
}
unless(defined(&VR_ISR_RX_EARLY)) {
    sub VR_ISR_RX_EARLY () {	0x0100;}
}
unless(defined(&VR_ISR_LINKSTAT)) {
    sub VR_ISR_LINKSTAT () {	0x0200;}
}
unless(defined(&VR_ISR_RX_OFLOW)) {
    sub VR_ISR_RX_OFLOW () {	0x0400;}
}
unless(defined(&VR_ISR_RX_DROPPED)) {
    sub VR_ISR_RX_DROPPED () {	0x0800;}
}
unless(defined(&VR_ISR_RX_NOBUF2)) {
    sub VR_ISR_RX_NOBUF2 () {	0x1000;}
}
unless(defined(&VR_ISR_TX_ABRT2)) {
    sub VR_ISR_TX_ABRT2 () {	0x2000;}
}
unless(defined(&VR_ISR_LINKSTAT2)) {
    sub VR_ISR_LINKSTAT2 () {	0x4000;}
}
unless(defined(&VR_ISR_MAGICPACKET)) {
    sub VR_ISR_MAGICPACKET () {	0x8000;}
}
unless(defined(&VR_IMR_RX_OK)) {
    sub VR_IMR_RX_OK () {	0x0001;}
}
unless(defined(&VR_IMR_TX_OK)) {
    sub VR_IMR_TX_OK () {	0x0002;}
}
unless(defined(&VR_IMR_RX_ERR)) {
    sub VR_IMR_RX_ERR () {	0x0004;}
}
unless(defined(&VR_IMR_TX_ABRT)) {
    sub VR_IMR_TX_ABRT () {	0x0008;}
}
unless(defined(&VR_IMR_TX_UNDERRUN)) {
    sub VR_IMR_TX_UNDERRUN () {	0x0010;}
}
unless(defined(&VR_IMR_RX_NOBUF)) {
    sub VR_IMR_RX_NOBUF () {	0x0020;}
}
unless(defined(&VR_IMR_BUSERR)) {
    sub VR_IMR_BUSERR () {	0x0040;}
}
unless(defined(&VR_IMR_STATSOFLOW)) {
    sub VR_IMR_STATSOFLOW () {	0x0080;}
}
unless(defined(&VR_IMR_RX_EARLY)) {
    sub VR_IMR_RX_EARLY () {	0x0100;}
}
unless(defined(&VR_IMR_LINKSTAT)) {
    sub VR_IMR_LINKSTAT () {	0x0200;}
}
unless(defined(&VR_IMR_RX_OFLOW)) {
    sub VR_IMR_RX_OFLOW () {	0x0400;}
}
unless(defined(&VR_IMR_RX_DROPPED)) {
    sub VR_IMR_RX_DROPPED () {	0x0800;}
}
unless(defined(&VR_IMR_RX_NOBUF2)) {
    sub VR_IMR_RX_NOBUF2 () {	0x1000;}
}
unless(defined(&VR_IMR_TX_ABRT2)) {
    sub VR_IMR_TX_ABRT2 () {	0x2000;}
}
unless(defined(&VR_IMR_LINKSTAT2)) {
    sub VR_IMR_LINKSTAT2 () {	0x4000;}
}
unless(defined(&VR_IMR_MAGICPACKET)) {
    sub VR_IMR_MAGICPACKET () {	0x8000;}
}
unless(defined(&VR_INTRS)) {
    sub VR_INTRS () {	( &VR_IMR_RX_OK| &VR_IMR_TX_OK| &VR_IMR_RX_NOBUF|  &VR_IMR_TX_ABRT| &VR_IMR_TX_UNDERRUN| &VR_IMR_BUSERR|  &VR_IMR_RX_ERR| &VR_ISR_RX_DROPPED);}
}
unless(defined(&VR_MIISTAT_SPEED)) {
    sub VR_MIISTAT_SPEED () {	0x01;}
}
unless(defined(&VR_MIISTAT_LINKFAULT)) {
    sub VR_MIISTAT_LINKFAULT () {	0x02;}
}
unless(defined(&VR_MIISTAT_MGTREADERR)) {
    sub VR_MIISTAT_MGTREADERR () {	0x04;}
}
unless(defined(&VR_MIISTAT_MIIERR)) {
    sub VR_MIISTAT_MIIERR () {	0x08;}
}
unless(defined(&VR_MIISTAT_PHYOPT)) {
    sub VR_MIISTAT_PHYOPT () {	0x10;}
}
unless(defined(&VR_MIISTAT_MDC_SPEED)) {
    sub VR_MIISTAT_MDC_SPEED () {	0x20;}
}
unless(defined(&VR_MIISTAT_RSVD)) {
    sub VR_MIISTAT_RSVD () {	0x40;}
}
unless(defined(&VR_MIISTAT_GPIO1POLL)) {
    sub VR_MIISTAT_GPIO1POLL () {	0x80;}
}
unless(defined(&VR_MIICMD_CLK)) {
    sub VR_MIICMD_CLK () {	0x01;}
}
unless(defined(&VR_MIICMD_DATAOUT)) {
    sub VR_MIICMD_DATAOUT () {	0x02;}
}
unless(defined(&VR_MIICMD_DATAIN)) {
    sub VR_MIICMD_DATAIN () {	0x04;}
}
unless(defined(&VR_MIICMD_DIR)) {
    sub VR_MIICMD_DIR () {	0x08;}
}
unless(defined(&VR_MIICMD_DIRECTPGM)) {
    sub VR_MIICMD_DIRECTPGM () {	0x10;}
}
unless(defined(&VR_MIICMD_WRITE_ENB)) {
    sub VR_MIICMD_WRITE_ENB () {	0x20;}
}
unless(defined(&VR_MIICMD_READ_ENB)) {
    sub VR_MIICMD_READ_ENB () {	0x40;}
}
unless(defined(&VR_MIICMD_AUTOPOLL)) {
    sub VR_MIICMD_AUTOPOLL () {	0x80;}
}
unless(defined(&VR_EECSR_DATAIN)) {
    sub VR_EECSR_DATAIN () {	0x01;}
}
unless(defined(&VR_EECSR_DATAOUT)) {
    sub VR_EECSR_DATAOUT () {	0x02;}
}
unless(defined(&VR_EECSR_CLK)) {
    sub VR_EECSR_CLK () {	0x04;}
}
unless(defined(&VR_EECSR_CS)) {
    sub VR_EECSR_CS () {	0x08;}
}
unless(defined(&VR_EECSR_DPM)) {
    sub VR_EECSR_DPM () {	0x10;}
}
unless(defined(&VR_EECSR_LOAD)) {
    sub VR_EECSR_LOAD () {	0x20;}
}
unless(defined(&VR_EECSR_EMBP)) {
    sub VR_EECSR_EMBP () {	0x40;}
}
unless(defined(&VR_EECSR_EEPR)) {
    sub VR_EECSR_EEPR () {	0x80;}
}
unless(defined(&VR_EECMD_WRITE)) {
    sub VR_EECMD_WRITE () {	0x140;}
}
unless(defined(&VR_EECMD_READ)) {
    sub VR_EECMD_READ () {	0x180;}
}
unless(defined(&VR_EECMD_ERASE)) {
    sub VR_EECMD_ERASE () {	0x1c0;}
}
unless(defined(&VR_TEST_TEST0)) {
    sub VR_TEST_TEST0 () {	0x01;}
}
unless(defined(&VR_TEST_TEST1)) {
    sub VR_TEST_TEST1 () {	0x02;}
}
unless(defined(&VR_TEST_TEST2)) {
    sub VR_TEST_TEST2 () {	0x04;}
}
unless(defined(&VR_TEST_TSTUD)) {
    sub VR_TEST_TSTUD () {	0x08;}
}
unless(defined(&VR_TEST_TSTOV)) {
    sub VR_TEST_TSTOV () {	0x10;}
}
unless(defined(&VR_TEST_BKOFF)) {
    sub VR_TEST_BKOFF () {	0x20;}
}
unless(defined(&VR_TEST_FCOL)) {
    sub VR_TEST_FCOL () {	0x40;}
}
unless(defined(&VR_TEST_HBDES)) {
    sub VR_TEST_HBDES () {	0x80;}
}
unless(defined(&VR_CFG_GPIO2OUTENB)) {
    sub VR_CFG_GPIO2OUTENB () {	0x00000001;}
}
unless(defined(&VR_CFG_GPIO2OUT)) {
    sub VR_CFG_GPIO2OUT () {	0x00000002;}
}
unless(defined(&VR_CFG_GPIO2IN)) {
    sub VR_CFG_GPIO2IN () {	0x00000004;}
}
unless(defined(&VR_CFG_AUTOOPT)) {
    sub VR_CFG_AUTOOPT () {	0x00000008;}
}
unless(defined(&VR_CFG_MIIOPT)) {
    sub VR_CFG_MIIOPT () {	0x00000010;}
}
unless(defined(&VR_CFG_MMIENB)) {
    sub VR_CFG_MMIENB () {	0x00000020;}
}
unless(defined(&VR_CFG_JUMPER)) {
    sub VR_CFG_JUMPER () {	0x00000040;}
}
unless(defined(&VR_CFG_EELOAD)) {
    sub VR_CFG_EELOAD () {	0x00000080;}
}
unless(defined(&VR_CFG_LATMENB)) {
    sub VR_CFG_LATMENB () {	0x00000100;}
}
unless(defined(&VR_CFG_MRREADWAIT)) {
    sub VR_CFG_MRREADWAIT () {	0x00000200;}
}
unless(defined(&VR_CFG_MRWRITEWAIT)) {
    sub VR_CFG_MRWRITEWAIT () {	0x00000400;}
}
unless(defined(&VR_CFG_RX_ARB)) {
    sub VR_CFG_RX_ARB () {	0x00000800;}
}
unless(defined(&VR_CFG_TX_ARB)) {
    sub VR_CFG_TX_ARB () {	0x00001000;}
}
unless(defined(&VR_CFG_READMULTI)) {
    sub VR_CFG_READMULTI () {	0x00002000;}
}
unless(defined(&VR_CFG_TX_PACE)) {
    sub VR_CFG_TX_PACE () {	0x00004000;}
}
unless(defined(&VR_CFG_TX_QDIS)) {
    sub VR_CFG_TX_QDIS () {	0x00008000;}
}
unless(defined(&VR_CFG_ROMSEL0)) {
    sub VR_CFG_ROMSEL0 () {	0x00010000;}
}
unless(defined(&VR_CFG_ROMSEL1)) {
    sub VR_CFG_ROMSEL1 () {	0x00020000;}
}
unless(defined(&VR_CFG_ROMSEL2)) {
    sub VR_CFG_ROMSEL2 () {	0x00040000;}
}
unless(defined(&VR_CFG_ROMTIMESEL)) {
    sub VR_CFG_ROMTIMESEL () {	0x00080000;}
}
unless(defined(&VR_CFG_RSVD0)) {
    sub VR_CFG_RSVD0 () {	0x00100000;}
}
unless(defined(&VR_CFG_ROMDLY)) {
    sub VR_CFG_ROMDLY () {	0x00200000;}
}
unless(defined(&VR_CFG_ROMOPT)) {
    sub VR_CFG_ROMOPT () {	0x00400000;}
}
unless(defined(&VR_CFG_RSVD1)) {
    sub VR_CFG_RSVD1 () {	0x00800000;}
}
unless(defined(&VR_CFG_BACKOFFOPT)) {
    sub VR_CFG_BACKOFFOPT () {	0x01000000;}
}
unless(defined(&VR_CFG_BACKOFFMOD)) {
    sub VR_CFG_BACKOFFMOD () {	0x02000000;}
}
unless(defined(&VR_CFG_CAPEFFECT)) {
    sub VR_CFG_CAPEFFECT () {	0x04000000;}
}
unless(defined(&VR_CFG_BACKOFFRAND)) {
    sub VR_CFG_BACKOFFRAND () {	0x08000000;}
}
unless(defined(&VR_CFG_MAGICKPACKET)) {
    sub VR_CFG_MAGICKPACKET () {	0x10000000;}
}
unless(defined(&VR_CFG_PCIREADLINE)) {
    sub VR_CFG_PCIREADLINE () {	0x20000000;}
}
unless(defined(&VR_CFG_DIAG)) {
    sub VR_CFG_DIAG () {	0x40000000;}
}
unless(defined(&VR_CFG_GPIOEN)) {
    sub VR_CFG_GPIOEN () {	0x80000000;}
}
unless(defined(&vr_data)) {
    sub vr_data () {	 &vr_ptr1;}
}
unless(defined(&vr_next)) {
    sub vr_next () {	 &vr_ptr2;}
}
unless(defined(&VR_RXSTAT_RXERR)) {
    sub VR_RXSTAT_RXERR () {	0x00000001;}
}
unless(defined(&VR_RXSTAT_CRCERR)) {
    sub VR_RXSTAT_CRCERR () {	0x00000002;}
}
unless(defined(&VR_RXSTAT_FRAMEALIGNERR)) {
    sub VR_RXSTAT_FRAMEALIGNERR () {	0x00000004;}
}
unless(defined(&VR_RXSTAT_FIFOOFLOW)) {
    sub VR_RXSTAT_FIFOOFLOW () {	0x00000008;}
}
unless(defined(&VR_RXSTAT_GIANT)) {
    sub VR_RXSTAT_GIANT () {	0x00000010;}
}
unless(defined(&VR_RXSTAT_RUNT)) {
    sub VR_RXSTAT_RUNT () {	0x00000020;}
}
unless(defined(&VR_RXSTAT_BUSERR)) {
    sub VR_RXSTAT_BUSERR () {	0x00000040;}
}
unless(defined(&VR_RXSTAT_BUFFERR)) {
    sub VR_RXSTAT_BUFFERR () {	0x00000080;}
}
unless(defined(&VR_RXSTAT_LASTFRAG)) {
    sub VR_RXSTAT_LASTFRAG () {	0x00000100;}
}
unless(defined(&VR_RXSTAT_FIRSTFRAG)) {
    sub VR_RXSTAT_FIRSTFRAG () {	0x00000200;}
}
unless(defined(&VR_RXSTAT_RLINK)) {
    sub VR_RXSTAT_RLINK () {	0x00000400;}
}
unless(defined(&VR_RXSTAT_RX_PHYS)) {
    sub VR_RXSTAT_RX_PHYS () {	0x00000800;}
}
unless(defined(&VR_RXSTAT_RX_BROAD)) {
    sub VR_RXSTAT_RX_BROAD () {	0x00001000;}
}
unless(defined(&VR_RXSTAT_RX_MULTI)) {
    sub VR_RXSTAT_RX_MULTI () {	0x00002000;}
}
unless(defined(&VR_RXSTAT_RX_OK)) {
    sub VR_RXSTAT_RX_OK () {	0x00004000;}
}
unless(defined(&VR_RXSTAT_RXLEN)) {
    sub VR_RXSTAT_RXLEN () {	0x07ff0000;}
}
unless(defined(&VR_RXSTAT_RXLEN_EXT)) {
    sub VR_RXSTAT_RXLEN_EXT () {	0x78000000;}
}
unless(defined(&VR_RXSTAT_OWN)) {
    sub VR_RXSTAT_OWN () {	0x80000000;}
}
unless(defined(&VR_RXBYTES)) {
    sub VR_RXBYTES {
	local($x) = @_;
	eval q((($x &  &VR_RXSTAT_RXLEN) >> 16));
    }
}
unless(defined(&VR_RXSTAT)) {
    sub VR_RXSTAT () {	( &VR_RXSTAT_FIRSTFRAG| &VR_RXSTAT_LASTFRAG| &VR_RXSTAT_OWN);}
}
unless(defined(&VR_RXCTL_BUFLEN)) {
    sub VR_RXCTL_BUFLEN () {	0x000007ff;}
}
unless(defined(&VR_RXCTL_BUFLEN_EXT)) {
    sub VR_RXCTL_BUFLEN_EXT () {	0x00007800;}
}
unless(defined(&VR_RXCTL_CHAIN)) {
    sub VR_RXCTL_CHAIN () {	0x00008000;}
}
unless(defined(&VR_RXCTL_RX_INTR)) {
    sub VR_RXCTL_RX_INTR () {	0x00800000;}
}
unless(defined(&VR_RXCTL)) {
    sub VR_RXCTL () {	( &VR_RXCTL_CHAIN| &VR_RXCTL_RX_INTR);}
}
unless(defined(&VR_TXSTAT_DEFER)) {
    sub VR_TXSTAT_DEFER () {	0x00000001;}
}
unless(defined(&VR_TXSTAT_UNDERRUN)) {
    sub VR_TXSTAT_UNDERRUN () {	0x00000002;}
}
unless(defined(&VR_TXSTAT_COLLCNT)) {
    sub VR_TXSTAT_COLLCNT () {	0x00000078;}
}
unless(defined(&VR_TXSTAT_SQE)) {
    sub VR_TXSTAT_SQE () {	0x00000080;}
}
unless(defined(&VR_TXSTAT_ABRT)) {
    sub VR_TXSTAT_ABRT () {	0x00000100;}
}
unless(defined(&VR_TXSTAT_LATECOLL)) {
    sub VR_TXSTAT_LATECOLL () {	0x00000200;}
}
unless(defined(&VR_TXSTAT_CARRLOST)) {
    sub VR_TXSTAT_CARRLOST () {	0x00000400;}
}
unless(defined(&VR_TXSTAT_BUSERR)) {
    sub VR_TXSTAT_BUSERR () {	0x00002000;}
}
unless(defined(&VR_TXSTAT_JABTIMEO)) {
    sub VR_TXSTAT_JABTIMEO () {	0x00004000;}
}
unless(defined(&VR_TXSTAT_ERRSUM)) {
    sub VR_TXSTAT_ERRSUM () {	0x00008000;}
}
unless(defined(&VR_TXSTAT_OWN)) {
    sub VR_TXSTAT_OWN () {	0x80000000;}
}
unless(defined(&VR_TXCTL_BUFLEN)) {
    sub VR_TXCTL_BUFLEN () {	0x000007ff;}
}
unless(defined(&VR_TXCTL_BUFLEN_EXT)) {
    sub VR_TXCTL_BUFLEN_EXT () {	0x00007800;}
}
unless(defined(&VR_TXCTL_TLINK)) {
    sub VR_TXCTL_TLINK () {	0x00008000;}
}
unless(defined(&VR_TXCTL_FIRSTFRAG)) {
    sub VR_TXCTL_FIRSTFRAG () {	0x00200000;}
}
unless(defined(&VR_TXCTL_LASTFRAG)) {
    sub VR_TXCTL_LASTFRAG () {	0x00400000;}
}
unless(defined(&VR_TXCTL_FINT)) {
    sub VR_TXCTL_FINT () {	0x00800000;}
}
unless(defined(&VR_MAXFRAGS)) {
    sub VR_MAXFRAGS () {	16;}
}
unless(defined(&VR_RX_LIST_CNT)) {
    sub VR_RX_LIST_CNT () {	64;}
}
unless(defined(&VR_TX_LIST_CNT)) {
    sub VR_TX_LIST_CNT () {	64;}
}
unless(defined(&VR_MIN_FRAMELEN)) {
    sub VR_MIN_FRAMELEN () {	60;}
}
unless(defined(&VR_FRAMELEN)) {
    sub VR_FRAMELEN () {	1536;}
}
unless(defined(&VR_RXLEN)) {
    sub VR_RXLEN () {	1520;}
}
unless(defined(&VR_TXOWN)) {
    sub VR_TXOWN {
	local($x) = @_;
	eval q( ($x->{vr_ptr}->{vr_status}));
    }
}
unless(defined(&VR_MII_STARTDELIM)) {
    sub VR_MII_STARTDELIM () {	0x01;}
}
unless(defined(&VR_MII_READOP)) {
    sub VR_MII_READOP () {	0x02;}
}
unless(defined(&VR_MII_WRITEOP)) {
    sub VR_MII_WRITEOP () {	0x01;}
}
unless(defined(&VR_MII_TURNAROUND)) {
    sub VR_MII_TURNAROUND () {	0x02;}
}
unless(defined(&VR_FLAG_FORCEDELAY)) {
    sub VR_FLAG_FORCEDELAY () {	1;}
}
unless(defined(&VR_FLAG_SCHEDDELAY)) {
    sub VR_FLAG_SCHEDDELAY () {	2;}
}
unless(defined(&VR_FLAG_DELAYTIMEO)) {
    sub VR_FLAG_DELAYTIMEO () {	3;}
}
unless(defined(&CSR_WRITE_4)) {
    sub CSR_WRITE_4 {
	local($sc, $reg, $val) = @_;
	eval q( &bus_space_write_4( ($sc->{vr_btag}),  ($sc->{vr_bhandle}), $reg, $val));
    }
}
unless(defined(&CSR_WRITE_2)) {
    sub CSR_WRITE_2 {
	local($sc, $reg, $val) = @_;
	eval q( &bus_space_write_2( ($sc->{vr_btag}),  ($sc->{vr_bhandle}), $reg, $val));
    }
}
unless(defined(&CSR_WRITE_1)) {
    sub CSR_WRITE_1 {
	local($sc, $reg, $val) = @_;
	eval q( &bus_space_write_1( ($sc->{vr_btag}),  ($sc->{vr_bhandle}), $reg, $val));
    }
}
unless(defined(&CSR_READ_4)) {
    sub CSR_READ_4 {
	local($sc, $reg) = @_;
	eval q( &bus_space_read_4( ($sc->{vr_btag}),  ($sc->{vr_bhandle}), $reg));
    }
}
unless(defined(&CSR_READ_2)) {
    sub CSR_READ_2 {
	local($sc, $reg) = @_;
	eval q( &bus_space_read_2( ($sc->{vr_btag}),  ($sc->{vr_bhandle}), $reg));
    }
}
unless(defined(&CSR_READ_1)) {
    sub CSR_READ_1 {
	local($sc, $reg) = @_;
	eval q( &bus_space_read_1( ($sc->{vr_btag}),  ($sc->{vr_bhandle}), $reg));
    }
}
unless(defined(&VR_TIMEOUT)) {
    sub VR_TIMEOUT () {	1000;}
}
unless(defined(&VIA_VENDORID)) {
    sub VIA_VENDORID () {	0x1106;}
}
unless(defined(&VIA_DEVICEID_RHINE)) {
    sub VIA_DEVICEID_RHINE () {	0x3043;}
}
unless(defined(&VIA_DEVICEID_RHINE_II)) {
    sub VIA_DEVICEID_RHINE_II () {	0x6100;}
}
unless(defined(&TI_PHY_VENDORID)) {
    sub TI_PHY_VENDORID () {	0x4000;}
}
unless(defined(&TI_PHY_10BT)) {
    sub TI_PHY_10BT () {	0x501f;}
}
unless(defined(&TI_PHY_100VGPMI)) {
    sub TI_PHY_100VGPMI () {	0x502f;}
}
unless(defined(&NS_PHY_VENDORID)) {
    sub NS_PHY_VENDORID () {	0x2000;}
}
unless(defined(&NS_PHY_83840A)) {
    sub NS_PHY_83840A () {	0x5c0f;}
}
unless(defined(&LEVEL1_PHY_VENDORID)) {
    sub LEVEL1_PHY_VENDORID () {	0x7810;}
}
unless(defined(&LEVEL1_PHY_LXT970)) {
    sub LEVEL1_PHY_LXT970 () {	0x000f;}
}
unless(defined(&INTEL_PHY_VENDORID)) {
    sub INTEL_PHY_VENDORID () {	0x0a28;}
}
unless(defined(&INTEL_PHY_82555)) {
    sub INTEL_PHY_82555 () {	0x015f;}
}
unless(defined(&SEEQ_PHY_VENDORID)) {
    sub SEEQ_PHY_VENDORID () {	0x0016;}
}
unless(defined(&SEEQ_PHY_80220)) {
    sub SEEQ_PHY_80220 () {	0xf83f;}
}
unless(defined(&VR_PCI_VENDOR_ID)) {
    sub VR_PCI_VENDOR_ID () {	0x00;}
}
unless(defined(&VR_PCI_DEVICE_ID)) {
    sub VR_PCI_DEVICE_ID () {	0x02;}
}
unless(defined(&VR_PCI_COMMAND)) {
    sub VR_PCI_COMMAND () {	0x04;}
}
unless(defined(&VR_PCI_STATUS)) {
    sub VR_PCI_STATUS () {	0x06;}
}
unless(defined(&VR_PCI_CLASSCODE)) {
    sub VR_PCI_CLASSCODE () {	0x09;}
}
unless(defined(&VR_PCI_LATENCY_TIMER)) {
    sub VR_PCI_LATENCY_TIMER () {	0x0d;}
}
unless(defined(&VR_PCI_HEADER_TYPE)) {
    sub VR_PCI_HEADER_TYPE () {	0x0e;}
}
unless(defined(&VR_PCI_LOIO)) {
    sub VR_PCI_LOIO () {	0x10;}
}
unless(defined(&VR_PCI_LOMEM)) {
    sub VR_PCI_LOMEM () {	0x14;}
}
unless(defined(&VR_PCI_BIOSROM)) {
    sub VR_PCI_BIOSROM () {	0x30;}
}
unless(defined(&VR_PCI_INTLINE)) {
    sub VR_PCI_INTLINE () {	0x3c;}
}
unless(defined(&VR_PCI_INTPIN)) {
    sub VR_PCI_INTPIN () {	0x3d;}
}
unless(defined(&VR_PCI_MINGNT)) {
    sub VR_PCI_MINGNT () {	0x3e;}
}
unless(defined(&VR_PCI_MINLAT)) {
    sub VR_PCI_MINLAT () {	0x0f;}
}
unless(defined(&VR_PCI_RESETOPT)) {
    sub VR_PCI_RESETOPT () {	0x48;}
}
unless(defined(&VR_PCI_EEPROM_DATA)) {
    sub VR_PCI_EEPROM_DATA () {	0x4c;}
}
unless(defined(&VR_PCI_CAPID)) {
    sub VR_PCI_CAPID () {	0xdc;}
}
unless(defined(&VR_PCI_NEXTPTR)) {
    sub VR_PCI_NEXTPTR () {	0xdd;}
}
unless(defined(&VR_PCI_PWRMGMTCAP)) {
    sub VR_PCI_PWRMGMTCAP () {	0xde;}
}
unless(defined(&VR_PCI_PWRMGMTCTRL)) {
    sub VR_PCI_PWRMGMTCTRL () {	0xe0;}
}
unless(defined(&VR_PSTATE_MASK)) {
    sub VR_PSTATE_MASK () {	0x0003;}
}
unless(defined(&VR_PSTATE_D0)) {
    sub VR_PSTATE_D0 () {	0x0000;}
}
unless(defined(&VR_PSTATE_D1)) {
    sub VR_PSTATE_D1 () {	0x0002;}
}
unless(defined(&VR_PSTATE_D2)) {
    sub VR_PSTATE_D2 () {	0x0002;}
}
unless(defined(&VR_PSTATE_D3)) {
    sub VR_PSTATE_D3 () {	0x0003;}
}
unless(defined(&VR_PME_EN)) {
    sub VR_PME_EN () {	0x0010;}
}
unless(defined(&VR_PME_STATUS)) {
    sub VR_PME_STATUS () {	0x8000;}
}
unless(defined(&PHY_UNKNOWN)) {
    sub PHY_UNKNOWN () {	6;}
}
unless(defined(&VR_PHYADDR_MIN)) {
    sub VR_PHYADDR_MIN () {	0x00;}
}
unless(defined(&VR_PHYADDR_MAX)) {
    sub VR_PHYADDR_MAX () {	0x1f;}
}
unless(defined(&PHY_BMCR)) {
    sub PHY_BMCR () {	0x00;}
}
unless(defined(&PHY_BMSR)) {
    sub PHY_BMSR () {	0x01;}
}
unless(defined(&PHY_VENID)) {
    sub PHY_VENID () {	0x02;}
}
unless(defined(&PHY_DEVID)) {
    sub PHY_DEVID () {	0x03;}
}
unless(defined(&PHY_ANAR)) {
    sub PHY_ANAR () {	0x04;}
}
unless(defined(&PHY_LPAR)) {
    sub PHY_LPAR () {	0x05;}
}
unless(defined(&PHY_ANEXP)) {
    sub PHY_ANEXP () {	0x06;}
}
unless(defined(&PHY_ANAR_NEXTPAGE)) {
    sub PHY_ANAR_NEXTPAGE () {	0x8000;}
}
unless(defined(&PHY_ANAR_RSVD0)) {
    sub PHY_ANAR_RSVD0 () {	0x4000;}
}
unless(defined(&PHY_ANAR_TLRFLT)) {
    sub PHY_ANAR_TLRFLT () {	0x2000;}
}
unless(defined(&PHY_ANAR_RSVD1)) {
    sub PHY_ANAR_RSVD1 () {	0x1000;}
}
unless(defined(&PHY_ANAR_RSVD2)) {
    sub PHY_ANAR_RSVD2 () {	0x0800;}
}
unless(defined(&PHY_ANAR_RSVD3)) {
    sub PHY_ANAR_RSVD3 () {	0x0400;}
}
unless(defined(&PHY_ANAR_100BT4)) {
    sub PHY_ANAR_100BT4 () {	0x0200;}
}
unless(defined(&PHY_ANAR_100BTXFULL)) {
    sub PHY_ANAR_100BTXFULL () {	0x0100;}
}
unless(defined(&PHY_ANAR_100BTXHALF)) {
    sub PHY_ANAR_100BTXHALF () {	0x0080;}
}
unless(defined(&PHY_ANAR_10BTFULL)) {
    sub PHY_ANAR_10BTFULL () {	0x0040;}
}
unless(defined(&PHY_ANAR_10BTHALF)) {
    sub PHY_ANAR_10BTHALF () {	0x0020;}
}
unless(defined(&PHY_ANAR_PROTO4)) {
    sub PHY_ANAR_PROTO4 () {	0x0010;}
}
unless(defined(&PHY_ANAR_PROTO3)) {
    sub PHY_ANAR_PROTO3 () {	0x0008;}
}
unless(defined(&PHY_ANAR_PROTO2)) {
    sub PHY_ANAR_PROTO2 () {	0x0004;}
}
unless(defined(&PHY_ANAR_PROTO1)) {
    sub PHY_ANAR_PROTO1 () {	0x0002;}
}
unless(defined(&PHY_ANAR_PROTO0)) {
    sub PHY_ANAR_PROTO0 () {	0x0001;}
}
unless(defined(&PHY_BMCR_RESET)) {
    sub PHY_BMCR_RESET () {	0x8000;}
}
unless(defined(&PHY_BMCR_LOOPBK)) {
    sub PHY_BMCR_LOOPBK () {	0x4000;}
}
unless(defined(&PHY_BMCR_SPEEDSEL)) {
    sub PHY_BMCR_SPEEDSEL () {	0x2000;}
}
unless(defined(&PHY_BMCR_AUTONEGENBL)) {
    sub PHY_BMCR_AUTONEGENBL () {	0x1000;}
}
unless(defined(&PHY_BMCR_RSVD0)) {
    sub PHY_BMCR_RSVD0 () {	0x0800;}
}
unless(defined(&PHY_BMCR_ISOLATE)) {
    sub PHY_BMCR_ISOLATE () {	0x0400;}
}
unless(defined(&PHY_BMCR_AUTONEGRSTR)) {
    sub PHY_BMCR_AUTONEGRSTR () {	0x0200;}
}
unless(defined(&PHY_BMCR_DUPLEX)) {
    sub PHY_BMCR_DUPLEX () {	0x0100;}
}
unless(defined(&PHY_BMCR_COLLTEST)) {
    sub PHY_BMCR_COLLTEST () {	0x0080;}
}
unless(defined(&PHY_BMCR_RSVD1)) {
    sub PHY_BMCR_RSVD1 () {	0x0040;}
}
unless(defined(&PHY_BMCR_RSVD2)) {
    sub PHY_BMCR_RSVD2 () {	0x0020;}
}
unless(defined(&PHY_BMCR_RSVD3)) {
    sub PHY_BMCR_RSVD3 () {	0x0010;}
}
unless(defined(&PHY_BMCR_RSVD4)) {
    sub PHY_BMCR_RSVD4 () {	0x0008;}
}
unless(defined(&PHY_BMCR_RSVD5)) {
    sub PHY_BMCR_RSVD5 () {	0x0004;}
}
unless(defined(&PHY_BMCR_RSVD6)) {
    sub PHY_BMCR_RSVD6 () {	0x0002;}
}
unless(defined(&PHY_BMCR_RSVD7)) {
    sub PHY_BMCR_RSVD7 () {	0x0001;}
}
unless(defined(&PHY_BMSR_100BT4)) {
    sub PHY_BMSR_100BT4 () {	0x8000;}
}
unless(defined(&PHY_BMSR_100BTXFULL)) {
    sub PHY_BMSR_100BTXFULL () {	0x4000;}
}
unless(defined(&PHY_BMSR_100BTXHALF)) {
    sub PHY_BMSR_100BTXHALF () {	0x2000;}
}
unless(defined(&PHY_BMSR_10BTFULL)) {
    sub PHY_BMSR_10BTFULL () {	0x1000;}
}
unless(defined(&PHY_BMSR_10BTHALF)) {
    sub PHY_BMSR_10BTHALF () {	0x0800;}
}
unless(defined(&PHY_BMSR_RSVD1)) {
    sub PHY_BMSR_RSVD1 () {	0x0400;}
}
unless(defined(&PHY_BMSR_RSVD2)) {
    sub PHY_BMSR_RSVD2 () {	0x0200;}
}
unless(defined(&PHY_BMSR_RSVD3)) {
    sub PHY_BMSR_RSVD3 () {	0x0100;}
}
unless(defined(&PHY_BMSR_RSVD4)) {
    sub PHY_BMSR_RSVD4 () {	0x0080;}
}
unless(defined(&PHY_BMSR_MFPRESUP)) {
    sub PHY_BMSR_MFPRESUP () {	0x0040;}
}
unless(defined(&PHY_BMSR_AUTONEGCOMP)) {
    sub PHY_BMSR_AUTONEGCOMP () {	0x0020;}
}
unless(defined(&PHY_BMSR_REMFAULT)) {
    sub PHY_BMSR_REMFAULT () {	0x0010;}
}
unless(defined(&PHY_BMSR_CANAUTONEG)) {
    sub PHY_BMSR_CANAUTONEG () {	0x0008;}
}
unless(defined(&PHY_BMSR_LINKSTAT)) {
    sub PHY_BMSR_LINKSTAT () {	0x0004;}
}
unless(defined(&PHY_BMSR_JABBER)) {
    sub PHY_BMSR_JABBER () {	0x0002;}
}
unless(defined(&PHY_BMSR_EXTENDED)) {
    sub PHY_BMSR_EXTENDED () {	0x0001;}
}
unless(defined(&ETHER_CRC_LEN)) {
    eval 'sub ETHER_CRC_LEN () {4;}' unless defined(&ETHER_CRC_LEN);
}
1;
