require '_h2ph_pre.ph';

unless(defined(&_ISPREG_H)) {
    eval 'sub _ISPREG_H () {1;}' unless defined(&_ISPREG_H);
    eval 'sub BIU_REGS_OFF () {0x00;}' unless defined(&BIU_REGS_OFF);
    eval 'sub PCI_MBOX_REGS_OFF () {0x70;}' unless defined(&PCI_MBOX_REGS_OFF);
    eval 'sub PCI_MBOX_REGS2100_OFF () {0x10;}' unless defined(&PCI_MBOX_REGS2100_OFF);
    eval 'sub SBUS_MBOX_REGS_OFF () {0x80;}' unless defined(&SBUS_MBOX_REGS_OFF);
    eval 'sub PCI_SXP_REGS_OFF () {0x80;}' unless defined(&PCI_SXP_REGS_OFF);
    eval 'sub SBUS_SXP_REGS_OFF () {0x200;}' unless defined(&SBUS_SXP_REGS_OFF);
    eval 'sub PCI_RISC_REGS_OFF () {0x80;}' unless defined(&PCI_RISC_REGS_OFF);
    eval 'sub SBUS_RISC_REGS_OFF () {0x400;}' unless defined(&SBUS_RISC_REGS_OFF);
    eval 'sub ISP1080_DMA_REGS_OFF () {0x60;}' unless defined(&ISP1080_DMA_REGS_OFF);
    eval 'sub DMA_REGS_OFF () {0x00;}' unless defined(&DMA_REGS_OFF);
    eval 'sub _NREG_BLKS () {5;}' unless defined(&_NREG_BLKS);
    eval 'sub _BLK_REG_SHFT () {13;}' unless defined(&_BLK_REG_SHFT);
    eval 'sub _BLK_REG_MASK () {(7<<  &_BLK_REG_SHFT);}' unless defined(&_BLK_REG_MASK);
    eval 'sub BIU_BLOCK () {(0<<  &_BLK_REG_SHFT);}' unless defined(&BIU_BLOCK);
    eval 'sub MBOX_BLOCK () {(1<<  &_BLK_REG_SHFT);}' unless defined(&MBOX_BLOCK);
    eval 'sub SXP_BLOCK () {(2<<  &_BLK_REG_SHFT);}' unless defined(&SXP_BLOCK);
    eval 'sub RISC_BLOCK () {(3<<  &_BLK_REG_SHFT);}' unless defined(&RISC_BLOCK);
    eval 'sub DMA_BLOCK () {(4<<  &_BLK_REG_SHFT);}' unless defined(&DMA_BLOCK);
    eval 'sub BIU_ID_LO () {( &BIU_BLOCK+0x0);}' unless defined(&BIU_ID_LO);
    eval 'sub BIU2100_FLASH_ADDR () {( &BIU_BLOCK+0x0);}' unless defined(&BIU2100_FLASH_ADDR);
    eval 'sub BIU_ID_HI () {( &BIU_BLOCK+0x2);}' unless defined(&BIU_ID_HI);
    eval 'sub BIU2100_FLASH_DATA () {( &BIU_BLOCK+0x2);}' unless defined(&BIU2100_FLASH_DATA);
    eval 'sub BIU_CONF0 () {( &BIU_BLOCK+0x4);}' unless defined(&BIU_CONF0);
    eval 'sub BIU_CONF1 () {( &BIU_BLOCK+0x6);}' unless defined(&BIU_CONF1);
    eval 'sub BIU2100_CSR () {( &BIU_BLOCK+0x6);}' unless defined(&BIU2100_CSR);
    eval 'sub BIU_ICR () {( &BIU_BLOCK+0x8);}' unless defined(&BIU_ICR);
    eval 'sub BIU_ISR () {( &BIU_BLOCK+0xa);}' unless defined(&BIU_ISR);
    eval 'sub BIU_SEMA () {( &BIU_BLOCK+0xc);}' unless defined(&BIU_SEMA);
    eval 'sub BIU_NVRAM () {( &BIU_BLOCK+0xe);}' unless defined(&BIU_NVRAM);
    eval 'sub DFIFO_COMMAND () {( &BIU_BLOCK+0x60);}' unless defined(&DFIFO_COMMAND);
    eval 'sub RDMA2100_CONTROL () { &DFIFO_COMMAND;}' unless defined(&RDMA2100_CONTROL);
    eval 'sub DFIFO_DATA () {( &BIU_BLOCK+0x62);}' unless defined(&DFIFO_DATA);
    eval 'sub CDMA_CONF () {( &DMA_BLOCK+0x20);}' unless defined(&CDMA_CONF);
    eval 'sub CDMA2100_CONTROL () { &CDMA_CONF;}' unless defined(&CDMA2100_CONTROL);
    eval 'sub CDMA_CONTROL () {( &DMA_BLOCK+0x22);}' unless defined(&CDMA_CONTROL);
    eval 'sub CDMA_STATUS () {( &DMA_BLOCK+0x24);}' unless defined(&CDMA_STATUS);
    eval 'sub CDMA_FIFO_STS () {( &DMA_BLOCK+0x26);}' unless defined(&CDMA_FIFO_STS);
    eval 'sub CDMA_COUNT () {( &DMA_BLOCK+0x28);}' unless defined(&CDMA_COUNT);
    eval 'sub CDMA_ADDR0 () {( &DMA_BLOCK+0x2c);}' unless defined(&CDMA_ADDR0);
    eval 'sub CDMA_ADDR1 () {( &DMA_BLOCK+0x2e);}' unless defined(&CDMA_ADDR1);
    eval 'sub CDMA_ADDR2 () {( &DMA_BLOCK+0x30);}' unless defined(&CDMA_ADDR2);
    eval 'sub CDMA_ADDR3 () {( &DMA_BLOCK+0x32);}' unless defined(&CDMA_ADDR3);
    eval 'sub DDMA_CONF () {( &DMA_BLOCK+0x40);}' unless defined(&DDMA_CONF);
    eval 'sub TDMA2100_CONTROL () { &DDMA_CONF;}' unless defined(&TDMA2100_CONTROL);
    eval 'sub DDMA_CONTROL () {( &DMA_BLOCK+0x42);}' unless defined(&DDMA_CONTROL);
    eval 'sub DDMA_STATUS () {( &DMA_BLOCK+0x44);}' unless defined(&DDMA_STATUS);
    eval 'sub DDMA_FIFO_STS () {( &DMA_BLOCK+0x46);}' unless defined(&DDMA_FIFO_STS);
    eval 'sub DDMA_COUNT_LO () {( &DMA_BLOCK+0x48);}' unless defined(&DDMA_COUNT_LO);
    eval 'sub DDMA_COUNT_HI () {( &DMA_BLOCK+0x4a);}' unless defined(&DDMA_COUNT_HI);
    eval 'sub DDMA_ADDR0 () {( &DMA_BLOCK+0x4c);}' unless defined(&DDMA_ADDR0);
    eval 'sub DDMA_ADDR1 () {( &DMA_BLOCK+0x4e);}' unless defined(&DDMA_ADDR1);
    eval 'sub DDMA_ADDR2 () {( &DMA_BLOCK+0x50);}' unless defined(&DDMA_ADDR2);
    eval 'sub DDMA_ADDR3 () {( &DMA_BLOCK+0x52);}' unless defined(&DDMA_ADDR3);
    eval 'sub BIU_CONF0_HW_MASK () {0x000f;}' unless defined(&BIU_CONF0_HW_MASK);
    eval 'sub BIU_SBUS_CONF1_PARITY () {0x0100;}' unless defined(&BIU_SBUS_CONF1_PARITY);
    eval 'sub BIU_SBUS_CONF1_FCODE_MASK () {0x00f0;}' unless defined(&BIU_SBUS_CONF1_FCODE_MASK);
    eval 'sub BIU_PCI_CONF1_FIFO_128 () {0x0040;}' unless defined(&BIU_PCI_CONF1_FIFO_128);
    eval 'sub BIU_PCI_CONF1_FIFO_64 () {0x0030;}' unless defined(&BIU_PCI_CONF1_FIFO_64);
    eval 'sub BIU_PCI_CONF1_FIFO_32 () {0x0020;}' unless defined(&BIU_PCI_CONF1_FIFO_32);
    eval 'sub BIU_PCI_CONF1_FIFO_16 () {0x0010;}' unless defined(&BIU_PCI_CONF1_FIFO_16);
    eval 'sub BIU_BURST_ENABLE () {0x0004;}' unless defined(&BIU_BURST_ENABLE);
    eval 'sub BIU_SBUS_CONF1_FIFO_64 () {0x0003;}' unless defined(&BIU_SBUS_CONF1_FIFO_64);
    eval 'sub BIU_SBUS_CONF1_FIFO_32 () {0x0002;}' unless defined(&BIU_SBUS_CONF1_FIFO_32);
    eval 'sub BIU_SBUS_CONF1_FIFO_16 () {0x0001;}' unless defined(&BIU_SBUS_CONF1_FIFO_16);
    eval 'sub BIU_SBUS_CONF1_FIFO_8 () {0x0000;}' unless defined(&BIU_SBUS_CONF1_FIFO_8);
    eval 'sub BIU_SBUS_CONF1_BURST8 () {0x0008;}' unless defined(&BIU_SBUS_CONF1_BURST8);
    eval 'sub BIU_PCI_CONF1_SXP () {0x0008;}' unless defined(&BIU_PCI_CONF1_SXP);
    eval 'sub BIU_PCI1080_CONF1_SXP0 () {0x0100;}' unless defined(&BIU_PCI1080_CONF1_SXP0);
    eval 'sub BIU_PCI1080_CONF1_SXP1 () {0x0200;}' unless defined(&BIU_PCI1080_CONF1_SXP1);
    eval 'sub BIU_PCI1080_CONF1_DMA () {0x0300;}' unless defined(&BIU_PCI1080_CONF1_DMA);
    eval 'sub BIU2100_ICSR_REGBSEL () {0x30;}' unless defined(&BIU2100_ICSR_REGBSEL);
    eval 'sub BIU2100_RISC_REGS () {(0<< 4);}' unless defined(&BIU2100_RISC_REGS);
    eval 'sub BIU2100_FB_REGS () {(1<< 4);}' unless defined(&BIU2100_FB_REGS);
    eval 'sub BIU2100_FPM0_REGS () {(2<< 4);}' unless defined(&BIU2100_FPM0_REGS);
    eval 'sub BIU2100_FPM1_REGS () {(3<< 4);}' unless defined(&BIU2100_FPM1_REGS);
    eval 'sub BIU2100_PCI64 () {0x04;}' unless defined(&BIU2100_PCI64);
    eval 'sub BIU2100_FLASH_ENABLE () {0x02;}' unless defined(&BIU2100_FLASH_ENABLE);
    eval 'sub BIU2100_SOFT_RESET () {0x01;}' unless defined(&BIU2100_SOFT_RESET);
    eval 'sub BIU_ICR_ENABLE_DMA_INT () {0x0020;}' unless defined(&BIU_ICR_ENABLE_DMA_INT);
    eval 'sub BIU_ICR_ENABLE_CDMA_INT () {0x0010;}' unless defined(&BIU_ICR_ENABLE_CDMA_INT);
    eval 'sub BIU_ICR_ENABLE_SXP_INT () {0x0008;}' unless defined(&BIU_ICR_ENABLE_SXP_INT);
    eval 'sub BIU_ICR_ENABLE_RISC_INT () {0x0004;}' unless defined(&BIU_ICR_ENABLE_RISC_INT);
    eval 'sub BIU_ICR_ENABLE_ALL_INTS () {0x0002;}' unless defined(&BIU_ICR_ENABLE_ALL_INTS);
    eval 'sub BIU_ICR_SOFT_RESET () {0x0001;}' unless defined(&BIU_ICR_SOFT_RESET);
    eval 'sub BIU2100_ICR_ENABLE_ALL_INTS () {0x8000;}' unless defined(&BIU2100_ICR_ENABLE_ALL_INTS);
    eval 'sub BIU2100_ICR_ENA_FPM_INT () {0x0020;}' unless defined(&BIU2100_ICR_ENA_FPM_INT);
    eval 'sub BIU2100_ICR_ENA_FB_INT () {0x0010;}' unless defined(&BIU2100_ICR_ENA_FB_INT);
    eval 'sub BIU2100_ICR_ENA_RISC_INT () {0x0008;}' unless defined(&BIU2100_ICR_ENA_RISC_INT);
    eval 'sub BIU2100_ICR_ENA_CDMA_INT () {0x0004;}' unless defined(&BIU2100_ICR_ENA_CDMA_INT);
    eval 'sub BIU2100_ICR_ENABLE_RXDMA_INT () {0x0002;}' unless defined(&BIU2100_ICR_ENABLE_RXDMA_INT);
    eval 'sub BIU2100_ICR_ENABLE_TXDMA_INT () {0x0001;}' unless defined(&BIU2100_ICR_ENABLE_TXDMA_INT);
    eval 'sub BIU2100_ICR_DISABLE_ALL_INTS () {0x0000;}' unless defined(&BIU2100_ICR_DISABLE_ALL_INTS);
    eval 'sub ENABLE_INTS {
        local($isp) = @_;
	    eval q(( &IS_SCSI($isp))?  &ISP_WRITE($isp,  &BIU_ICR,  &BIU_ICR_ENABLE_RISC_INT |  &BIU_ICR_ENABLE_ALL_INTS) :  &ISP_WRITE($isp,  &BIU_ICR,  &BIU2100_ICR_ENA_RISC_INT |  &BIU2100_ICR_ENABLE_ALL_INTS));
    }' unless defined(&ENABLE_INTS);
    eval 'sub INTS_ENABLED {
        local($isp) = @_;
	    eval q((( &IS_SCSI($isp))? ( &ISP_READ($isp,  &BIU_ICR) & ( &BIU_ICR_ENABLE_RISC_INT| &BIU_ICR_ENABLE_ALL_INTS)) : ( &ISP_READ($isp,  &BIU_ICR) & ( &BIU2100_ICR_ENA_RISC_INT| &BIU2100_ICR_ENABLE_ALL_INTS))));
    }' unless defined(&INTS_ENABLED);
    eval 'sub DISABLE_INTS {
        local($isp) = @_;
	    eval q( &ISP_WRITE($isp,  &BIU_ICR, 0));
    }' unless defined(&DISABLE_INTS);
    eval 'sub BIU_ISR_DMA_INT () {0x0020;}' unless defined(&BIU_ISR_DMA_INT);
    eval 'sub BIU_ISR_CDMA_INT () {0x0010;}' unless defined(&BIU_ISR_CDMA_INT);
    eval 'sub BIU_ISR_SXP_INT () {0x0008;}' unless defined(&BIU_ISR_SXP_INT);
    eval 'sub BIU_ISR_RISC_INT () {0x0004;}' unless defined(&BIU_ISR_RISC_INT);
    eval 'sub BIU_ISR_IPEND () {0x0002;}' unless defined(&BIU_ISR_IPEND);
    eval 'sub BIU2100_ISR_INT_PENDING () {0x8000;}' unless defined(&BIU2100_ISR_INT_PENDING);
    eval 'sub BIU2100_ISR_FPM_INT () {0x0020;}' unless defined(&BIU2100_ISR_FPM_INT);
    eval 'sub BIU2100_ISR_FB_INT () {0x0010;}' unless defined(&BIU2100_ISR_FB_INT);
    eval 'sub BIU2100_ISR_RISC_INT () {0x0008;}' unless defined(&BIU2100_ISR_RISC_INT);
    eval 'sub BIU2100_ISR_CDMA_INT () {0x0004;}' unless defined(&BIU2100_ISR_CDMA_INT);
    eval 'sub BIU2100_ISR_RXDMA_INT_PENDING () {0x0002;}' unless defined(&BIU2100_ISR_RXDMA_INT_PENDING);
    eval 'sub BIU2100_ISR_TXDMA_INT_PENDING () {0x0001;}' unless defined(&BIU2100_ISR_TXDMA_INT_PENDING);
    eval 'sub INT_PENDING {
        local($isp, $isr) = @_;
	    eval q(( &IS_FC($isp)? (($isr &  &BIU2100_ISR_RISC_INT) != 0) : (($isr &  &BIU_ISR_RISC_INT) != 0)));
    }' unless defined(&INT_PENDING);
    eval 'sub BIU_SEMA_STATUS () {0x0002;}' unless defined(&BIU_SEMA_STATUS);
    eval 'sub BIU_SEMA_LOCK () {0x0001;}' unless defined(&BIU_SEMA_LOCK);
    eval 'sub BIU_NVRAM_CLOCK () {0x0001;}' unless defined(&BIU_NVRAM_CLOCK);
    eval 'sub BIU_NVRAM_SELECT () {0x0002;}' unless defined(&BIU_NVRAM_SELECT);
    eval 'sub BIU_NVRAM_DATAOUT () {0x0004;}' unless defined(&BIU_NVRAM_DATAOUT);
    eval 'sub BIU_NVRAM_DATAIN () {0x0008;}' unless defined(&BIU_NVRAM_DATAIN);
    eval 'sub ISP_NVRAM_READ () {6;}' unless defined(&ISP_NVRAM_READ);
    eval 'sub DMA_ENABLE_SXP_DMA () {0x0008;}' unless defined(&DMA_ENABLE_SXP_DMA);
    eval 'sub DMA_ENABLE_INTS () {0x0004;}' unless defined(&DMA_ENABLE_INTS);
    eval 'sub DMA_ENABLE_BURST () {0x0002;}' unless defined(&DMA_ENABLE_BURST);
    eval 'sub DMA_DMA_DIRECTION () {0x0001;}' unless defined(&DMA_DMA_DIRECTION);
    eval 'sub DMA_CNTRL_SUSPEND_CHAN () {0x0010;}' unless defined(&DMA_CNTRL_SUSPEND_CHAN);
    eval 'sub DMA_CNTRL_CLEAR_CHAN () {0x0008;}' unless defined(&DMA_CNTRL_CLEAR_CHAN);
    eval 'sub DMA_CNTRL_CLEAR_FIFO () {0x0004;}' unless defined(&DMA_CNTRL_CLEAR_FIFO);
    eval 'sub DMA_CNTRL_RESET_INT () {0x0002;}' unless defined(&DMA_CNTRL_RESET_INT);
    eval 'sub DMA_CNTRL_STROBE () {0x0001;}' unless defined(&DMA_CNTRL_STROBE);
    eval 'sub DMA_CNTRL2100_CLEAR_CHAN () {0x0004;}' unless defined(&DMA_CNTRL2100_CLEAR_CHAN);
    eval 'sub DMA_CNTRL2100_RESET_INT () {0x0002;}' unless defined(&DMA_CNTRL2100_RESET_INT);
    eval 'sub DMA_SBUS_STATUS_PIPE_MASK () {0x00c0;}' unless defined(&DMA_SBUS_STATUS_PIPE_MASK);
    eval 'sub DMA_SBUS_STATUS_CHAN_MASK () {0x0030;}' unless defined(&DMA_SBUS_STATUS_CHAN_MASK);
    eval 'sub DMA_SBUS_STATUS_BUS_PARITY () {0x0008;}' unless defined(&DMA_SBUS_STATUS_BUS_PARITY);
    eval 'sub DMA_SBUS_STATUS_BUS_ERR () {0x0004;}' unless defined(&DMA_SBUS_STATUS_BUS_ERR);
    eval 'sub DMA_SBUS_STATUS_TERM_COUNT () {0x0002;}' unless defined(&DMA_SBUS_STATUS_TERM_COUNT);
    eval 'sub DMA_SBUS_STATUS_INTERRUPT () {0x0001;}' unless defined(&DMA_SBUS_STATUS_INTERRUPT);
    eval 'sub DMA_PCI_STATUS_INTERRUPT () {0x8000;}' unless defined(&DMA_PCI_STATUS_INTERRUPT);
    eval 'sub DMA_PCI_STATUS_RETRY_STAT () {0x4000;}' unless defined(&DMA_PCI_STATUS_RETRY_STAT);
    eval 'sub DMA_PCI_STATUS_CHAN_MASK () {0x3000;}' unless defined(&DMA_PCI_STATUS_CHAN_MASK);
    eval 'sub DMA_PCI_STATUS_FIFO_OVR () {0x0100;}' unless defined(&DMA_PCI_STATUS_FIFO_OVR);
    eval 'sub DMA_PCI_STATUS_FIFO_UDR () {0x0080;}' unless defined(&DMA_PCI_STATUS_FIFO_UDR);
    eval 'sub DMA_PCI_STATUS_BUS_ERR () {0x0040;}' unless defined(&DMA_PCI_STATUS_BUS_ERR);
    eval 'sub DMA_PCI_STATUS_BUS_PARITY () {0x0020;}' unless defined(&DMA_PCI_STATUS_BUS_PARITY);
    eval 'sub DMA_PCI_STATUS_CLR_PEND () {0x0010;}' unless defined(&DMA_PCI_STATUS_CLR_PEND);
    eval 'sub DMA_PCI_STATUS_TERM_COUNT () {0x0008;}' unless defined(&DMA_PCI_STATUS_TERM_COUNT);
    eval 'sub DMA_PCI_STATUS_DMA_SUSP () {0x0004;}' unless defined(&DMA_PCI_STATUS_DMA_SUSP);
    eval 'sub DMA_PCI_STATUS_PIPE_MASK () {0x0003;}' unless defined(&DMA_PCI_STATUS_PIPE_MASK);
    eval 'sub DMA_SBUS_PIPE_FULL () {0x00c0;}' unless defined(&DMA_SBUS_PIPE_FULL);
    eval 'sub DMA_SBUS_PIPE_OVERRUN () {0x0080;}' unless defined(&DMA_SBUS_PIPE_OVERRUN);
    eval 'sub DMA_SBUS_PIPE_STAGE1 () {0x0040;}' unless defined(&DMA_SBUS_PIPE_STAGE1);
    eval 'sub DMA_PCI_PIPE_FULL () {0x0003;}' unless defined(&DMA_PCI_PIPE_FULL);
    eval 'sub DMA_PCI_PIPE_OVERRUN () {0x0002;}' unless defined(&DMA_PCI_PIPE_OVERRUN);
    eval 'sub DMA_PCI_PIPE_STAGE1 () {0x0001;}' unless defined(&DMA_PCI_PIPE_STAGE1);
    eval 'sub DMA_PIPE_EMPTY () {0x0000;}' unless defined(&DMA_PIPE_EMPTY);
    eval 'sub DMA_SBUS_CHAN_SUSPEND () {0x0030;}' unless defined(&DMA_SBUS_CHAN_SUSPEND);
    eval 'sub DMA_SBUS_CHAN_TRANSFER () {0x0020;}' unless defined(&DMA_SBUS_CHAN_TRANSFER);
    eval 'sub DMA_SBUS_CHAN_ACTIVE () {0x0010;}' unless defined(&DMA_SBUS_CHAN_ACTIVE);
    eval 'sub DMA_PCI_CHAN_TRANSFER () {0x3000;}' unless defined(&DMA_PCI_CHAN_TRANSFER);
    eval 'sub DMA_PCI_CHAN_SUSPEND () {0x2000;}' unless defined(&DMA_PCI_CHAN_SUSPEND);
    eval 'sub DMA_PCI_CHAN_ACTIVE () {0x1000;}' unless defined(&DMA_PCI_CHAN_ACTIVE);
    eval 'sub ISP_DMA_CHAN_IDLE () {0x0000;}' unless defined(&ISP_DMA_CHAN_IDLE);
    eval 'sub DMA_FIFO_STATUS_OVERRUN () {0x0200;}' unless defined(&DMA_FIFO_STATUS_OVERRUN);
    eval 'sub DMA_FIFO_STATUS_UNDERRUN () {0x0100;}' unless defined(&DMA_FIFO_STATUS_UNDERRUN);
    eval 'sub DMA_FIFO_SBUS_COUNT_MASK () {0x007f;}' unless defined(&DMA_FIFO_SBUS_COUNT_MASK);
    eval 'sub DMA_FIFO_PCI_COUNT_MASK () {0x00ff;}' unless defined(&DMA_FIFO_PCI_COUNT_MASK);
    eval 'sub INMAILBOX0 () {( &MBOX_BLOCK+0x0);}' unless defined(&INMAILBOX0);
    eval 'sub INMAILBOX1 () {( &MBOX_BLOCK+0x2);}' unless defined(&INMAILBOX1);
    eval 'sub INMAILBOX2 () {( &MBOX_BLOCK+0x4);}' unless defined(&INMAILBOX2);
    eval 'sub INMAILBOX3 () {( &MBOX_BLOCK+0x6);}' unless defined(&INMAILBOX3);
    eval 'sub INMAILBOX4 () {( &MBOX_BLOCK+0x8);}' unless defined(&INMAILBOX4);
    eval 'sub INMAILBOX5 () {( &MBOX_BLOCK+0xa);}' unless defined(&INMAILBOX5);
    eval 'sub INMAILBOX6 () {( &MBOX_BLOCK+0xc);}' unless defined(&INMAILBOX6);
    eval 'sub INMAILBOX7 () {( &MBOX_BLOCK+0xe);}' unless defined(&INMAILBOX7);
    eval 'sub OUTMAILBOX0 () {( &MBOX_BLOCK+0x0);}' unless defined(&OUTMAILBOX0);
    eval 'sub OUTMAILBOX1 () {( &MBOX_BLOCK+0x2);}' unless defined(&OUTMAILBOX1);
    eval 'sub OUTMAILBOX2 () {( &MBOX_BLOCK+0x4);}' unless defined(&OUTMAILBOX2);
    eval 'sub OUTMAILBOX3 () {( &MBOX_BLOCK+0x6);}' unless defined(&OUTMAILBOX3);
    eval 'sub OUTMAILBOX4 () {( &MBOX_BLOCK+0x8);}' unless defined(&OUTMAILBOX4);
    eval 'sub OUTMAILBOX5 () {( &MBOX_BLOCK+0xa);}' unless defined(&OUTMAILBOX5);
    eval 'sub OUTMAILBOX6 () {( &MBOX_BLOCK+0xc);}' unless defined(&OUTMAILBOX6);
    eval 'sub OUTMAILBOX7 () {( &MBOX_BLOCK+0xe);}' unless defined(&OUTMAILBOX7);
    eval 'sub OMBOX_OFFN {
        local($n) = @_;
	    eval q(( &MBOX_BLOCK + ($n * 2)));
    }' unless defined(&OMBOX_OFFN);
    eval 'sub NMBOX {
        local($isp) = @_;
	    eval q(((((($isp)-> &isp_type &  &ISP_HA_SCSI) >=  &ISP_HA_SCSI_1040A) || (($isp)-> &isp_type &  &ISP_HA_FC))? 8: 6));
    }' unless defined(&NMBOX);
    eval 'sub SXP_PART_ID () {( &SXP_BLOCK+0x0);}' unless defined(&SXP_PART_ID);
    eval 'sub SXP_CONFIG1 () {( &SXP_BLOCK+0x2);}' unless defined(&SXP_CONFIG1);
    eval 'sub SXP_CONFIG2 () {( &SXP_BLOCK+0x4);}' unless defined(&SXP_CONFIG2);
    eval 'sub SXP_CONFIG3 () {( &SXP_BLOCK+0x6);}' unless defined(&SXP_CONFIG3);
    eval 'sub SXP_INSTRUCTION () {( &SXP_BLOCK+0xc);}' unless defined(&SXP_INSTRUCTION);
    eval 'sub SXP_RETURN_ADDR () {( &SXP_BLOCK+0x10);}' unless defined(&SXP_RETURN_ADDR);
    eval 'sub SXP_COMMAND () {( &SXP_BLOCK+0x14);}' unless defined(&SXP_COMMAND);
    eval 'sub SXP_INTERRUPT () {( &SXP_BLOCK+0x18);}' unless defined(&SXP_INTERRUPT);
    eval 'sub SXP_SEQUENCE () {( &SXP_BLOCK+0x1c);}' unless defined(&SXP_SEQUENCE);
    eval 'sub SXP_GROSS_ERR () {( &SXP_BLOCK+0x1e);}' unless defined(&SXP_GROSS_ERR);
    eval 'sub SXP_EXCEPTION () {( &SXP_BLOCK+0x20);}' unless defined(&SXP_EXCEPTION);
    eval 'sub SXP_OVERRIDE () {( &SXP_BLOCK+0x24);}' unless defined(&SXP_OVERRIDE);
    eval 'sub SXP_LIT_BASE () {( &SXP_BLOCK+0x28);}' unless defined(&SXP_LIT_BASE);
    eval 'sub SXP_USER_FLAGS () {( &SXP_BLOCK+0x2c);}' unless defined(&SXP_USER_FLAGS);
    eval 'sub SXP_USER_EXCEPT () {( &SXP_BLOCK+0x30);}' unless defined(&SXP_USER_EXCEPT);
    eval 'sub SXP_BREAKPOINT () {( &SXP_BLOCK+0x34);}' unless defined(&SXP_BREAKPOINT);
    eval 'sub SXP_SCSI_ID () {( &SXP_BLOCK+0x40);}' unless defined(&SXP_SCSI_ID);
    eval 'sub SXP_DEV_CONFIG1 () {( &SXP_BLOCK+0x42);}' unless defined(&SXP_DEV_CONFIG1);
    eval 'sub SXP_DEV_CONFIG2 () {( &SXP_BLOCK+0x44);}' unless defined(&SXP_DEV_CONFIG2);
    eval 'sub SXP_PHASE_PTR () {( &SXP_BLOCK+0x48);}' unless defined(&SXP_PHASE_PTR);
    eval 'sub SXP_BUF_PTR () {( &SXP_BLOCK+0x4c);}' unless defined(&SXP_BUF_PTR);
    eval 'sub SXP_BUF_CTR () {( &SXP_BLOCK+0x50);}' unless defined(&SXP_BUF_CTR);
    eval 'sub SXP_BUFFER () {( &SXP_BLOCK+0x52);}' unless defined(&SXP_BUFFER);
    eval 'sub SXP_BUF_BYTE () {( &SXP_BLOCK+0x54);}' unless defined(&SXP_BUF_BYTE);
    eval 'sub SXP_BUF_WD () {( &SXP_BLOCK+0x56);}' unless defined(&SXP_BUF_WD);
    eval 'sub SXP_BUF_WD_TRAN () {( &SXP_BLOCK+0x58);}' unless defined(&SXP_BUF_WD_TRAN);
    eval 'sub SXP_FIFO () {( &SXP_BLOCK+0x5a);}' unless defined(&SXP_FIFO);
    eval 'sub SXP_FIFO_STATUS () {( &SXP_BLOCK+0x5c);}' unless defined(&SXP_FIFO_STATUS);
    eval 'sub SXP_FIFO_TOP () {( &SXP_BLOCK+0x5e);}' unless defined(&SXP_FIFO_TOP);
    eval 'sub SXP_FIFO_BOTTOM () {( &SXP_BLOCK+0x60);}' unless defined(&SXP_FIFO_BOTTOM);
    eval 'sub SXP_TRAN_REG () {( &SXP_BLOCK+0x64);}' unless defined(&SXP_TRAN_REG);
    eval 'sub SXP_TRAN_CNT_LO () {( &SXP_BLOCK+0x68);}' unless defined(&SXP_TRAN_CNT_LO);
    eval 'sub SXP_TRAN_CNT_HI () {( &SXP_BLOCK+0x6a);}' unless defined(&SXP_TRAN_CNT_HI);
    eval 'sub SXP_TRAN_CTR_LO () {( &SXP_BLOCK+0x6c);}' unless defined(&SXP_TRAN_CTR_LO);
    eval 'sub SXP_TRAN_CTR_HI () {( &SXP_BLOCK+0x6e);}' unless defined(&SXP_TRAN_CTR_HI);
    eval 'sub SXP_ARB_DATA () {( &SXP_BLOCK+0x70);}' unless defined(&SXP_ARB_DATA);
    eval 'sub SXP_PINS_CTRL () {( &SXP_BLOCK+0x72);}' unless defined(&SXP_PINS_CTRL);
    eval 'sub SXP_PINS_DATA () {( &SXP_BLOCK+0x74);}' unless defined(&SXP_PINS_DATA);
    eval 'sub SXP_PINS_DIFF () {( &SXP_BLOCK+0x76);}' unless defined(&SXP_PINS_DIFF);
    eval 'sub SXP_BANK1_SELECT () {0x100;}' unless defined(&SXP_BANK1_SELECT);
    eval 'sub SXP_CONF1_ASYNCH_SETUP () {0xf000;}' unless defined(&SXP_CONF1_ASYNCH_SETUP);
    eval 'sub SXP_CONF1_SELECTION_UNIT () {0x0000;}' unless defined(&SXP_CONF1_SELECTION_UNIT);
    eval 'sub SXP_CONF1_SELECTION_TIMEOUT () {0x0600;}' unless defined(&SXP_CONF1_SELECTION_TIMEOUT);
    eval 'sub SXP_CONF1_CLOCK_FACTOR () {0x00e0;}' unless defined(&SXP_CONF1_CLOCK_FACTOR);
    eval 'sub SXP_CONF1_SCSI_ID () {0x000f;}' unless defined(&SXP_CONF1_SCSI_ID);
    eval 'sub SXP_CONF2_DISABLE_FILTER () {0x0040;}' unless defined(&SXP_CONF2_DISABLE_FILTER);
    eval 'sub SXP_CONF2_REQ_ACK_PULLUPS () {0x0020;}' unless defined(&SXP_CONF2_REQ_ACK_PULLUPS);
    eval 'sub SXP_CONF2_DATA_PULLUPS () {0x0010;}' unless defined(&SXP_CONF2_DATA_PULLUPS);
    eval 'sub SXP_CONF2_CONFIG_AUTOLOAD () {0x0008;}' unless defined(&SXP_CONF2_CONFIG_AUTOLOAD);
    eval 'sub SXP_CONF2_RESELECT () {0x0002;}' unless defined(&SXP_CONF2_RESELECT);
    eval 'sub SXP_CONF2_SELECT () {0x0001;}' unless defined(&SXP_CONF2_SELECT);
    eval 'sub SXP_INT_PARITY_ERR () {0x8000;}' unless defined(&SXP_INT_PARITY_ERR);
    eval 'sub SXP_INT_GROSS_ERR () {0x4000;}' unless defined(&SXP_INT_GROSS_ERR);
    eval 'sub SXP_INT_FUNCTION_ABORT () {0x2000;}' unless defined(&SXP_INT_FUNCTION_ABORT);
    eval 'sub SXP_INT_CONDITION_FAILED () {0x1000;}' unless defined(&SXP_INT_CONDITION_FAILED);
    eval 'sub SXP_INT_FIFO_EMPTY () {0x0800;}' unless defined(&SXP_INT_FIFO_EMPTY);
    eval 'sub SXP_INT_BUF_COUNTER_ZERO () {0x0400;}' unless defined(&SXP_INT_BUF_COUNTER_ZERO);
    eval 'sub SXP_INT_XFER_ZERO () {0x0200;}' unless defined(&SXP_INT_XFER_ZERO);
    eval 'sub SXP_INT_INT_PENDING () {0x0080;}' unless defined(&SXP_INT_INT_PENDING);
    eval 'sub SXP_INT_CMD_RUNNING () {0x0040;}' unless defined(&SXP_INT_CMD_RUNNING);
    eval 'sub SXP_INT_INT_RETURN_CODE () {0x000f;}' unless defined(&SXP_INT_INT_RETURN_CODE);
    eval 'sub SXP_GROSS_OFFSET_RESID () {0x0040;}' unless defined(&SXP_GROSS_OFFSET_RESID);
    eval 'sub SXP_GROSS_OFFSET_UNDERFLOW () {0x0020;}' unless defined(&SXP_GROSS_OFFSET_UNDERFLOW);
    eval 'sub SXP_GROSS_OFFSET_OVERFLOW () {0x0010;}' unless defined(&SXP_GROSS_OFFSET_OVERFLOW);
    eval 'sub SXP_GROSS_FIFO_UNDERFLOW () {0x0008;}' unless defined(&SXP_GROSS_FIFO_UNDERFLOW);
    eval 'sub SXP_GROSS_FIFO_OVERFLOW () {0x0004;}' unless defined(&SXP_GROSS_FIFO_OVERFLOW);
    eval 'sub SXP_GROSS_WRITE_ERR () {0x0002;}' unless defined(&SXP_GROSS_WRITE_ERR);
    eval 'sub SXP_GROSS_ILLEGAL_INST () {0x0001;}' unless defined(&SXP_GROSS_ILLEGAL_INST);
    eval 'sub SXP_EXCEPT_USER_0 () {0x8000;}' unless defined(&SXP_EXCEPT_USER_0);
    eval 'sub SXP_EXCEPT_USER_1 () {0x4000;}' unless defined(&SXP_EXCEPT_USER_1);
    eval 'sub PCI_SXP_EXCEPT_SCAM () {0x0400;}' unless defined(&PCI_SXP_EXCEPT_SCAM);
    eval 'sub SXP_EXCEPT_BUS_FREE () {0x0200;}' unless defined(&SXP_EXCEPT_BUS_FREE);
    eval 'sub SXP_EXCEPT_TARGET_ATN () {0x0100;}' unless defined(&SXP_EXCEPT_TARGET_ATN);
    eval 'sub SXP_EXCEPT_RESELECTED () {0x0080;}' unless defined(&SXP_EXCEPT_RESELECTED);
    eval 'sub SXP_EXCEPT_SELECTED () {0x0040;}' unless defined(&SXP_EXCEPT_SELECTED);
    eval 'sub SXP_EXCEPT_ARBITRATION () {0x0020;}' unless defined(&SXP_EXCEPT_ARBITRATION);
    eval 'sub SXP_EXCEPT_GROSS_ERR () {0x0010;}' unless defined(&SXP_EXCEPT_GROSS_ERR);
    eval 'sub SXP_EXCEPT_BUS_RESET () {0x0008;}' unless defined(&SXP_EXCEPT_BUS_RESET);
    eval 'sub SXP_ORIDE_EXT_TRIGGER () {0x8000;}' unless defined(&SXP_ORIDE_EXT_TRIGGER);
    eval 'sub SXP_ORIDE_STEP () {0x4000;}' unless defined(&SXP_ORIDE_STEP);
    eval 'sub SXP_ORIDE_BREAKPOINT () {0x2000;}' unless defined(&SXP_ORIDE_BREAKPOINT);
    eval 'sub SXP_ORIDE_PIN_WRITE () {0x1000;}' unless defined(&SXP_ORIDE_PIN_WRITE);
    eval 'sub SXP_ORIDE_FORCE_OUTPUTS () {0x0800;}' unless defined(&SXP_ORIDE_FORCE_OUTPUTS);
    eval 'sub SXP_ORIDE_LOOPBACK () {0x0400;}' unless defined(&SXP_ORIDE_LOOPBACK);
    eval 'sub SXP_ORIDE_PARITY_TEST () {0x0200;}' unless defined(&SXP_ORIDE_PARITY_TEST);
    eval 'sub SXP_ORIDE_TRISTATE_ENA_PINS () {0x0100;}' unless defined(&SXP_ORIDE_TRISTATE_ENA_PINS);
    eval 'sub SXP_ORIDE_TRISTATE_PINS () {0x0080;}' unless defined(&SXP_ORIDE_TRISTATE_PINS);
    eval 'sub SXP_ORIDE_FIFO_RESET () {0x0008;}' unless defined(&SXP_ORIDE_FIFO_RESET);
    eval 'sub SXP_ORIDE_CMD_TERMINATE () {0x0004;}' unless defined(&SXP_ORIDE_CMD_TERMINATE);
    eval 'sub SXP_ORIDE_RESET_REG () {0x0002;}' unless defined(&SXP_ORIDE_RESET_REG);
    eval 'sub SXP_ORIDE_RESET_MODULE () {0x0001;}' unless defined(&SXP_ORIDE_RESET_MODULE);
    eval 'sub SXP_RESET_BUS_CMD () {0x300b;}' unless defined(&SXP_RESET_BUS_CMD);
    eval 'sub SXP_SELECTING_ID () {0x0f00;}' unless defined(&SXP_SELECTING_ID);
    eval 'sub SXP_SELECT_ID () {0x000f;}' unless defined(&SXP_SELECT_ID);
    eval 'sub SXP_DCONF1_SYNC_HOLD () {0x7000;}' unless defined(&SXP_DCONF1_SYNC_HOLD);
    eval 'sub SXP_DCONF1_SYNC_SETUP () {0x0f00;}' unless defined(&SXP_DCONF1_SYNC_SETUP);
    eval 'sub SXP_DCONF1_SYNC_OFFSET () {0x000f;}' unless defined(&SXP_DCONF1_SYNC_OFFSET);
    eval 'sub SXP_DCONF2_FLAGS_MASK () {0xf000;}' unless defined(&SXP_DCONF2_FLAGS_MASK);
    eval 'sub SXP_DCONF2_WIDE () {0x0400;}' unless defined(&SXP_DCONF2_WIDE);
    eval 'sub SXP_DCONF2_PARITY () {0x0200;}' unless defined(&SXP_DCONF2_PARITY);
    eval 'sub SXP_DCONF2_BLOCK_MODE () {0x0100;}' unless defined(&SXP_DCONF2_BLOCK_MODE);
    eval 'sub SXP_DCONF2_ASSERTION_MASK () {0x0007;}' unless defined(&SXP_DCONF2_ASSERTION_MASK);
    eval 'sub SXP_PHASE_STATUS_PTR () {0x1000;}' unless defined(&SXP_PHASE_STATUS_PTR);
    eval 'sub SXP_PHASE_MSG_IN_PTR () {0x0700;}' unless defined(&SXP_PHASE_MSG_IN_PTR);
    eval 'sub SXP_PHASE_COM_PTR () {0x00f0;}' unless defined(&SXP_PHASE_COM_PTR);
    eval 'sub SXP_PHASE_MSG_OUT_PTR () {0x0007;}' unless defined(&SXP_PHASE_MSG_OUT_PTR);
    eval 'sub SXP_FIFO_TOP_RESID () {0x8000;}' unless defined(&SXP_FIFO_TOP_RESID);
    eval 'sub SXP_FIFO_ACK_RESID () {0x4000;}' unless defined(&SXP_FIFO_ACK_RESID);
    eval 'sub SXP_FIFO_COUNT_MASK () {0x001c;}' unless defined(&SXP_FIFO_COUNT_MASK);
    eval 'sub SXP_FIFO_BOTTOM_RESID () {0x0001;}' unless defined(&SXP_FIFO_BOTTOM_RESID);
    eval 'sub SXP_PINS_CON_PHASE () {0x8000;}' unless defined(&SXP_PINS_CON_PHASE);
    eval 'sub SXP_PINS_CON_PARITY_HI () {0x0400;}' unless defined(&SXP_PINS_CON_PARITY_HI);
    eval 'sub SXP_PINS_CON_PARITY_LO () {0x0200;}' unless defined(&SXP_PINS_CON_PARITY_LO);
    eval 'sub SXP_PINS_CON_REQ () {0x0100;}' unless defined(&SXP_PINS_CON_REQ);
    eval 'sub SXP_PINS_CON_ACK () {0x0080;}' unless defined(&SXP_PINS_CON_ACK);
    eval 'sub SXP_PINS_CON_RST () {0x0040;}' unless defined(&SXP_PINS_CON_RST);
    eval 'sub SXP_PINS_CON_BSY () {0x0020;}' unless defined(&SXP_PINS_CON_BSY);
    eval 'sub SXP_PINS_CON_SEL () {0x0010;}' unless defined(&SXP_PINS_CON_SEL);
    eval 'sub SXP_PINS_CON_ATN () {0x0008;}' unless defined(&SXP_PINS_CON_ATN);
    eval 'sub SXP_PINS_CON_MSG () {0x0004;}' unless defined(&SXP_PINS_CON_MSG);
    eval 'sub SXP_PINS_CON_CD () {0x0002;}' unless defined(&SXP_PINS_CON_CD);
    eval 'sub SXP_PINS_CON_IO () {0x0001;}' unless defined(&SXP_PINS_CON_IO);
    eval 'sub SXP_SCSI_BUS_RESET_HOLD_TIME () {250;}' unless defined(&SXP_SCSI_BUS_RESET_HOLD_TIME);
    eval 'sub SXP_PINS_DIFF_SENSE () {0x0200;}' unless defined(&SXP_PINS_DIFF_SENSE);
    eval 'sub SXP_PINS_DIFF_MODE () {0x0100;}' unless defined(&SXP_PINS_DIFF_MODE);
    eval 'sub SXP_PINS_DIFF_ENABLE_OUTPUT () {0x0080;}' unless defined(&SXP_PINS_DIFF_ENABLE_OUTPUT);
    eval 'sub SXP_PINS_DIFF_PINS_MASK () {0x007c;}' unless defined(&SXP_PINS_DIFF_PINS_MASK);
    eval 'sub SXP_PINS_DIFF_TARGET () {0x0002;}' unless defined(&SXP_PINS_DIFF_TARGET);
    eval 'sub SXP_PINS_DIFF_INITIATOR () {0x0001;}' unless defined(&SXP_PINS_DIFF_INITIATOR);
    eval 'sub SXP_PINS_LVD_MODE () {0x1000;}' unless defined(&SXP_PINS_LVD_MODE);
    eval 'sub SXP_PINS_HVD_MODE () {0x0800;}' unless defined(&SXP_PINS_HVD_MODE);
    eval 'sub SXP_PINS_SE_MODE () {0x0400;}' unless defined(&SXP_PINS_SE_MODE);
    eval 'sub ISP1080_LVD_MODE () {( &SXP_PINS_LVD_MODE);}' unless defined(&ISP1080_LVD_MODE);
    eval 'sub ISP1080_HVD_MODE () {( &SXP_PINS_HVD_MODE| &SXP_PINS_DIFF_MODE);}' unless defined(&ISP1080_HVD_MODE);
    eval 'sub ISP1080_SE_MODE () {( &SXP_PINS_SE_MODE);}' unless defined(&ISP1080_SE_MODE);
    eval 'sub ISP1080_MODE_MASK () {( &SXP_PINS_LVD_MODE| &SXP_PINS_HVD_MODE| &SXP_PINS_SE_MODE| &SXP_PINS_DIFF_MODE);}' unless defined(&ISP1080_MODE_MASK);
    eval 'sub RISC_ACC () { &RISC_BLOCK+0x0;}' unless defined(&RISC_ACC);
    eval 'sub RISC_R1 () { &RISC_BLOCK+0x2;}' unless defined(&RISC_R1);
    eval 'sub RISC_R2 () { &RISC_BLOCK+0x4;}' unless defined(&RISC_R2);
    eval 'sub RISC_R3 () { &RISC_BLOCK+0x6;}' unless defined(&RISC_R3);
    eval 'sub RISC_R4 () { &RISC_BLOCK+0x8;}' unless defined(&RISC_R4);
    eval 'sub RISC_R5 () { &RISC_BLOCK+0xa;}' unless defined(&RISC_R5);
    eval 'sub RISC_R6 () { &RISC_BLOCK+0xc;}' unless defined(&RISC_R6);
    eval 'sub RISC_R7 () { &RISC_BLOCK+0xe;}' unless defined(&RISC_R7);
    eval 'sub RISC_R8 () { &RISC_BLOCK+0x10;}' unless defined(&RISC_R8);
    eval 'sub RISC_R9 () { &RISC_BLOCK+0x12;}' unless defined(&RISC_R9);
    eval 'sub RISC_R10 () { &RISC_BLOCK+0x14;}' unless defined(&RISC_R10);
    eval 'sub RISC_R11 () { &RISC_BLOCK+0x16;}' unless defined(&RISC_R11);
    eval 'sub RISC_R12 () { &RISC_BLOCK+0x18;}' unless defined(&RISC_R12);
    eval 'sub RISC_R13 () { &RISC_BLOCK+0x1a;}' unless defined(&RISC_R13);
    eval 'sub RISC_R14 () { &RISC_BLOCK+0x1c;}' unless defined(&RISC_R14);
    eval 'sub RISC_R15 () { &RISC_BLOCK+0x1e;}' unless defined(&RISC_R15);
    eval 'sub RISC_PSR () { &RISC_BLOCK+0x20;}' unless defined(&RISC_PSR);
    eval 'sub RISC_IVR () { &RISC_BLOCK+0x22;}' unless defined(&RISC_IVR);
    eval 'sub RISC_PCR () { &RISC_BLOCK+0x24;}' unless defined(&RISC_PCR);
    eval 'sub RISC_RAR0 () { &RISC_BLOCK+0x26;}' unless defined(&RISC_RAR0);
    eval 'sub RISC_RAR1 () { &RISC_BLOCK+0x28;}' unless defined(&RISC_RAR1);
    eval 'sub RISC_LCR () { &RISC_BLOCK+0x2a;}' unless defined(&RISC_LCR);
    eval 'sub RISC_PC () { &RISC_BLOCK+0x2c;}' unless defined(&RISC_PC);
    eval 'sub RISC_MTR () { &RISC_BLOCK+0x2e;}' unless defined(&RISC_MTR);
    eval 'sub RISC_MTR2100 () { &RISC_BLOCK+0x30;}' unless defined(&RISC_MTR2100);
    eval 'sub RISC_EMB () { &RISC_BLOCK+0x30;}' unless defined(&RISC_EMB);
    eval 'sub DUAL_BANK () {8;}' unless defined(&DUAL_BANK);
    eval 'sub RISC_SP () { &RISC_BLOCK+0x32;}' unless defined(&RISC_SP);
    eval 'sub RISC_HRL () { &RISC_BLOCK+0x3e;}' unless defined(&RISC_HRL);
    eval 'sub HCCR () { &RISC_BLOCK+0x40;}' unless defined(&HCCR);
    eval 'sub BP0 () { &RISC_BLOCK+0x42;}' unless defined(&BP0);
    eval 'sub BP1 () { &RISC_BLOCK+0x44;}' unless defined(&BP1);
    eval 'sub TCR () { &RISC_BLOCK+0x46;}' unless defined(&TCR);
    eval 'sub TMR () { &RISC_BLOCK+0x48;}' unless defined(&TMR);
    eval 'sub RISC_PSR_FORCE_TRUE () {0x8000;}' unless defined(&RISC_PSR_FORCE_TRUE);
    eval 'sub RISC_PSR_LOOP_COUNT_DONE () {0x4000;}' unless defined(&RISC_PSR_LOOP_COUNT_DONE);
    eval 'sub RISC_PSR_RISC_INT () {0x2000;}' unless defined(&RISC_PSR_RISC_INT);
    eval 'sub RISC_PSR_TIMER_ROLLOVER () {0x1000;}' unless defined(&RISC_PSR_TIMER_ROLLOVER);
    eval 'sub RISC_PSR_ALU_OVERFLOW () {0x0800;}' unless defined(&RISC_PSR_ALU_OVERFLOW);
    eval 'sub RISC_PSR_ALU_MSB () {0x0400;}' unless defined(&RISC_PSR_ALU_MSB);
    eval 'sub RISC_PSR_ALU_CARRY () {0x0200;}' unless defined(&RISC_PSR_ALU_CARRY);
    eval 'sub RISC_PSR_ALU_ZERO () {0x0100;}' unless defined(&RISC_PSR_ALU_ZERO);
    eval 'sub RISC_PSR_PCI_ULTRA () {0x0080;}' unless defined(&RISC_PSR_PCI_ULTRA);
    eval 'sub RISC_PSR_SBUS_ULTRA () {0x0020;}' unless defined(&RISC_PSR_SBUS_ULTRA);
    eval 'sub RISC_PSR_DMA_INT () {0x0010;}' unless defined(&RISC_PSR_DMA_INT);
    eval 'sub RISC_PSR_SXP_INT () {0x0008;}' unless defined(&RISC_PSR_SXP_INT);
    eval 'sub RISC_PSR_HOST_INT () {0x0004;}' unless defined(&RISC_PSR_HOST_INT);
    eval 'sub RISC_PSR_INT_PENDING () {0x0002;}' unless defined(&RISC_PSR_INT_PENDING);
    eval 'sub RISC_PSR_FORCE_FALSE () {0x0001;}' unless defined(&RISC_PSR_FORCE_FALSE);
    eval 'sub HCCR_CMD_NOP () {0x0000;}' unless defined(&HCCR_CMD_NOP);
    eval 'sub HCCR_CMD_RESET () {0x1000;}' unless defined(&HCCR_CMD_RESET);
    eval 'sub HCCR_CMD_PAUSE () {0x2000;}' unless defined(&HCCR_CMD_PAUSE);
    eval 'sub HCCR_CMD_RELEASE () {0x3000;}' unless defined(&HCCR_CMD_RELEASE);
    eval 'sub HCCR_CMD_STEP () {0x4000;}' unless defined(&HCCR_CMD_STEP);
    eval 'sub HCCR_CMD_SET_HOST_INT () {0x5000;}' unless defined(&HCCR_CMD_SET_HOST_INT);
    eval 'sub HCCR_CMD_CLEAR_HOST_INT () {0x6000;}' unless defined(&HCCR_CMD_CLEAR_HOST_INT);
    eval 'sub HCCR_CMD_CLEAR_RISC_INT () {0x7000;}' unless defined(&HCCR_CMD_CLEAR_RISC_INT);
    eval 'sub HCCR_CMD_BREAKPOINT () {0x8000;}' unless defined(&HCCR_CMD_BREAKPOINT);
    eval 'sub PCI_HCCR_CMD_BIOS () {0x9000;}' unless defined(&PCI_HCCR_CMD_BIOS);
    eval 'sub PCI_HCCR_CMD_PARITY () {0xa000;}' unless defined(&PCI_HCCR_CMD_PARITY);
    eval 'sub PCI_HCCR_CMD_PARITY_ERR () {0xe000;}' unless defined(&PCI_HCCR_CMD_PARITY_ERR);
    eval 'sub HCCR_CMD_TEST_MODE () {0xf000;}' unless defined(&HCCR_CMD_TEST_MODE);
    eval 'sub ISP2100_HCCR_PARITY_ENABLE_2 () {0x0400;}' unless defined(&ISP2100_HCCR_PARITY_ENABLE_2);
    eval 'sub ISP2100_HCCR_PARITY_ENABLE_1 () {0x0200;}' unless defined(&ISP2100_HCCR_PARITY_ENABLE_1);
    eval 'sub ISP2100_HCCR_PARITY_ENABLE_0 () {0x0100;}' unless defined(&ISP2100_HCCR_PARITY_ENABLE_0);
    eval 'sub ISP2100_HCCR_PARITY () {0x0001;}' unless defined(&ISP2100_HCCR_PARITY);
    eval 'sub PCI_HCCR_PARITY () {0x0400;}' unless defined(&PCI_HCCR_PARITY);
    eval 'sub PCI_HCCR_PARITY_ENABLE_1 () {0x0200;}' unless defined(&PCI_HCCR_PARITY_ENABLE_1);
    eval 'sub PCI_HCCR_PARITY_ENABLE_0 () {0x0100;}' unless defined(&PCI_HCCR_PARITY_ENABLE_0);
    eval 'sub HCCR_HOST_INT () {0x0080;}' unless defined(&HCCR_HOST_INT);
    eval 'sub HCCR_RESET () {0x0040;}' unless defined(&HCCR_RESET);
    eval 'sub HCCR_PAUSE () {0x0020;}' unless defined(&HCCR_PAUSE);
    eval 'sub PCI_HCCR_BIOS () {0x0001;}' unless defined(&PCI_HCCR_BIOS);
    eval 'sub ISPBSMX {
        local($c, $byte, $shift, $mask) = @_;
	    eval q(((($c)[($byte)] >> ($shift)) & ($mask)));
    }' unless defined(&ISPBSMX);
    eval 'sub ISP_NVRAM_SIZE () {128;}' unless defined(&ISP_NVRAM_SIZE);
    eval 'sub ISP_NVRAM_VERSION {
        local($c) = @_;
	    eval q(($c)[4]);
    }' unless defined(&ISP_NVRAM_VERSION);
    eval 'sub ISP_NVRAM_FIFO_THRESHOLD {
        local($c) = @_;
	    eval q( &ISPBSMX($c, 5, 0, 0x03));
    }' unless defined(&ISP_NVRAM_FIFO_THRESHOLD);
    eval 'sub ISP_NVRAM_BIOS_DISABLE {
        local($c) = @_;
	    eval q( &ISPBSMX($c, 5, 2, 0x01));
    }' unless defined(&ISP_NVRAM_BIOS_DISABLE);
    eval 'sub ISP_NVRAM_HBA_ENABLE {
        local($c) = @_;
	    eval q( &ISPBSMX($c, 5, 3, 0x01));
    }' unless defined(&ISP_NVRAM_HBA_ENABLE);
    eval 'sub ISP_NVRAM_INITIATOR_ID {
        local($c) = @_;
	    eval q( &ISPBSMX($c, 5, 4, 0x0f));
    }' unless defined(&ISP_NVRAM_INITIATOR_ID);
    eval 'sub ISP_NVRAM_BUS_RESET_DELAY {
        local($c) = @_;
	    eval q(($c)[6]);
    }' unless defined(&ISP_NVRAM_BUS_RESET_DELAY);
    eval 'sub ISP_NVRAM_BUS_RETRY_COUNT {
        local($c) = @_;
	    eval q(($c)[7]);
    }' unless defined(&ISP_NVRAM_BUS_RETRY_COUNT);
    eval 'sub ISP_NVRAM_BUS_RETRY_DELAY {
        local($c) = @_;
	    eval q(($c)[8]);
    }' unless defined(&ISP_NVRAM_BUS_RETRY_DELAY);
    eval 'sub ISP_NVRAM_ASYNC_DATA_SETUP_TIME {
        local($c) = @_;
	    eval q( &ISPBSMX($c, 9, 0, 0x0f));
    }' unless defined(&ISP_NVRAM_ASYNC_DATA_SETUP_TIME);
    eval 'sub ISP_NVRAM_REQ_ACK_ACTIVE_NEGATION {
        local($c) = @_;
	    eval q( &ISPBSMX($c, 9, 4, 0x01));
    }' unless defined(&ISP_NVRAM_REQ_ACK_ACTIVE_NEGATION);
    eval 'sub ISP_NVRAM_DATA_LINE_ACTIVE_NEGATION {
        local($c) = @_;
	    eval q( &ISPBSMX($c, 9, 5, 0x01));
    }' unless defined(&ISP_NVRAM_DATA_LINE_ACTIVE_NEGATION);
    eval 'sub ISP_NVRAM_DATA_DMA_BURST_ENABLE {
        local($c) = @_;
	    eval q( &ISPBSMX($c, 9, 6, 0x01));
    }' unless defined(&ISP_NVRAM_DATA_DMA_BURST_ENABLE);
    eval 'sub ISP_NVRAM_CMD_DMA_BURST_ENABLE {
        local($c) = @_;
	    eval q( &ISPBSMX($c, 9, 7, 0x01));
    }' unless defined(&ISP_NVRAM_CMD_DMA_BURST_ENABLE);
    eval 'sub ISP_NVRAM_TAG_AGE_LIMIT {
        local($c) = @_;
	    eval q(($c)[10]);
    }' unless defined(&ISP_NVRAM_TAG_AGE_LIMIT);
    eval 'sub ISP_NVRAM_LOWTRM_ENABLE {
        local($c) = @_;
	    eval q( &ISPBSMX($c, 11, 0, 0x01));
    }' unless defined(&ISP_NVRAM_LOWTRM_ENABLE);
    eval 'sub ISP_NVRAM_HITRM_ENABLE {
        local($c) = @_;
	    eval q( &ISPBSMX($c, 11, 1, 0x01));
    }' unless defined(&ISP_NVRAM_HITRM_ENABLE);
    eval 'sub ISP_NVRAM_PCMC_BURST_ENABLE {
        local($c) = @_;
	    eval q( &ISPBSMX($c, 11, 2, 0x01));
    }' unless defined(&ISP_NVRAM_PCMC_BURST_ENABLE);
    eval 'sub ISP_NVRAM_ENABLE_60_MHZ {
        local($c) = @_;
	    eval q( &ISPBSMX($c, 11, 3, 0x01));
    }' unless defined(&ISP_NVRAM_ENABLE_60_MHZ);
    eval 'sub ISP_NVRAM_SCSI_RESET_DISABLE {
        local($c) = @_;
	    eval q( &ISPBSMX($c, 11, 4, 0x01));
    }' unless defined(&ISP_NVRAM_SCSI_RESET_DISABLE);
    eval 'sub ISP_NVRAM_ENABLE_AUTO_TERM {
        local($c) = @_;
	    eval q( &ISPBSMX($c, 11, 5, 0x01));
    }' unless defined(&ISP_NVRAM_ENABLE_AUTO_TERM);
    eval 'sub ISP_NVRAM_FIFO_THRESHOLD_128 {
        local($c) = @_;
	    eval q( &ISPBSMX($c, 11, 6, 0x01));
    }' unless defined(&ISP_NVRAM_FIFO_THRESHOLD_128);
    eval 'sub ISP_NVRAM_AUTO_TERM_SUPPORT {
        local($c) = @_;
	    eval q( &ISPBSMX($c, 11, 7, 0x01));
    }' unless defined(&ISP_NVRAM_AUTO_TERM_SUPPORT);
    eval 'sub ISP_NVRAM_SELECTION_TIMEOUT {
        local($c) = @_;
	    eval q(((($c)[12]) | (($c)[13] << 8)));
    }' unless defined(&ISP_NVRAM_SELECTION_TIMEOUT);
    eval 'sub ISP_NVRAM_MAX_QUEUE_DEPTH {
        local($c) = @_;
	    eval q(((($c)[14]) | (($c)[15] << 8)));
    }' unless defined(&ISP_NVRAM_MAX_QUEUE_DEPTH);
    eval 'sub ISP_NVRAM_SCSI_BUS_SIZE {
        local($c) = @_;
	    eval q( &ISPBSMX($c, 16, 0, 0x01));
    }' unless defined(&ISP_NVRAM_SCSI_BUS_SIZE);
    eval 'sub ISP_NVRAM_SCSI_BUS_TYPE {
        local($c) = @_;
	    eval q( &ISPBSMX($c, 16, 1, 0x01));
    }' unless defined(&ISP_NVRAM_SCSI_BUS_TYPE);
    eval 'sub ISP_NVRAM_ADAPTER_CLK_SPEED {
        local($c) = @_;
	    eval q( &ISPBSMX($c, 16, 2, 0x01));
    }' unless defined(&ISP_NVRAM_ADAPTER_CLK_SPEED);
    eval 'sub ISP_NVRAM_SOFT_TERM_SUPPORT {
        local($c) = @_;
	    eval q( &ISPBSMX($c, 16, 3, 0x01));
    }' unless defined(&ISP_NVRAM_SOFT_TERM_SUPPORT);
    eval 'sub ISP_NVRAM_FLASH_ONBOARD {
        local($c) = @_;
	    eval q( &ISPBSMX($c, 16, 4, 0x01));
    }' unless defined(&ISP_NVRAM_FLASH_ONBOARD);
    eval 'sub ISP_NVRAM_FAST_MTTR_ENABLE {
        local($c) = @_;
	    eval q( &ISPBSMX($c, 22, 0, 0x01));
    }' unless defined(&ISP_NVRAM_FAST_MTTR_ENABLE);
    eval 'sub ISP_NVRAM_TARGOFF () {28;}' unless defined(&ISP_NVRAM_TARGOFF);
    eval 'sub ISP_NVARM_TARGSIZE () {6;}' unless defined(&ISP_NVARM_TARGSIZE);
    eval 'sub _IxT {
        local($tgt, $tidx) = @_;
	    eval q(( &ISP_NVRAM_TARGOFF + ( &ISP_NVARM_TARGSIZE * ($tgt)) + ($tidx)));
    }' unless defined(&_IxT);
    eval 'sub ISP_NVRAM_TGT_RENEG {
        local($c, $t) = @_;
	    eval q( &ISPBSMX($c,  &_IxT($t, 0), 0, 0x01));
    }' unless defined(&ISP_NVRAM_TGT_RENEG);
    eval 'sub ISP_NVRAM_TGT_QFRZ {
        local($c, $t) = @_;
	    eval q( &ISPBSMX($c,  &_IxT($t, 0), 1, 0x01));
    }' unless defined(&ISP_NVRAM_TGT_QFRZ);
    eval 'sub ISP_NVRAM_TGT_ARQ {
        local($c, $t) = @_;
	    eval q( &ISPBSMX($c,  &_IxT($t, 0), 2, 0x01));
    }' unless defined(&ISP_NVRAM_TGT_ARQ);
    eval 'sub ISP_NVRAM_TGT_TQING {
        local($c, $t) = @_;
	    eval q( &ISPBSMX($c,  &_IxT($t, 0), 3, 0x01));
    }' unless defined(&ISP_NVRAM_TGT_TQING);
    eval 'sub ISP_NVRAM_TGT_SYNC {
        local($c, $t) = @_;
	    eval q( &ISPBSMX($c,  &_IxT($t, 0), 4, 0x01));
    }' unless defined(&ISP_NVRAM_TGT_SYNC);
    eval 'sub ISP_NVRAM_TGT_WIDE {
        local($c, $t) = @_;
	    eval q( &ISPBSMX($c,  &_IxT($t, 0), 5, 0x01));
    }' unless defined(&ISP_NVRAM_TGT_WIDE);
    eval 'sub ISP_NVRAM_TGT_PARITY {
        local($c, $t) = @_;
	    eval q( &ISPBSMX($c,  &_IxT($t, 0), 6, 0x01));
    }' unless defined(&ISP_NVRAM_TGT_PARITY);
    eval 'sub ISP_NVRAM_TGT_DISC {
        local($c, $t) = @_;
	    eval q( &ISPBSMX($c,  &_IxT($t, 0), 7, 0x01));
    }' unless defined(&ISP_NVRAM_TGT_DISC);
    eval 'sub ISP_NVRAM_TGT_EXEC_THROTTLE {
        local($c, $t) = @_;
	    eval q( &ISPBSMX($c,  &_IxT($t, 1), 0, 0xff));
    }' unless defined(&ISP_NVRAM_TGT_EXEC_THROTTLE);
    eval 'sub ISP_NVRAM_TGT_SYNC_PERIOD {
        local($c, $t) = @_;
	    eval q( &ISPBSMX($c,  &_IxT($t, 2), 0, 0xff));
    }' unless defined(&ISP_NVRAM_TGT_SYNC_PERIOD);
    eval 'sub ISP_NVRAM_TGT_SYNC_OFFSET {
        local($c, $t) = @_;
	    eval q( &ISPBSMX($c,  &_IxT($t, 3), 0, 0x0f));
    }' unless defined(&ISP_NVRAM_TGT_SYNC_OFFSET);
    eval 'sub ISP_NVRAM_TGT_DEVICE_ENABLE {
        local($c, $t) = @_;
	    eval q( &ISPBSMX($c,  &_IxT($t, 3), 4, 0x01));
    }' unless defined(&ISP_NVRAM_TGT_DEVICE_ENABLE);
    eval 'sub ISP_NVRAM_TGT_LUN_DISABLE {
        local($c, $t) = @_;
	    eval q( &ISPBSMX($c,  &_IxT($t, 3), 5, 0x01));
    }' unless defined(&ISP_NVRAM_TGT_LUN_DISABLE);
    eval 'sub ISP1080_NVRAM_SIZE () {256;}' unless defined(&ISP1080_NVRAM_SIZE);
    eval 'sub ISP1080_NVRAM_VERSION {
        local($c) = @_;
	    eval q( &ISP_NVRAM_VERSION($c));
    }' unless defined(&ISP1080_NVRAM_VERSION);
    eval 'sub ISP1080_NVRAM_HBA_ENABLE {
        local($c) = @_;
	    eval q( &ISPBSMX($c, 16, 3, 0x01));
    }' unless defined(&ISP1080_NVRAM_HBA_ENABLE);
    eval 'sub ISP1080_NVRAM_BURST_ENABLE {
        local($c) = @_;
	    eval q( &ISPBSMX($c, 16, 1, 0x01));
    }' unless defined(&ISP1080_NVRAM_BURST_ENABLE);
    eval 'sub ISP1080_NVRAM_FIFO_THRESHOLD {
        local($c) = @_;
	    eval q( &ISPBSMX($c, 16, 4, 0x0f));
    }' unless defined(&ISP1080_NVRAM_FIFO_THRESHOLD);
    eval 'sub ISP1080_NVRAM_AUTO_TERM_SUPPORT {
        local($c) = @_;
	    eval q( &ISPBSMX($c, 17, 7, 0x01));
    }' unless defined(&ISP1080_NVRAM_AUTO_TERM_SUPPORT);
    eval 'sub ISP1080_NVRAM_BUS0_TERM_MODE {
        local($c) = @_;
	    eval q( &ISPBSMX($c, 17, 0, 0x03));
    }' unless defined(&ISP1080_NVRAM_BUS0_TERM_MODE);
    eval 'sub ISP1080_NVRAM_BUS1_TERM_MODE {
        local($c) = @_;
	    eval q( &ISPBSMX($c, 17, 2, 0x03));
    }' unless defined(&ISP1080_NVRAM_BUS1_TERM_MODE);
    eval 'sub ISP1080_ISP_PARAMETER {
        local($c) = @_;
	    eval q(((($c)[18]) | (($c)[19] << 8)));
    }' unless defined(&ISP1080_ISP_PARAMETER);
    eval 'sub ISP1080_FAST_POST {
        local($c) = @_;
	    eval q( &ISPBSMX($c, 20, 0, 0x01));
    }' unless defined(&ISP1080_FAST_POST);
    eval 'sub ISP1080_REPORT_LVD_TRANSITION {
        local($c) = @_;
	    eval q( &ISPBSMX($c, 20, 1, 0x01));
    }' unless defined(&ISP1080_REPORT_LVD_TRANSITION);
    eval 'sub ISP1080_BUS1_OFF () {112;}' unless defined(&ISP1080_BUS1_OFF);
    eval 'sub ISP1080_NVRAM_INITIATOR_ID {
        local($c, $b) = @_;
	    eval q( &ISPBSMX($c, (($b == 0)? 0:  &ISP1080_BUS1_OFF) + 24, 0, 0x0f));
    }' unless defined(&ISP1080_NVRAM_INITIATOR_ID);
    eval 'sub ISP1080_NVRAM_BUS_RESET_DELAY {
        local($c, $b) = @_;
	    eval q(($c)[(($b == 0)? 0:  &ISP1080_BUS1_OFF) + 25]);
    }' unless defined(&ISP1080_NVRAM_BUS_RESET_DELAY);
    eval 'sub ISP1080_NVRAM_BUS_RETRY_COUNT {
        local($c, $b) = @_;
	    eval q(($c)[(($b == 0)? 0:  &ISP1080_BUS1_OFF) + 26]);
    }' unless defined(&ISP1080_NVRAM_BUS_RETRY_COUNT);
    eval 'sub ISP1080_NVRAM_BUS_RETRY_DELAY {
        local($c, $b) = @_;
	    eval q(($c)[(($b == 0)? 0:  &ISP1080_BUS1_OFF) + 27]);
    }' unless defined(&ISP1080_NVRAM_BUS_RETRY_DELAY);
    eval 'sub ISP1080_NVRAM_ASYNC_DATA_SETUP_TIME {
        local($c, $b) = @_;
	    eval q( &ISPBSMX($c, (($b == 0)? 0:  &ISP1080_BUS1_OFF) + 28, 0, 0x0f));
    }' unless defined(&ISP1080_NVRAM_ASYNC_DATA_SETUP_TIME);
    eval 'sub ISP1080_NVRAM_REQ_ACK_ACTIVE_NEGATION {
        local($c, $b) = @_;
	    eval q( &ISPBSMX($c, (($b == 0)? 0:  &ISP1080_BUS1_OFF) + 28, 4, 0x01));
    }' unless defined(&ISP1080_NVRAM_REQ_ACK_ACTIVE_NEGATION);
    eval 'sub ISP1080_NVRAM_DATA_LINE_ACTIVE_NEGATION {
        local($c, $b) = @_;
	    eval q( &ISPBSMX($c, (($b == 0)? 0:  &ISP1080_BUS1_OFF) + 28, 5, 0x01));
    }' unless defined(&ISP1080_NVRAM_DATA_LINE_ACTIVE_NEGATION);
    eval 'sub ISP1080_NVRAM_SELECTION_TIMEOUT {
        local($c, $b) = @_;
	    eval q(((($c)[(($b == 0)? 0:  &ISP1080_BUS1_OFF) + 30]) | (($c)[(($b == 0)? 0:  &ISP1080_BUS1_OFF) + 31] << 8)));
    }' unless defined(&ISP1080_NVRAM_SELECTION_TIMEOUT);
    eval 'sub ISP1080_NVRAM_MAX_QUEUE_DEPTH {
        local($c, $b) = @_;
	    eval q(((($c)[(($b == 0)? 0:  &ISP1080_BUS1_OFF) + 32]) | (($c)[(($b == 0)? 0:  &ISP1080_BUS1_OFF) + 33] << 8)));
    }' unless defined(&ISP1080_NVRAM_MAX_QUEUE_DEPTH);
    eval 'sub ISP1080_NVRAM_TARGOFF {
        local($b) = @_;
	    eval q((($b == 0)? 40: (40+  &ISP1080_BUS1_OFF)));
    }' unless defined(&ISP1080_NVRAM_TARGOFF);
    eval 'sub ISP1080_NVRAM_TARGSIZE () {6;}' unless defined(&ISP1080_NVRAM_TARGSIZE);
    eval 'sub _IxT8 {
        local($tgt, $tidx, $b) = @_;
	    eval q(( &ISP1080_NVRAM_TARGOFF(($b)) + ( &ISP1080_NVRAM_TARGSIZE * ($tgt)) + ($tidx)));
    }' unless defined(&_IxT8);
    eval 'sub ISP1080_NVRAM_TGT_RENEG {
        local($c, $t, $b) = @_;
	    eval q( &ISPBSMX($c,  &_IxT8($t, 0, ($b)), 0, 0x01));
    }' unless defined(&ISP1080_NVRAM_TGT_RENEG);
    eval 'sub ISP1080_NVRAM_TGT_QFRZ {
        local($c, $t, $b) = @_;
	    eval q( &ISPBSMX($c,  &_IxT8($t, 0, ($b)), 1, 0x01));
    }' unless defined(&ISP1080_NVRAM_TGT_QFRZ);
    eval 'sub ISP1080_NVRAM_TGT_ARQ {
        local($c, $t, $b) = @_;
	    eval q( &ISPBSMX($c,  &_IxT8($t, 0, ($b)), 2, 0x01));
    }' unless defined(&ISP1080_NVRAM_TGT_ARQ);
    eval 'sub ISP1080_NVRAM_TGT_TQING {
        local($c, $t, $b) = @_;
	    eval q( &ISPBSMX($c,  &_IxT8($t, 0, ($b)), 3, 0x01));
    }' unless defined(&ISP1080_NVRAM_TGT_TQING);
    eval 'sub ISP1080_NVRAM_TGT_SYNC {
        local($c, $t, $b) = @_;
	    eval q( &ISPBSMX($c,  &_IxT8($t, 0, ($b)), 4, 0x01));
    }' unless defined(&ISP1080_NVRAM_TGT_SYNC);
    eval 'sub ISP1080_NVRAM_TGT_WIDE {
        local($c, $t, $b) = @_;
	    eval q( &ISPBSMX($c,  &_IxT8($t, 0, ($b)), 5, 0x01));
    }' unless defined(&ISP1080_NVRAM_TGT_WIDE);
    eval 'sub ISP1080_NVRAM_TGT_PARITY {
        local($c, $t, $b) = @_;
	    eval q( &ISPBSMX($c,  &_IxT8($t, 0, ($b)), 6, 0x01));
    }' unless defined(&ISP1080_NVRAM_TGT_PARITY);
    eval 'sub ISP1080_NVRAM_TGT_DISC {
        local($c, $t, $b) = @_;
	    eval q( &ISPBSMX($c,  &_IxT8($t, 0, ($b)), 7, 0x01));
    }' unless defined(&ISP1080_NVRAM_TGT_DISC);
    eval 'sub ISP1080_NVRAM_TGT_EXEC_THROTTLE {
        local($c, $t, $b) = @_;
	    eval q( &ISPBSMX($c,  &_IxT8($t, 1, ($b)), 0, 0xff));
    }' unless defined(&ISP1080_NVRAM_TGT_EXEC_THROTTLE);
    eval 'sub ISP1080_NVRAM_TGT_SYNC_PERIOD {
        local($c, $t, $b) = @_;
	    eval q( &ISPBSMX($c,  &_IxT8($t, 2, ($b)), 0, 0xff));
    }' unless defined(&ISP1080_NVRAM_TGT_SYNC_PERIOD);
    eval 'sub ISP1080_NVRAM_TGT_SYNC_OFFSET {
        local($c, $t, $b) = @_;
	    eval q( &ISPBSMX($c,  &_IxT8($t, 3, ($b)), 0, 0x0f));
    }' unless defined(&ISP1080_NVRAM_TGT_SYNC_OFFSET);
    eval 'sub ISP1080_NVRAM_TGT_DEVICE_ENABLE {
        local($c, $t, $b) = @_;
	    eval q( &ISPBSMX($c,  &_IxT8($t, 3, ($b)), 4, 0x01));
    }' unless defined(&ISP1080_NVRAM_TGT_DEVICE_ENABLE);
    eval 'sub ISP1080_NVRAM_TGT_LUN_DISABLE {
        local($c, $t, $b) = @_;
	    eval q( &ISPBSMX($c,  &_IxT8($t, 3, ($b)), 5, 0x01));
    }' unless defined(&ISP1080_NVRAM_TGT_LUN_DISABLE);
    eval 'sub ISP12160_NVRAM_HBA_ENABLE () { &ISP1080_NVRAM_HBA_ENABLE;}' unless defined(&ISP12160_NVRAM_HBA_ENABLE);
    eval 'sub ISP12160_NVRAM_BURST_ENABLE () { &ISP1080_NVRAM_BURST_ENABLE;}' unless defined(&ISP12160_NVRAM_BURST_ENABLE);
    eval 'sub ISP12160_NVRAM_FIFO_THRESHOLD () { &ISP1080_NVRAM_FIFO_THRESHOLD;}' unless defined(&ISP12160_NVRAM_FIFO_THRESHOLD);
    eval 'sub ISP12160_NVRAM_AUTO_TERM_SUPPORT () { &ISP1080_NVRAM_AUTO_TERM_SUPPORT;}' unless defined(&ISP12160_NVRAM_AUTO_TERM_SUPPORT);
    eval 'sub ISP12160_NVRAM_BUS0_TERM_MODE () { &ISP1080_NVRAM_BUS0_TERM_MODE;}' unless defined(&ISP12160_NVRAM_BUS0_TERM_MODE);
    eval 'sub ISP12160_NVRAM_BUS1_TERM_MODE () { &ISP1080_NVRAM_BUS1_TERM_MODE;}' unless defined(&ISP12160_NVRAM_BUS1_TERM_MODE);
    eval 'sub ISP12160_ISP_PARAMETER () { &ISP12160_ISP_PARAMETER;}' unless defined(&ISP12160_ISP_PARAMETER);
    eval 'sub ISP12160_FAST_POST () { &ISP1080_FAST_POST;}' unless defined(&ISP12160_FAST_POST);
    eval 'sub ISP12160_REPORT_LVD_TRANSITION () { &ISP1080_REPORT_LVD_TRANSTION;}' unless defined(&ISP12160_REPORT_LVD_TRANSITION);
    eval 'sub ISP12160_NVRAM_INITIATOR_ID () { &ISP1080_NVRAM_INITIATOR_ID;}' unless defined(&ISP12160_NVRAM_INITIATOR_ID);
    eval 'sub ISP12160_NVRAM_BUS_RESET_DELAY () { &ISP1080_NVRAM_BUS_RESET_DELAY;}' unless defined(&ISP12160_NVRAM_BUS_RESET_DELAY);
    eval 'sub ISP12160_NVRAM_BUS_RETRY_COUNT () { &ISP1080_NVRAM_BUS_RETRY_COUNT;}' unless defined(&ISP12160_NVRAM_BUS_RETRY_COUNT);
    eval 'sub ISP12160_NVRAM_BUS_RETRY_DELAY () { &ISP1080_NVRAM_BUS_RETRY_DELAY;}' unless defined(&ISP12160_NVRAM_BUS_RETRY_DELAY);
    eval 'sub ISP12160_NVRAM_ASYNC_DATA_SETUP_TIME () { &ISP1080_NVRAM_ASYNC_DATA_SETUP_TIME;}' unless defined(&ISP12160_NVRAM_ASYNC_DATA_SETUP_TIME);
    eval 'sub ISP12160_NVRAM_REQ_ACK_ACTIVE_NEGATION () { &ISP1080_NVRAM_REQ_ACK_ACTIVE_NEGATION;}' unless defined(&ISP12160_NVRAM_REQ_ACK_ACTIVE_NEGATION);
    eval 'sub ISP12160_NVRAM_DATA_LINE_ACTIVE_NEGATION () { &ISP1080_NVRAM_DATA_LINE_ACTIVE_NEGATION;}' unless defined(&ISP12160_NVRAM_DATA_LINE_ACTIVE_NEGATION);
    eval 'sub ISP12160_NVRAM_SELECTION_TIMEOUT () { &ISP1080_NVRAM_SELECTION_TIMEOUT;}' unless defined(&ISP12160_NVRAM_SELECTION_TIMEOUT);
    eval 'sub ISP12160_NVRAM_MAX_QUEUE_DEPTH () { &ISP1080_NVRAM_MAX_QUEUE_DEPTH;}' unless defined(&ISP12160_NVRAM_MAX_QUEUE_DEPTH);
    eval 'sub ISP12160_BUS0_OFF () {24;}' unless defined(&ISP12160_BUS0_OFF);
    eval 'sub ISP12160_BUS1_OFF () {136;}' unless defined(&ISP12160_BUS1_OFF);
    eval 'sub ISP12160_NVRAM_TARGOFF {
        local($b) = @_;
	    eval q(((($b == 0)?  &ISP12160_BUS0_OFF :  &ISP12160_BUS1_OFF) + 16));
    }' unless defined(&ISP12160_NVRAM_TARGOFF);
    eval 'sub ISP12160_NVRAM_TARGSIZE () {6;}' unless defined(&ISP12160_NVRAM_TARGSIZE);
    eval 'sub _IxT16 {
        local($tgt, $tidx, $b) = @_;
	    eval q(( &ISP12160_NVRAM_TARGOFF(($b))+( &ISP12160_NVRAM_TARGSIZE * ($tgt))+($tidx)));
    }' unless defined(&_IxT16);
    eval 'sub ISP12160_NVRAM_TGT_RENEG {
        local($c, $t, $b) = @_;
	    eval q( &ISPBSMX($c,  &_IxT16($t, 0, ($b)), 0, 0x01));
    }' unless defined(&ISP12160_NVRAM_TGT_RENEG);
    eval 'sub ISP12160_NVRAM_TGT_QFRZ {
        local($c, $t, $b) = @_;
	    eval q( &ISPBSMX($c,  &_IxT16($t, 0, ($b)), 1, 0x01));
    }' unless defined(&ISP12160_NVRAM_TGT_QFRZ);
    eval 'sub ISP12160_NVRAM_TGT_ARQ {
        local($c, $t, $b) = @_;
	    eval q( &ISPBSMX($c,  &_IxT16($t, 0, ($b)), 2, 0x01));
    }' unless defined(&ISP12160_NVRAM_TGT_ARQ);
    eval 'sub ISP12160_NVRAM_TGT_TQING {
        local($c, $t, $b) = @_;
	    eval q( &ISPBSMX($c,  &_IxT16($t, 0, ($b)), 3, 0x01));
    }' unless defined(&ISP12160_NVRAM_TGT_TQING);
    eval 'sub ISP12160_NVRAM_TGT_SYNC {
        local($c, $t, $b) = @_;
	    eval q( &ISPBSMX($c,  &_IxT16($t, 0, ($b)), 4, 0x01));
    }' unless defined(&ISP12160_NVRAM_TGT_SYNC);
    eval 'sub ISP12160_NVRAM_TGT_WIDE {
        local($c, $t, $b) = @_;
	    eval q( &ISPBSMX($c,  &_IxT16($t, 0, ($b)), 5, 0x01));
    }' unless defined(&ISP12160_NVRAM_TGT_WIDE);
    eval 'sub ISP12160_NVRAM_TGT_PARITY {
        local($c, $t, $b) = @_;
	    eval q( &ISPBSMX($c,  &_IxT16($t, 0, ($b)), 6, 0x01));
    }' unless defined(&ISP12160_NVRAM_TGT_PARITY);
    eval 'sub ISP12160_NVRAM_TGT_DISC {
        local($c, $t, $b) = @_;
	    eval q( &ISPBSMX($c,  &_IxT16($t, 0, ($b)), 7, 0x01));
    }' unless defined(&ISP12160_NVRAM_TGT_DISC);
    eval 'sub ISP12160_NVRAM_TGT_EXEC_THROTTLE {
        local($c, $t, $b) = @_;
	    eval q( &ISPBSMX($c,  &_IxT16($t, 1, ($b)), 0, 0xff));
    }' unless defined(&ISP12160_NVRAM_TGT_EXEC_THROTTLE);
    eval 'sub ISP12160_NVRAM_TGT_SYNC_PERIOD {
        local($c, $t, $b) = @_;
	    eval q( &ISPBSMX($c,  &_IxT16($t, 2, ($b)), 0, 0xff));
    }' unless defined(&ISP12160_NVRAM_TGT_SYNC_PERIOD);
    eval 'sub ISP12160_NVRAM_TGT_SYNC_OFFSET {
        local($c, $t, $b) = @_;
	    eval q( &ISPBSMX($c,  &_IxT16($t, 3, ($b)), 0, 0x1f));
    }' unless defined(&ISP12160_NVRAM_TGT_SYNC_OFFSET);
    eval 'sub ISP12160_NVRAM_TGT_DEVICE_ENABLE {
        local($c, $t, $b) = @_;
	    eval q( &ISPBSMX($c,  &_IxT16($t, 3, ($b)), 5, 0x01));
    }' unless defined(&ISP12160_NVRAM_TGT_DEVICE_ENABLE);
    eval 'sub ISP12160_NVRAM_PPR_OPTIONS {
        local($c, $t, $b) = @_;
	    eval q( &ISPBSMX($c,  &_IxT16($t, 4, ($b)), 0, 0x0f));
    }' unless defined(&ISP12160_NVRAM_PPR_OPTIONS);
    eval 'sub ISP12160_NVRAM_PPR_WIDTH {
        local($c, $t, $b) = @_;
	    eval q( &ISPBSMX($c,  &_IxT16($t, 4, ($b)), 4, 0x03));
    }' unless defined(&ISP12160_NVRAM_PPR_WIDTH);
    eval 'sub ISP12160_NVRAM_PPR_ENABLE {
        local($c, $t, $b) = @_;
	    eval q( &ISPBSMX($c,  &_IxT16($t, 4, ($b)), 7, 0x01));
    }' unless defined(&ISP12160_NVRAM_PPR_ENABLE);
    eval 'sub ISP2100_NVRAM_SIZE () {256;}' unless defined(&ISP2100_NVRAM_SIZE);
    eval 'sub ISP2100_NVRAM_RISCVER {
        local($c) = @_;
	    eval q(($c)[6]);
    }' unless defined(&ISP2100_NVRAM_RISCVER);
    eval 'sub ISP2100_NVRAM_OPTIONS {
        local($c) = @_;
	    eval q(($c)[8]);
    }' unless defined(&ISP2100_NVRAM_OPTIONS);
    eval 'sub ISP2100_NVRAM_MAXFRAMELENGTH {
        local($c) = @_;
	    eval q(((($c)[10]) | (($c)[11] << 8)));
    }' unless defined(&ISP2100_NVRAM_MAXFRAMELENGTH);
    eval 'sub ISP2100_NVRAM_MAXIOCBALLOCATION {
        local($c) = @_;
	    eval q(((($c)[12]) | (($c)[13] << 8)));
    }' unless defined(&ISP2100_NVRAM_MAXIOCBALLOCATION);
    eval 'sub ISP2100_NVRAM_EXECUTION_THROTTLE {
        local($c) = @_;
	    eval q(((($c)[14]) | (($c)[15] << 8)));
    }' unless defined(&ISP2100_NVRAM_EXECUTION_THROTTLE);
    eval 'sub ISP2100_NVRAM_RETRY_COUNT {
        local($c) = @_;
	    eval q(($c)[16]);
    }' unless defined(&ISP2100_NVRAM_RETRY_COUNT);
    eval 'sub ISP2100_NVRAM_RETRY_DELAY {
        local($c) = @_;
	    eval q(($c)[17]);
    }' unless defined(&ISP2100_NVRAM_RETRY_DELAY);
    eval 'sub ISP2100_NVRAM_NODE_NAME {
        local($c) = @_;
	    eval q(( (([18]) << 56) | (([19]) << 48) | (([20]) << 40) | (([21]) << 32) | (([22]) << 24) | (([23]) << 16) | (([24]) << 8) | ((($c)[25]) << 0)));
    }' unless defined(&ISP2100_NVRAM_NODE_NAME);
    eval 'sub ISP2100_NVRAM_HARDLOOPID {
        local($c) = @_;
	    eval q(($c)[26]);
    }' unless defined(&ISP2100_NVRAM_HARDLOOPID);
    eval 'sub ISP2100_NVRAM_HBA_OPTIONS {
        local($c) = @_;
	    eval q(($c)[70]);
    }' unless defined(&ISP2100_NVRAM_HBA_OPTIONS);
    eval 'sub ISP2100_NVRAM_HBA_DISABLE {
        local($c) = @_;
	    eval q( &ISPBSMX($c, 70, 0, 0x01));
    }' unless defined(&ISP2100_NVRAM_HBA_DISABLE);
    eval 'sub ISP2100_NVRAM_BIOS_DISABLE {
        local($c) = @_;
	    eval q( &ISPBSMX($c, 70, 1, 0x01));
    }' unless defined(&ISP2100_NVRAM_BIOS_DISABLE);
    eval 'sub ISP2100_NVRAM_LUN_DISABLE {
        local($c) = @_;
	    eval q( &ISPBSMX($c, 70, 2, 0x01));
    }' unless defined(&ISP2100_NVRAM_LUN_DISABLE);
    eval 'sub ISP2100_NVRAM_ENABLE_SELECT_BOOT {
        local($c) = @_;
	    eval q( &ISPBSMX($c, 70, 3, 0x01));
    }' unless defined(&ISP2100_NVRAM_ENABLE_SELECT_BOOT);
    eval 'sub ISP2100_NVRAM_DISABLE_CODELOAD {
        local($c) = @_;
	    eval q( &ISPBSMX($c, 70, 4, 0x01));
    }' unless defined(&ISP2100_NVRAM_DISABLE_CODELOAD);
    eval 'sub ISP2100_NVRAM_SET_CACHELINESZ {
        local($c) = @_;
	    eval q( &ISPBSMX($c, 70, 5, 0x01));
    }' unless defined(&ISP2100_NVRAM_SET_CACHELINESZ);
    eval 'sub ISP2100_NVRAM_BOOT_NODE_NAME {
        local($c) = @_;
	    eval q(( (([72]) << 56) | (([73]) << 48) | (([74]) << 40) | (([75]) << 32) | (([76]) << 24) | (([77]) << 16) | (([78]) << 8) | ((($c)[79]) << 0)));
    }' unless defined(&ISP2100_NVRAM_BOOT_NODE_NAME);
    eval 'sub ISP2100_NVRAM_BOOT_LUN {
        local($c) = @_;
	    eval q(($c)[80]);
    }' unless defined(&ISP2100_NVRAM_BOOT_LUN);
}
1;
