require '_h2ph_pre.ph';

unless(defined(&_ISP_OPENBSD_H)) {
    eval 'sub _ISP_OPENBSD_H () {1;}' unless defined(&_ISP_OPENBSD_H);
    require 'sys/types.ph';
    require 'sys/param.ph';
    require 'sys/systm.ph';
    require 'sys/kernel.ph';
    require 'sys/errno.ph';
    require 'sys/ioctl.ph';
    require 'sys/device.ph';
    require 'sys/malloc.ph';
    require 'sys/buf.ph';
    require 'sys/proc.ph';
    require 'sys/user.ph';
    require 'sys/queue.ph';
    require 'scsi/scsi_all.ph';
    require 'scsi/scsi_all.ph';
    require 'scsi/scsiconf.ph';
    require 'scsi/scsi_message.ph';
    require 'scsi/scsi_debug.ph';
    require 'vm/vm.ph';
    require 'vm/vm_param.ph';
    require 'vm/pmap.ph';
    eval 'sub ISP_PLATFORM_VERSION_MAJOR () {0;}' unless defined(&ISP_PLATFORM_VERSION_MAJOR);
    eval 'sub ISP_PLATFORM_VERSION_MINOR () {9;}' unless defined(&ISP_PLATFORM_VERSION_MINOR);
    eval 'sub ISP_SCSI_XFER_T () {\'struct scsi_xfer\';}' unless defined(&ISP_SCSI_XFER_T);
    eval 'sub seed () { ($un->{_seed});}' unless defined(&seed);
    eval 'sub discovered () { ($un->{_discovered});}' unless defined(&discovered);
    eval 'sub MAXISPREQUEST () {256;}' unless defined(&MAXISPREQUEST);
    if(defined(&ISP2100_FABRIC)) {
	eval 'sub ISP2100_SCRLEN () {0x400;}' unless defined(&ISP2100_SCRLEN);
    } else {
	eval 'sub ISP2100_SCRLEN () {0x100;}' unless defined(&ISP2100_SCRLEN);
    }
    require 'dev/ic/ispreg.ph';
    require 'dev/ic/ispvar.ph';
    require 'dev/ic/ispmbox.ph';
    eval 'sub IDPRINTF {
        local($lev, $x) = @_;
	    eval q( &if ( ($isp->{isp_dblev}) >= $lev)  &printf $x);
    }' unless defined(&IDPRINTF);
    eval 'sub PRINTF () { &printf;}' unless defined(&PRINTF);
    eval 'sub MEMZERO () { &bzero;}' unless defined(&MEMZERO);
    eval 'sub MEMCPY {
        local($dst, $src, $count) = @_;
	    eval q( &bcopy(($src), ($dst), ($count)));
    }' unless defined(&MEMCPY);
    if(defined(&__alpha__)) {
	eval 'sub MemoryBarrier () { &alpha_mb;}' unless defined(&MemoryBarrier);
    } else {
	eval 'sub MemoryBarrier () {
	    eval q();
	}' unless defined(&MemoryBarrier);
    }
    eval 'sub DMA_MSW {
        local($x) = @_;
	    eval q(((($x) >> 16) & 0xffff));
    }' unless defined(&DMA_MSW);
    eval 'sub DMA_LSW {
        local($x) = @_;
	    eval q(((($x) & 0xffff)));
    }' unless defined(&DMA_LSW);
    if(defined( &SCSIDEBUG)) {
	eval 'sub DFLT_DBLEVEL () {3;}' unless defined(&DFLT_DBLEVEL);
	eval 'sub CFGPRINTF () { &printf;}' unless defined(&CFGPRINTF);
    }
 elsif(defined( &DEBUG)) {
	eval 'sub DFLT_DBLEVEL () {2;}' unless defined(&DFLT_DBLEVEL);
	eval 'sub CFGPRINTF () { &printf;}' unless defined(&CFGPRINTF);
    }
 elsif(defined( &DIAGNOSTIC)) {
	eval 'sub DFLT_DBLEVEL () {1;}' unless defined(&DFLT_DBLEVEL);
	eval 'sub CFGPRINTF () { &if  &printf;}' unless defined(&CFGPRINTF);
    } else {
	eval 'sub DFLT_DBLEVEL () {0;}' unless defined(&DFLT_DBLEVEL);
	eval 'sub CFGPRINTF () { &if  &printf;}' unless defined(&CFGPRINTF);
    }
    eval 'sub ISP_LOCKVAL_DECL () {\'int\'  &isp_spl_save;}' unless defined(&ISP_LOCKVAL_DECL);
    eval 'sub ISP_ILOCKVAL_DECL () { &ISP_LOCKVAL_DECL;}' unless defined(&ISP_ILOCKVAL_DECL);
    eval 'sub ISP_LOCK {
        local($x) = @_;
	    eval q( &isp_spl_save =  &splbio());
    }' unless defined(&ISP_LOCK);
    eval 'sub ISP_UNLOCK {
        local($x) = @_;
	    eval q(  &splx( &isp_spl_save));
    }' unless defined(&ISP_UNLOCK);
    eval 'sub ISP_ILOCK () { &ISP_LOCK;}' unless defined(&ISP_ILOCK);
    eval 'sub ISP_IUNLOCK () { &ISP_UNLOCK;}' unless defined(&ISP_IUNLOCK);
    eval 'sub XS_NULL {
        local($xs) = @_;
	    eval q($xs ==  &NULL ||  ($xs->{sc_link}) ==  &NULL);
    }' unless defined(&XS_NULL);
    eval 'sub XS_ISP {
        local($xs) = @_;
	    eval q(($xs)-> ($sc_link->{adapter_softc}));
    }' unless defined(&XS_ISP);
    eval 'sub XS_LUN {
        local($xs) = @_;
	    eval q(( ($xs)-> ($sc_link->{lun})));
    }' unless defined(&XS_LUN);
    eval 'sub XS_TGT {
        local($xs) = @_;
	    eval q(( ($xs)-> ($sc_link->{target})));
    }' unless defined(&XS_TGT);
    eval 'sub XS_RESID {
        local($xs) = @_;
	    eval q(($xs)-> &resid);
    }' unless defined(&XS_RESID);
    eval 'sub XS_CHANNEL {
        local($xs) = @_;
	    eval q(((($xs)-> ($sc_link->{flags}) &  &SDEV_2NDBUS)? 1: 0));
    }' unless defined(&XS_CHANNEL);
    eval 'sub XS_XFRLEN {
        local($xs) = @_;
	    eval q(($xs)-> &datalen);
    }' unless defined(&XS_XFRLEN);
    eval 'sub XS_CDBLEN {
        local($xs) = @_;
	    eval q(($xs)-> &cmdlen);
    }' unless defined(&XS_CDBLEN);
    eval 'sub XS_CDBP {
        local($xs) = @_;
	    eval q(( ($xs)-> &cmd));
    }' unless defined(&XS_CDBP);
    eval 'sub XS_STS {
        local($xs) = @_;
	    eval q(($xs)-> &status);
    }' unless defined(&XS_STS);
    eval 'sub XS_TIME {
        local($xs) = @_;
	    eval q(($xs)-> &timeout);
    }' unless defined(&XS_TIME);
    eval 'sub XS_SNSP {
        local($xs) = @_;
	    eval q((($xs)-> &sense));
    }' unless defined(&XS_SNSP);
    eval 'sub XS_SNSLEN {
        local($xs) = @_;
	    eval q(($sizeof{$xs}-> &sense));
    }' unless defined(&XS_SNSLEN);
    eval 'sub XS_SNSKEY {
        local($xs) = @_;
	    eval q((($xs)-> ($sense->{flags})));
    }' unless defined(&XS_SNSKEY);
    eval 'sub HBA_NOERROR () { &XS_NOERROR;}' unless defined(&HBA_NOERROR);
    eval 'sub HBA_BOTCH () { &XS_DRIVER_STUFFUP;}' unless defined(&HBA_BOTCH);
    eval 'sub HBA_CMDTIMEOUT () { &XS_TIMEOUT;}' unless defined(&HBA_CMDTIMEOUT);
    eval 'sub HBA_SELTIMEOUT () { &XS_SELTIMEOUT;}' unless defined(&HBA_SELTIMEOUT);
    eval 'sub HBA_TGTBSY () { &XS_BUSY;}' unless defined(&HBA_TGTBSY);
    if(defined(&XS_RESET)) {
	eval 'sub HBA_BUSRESET () { &XS_RESET;}' unless defined(&HBA_BUSRESET);
    } else {
	eval 'sub HBA_BUSRESET () { &XS_DRIVER_STUFFUP;}' unless defined(&HBA_BUSRESET);
    }
    eval 'sub HBA_ABORTED () { &XS_DRIVER_STUFFUP;}' unless defined(&HBA_ABORTED);
    eval 'sub HBA_DATAOVR () { &XS_DRIVER_STUFFUP;}' unless defined(&HBA_DATAOVR);
    eval 'sub HBA_ARQFAIL () { &XS_DRIVER_STUFFUP;}' unless defined(&HBA_ARQFAIL);
    eval 'sub XS_SNS_IS_VALID {
        local($xs) = @_;
	    eval q(($xs)-> &error =  &XS_SENSE);
    }' unless defined(&XS_SNS_IS_VALID);
    eval 'sub XS_IS_SNS_VALID {
        local($xs) = @_;
	    eval q((($xs)-> &error ==  &XS_SENSE));
    }' unless defined(&XS_IS_SNS_VALID);
    eval 'sub XS_INITERR {
        local($xs) = @_;
	    eval q(($xs)-> &error = 0);
    }' unless defined(&XS_INITERR);
    eval 'sub XS_SETERR {
        local($xs, $v) = @_;
	    eval q(($xs)-> &error = $v);
    }' unless defined(&XS_SETERR);
    eval 'sub XS_ERR {
        local($xs) = @_;
	    eval q(($xs)-> &error);
    }' unless defined(&XS_ERR);
    eval 'sub XS_NOERR {
        local($xs) = @_;
	    eval q(($xs)-> &error ==  &XS_NOERROR);
    }' unless defined(&XS_NOERR);
    eval 'sub XS_CMD_DONE {
        local($xs) = @_;
	    eval q(($xs)-> &flags |=  &ITSDONE,  &scsi_done($xs));
    }' unless defined(&XS_CMD_DONE);
    eval 'sub XS_IS_CMD_DONE {
        local($xs) = @_;
	    eval q(((($xs)-> &flags &  &ITSDONE) != 0));
    }' unless defined(&XS_IS_CMD_DONE);
    eval 'sub XS_CANTAG {
        local($xs) = @_;
	    eval q(((($xs)-> &flags &  &SCSI_POLL) != 0));
    }' unless defined(&XS_CANTAG);
    eval 'sub XS_KINDOF_TAG {
        local($xs) = @_;
	    eval q( &REQFLAG_OTAG);
    }' unless defined(&XS_KINDOF_TAG);
    eval 'sub CMD_COMPLETE () {100;}' unless defined(&CMD_COMPLETE);
    eval 'sub CMD_EAGAIN () {101;}' unless defined(&CMD_EAGAIN);
    eval 'sub CMD_QUEUED () {102;}' unless defined(&CMD_QUEUED);
    eval 'sub CMD_RQLATER () {103;}' unless defined(&CMD_RQLATER);
    eval 'sub isp_name () { ($isp_osinfo->{_dev}->{dv_xname});}' unless defined(&isp_name);
    eval 'sub isp_unit () { ($isp_osinfo->{_dev}->{dv_unit});}' unless defined(&isp_unit);
    eval 'sub SCSI_QFULL () {0x28;}' unless defined(&SCSI_QFULL);
    eval 'sub SYS_DELAY {
        local($x) = @_;
	    eval q( &delay($x));
    }' unless defined(&SYS_DELAY);
    eval 'sub WATCH_INTERVAL () {30;}' unless defined(&WATCH_INTERVAL);
    eval 'sub FC_FW_READY_DELAY () {(5* 1000000);}' unless defined(&FC_FW_READY_DELAY);
    eval 'sub DEFAULT_LOOPID {
        local($x) = @_;
	    eval q(107);
    }' unless defined(&DEFAULT_LOOPID);
    eval 'sub DEFAULT_WWN {
        local($x) = @_;
	    eval q((0x1000b00d00000000 + ($x)-> ($isp_osinfo->{seed})));
    }' unless defined(&DEFAULT_WWN);
    eval 'sub ISP_UNSWIZZLE_AND_COPY_PDBP {
        local($isp, $dest, $src) = @_;
	    eval q( &bcopy($src, $dest, $sizeof{ &isp_pdb_t}));
    }' unless defined(&ISP_UNSWIZZLE_AND_COPY_PDBP);
    eval 'sub ISP_SWIZZLE_ICB {
        local($a, $b) = @_;
	    eval q();
    }' unless defined(&ISP_SWIZZLE_ICB);
    if(defined(&__sparc__)) {
	eval 'sub ISP_SWIZZLE_CONTINUATION {
	    local($a, $b) = @_;
    	    eval q( &ISP_SBUSIFY_ISPHDR($a, ($b)-> &req_header));
	}' unless defined(&ISP_SWIZZLE_CONTINUATION);
	eval 'sub ISP_SWIZZLE_REQUEST {
	    local($a, $b) = @_;
    	    eval q( &ISP_SBUSIFY_ISPHDR($a, ($b)-> &req_header);  &ISP_SBUSIFY_ISPREQ($a, $b));
	}' unless defined(&ISP_SWIZZLE_REQUEST);
	eval 'sub ISP_UNSWIZZLE_RESPONSE {
	    local($a, $b) = @_;
    	    eval q( &ISP_SBUSIFY_ISPHDR($a, ($b)-> &req_header));
	}' unless defined(&ISP_UNSWIZZLE_RESPONSE);
    } else {
	eval 'sub ISP_SWIZZLE_CONTINUATION {
	    local($a, $b) = @_;
    	    eval q();
	}' unless defined(&ISP_SWIZZLE_CONTINUATION);
	eval 'sub ISP_SWIZZLE_REQUEST {
	    local($a, $b) = @_;
    	    eval q();
	}' unless defined(&ISP_SWIZZLE_REQUEST);
	eval 'sub ISP_UNSWIZZLE_RESPONSE {
	    local($a, $b) = @_;
    	    eval q();
	}' unless defined(&ISP_UNSWIZZLE_RESPONSE);
    }
    eval 'sub ISP_SWIZZLE_SNS_REQ {
        local($a, $b) = @_;
	    eval q();
    }' unless defined(&ISP_SWIZZLE_SNS_REQ);
    eval 'sub ISP_UNSWIZZLE_SNS_RSP {
        local($a, $b, $c) = @_;
	    eval q();
    }' unless defined(&ISP_UNSWIZZLE_SNS_RSP);
    eval 'sub INLINE () { &inline;}' unless defined(&INLINE);
    require 'dev/ic/isp_inline.ph';
}
1;
