/*	$OpenBSD: free_ttype.c,v 1.2 1999/05/08 20:29:01 millert Exp $	*/

/****************************************************************************
 * Copyright (c) 1999 Free Software Foundation, Inc.                        *
 *                                                                          *
 * Permission is hereby granted, free of charge, to any person obtaining a  *
 * copy of this software and associated documentation files (the            *
 * "Software"), to deal in the Software without restriction, including      *
 * without limitation the rights to use, copy, modify, merge, publish,      *
 * distribute, distribute with modifications, sublicense, and/or sell       *
 * copies of the Software, and to permit persons to whom the Software is    *
 * furnished to do so, subject to the following conditions:                 *
 *                                                                          *
 * The above copyright notice and this permission notice shall be included  *
 * in all copies or substantial portions of the Software.                   *
 *                                                                          *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS  *
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF               *
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.   *
 * IN NO EVENT SHALL THE ABOVE COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,   *
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR    *
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR    *
 * THE USE OR OTHER DEALINGS IN THE SOFTWARE.                               *
 *                                                                          *
 * Except as contained in this notice, the name(s) of the above copyright   *
 * holders shall not be used in advertising or otherwise to promote the     *
 * sale, use or other dealings in this Software without prior written       *
 * authorization.                                                           *
 ****************************************************************************/

/****************************************************************************
 *  Author: Thomas E. Dickey <dickey@clark.net> 1999                        *
 ****************************************************************************/


/*
 * free_ttype.c -- allocation functions for TERMTYPE
 *
 *	_nc_free_termtype()
 *	use_extended_names()
 *
 */

#include <curses.priv.h>

#include <tic.h>
#include <term_entry.h>

MODULE_ID("$From: free_ttype.c,v 1.2 1999/03/01 00:30:35 tom Exp $")

void _nc_free_termtype(TERMTYPE *ptr)
{
	FreeIfNeeded(ptr->str_table);
	FreeIfNeeded(ptr->term_names);
#if NCURSES_XNAMES
	FreeIfNeeded(ptr->ext_str_table);
	FreeIfNeeded(ptr->Booleans);
	FreeIfNeeded(ptr->Numbers);
	FreeIfNeeded(ptr->Strings);
	FreeIfNeeded(ptr->ext_Names);
#endif
	memset(ptr, 0, sizeof(TERMTYPE));
}

#if NCURSES_XNAMES
bool _nc_user_definable = TRUE;

int use_extended_names(bool flag)
{
	int oldflag = _nc_user_definable;
	_nc_user_definable = flag;
	return oldflag;
}
#endif
