/*      $OpenBSD: atapiconf.h,v 1.2 1999/07/22 03:10:47 csapuntz Exp $     */
/*	$NetBSD: atapiconf.h,v 1.7 1998/10/12 16:09:24 bouyer Exp $	*/

/*
 * Copyright (c) 1996 Manuel Bouyer.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Manuel Bouyer.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <scsi/scsiconf.h>

/* drive states stored in ata_drive_datas */
#define IDENTIFY        0
#define IDENTIFY_WAIT   1
#define PIOMODE		2
#define PIOMODE_WAIT	3
#define DMAMODE		4
#define DMAMODE_WAIT	5
#define READY		6

struct atapi_mode_header;
struct ataparams;

void	atapi_print_addr __P((struct scsi_link *));
int	atapi_interpret_sense __P((struct scsi_xfer *));
int	atapi_scsi_cmd __P((struct scsi_link *, struct scsi_generic *,
	    int, u_char *, int, int, int, struct buf *, int));
int	atapi_mode_select __P((struct scsi_link *,
	    struct atapi_mode_header *, int, int, int, int));
int	atapi_mode_sense __P((struct scsi_link *, int,
	    struct atapi_mode_header *, int, int, int, int));
