require '_h2ph_pre.ph';

unless(defined(&_MACHINE)) {
    sub _MACHINE () {	 &sparc;}
}
unless(defined(&MACHINE)) {
    sub MACHINE () {	"sparc";}
}
unless(defined(&_MACHINE_ARCH)) {
    sub _MACHINE_ARCH () {	 &sparc;}
}
unless(defined(&MACHINE_ARCH)) {
    sub MACHINE_ARCH () {	"sparc";}
}
unless(defined(&MID_MACHINE)) {
    sub MID_MACHINE () {	 &MID_SPARC;}
}
if(defined(&_KERNEL)) {
    unless(defined(&_LOCORE)) {
	require 'machine/cpu.ph';
    }
}
unless(defined(&ALIGNBYTES)) {
    sub ALIGNBYTES () {	7;}
}
unless(defined(&ALIGN)) {
    sub ALIGN {
	local($p) = @_;
	eval q(((($p) +  &ALIGNBYTES) & ~ &ALIGNBYTES));
    }
}
unless(defined(&ALIGNED_POINTER)) {
    sub ALIGNED_POINTER {
	local($p,$t) = @_;
	eval q((((($p)) & ($sizeof{$t}-1)) == 0));
    }
}
unless(defined(&SUN4_PGSHIFT)) {
    sub SUN4_PGSHIFT () {	13;}
}
unless(defined(&SUN4CM_PGSHIFT)) {
    sub SUN4CM_PGSHIFT () {	12;}
}
if(defined( &_KERNEL)  && !defined( &_LOCORE)) {
}
unless(defined(&KERNBASE)) {
    sub KERNBASE () {	0xf8000000;}
}
unless(defined(&KERNTEXTOFF)) {
    sub KERNTEXTOFF () {	0xf8004000;}
}
unless(defined(&DEV_BSIZE)) {
    sub DEV_BSIZE () {	512;}
}
unless(defined(&DEV_BSHIFT)) {
    sub DEV_BSHIFT () {	9;}
}
unless(defined(&BLKDEV_IOSIZE)) {
    sub BLKDEV_IOSIZE () {	2048;}
}
unless(defined(&MAXPHYS)) {
    sub MAXPHYS () {	(64* 1024);}
}
unless(defined(&CLSIZE)) {
    sub CLSIZE () {	1;}
}
unless(defined(&CLSIZELOG2)) {
    sub CLSIZELOG2 () {	0;}
}
unless(defined(&SSIZE)) {
    sub SSIZE () {	1;}
}
unless(defined(&USPACE)) {
    sub USPACE () {	8192;}
}
unless(defined(&MSIZE)) {
    sub MSIZE () {	128;}
}
unless(defined(&MCLBYTES)) {
    sub MCLBYTES () {	2048;}
}
unless(defined(&MCLSHIFT)) {
    sub MCLSHIFT () {	11;}
}
unless(defined(&MCLOFSET)) {
    sub MCLOFSET () {	( &MCLBYTES - 1);}
}
unless(defined(&NMBCLUSTERS)) {
    if(defined(&GATEWAY)) {
	eval 'sub NMBCLUSTERS () {1024;}' unless defined(&NMBCLUSTERS);
    } else {
	eval 'sub NMBCLUSTERS () {512;}' unless defined(&NMBCLUSTERS);
    }
}
unless(defined(&NKMEMCLUSTERS)) {
    eval 'sub NKMEMCLUSTERS () {(6* 1024* 1024/  &CLBYTES);}' unless defined(&NKMEMCLUSTERS);
}
unless(defined(&ctod)) {
    sub ctod {
	local($x) = @_;
	eval q((($x) << ( &PGSHIFT -  &DEV_BSHIFT)));
    }
}
unless(defined(&dtoc)) {
    sub dtoc {
	local($x) = @_;
	eval q((($x) >> ( &PGSHIFT -  &DEV_BSHIFT)));
    }
}
unless(defined(&ctob)) {
    sub ctob {
	local($x) = @_;
	eval q((($x) <<  &PGSHIFT));
    }
}
unless(defined(&btoc)) {
    sub btoc {
	local($x) = @_;
	eval q(((($x) +  &PGOFSET) >>  &PGSHIFT));
    }
}
unless(defined(&btodb)) {
    sub btodb {
	local($x) = @_;
	eval q((($x) >>  &DEV_BSHIFT));
    }
}
unless(defined(&dbtob)) {
    sub dbtob {
	local($x) = @_;
	eval q((($x) <<  &DEV_BSHIFT));
    }
}
unless(defined(&bdbtofsb)) {
    sub bdbtofsb {
	local($bn) = @_;
	eval q((($bn) / ( &BLKDEV_IOSIZE /  &DEV_BSIZE)));
    }
}
unless(defined(&sparc_btop)) {
    sub sparc_btop {
	local($x) = @_;
	eval q((($x) >>  &PGSHIFT));
    }
}
unless(defined(&sparc_ptob)) {
    sub sparc_ptob {
	local($x) = @_;
	eval q((($x) <<  &PGSHIFT));
    }
}
if(defined(&_KERNEL)) {
    unless(defined(&_LOCORE)) {
	eval 'sub rctov {
	    local($n) = @_;
    	    eval q(( &ctob((($n)-1))+ &dvma_base));
	}' unless defined(&rctov);
	eval 'sub vtorc {
	    local($v) = @_;
    	    eval q((( &btoc(($v)- &dvma_base))+1));
	}' unless defined(&vtorc);
	eval 'sub DELAY {
	    local($n) = @_;
    	    eval q( &delay($n));
	}' unless defined(&DELAY);
	if(0) {
	}
    }
}
unless(defined(&CPU_SUN4)) {
    sub CPU_SUN4 () {	0;}
}
unless(defined(&CPU_SUN4C)) {
    sub CPU_SUN4C () {	1;}
}
unless(defined(&CPU_SUN4M)) {
    sub CPU_SUN4M () {	2;}
}
if(defined( &SUN4M)  && defined( &SUN4C)  && defined( &SUN4)) {
    eval 'sub CPU_ISSUN4M () {( &cputyp ==  &CPU_SUN4M);}' unless defined(&CPU_ISSUN4M);
    eval 'sub CPU_ISSUN4C () {( &cputyp ==  &CPU_SUN4C);}' unless defined(&CPU_ISSUN4C);
    eval 'sub CPU_ISSUN4 () {( &cputyp ==  &CPU_SUN4);}' unless defined(&CPU_ISSUN4);
    eval 'sub CPU_ISSUN4OR4C () {( &cputyp ==  &CPU_SUN4 ||  &cputyp ==  &CPU_SUN4C);}' unless defined(&CPU_ISSUN4OR4C);
    eval 'sub CPU_ISSUN4COR4M () {( &cputyp ==  &CPU_SUN4C ||  &cputyp ==  &CPU_SUN4M);}' unless defined(&CPU_ISSUN4COR4M);
    eval 'sub NBPG () { &nbpg;}' unless defined(&NBPG);
    eval 'sub PGOFSET () { &pgofset;}' unless defined(&PGOFSET);
    eval 'sub PGSHIFT () { &pgshift;}' unless defined(&PGSHIFT);
}
 elsif(defined( &SUN4M)  && defined( &SUN4C)  && !defined( &SUN4)) {
    eval 'sub CPU_ISSUN4M () {( &cputyp ==  &CPU_SUN4M);}' unless defined(&CPU_ISSUN4M);
    eval 'sub CPU_ISSUN4C () {( &cputyp ==  &CPU_SUN4C);}' unless defined(&CPU_ISSUN4C);
    eval 'sub CPU_ISSUN4 () {(0);}' unless defined(&CPU_ISSUN4);
    eval 'sub CPU_ISSUN4OR4C () {( &cputyp ==  &CPU_SUN4C);}' unless defined(&CPU_ISSUN4OR4C);
    eval 'sub CPU_ISSUN4COR4M () {( &cputyp ==  &CPU_SUN4C ||  &cputyp ==  &CPU_SUN4M);}' unless defined(&CPU_ISSUN4COR4M);
    eval 'sub NBPG () {4096;}' unless defined(&NBPG);
    eval 'sub PGOFSET () {( &NBPG-1);}' unless defined(&PGOFSET);
    eval 'sub PGSHIFT () { &SUN4CM_PGSHIFT;}' unless defined(&PGSHIFT);
}
 elsif(defined( &SUN4M)  && !defined( &SUN4C)  && defined( &SUN4)) {
    eval 'sub CPU_ISSUN4M () {( &cputyp ==  &CPU_SUN4M);}' unless defined(&CPU_ISSUN4M);
    eval 'sub CPU_ISSUN4C () {(0);}' unless defined(&CPU_ISSUN4C);
    eval 'sub CPU_ISSUN4 () {( &cputyp ==  &CPU_SUN4);}' unless defined(&CPU_ISSUN4);
    eval 'sub CPU_ISSUN4OR4C () {( &cputyp ==  &CPU_SUN4);}' unless defined(&CPU_ISSUN4OR4C);
    eval 'sub CPU_ISSUN4COR4M () {( &cputyp ==  &CPU_SUN4M);}' unless defined(&CPU_ISSUN4COR4M);
    eval 'sub NBPG () { &nbpg;}' unless defined(&NBPG);
    eval 'sub PGOFSET () { &pgofset;}' unless defined(&PGOFSET);
    eval 'sub PGSHIFT () { &pgshift;}' unless defined(&PGSHIFT);
}
 elsif(defined( &SUN4M)  && !defined( &SUN4C)  && !defined( &SUN4)) {
    eval 'sub CPU_ISSUN4M () {(1);}' unless defined(&CPU_ISSUN4M);
    eval 'sub CPU_ISSUN4C () {(0);}' unless defined(&CPU_ISSUN4C);
    eval 'sub CPU_ISSUN4 () {(0);}' unless defined(&CPU_ISSUN4);
    eval 'sub CPU_ISSUN4OR4C () {(0);}' unless defined(&CPU_ISSUN4OR4C);
    eval 'sub CPU_ISSUN4COR4M () {(1);}' unless defined(&CPU_ISSUN4COR4M);
    eval 'sub NBPG () {4096;}' unless defined(&NBPG);
    eval 'sub PGOFSET () {( &NBPG-1);}' unless defined(&PGOFSET);
    eval 'sub PGSHIFT () { &SUN4CM_PGSHIFT;}' unless defined(&PGSHIFT);
}
 elsif(!defined( &SUN4M)  && defined( &SUN4C)  && defined( &SUN4)) {
    eval 'sub CPU_ISSUN4M () {(0);}' unless defined(&CPU_ISSUN4M);
    eval 'sub CPU_ISSUN4C () {( &cputyp ==  &CPU_SUN4C);}' unless defined(&CPU_ISSUN4C);
    eval 'sub CPU_ISSUN4 () {( &cputyp ==  &CPU_SUN4);}' unless defined(&CPU_ISSUN4);
    eval 'sub CPU_ISSUN4OR4C () {(1);}' unless defined(&CPU_ISSUN4OR4C);
    eval 'sub CPU_ISSUN4COR4M () {( &cputyp ==  &CPU_SUN4C);}' unless defined(&CPU_ISSUN4COR4M);
    eval 'sub NBPG () { &nbpg;}' unless defined(&NBPG);
    eval 'sub PGOFSET () { &pgofset;}' unless defined(&PGOFSET);
    eval 'sub PGSHIFT () { &pgshift;}' unless defined(&PGSHIFT);
}
 elsif(!defined( &SUN4M)  && defined( &SUN4C)  && !defined( &SUN4)) {
    eval 'sub CPU_ISSUN4M () {(0);}' unless defined(&CPU_ISSUN4M);
    eval 'sub CPU_ISSUN4C () {(1);}' unless defined(&CPU_ISSUN4C);
    eval 'sub CPU_ISSUN4 () {(0);}' unless defined(&CPU_ISSUN4);
    eval 'sub CPU_ISSUN4OR4C () {(1);}' unless defined(&CPU_ISSUN4OR4C);
    eval 'sub CPU_ISSUN4COR4M () {(1);}' unless defined(&CPU_ISSUN4COR4M);
    eval 'sub NBPG () {4096;}' unless defined(&NBPG);
    eval 'sub PGOFSET () {( &NBPG-1);}' unless defined(&PGOFSET);
    eval 'sub PGSHIFT () { &SUN4CM_PGSHIFT;}' unless defined(&PGSHIFT);
}
 elsif(!defined( &SUN4M)  && !defined( &SUN4C)  && defined( &SUN4)) {
    eval 'sub CPU_ISSUN4M () {(0);}' unless defined(&CPU_ISSUN4M);
    eval 'sub CPU_ISSUN4C () {(0);}' unless defined(&CPU_ISSUN4C);
    eval 'sub CPU_ISSUN4 () {(1);}' unless defined(&CPU_ISSUN4);
    eval 'sub CPU_ISSUN4OR4C () {(1);}' unless defined(&CPU_ISSUN4OR4C);
    eval 'sub CPU_ISSUN4COR4M () {(0);}' unless defined(&CPU_ISSUN4COR4M);
    eval 'sub NBPG () {8192;}' unless defined(&NBPG);
    eval 'sub PGOFSET () {( &NBPG-1);}' unless defined(&PGOFSET);
    eval 'sub PGSHIFT () { &SUN4_PGSHIFT;}' unless defined(&PGSHIFT);
}
 elsif(!defined( &SUN4M)  && !defined( &SUN4C)  && !defined( &SUN4)) {
    eval 'sub CPU_ISSUN4M () {( &cputyp ==  &CPU_SUN4M);}' unless defined(&CPU_ISSUN4M);
    eval 'sub CPU_ISSUN4C () {( &cputyp ==  &CPU_SUN4C);}' unless defined(&CPU_ISSUN4C);
    eval 'sub CPU_ISSUN4 () {( &cputyp ==  &CPU_SUN4);}' unless defined(&CPU_ISSUN4);
    eval 'sub CPU_ISSUN4OR4C () {( &cputyp ==  &CPU_SUN4 ||  &cputyp ==  &CPU_SUN4C);}' unless defined(&CPU_ISSUN4OR4C);
    eval 'sub CPU_ISSUN4COR4M () {( &cputyp ==  &CPU_SUN4C ||  &cputyp ==  &CPU_SUN4M);}' unless defined(&CPU_ISSUN4COR4M);
    eval 'sub NBPG () { &nbpg;}' unless defined(&NBPG);
    eval 'sub PGOFSET () { &pgofset;}' unless defined(&PGOFSET);
    eval 'sub PGSHIFT () { &pgshift;}' unless defined(&PGSHIFT);
}
1;
