require '_h2ph_pre.ph';

require 'machine/pcb.ph';
unless(defined(&_KERNEL)) {
    require 'errno.ph';
    require 'sys/time.ph';
    require 'sys/resource.ph';
    require 'sys/ucred.ph';
    require 'sys/uio.ph';
}
require 'sys/resourcevar.ph';
require 'sys/signalvar.ph';
require 'vm/vm.ph';
require 'sys/sysctl.ph';
unless(defined(&U_ar0)) {
    sub U_ar0 () {	 ($u_kproc->{kp_proc}->{p_md}->{md_regs});}
}
unless(defined(&U_tsize)) {
    sub U_tsize () {	 ($u_kproc->{kp_eproc}->{e_vm}->{vm_tsize});}
}
unless(defined(&U_dsize)) {
    sub U_dsize () {	 ($u_kproc->{kp_eproc}->{e_vm}->{vm_dsize});}
}
unless(defined(&U_ssize)) {
    sub U_ssize () {	 ($u_kproc->{kp_eproc}->{e_vm}->{vm_ssize});}
}
unless(defined(&U_sig)) {
    sub U_sig () {	 ($u_sigacts->{ps_sig});}
}
unless(defined(&U_code)) {
    sub U_code () {	 ($u_sigacts->{ps_code});}
}
unless(defined(&_KERNEL)) {
    eval 'sub u_ar0 () { &U_ar0;}' unless defined(&u_ar0);
    eval 'sub u_tsize () { &U_tsize;}' unless defined(&u_tsize);
    eval 'sub u_dsize () { &U_dsize;}' unless defined(&u_dsize);
    eval 'sub u_ssize () { &U_ssize;}' unless defined(&u_ssize);
    eval 'sub u_sig () { &U_sig;}' unless defined(&u_sig);
    eval 'sub u_code () { &U_code;}' unless defined(&u_code);
}
1;
