require '_h2ph_pre.ph';

unless(defined(&ASSEMBLER)) {
    if(defined(&STANDALONE)) {
    }
}
unless(defined(&PROM_R_CLOSE)) {
    sub PROM_R_CLOSE () {	0x11;}
}
unless(defined(&PROM_R_GETC)) {
    sub PROM_R_GETC () {	0x01;}
}
unless(defined(&PROM_R_GETENV)) {
    sub PROM_R_GETENV () {	0x22;}
}
unless(defined(&PROM_R_OPEN)) {
    sub PROM_R_OPEN () {	0x10;}
}
unless(defined(&PROM_R_PUTS)) {
    sub PROM_R_PUTS () {	0x02;}
}
unless(defined(&PROM_R_READ)) {
    sub PROM_R_READ () {	0x13;}
}
unless(defined(&PROM_R_WRITE)) {
    sub PROM_R_WRITE () {	0x14;}
}
unless(defined(&PROM_E_BOOTED_DEV)) {
    sub PROM_E_BOOTED_DEV () {	0x4;}
}
unless(defined(&PROM_E_BOOTED_FILE)) {
    sub PROM_E_BOOTED_FILE () {	0x6;}
}
unless(defined(&PROM_E_BOOTED_OSFLAGS)) {
    sub PROM_E_BOOTED_OSFLAGS () {	0x8;}
}
unless(defined(&PROM_E_TTY_DEV)) {
    sub PROM_E_TTY_DEV () {	0xf;}
}
unless(defined(&prom_close)) {
    sub prom_close {
	local($chan) = @_;
	eval q( &prom_dispatch( &PROM_R_CLOSE, $chan, 0, 0, 0));
    }
}
unless(defined(&prom_read)) {
    sub prom_read {
	local($chan, $len, $buf, $blkno) = @_;
	eval q( &prom_dispatch( &PROM_R_READ, $chan, $len, $buf, $blkno));
    }
}
unless(defined(&prom_write)) {
    sub prom_write {
	local($chan, $len, $buf, $blkno) = @_;
	eval q( &prom_dispatch( &PROM_R_WRITE, $chan, $len, $buf, $blkno));
    }
}
unless(defined(&prom_putstr)) {
    sub prom_putstr {
	local($chan, $str, $len) = @_;
	eval q( &prom_dispatch( &PROM_R_PUTS, $chan, $str, $len, 0));
    }
}
unless(defined(&prom_getc)) {
    sub prom_getc {
	local($chan) = @_;
	eval q( &prom_dispatch( &PROM_R_GETC, $chan, 0, 0, 0));
    }
}
unless(defined(&prom_getenv_disp)) {
    sub prom_getenv_disp {
	local($id, $buf, $len) = @_;
	eval q( &prom_dispatch( &PROM_R_GETENV, $id, $buf, $len, 0));
    }
}
unless(defined(&ASSEMBLER)) {
    if(defined(&_KERNEL)) {
    }
}
1;
