require '_h2ph_pre.ph';

unless(defined(&_MACHINE)) {
    sub _MACHINE () {	 &alpha;}
}
unless(defined(&MACHINE)) {
    sub MACHINE () {	"alpha";}
}
unless(defined(&_MACHINE_ARCH)) {
    sub _MACHINE_ARCH () {	 &alpha;}
}
unless(defined(&MACHINE_ARCH)) {
    sub MACHINE_ARCH () {	"alpha";}
}
unless(defined(&MID_MACHINE)) {
    sub MID_MACHINE () {	 &MID_ALPHA;}
}
require 'machine/alpha_cpu.ph';
require 'machine/cpu.ph';
unless(defined(&ALIGNBYTES)) {
    sub ALIGNBYTES () {	7;}
}
unless(defined(&ALIGN)) {
    sub ALIGN {
	local($p) = @_;
	eval q(((($p) +  &ALIGNBYTES) &~  &ALIGNBYTES));
    }
}
unless(defined(&NBPG)) {
    sub NBPG () {	(1<<  &ALPHA_PGSHIFT);}
}
unless(defined(&PGOFSET)) {
    sub PGOFSET () {	( &NBPG-1);}
}
unless(defined(&PGSHIFT)) {
    sub PGSHIFT () {	 &ALPHA_PGSHIFT;}
}
unless(defined(&NPTEPG)) {
    sub NPTEPG () {	(1<< ( &PGSHIFT- &PTESHIFT));}
}
unless(defined(&SEGSHIFT)) {
    sub SEGSHIFT () {	( &PGSHIFT + ( &PGSHIFT- &PTESHIFT));}
}
unless(defined(&NBSEG)) {
    sub NBSEG () {	(1<<  &SEGSHIFT);}
}
unless(defined(&SEGOFSET)) {
    sub SEGOFSET () {	( &NBSEG-1);}
}
unless(defined(&KERNBASE)) {
    sub KERNBASE () {	0xfffffc0000230000;}
}
unless(defined(&BTOPKERNBASE)) {
    sub BTOPKERNBASE () {	( &KERNBASE >>  &PGSHIFT);}
}
unless(defined(&DEV_BSIZE)) {
    sub DEV_BSIZE () {	512;}
}
unless(defined(&DEV_BSHIFT)) {
    sub DEV_BSHIFT () {	9;}
}
unless(defined(&BLKDEV_IOSIZE)) {
    sub BLKDEV_IOSIZE () {	2048;}
}
unless(defined(&MAXPHYS)) {
    sub MAXPHYS () {	(64* 1024);}
}
unless(defined(&CLSIZE)) {
    sub CLSIZE () {	1;}
}
unless(defined(&CLSIZELOG2)) {
    sub CLSIZELOG2 () {	0;}
}
unless(defined(&SSIZE)) {
    sub SSIZE () {	1;}
}
unless(defined(&SINCR)) {
    sub SINCR () {	1;}
}
unless(defined(&UPAGES)) {
    sub UPAGES () {	2;}
}
unless(defined(&USPACE)) {
    sub USPACE () {	( &UPAGES *  &NBPG);}
}
unless(defined(&MSIZE)) {
    sub MSIZE () {	256;}
}
unless(defined(&MCLSHIFT)) {
    sub MCLSHIFT () {	11;}
}
unless(defined(&MCLBYTES)) {
    sub MCLBYTES () {	(1<<  &MCLSHIFT);}
}
unless(defined(&MCLOFSET)) {
    sub MCLOFSET () {	( &MCLBYTES - 1);}
}
unless(defined(&NMBCLUSTERS)) {
    if(defined(&GATEWAY)) {
	eval 'sub NMBCLUSTERS () {1024;}' unless defined(&NMBCLUSTERS);
    } else {
	eval 'sub NMBCLUSTERS () {512;}' unless defined(&NMBCLUSTERS);
    }
}
unless(defined(&NKMEMCLUSTERS)) {
    eval 'sub NKMEMCLUSTERS () {(4096*1024/ &CLBYTES);}' unless defined(&NKMEMCLUSTERS);
}
unless(defined(&ctod)) {
    sub ctod {
	local($x) = @_;
	eval q((($x) << ( &PGSHIFT -  &DEV_BSHIFT)));
    }
}
unless(defined(&dtoc)) {
    sub dtoc {
	local($x) = @_;
	eval q((($x) >> ( &PGSHIFT -  &DEV_BSHIFT)));
    }
}
unless(defined(&ctob)) {
    sub ctob {
	local($x) = @_;
	eval q((($x) <<  &PGSHIFT));
    }
}
unless(defined(&btoc)) {
    sub btoc {
	local($x) = @_;
	eval q(((($x) +  &PGOFSET) >>  &PGSHIFT));
    }
}
unless(defined(&btodb)) {
    sub btodb {
	local($x) = @_;
	eval q((($x) >>  &DEV_BSHIFT));
    }
}
unless(defined(&dbtob)) {
    sub dbtob {
	local($x) = @_;
	eval q((($x) <<  &DEV_BSHIFT));
    }
}
unless(defined(&bdbtofsb)) {
    sub bdbtofsb {
	local($bn) = @_;
	eval q((($bn) / ( &BLKDEV_IOSIZE/ &DEV_BSIZE)));
    }
}
unless(defined(&alpha_round_page)) {
    sub alpha_round_page {
	local($x) = @_;
	eval q((((($x)) +  &NBPG - 1) & ~( &NBPG-1)));
    }
}
unless(defined(&alpha_trunc_page)) {
    sub alpha_trunc_page {
	local($x) = @_;
	eval q((($x) & ~( &NBPG-1)));
    }
}
unless(defined(&alpha_btop)) {
    sub alpha_btop {
	local($x) = @_;
	eval q((($x) >>  &PGSHIFT));
    }
}
unless(defined(&alpha_ptob)) {
    sub alpha_ptob {
	local($x) = @_;
	eval q((($x) <<  &PGSHIFT));
    }
}
require 'machine/intr.ph';
if(defined(&_KERNEL)) {
    unless(defined(&_LOCORE)) {
	eval 'sub DELAY {
	    local($n) = @_;
    	    eval q( &delay($n));
	}' unless defined(&DELAY);
    }
}
1;
