#!/usr/bin/perl

use ExtUtils::testlib;

use SSLeay;

$g=SSLeay::BN::hex2bn("000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002"); 
$p=SSLeay::BN::hex2bn("ffffffffffffffffc90fdaa22168c234c4c6628b80dc1cd129024e088a67cc74020bbea63b139b22514a08798e3404ddef9519b3cd3a431b302b0a6df25f14374fe1356d6d51c245e485b576625e7ec6f44c42e9a63a3620ffffffffffffffff");
$pub=SSLeay::BN::hex2bn("521b5b72d0a23f5f908eff62741b9c43ac65c47ad264a4f8d62d73dfab4938a6e019f81c28d64efd9b47c1b8188566c6184b6064cc42fac2778bd732678148c6cc7601bfe0ed18da76dd7bb976cd2ff0afc7b20f3f81171e2ea6534de061f929");
$priv=SSLeay::BN::hex2bn("6e15c752af3f4cf6d7425164c451eeba760ec0651d12dc3b0ee5002a95af6191268ca47c0fbb3d836136eee795ae4af3a1adad5e04d0dbb04378cae0406ece23ca3b86839c0fd60064c1019c7d18be4dc0ec4be6c1e9ff6b0f5bd76373585503");
$his=SSLeay::BN::hex2bn("d0fb51cd44a8578f55eb0822ede90f07504f4720d7367ff4bf76c27fedbce79d9204421ff7e86bd1dd02031bce4ceccd1d3e7c62679b6eb5fda8238fd4fe07bff573d552795f0d46f25753c688300fb9ed396792b59a49fdf89c8429124b668e");
$sh=SSLeay::BN::hex2bn("66ec34b09bddf86147f6c6efd5ee4e6691e690eb0e90aceda16a742cad0abe531cb61d057aff362001ca19013215140ca2a1dd8966c78105bacbf2161f9cfbd58d351ff87923de77f9c56851037223d48272565416ee769e65a621cefb90b403");

$g2=SSLeay::BN::hex2bn("000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002");
$p2=SSLeay::BN::hex2bn("ffffffffffffffffc90fdaa22168c234c4c6628b80dc1cd129024e088a67cc74020bbea63b139b22514a08798e3404ddef9519b3cd3a431b302b0a6df25f14374fe1356d6d51c245e485b576625e7ec6f44c42e9a63a3620ffffffffffffffff");
$pub2=SSLeay::BN::hex2bn("d0fb51cd44a8578f55eb0822ede90f07504f4720d7367ff4bf76c27fedbce79d9204421ff7e86bd1dd02031bce4ceccd1d3e7c62679b6eb5fda8238fd4fe07bff573d552795f0d46f25753c688300fb9ed396792b59a49fdf89c8429124b668e");
$priv2=SSLeay::BN::hex2bn("b81d54f52b687669fc8bd8087ac319accc2f94a2feafe09779f4a81e8e01f77290f5bbe84a08003afc4448145be427fad0b9d047889cf361c9dd378b15c1ebd5bda33e051fbd9eba8bf063e2bd836467cddb61f1db5c4b06bea5c9a77fb87b24");
$his2=SSLeay::BN::hex2bn("521b5b72d0a23f5f908eff62741b9c43ac65c47ad264a4f8d62d73dfab4938a6e019f81c28d64efd9b47c1b8188566c6184b6064cc42fac2778bd732678148c6cc7601bfe0ed18da76dd7bb976cd2ff0afc7b20f3f81171e2ea6534de061f929");
$sh2=SSLeay::BN::hex2bn("791faba7a6b592cb68a963945229483dc30f80f5cb295b2b5a59ef618a262d22de0845948a34db83d8bde260b940967ff85593a609e53ee6510aea09b776b4704d5e916917f384458d4790b6e0befcb1cb2f112b850e9ed410a091db80e1db2e");

print "g=".$g->bn2hex."\n";
print "p=".$p->bn2hex."\n";
print "pub=".$pub->bn2hex."\n";
print "priv=".$priv->bn2hex."\n";
print "sh=".$sh->bn2hex."\n";

print "new p - p2 = ".($p-$p2)."\n";

$tmp=$g->mod_exp($priv,$p);
print "XXXXXXXXXXXXXXXX\n";
print "new pub - pub = ".($tmp-$pub)."\n";
$tmp2=$g2->mod_exp($priv2,$p2);
print "XXXXXXXXXXXXXXXX\n";

print $p." pub\n";
print $tmp2." calc pub\n";
print $pub2." txt pub\n";



