/*	$OpenBSD: lib_slkcolor.c,v 1.1 1998/07/23 21:19:31 millert Exp $	*/

/****************************************************************************
 * Copyright (c) 1998 Free Software Foundation, Inc.                        *
 *                                                                          *
 * Permission is hereby granted, free of charge, to any person obtaining a  *
 * copy of this software and associated documentation files (the            *
 * "Software"), to deal in the Software without restriction, including      *
 * without limitation the rights to use, copy, modify, merge, publish,      *
 * distribute, distribute with modifications, sublicense, and/or sell       *
 * copies of the Software, and to permit persons to whom the Software is    *
 * furnished to do so, subject to the following conditions:                 *
 *                                                                          *
 * The above copyright notice and this permission notice shall be included  *
 * in all copies or substantial portions of the Software.                   *
 *                                                                          *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS  *
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF               *
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.   *
 * IN NO EVENT SHALL THE ABOVE COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,   *
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR    *
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR    *
 * THE USE OR OTHER DEALINGS IN THE SOFTWARE.                               *
 *                                                                          *
 * Except as contained in this notice, the name(s) of the above copyright   *
 * holders shall not be used in advertising or otherwise to promote the     *
 * sale, use or other dealings in this Software without prior written       *
 * authorization.                                                           *
 ****************************************************************************/

/****************************************************************************
 *  Author: Juergen Pfeifer <Juergen.Pfeifer@T-Online.de> 1998              *
 ****************************************************************************/

/*
 *	lib_slkcolor.c
 */
#include <curses.priv.h>

MODULE_ID("$From: lib_slkcolor.c,v 1.3 1998/04/11 23:31:08 tom Exp $")

int
slk_color(short color_pair_number)
{
  T((T_CALLED("slk_color(%d)"), color_pair_number));

  if (SP!=0 && SP->_slk!=0 &&
      color_pair_number>=0 && color_pair_number<COLOR_PAIRS)
    {
      T(("... current %ld", (long) PAIR_NUMBER(SP->_slk->attr)));
      toggle_attr_on(SP->_slk->attr,COLOR_PAIR(color_pair_number));
      returnCode(OK);
    }
  else
    returnCode(ERR);
}
