require 'machine/alpha_cpu.ph';
unless(defined(&PT_ENTRY_NULL)) {
sub PT_ENTRY_NULL () {(( &pt_entry_t *) 0);}
}
unless(defined(&PTESHIFT)) {
sub PTESHIFT () {3;}
}
unless(defined(&PG_V)) {
sub PG_V () { &ALPHA_PTE_VALID;}
}
unless(defined(&PG_NV)) {
sub PG_NV () {0;}
}
unless(defined(&PG_FOR)) {
sub PG_FOR () { &ALPHA_PTE_FAULT_ON_READ;}
}
unless(defined(&PG_FOW)) {
sub PG_FOW () { &ALPHA_PTE_FAULT_ON_WRITE;}
}
unless(defined(&PG_FOE)) {
sub PG_FOE () { &ALPHA_PTE_FAULT_ON_EXECUTE;}
}
unless(defined(&PG_ASM)) {
sub PG_ASM () { &ALPHA_PTE_ASM;}
}
unless(defined(&PG_GH)) {
sub PG_GH () { &ALPHA_PTE_GRANULARITY;}
}
unless(defined(&PG_KRE)) {
sub PG_KRE () { &ALPHA_PTE_KR;}
}
unless(defined(&PG_URE)) {
sub PG_URE () { &ALPHA_PTE_UR;}
}
unless(defined(&PG_KWE)) {
sub PG_KWE () { &ALPHA_PTE_KW;}
}
unless(defined(&PG_UWE)) {
sub PG_UWE () { &ALPHA_PTE_UW;}
}
unless(defined(&PG_PROT)) {
sub PG_PROT () { &ALPHA_PTE_PROT;}
}
unless(defined(&PG_RSVD)) {
sub PG_RSVD () {0x000000000000cc80;}
}
unless(defined(&PG_WIRED)) {
sub PG_WIRED () {0x0000000000010000;}
}
unless(defined(&PG_FRAME)) {
sub PG_FRAME () { &ALPHA_PTE_RAME;}
}
unless(defined(&PG_SHIFT)) {
sub PG_SHIFT () {32;}
}
unless(defined(&PG_PFNUM)) {
sub PG_PFNUM {
    local($x) = @_;
    eval " &ALPHA_PTE_TO_PFN($x)";
}
}
if (0) {
    eval 'sub K0SEG_BEGIN () {0xfffffc0000000000;}' unless defined(&K0SEG_BEGIN);
    eval 'sub K0SEG_END () {0xfffffe0000000000;}' unless defined(&K0SEG_END);
    eval 'sub PHYS_UNCACHED () {0x0000000040000000;}' unless defined(&PHYS_UNCACHED);
}
if (!defined &_LOCORE) {
    if (0) {
	eval 'sub k0segtophys {
	    local($x) = @_;
	    eval "(( &vm_offset_t)($x)  0x00000003ffffffff)";
	}' unless defined(&k0segtophys);
	eval 'sub phystok0seg {
	    local($x) = @_;
	    eval "(( &vm_offset_t)($x) |  &K0SEG_BEGIN)";
	}' unless defined(&phystok0seg);
	eval 'sub phystouncached {
	    local($x) = @_;
	    eval "(( &vm_offset_t)($x) |  &PHYS_UNCACHED)";
	}' unless defined(&phystouncached);
	eval 'sub uncachedtophys {
	    local($x) = @_;
	    eval "(( &vm_offset_t)($x)  ~ &PHYS_UNCACHED)";
	}' unless defined(&uncachedtophys);
    }
    eval 'sub PTEMASK () {( &NPTEPG - 1);}' unless defined(&PTEMASK);
    eval 'sub vatopte {
        local($va) = @_;
        eval "((($va) >>  &PGSHIFT)   &PTEMASK)";
    }' unless defined(&vatopte);
    eval 'sub vatoste {
        local($va) = @_;
        eval "((($va) >>  &SEGSHIFT)   &PTEMASK)";
    }' unless defined(&vatoste);
    eval 'sub kvtol1pte {
        local($va) = @_;
        eval "((( &vm_offset_t)($va) >> ( &PGSHIFT + 2*( &PGSHIFT- &PTESHIFT)))   &PTEMASK)";
    }' unless defined(&kvtol1pte);
    eval 'sub vatopa {
        local($va) = @_;
        eval "(( &PG_PFNUM(* &kvtopte($va)) <<  &PGSHIFT) | (( &vm_offset_t)($va)   &PGOFSET))";
    }' unless defined(&vatopa);
    eval 'sub ALPHA_STSIZE () {( &NBPG);}' unless defined(&ALPHA_STSIZE);
    eval 'sub ALPHA_MAX_PTSIZE () {(( &NPTEPG *  &NBPG));}' unless defined(&ALPHA_MAX_PTSIZE);
    if (defined &_KERNEL) {
	eval 'sub kvtopte {
	    local($va) = @_;
	    eval "( &Sysmap + ((( &vm_offset_t)($va) -  &VM_MIN_KERNEL_ADDRESS) >>  &PGSHIFT))";
	}' unless defined(&kvtopte);
	eval 'sub ptetokv {
	    local($pte) = @_;
	    eval "(((( &pt_entry_t *)($pte) -  &Sysmap) <<  &PGSHIFT) +  &VM_MIN_KERNEL_ADDRESS)";
	}' unless defined(&ptetokv);
	eval 'sub loadustp {
	    local($stpte) = @_;
	    eval "{  $Lev1map[ &kvtol1pte( &VM_MIN_ADDRESS)] = $stpte;  &ALPHA_TBIAP(); }";
	}' unless defined(&loadustp);
    }
}
1;
