require 'machine/mips_param.ph';
sub _MACHINE { &pmax;}
sub MACHINE {"pmax";}
sub _MACHINE_ARCH { &mips;}
sub MACHINE_ARCH {"mips";}
sub MID_MACHINE { &MID_PMAX;}
sub KERNBASE {0x80000000;}
sub KERNTEXTOFF {0x80030000;}
sub BTOPKERNBASE {( &KERNBASE >>  &PGSHIFT);}
sub DEV_BSIZE {512;}
sub DEV_BSHIFT {9;}
sub BLKDEV_IOSIZE {2048;}
sub MAXPHYS {(64 * 1024);}
sub CLSIZE {1;}
sub CLSIZELOG2 {0;}
sub SSIZE {1;}
sub SINCR {1;}
sub UPAGES {2;}
sub UADDR {0xffffd000;}
sub USPACE {( &UPAGES* &NBPG);}
sub UVPN {( &UADDR>> &PGSHIFT);}
sub KERNELSTACK {( &UADDR+ &UPAGES* &NBPG);}
sub MSIZE {128;}
if (!defined &MCLSHIFT) {
    eval 'sub MCLSHIFT {11;}';
}
sub MCLBYTES {(1 <<  &MCLSHIFT);}
sub MCLOFSET {( &MCLBYTES - 1);}
if (!defined &NMBCLUSTERS) {
    if (defined &GATEWAY) {
	eval 'sub NMBCLUSTERS {2048;}';
    }
    else {
	eval 'sub NMBCLUSTERS {1024;}';
    }
}
if (defined &_KERNEL) {
    if (!defined &_LOCORE) {
	eval 'sub DELAY {
	    local($n) = @_;
	    eval "{  &register \'int\'  &N =  &cpuspeed * ($n);  &while (-- &N > 0); }";
	}';
    }
}
1;
