if (defined &_KERNEL) {
    if (defined &_LOCORE) {
	require 'machine/psl.ph';
    }
    else {
	require 'machine/cpu.ph';
    }
}
sub _MACHINE { &i386;}
sub MACHINE {"i386";}
sub _MACHINE_ARCH { &i386;}
sub MACHINE_ARCH {"i386";}
sub MID_MACHINE { &MID_I386;}
sub ALIGNBYTES {($sizeof{'int'} - 1);}
sub ALIGN {
    local($p) = @_;
    eval "((($p) +  &ALIGNBYTES) &~  &ALIGNBYTES)";
}
sub PGSHIFT {12;}
sub NBPG {(1 <<  &PGSHIFT);}
sub PGOFSET {( &NBPG-1);}
sub NPTEPG {( &NBPG/($sizeof{ &pt_entry_t}));}
sub KERNBASE {0xf0000000;}
if (0) {
    eval 'sub KERNSIZE {0x01800000;}';
}
sub KERNTEXTOFF {0xf0100000;}
sub BTOPKERNBASE {( &KERNBASE >>  &PGSHIFT);}
sub DEV_BSHIFT {9;}
sub DEV_BSIZE {(1 <<  &DEV_BSHIFT);}
sub BLKDEV_IOSIZE {2048;}
sub MAXPHYS {(64 * 1024);}
sub CLSIZELOG2 {0;}
sub CLSIZE {(1 <<  &CLSIZELOG2);}
sub SSIZE {1;}
sub SINCR {1;}
sub UPAGES {2;}
sub USPACE {( &UPAGES *  &NBPG);}
sub MSIZE {128;}
sub MCLSHIFT {11;}
sub MCLBYTES {(1 <<  &MCLSHIFT);}
sub MCLOFSET {( &MCLBYTES - 1);}
if (!defined &NMBCLUSTERS) {
    if (defined &GATEWAY) {
	eval 'sub NMBCLUSTERS {1024;}';
    }
    else {
	eval 'sub NMBCLUSTERS {512;}';
    }
}
if (!defined &NKMEMCLUSTERS) {
    eval 'sub NKMEMCLUSTERS {(6 * 1024 * 1024 /  &CLBYTES);}';
}
sub ctod {
    local($x) = @_;
    eval "(($x) << ( &PGSHIFT -  &DEV_BSHIFT))";
}
sub dtoc {
    local($x) = @_;
    eval "(($x) >> ( &PGSHIFT -  &DEV_BSHIFT))";
}
sub ctob {
    local($x) = @_;
    eval "(($x) <<  &PGSHIFT)";
}
sub btoc {
    local($x) = @_;
    eval "((($x) +  &PGOFSET) >>  &PGSHIFT)";
}
sub dbtob {
    local($x) = @_;
    eval "(($x) <<  &DEV_BSHIFT)";
}
sub btodb {
    local($x) = @_;
    eval "(($x) >>  &DEV_BSHIFT)";
}
sub bdbtofsb {
    local($bn) = @_;
    eval "(($bn) / ( &BLKDEV_IOSIZE /  &DEV_BSIZE))";
}
sub i386_round_pdr {
    local($x) = @_;
    eval "(((($x)) +  &PDOFSET) & ~ &PDOFSET)";
}
sub i386_trunc_pdr {
    local($x) = @_;
    eval "(($x) & ~ &PDOFSET)";
}
sub i386_btod {
    local($x) = @_;
    eval "(($x) >>  &PDSHIFT)";
}
sub i386_dtob {
    local($x) = @_;
    eval "(($x) <<  &PDSHIFT)";
}
sub i386_round_page {
    local($x) = @_;
    eval "(((($x)) +  &PGOFSET) & ~ &PGOFSET)";
}
sub i386_trunc_page {
    local($x) = @_;
    eval "(($x) & ~ &PGOFSET)";
}
sub i386_btop {
    local($x) = @_;
    eval "(($x) >>  &PGSHIFT)";
}
sub i386_ptob {
    local($x) = @_;
    eval "(($x) <<  &PGSHIFT)";
}
1;
