sub _MACHINE { &alpha;}
sub MACHINE {"alpha";}
sub _MACHINE_ARCH { &alpha;}
sub MACHINE_ARCH {"alpha";}
sub MID_MACHINE { &MID_ALPHA;}
require 'machine/alpha_cpu.ph';
require 'machine/cpu.ph';
sub ALIGNBYTES {7;}
sub ALIGN {
    local($p) = @_;
    eval "((($p) +  &ALIGNBYTES) &~  &ALIGNBYTES)";
}
sub NBPG {(1 <<  &ALPHA_PGSHIFT);}
sub PGOFSET {( &NBPG-1);}
sub PGSHIFT { &ALPHA_PGSHIFT;}
sub NPTEPG {(1 << ( &PGSHIFT- &PTESHIFT));}
sub SEGSHIFT {( &PGSHIFT + ( &PGSHIFT- &PTESHIFT));}
sub NBSEG {(1 <<  &SEGSHIFT);}
sub SEGOFSET {( &NBSEG-1);}
sub KERNBASE {0xfffffc0000230000;}
sub BTOPKERNBASE {( &KERNBASE >>  &PGSHIFT);}
sub DEV_BSIZE {512;}
sub DEV_BSHIFT {9;}
sub BLKDEV_IOSIZE {2048;}
sub MAXPHYS {(64 * 1024);}
sub CLSIZE {1;}
sub CLSIZELOG2 {0;}
sub SSIZE {1;}
sub SINCR {1;}
sub UPAGES {2;}
sub USPACE {( &UPAGES *  &NBPG);}
sub MSIZE {256;}
sub MCLSHIFT {11;}
sub MCLBYTES {(1 <<  &MCLSHIFT);}
sub MCLOFSET {( &MCLBYTES - 1);}
if (!defined &NMBCLUSTERS) {
    if (defined &GATEWAY) {
	eval 'sub NMBCLUSTERS {1024;}';
    }
    else {
	eval 'sub NMBCLUSTERS {512;}';
    }
}
if (!defined &NKMEMCLUSTERS) {
    eval 'sub NKMEMCLUSTERS {(4096*1024/ &CLBYTES);}';
}
sub ctod {
    local($x) = @_;
    eval "(($x) << ( &PGSHIFT -  &DEV_BSHIFT))";
}
sub dtoc {
    local($x) = @_;
    eval "(($x) >> ( &PGSHIFT -  &DEV_BSHIFT))";
}
sub ctob {
    local($x) = @_;
    eval "(($x) <<  &PGSHIFT)";
}
sub btoc {
    local($x) = @_;
    eval "((($x) +  &PGOFSET) >>  &PGSHIFT)";
}
sub btodb {
    local($x) = @_;
    eval "(($x) >>  &DEV_BSHIFT)";
}
sub dbtob {
    local($x) = @_;
    eval "(($x) <<  &DEV_BSHIFT)";
}
sub bdbtofsb {
    local($bn) = @_;
    eval "(($bn) / ( &BLKDEV_IOSIZE/ &DEV_BSIZE))";
}
sub alpha_round_page {
    local($x) = @_;
    eval "(((($x)) +  &NBPG - 1) & ~( &NBPG-1))";
}
sub alpha_trunc_page {
    local($x) = @_;
    eval "(($x) & ~( &NBPG-1))";
}
sub alpha_btop {
    local($x) = @_;
    eval "(($x) >>  &PGSHIFT)";
}
sub alpha_ptob {
    local($x) = @_;
    eval "(($x) <<  &PGSHIFT)";
}
require 'machine/intr.ph';
if (defined &_KERNEL) {
    if (!defined &_LOCORE) {
	eval 'sub DELAY {
	    local($n) = @_;
	    eval " &delay($n)";
	}';
    }
}
1;
